/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.zip;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipBackup {
    private static final Logger logger = Logger.getLogger(ZipBackup.class.getName());
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private ZipOutputStream zos;
    private byte[] buf;

    public ZipBackup(OutputStream out) throws IOException {
        this(out, 65536);
    }

    public ZipBackup(OutputStream out, int bufferSize) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size: " + bufferSize);
        }
        this.zos = new ZipOutputStream(out);
        this.buf = new byte[bufferSize];
    }

    public void flush() throws IOException {
        this.zos.finish();
        this.zos.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZipEntry(ZipEntry entry, InputStream in) throws IOException {
        this.zos.putNextEntry(entry);
        try {
            int n;
            while ((n = in.read(this.buf)) >= 0) {
                this.zos.write(this.buf, 0, n);
            }
        }
        finally {
            this.zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(ZipEntry entry, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.writeZipEntry(entry, fis);
        }
        finally {
            fis.close();
        }
    }

    public void writeDirectory(ZipEntry entry, File dir, FileFilter filter, boolean recursive) throws IOException {
        this.writeDirectory(entry, dir, filter, recursive, new HashSet());
    }

    protected void writeDirectory(ZipEntry entry, File dir, FileFilter filter, boolean recursive, Set done) throws IOException {
        File[] files;
        this.zos.putNextEntry(entry);
        this.zos.closeEntry();
        String dirPath = entry.getName();
        if (dirPath.startsWith("/")) {
            dirPath = dirPath.substring(1);
        }
        int num = (files = dir.listFiles()) == null ? 0 : files.length;
        for (int i = 0; i < num; ++i) {
            ZipEntry child;
            String childPath;
            String canonPath;
            File file = files[i];
            if (file == null || filter != null && !filter.accept(file) || !done.add(canonPath = file.getCanonicalPath())) continue;
            if (file.isDirectory()) {
                if (!recursive) continue;
                childPath = dirPath + file.getName() + "/";
                child = new ZipEntry(childPath);
                child.setTime(file.lastModified());
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Backup directory: " + file);
                }
                this.writeDirectory(child, file, filter, recursive, done);
                continue;
            }
            if (!file.isFile()) continue;
            childPath = dirPath + file.getName();
            child = new ZipEntry(childPath);
            child.setTime(file.lastModified());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Backup file: " + file);
            }
            this.writeFile(child, file);
        }
    }
}

