/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.zip;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipRestore {
    private static final Logger logger = Logger.getLogger(ZipRestore.class.getName());
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private ZipInputStream zis;
    private byte[] buf;

    public ZipRestore(InputStream in) throws IOException {
        this(in, 65536);
    }

    public ZipRestore(InputStream in, int bufferSize) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size: " + bufferSize);
        }
        this.zis = new ZipInputStream(in);
        this.buf = new byte[bufferSize];
    }

    public void close() throws IOException {
        this.zis.close();
    }

    public void restoreRecursive(File targetDir, FileFilter targetFilter, boolean ignoreExisting, boolean overwrite) throws IOException {
        ZipEntry entry;
        while ((entry = this.zis.getNextEntry()) != null) {
            long lastModified;
            boolean exists;
            String name = entry.getName();
            File file = new File(targetDir, name);
            if (targetFilter != null && !targetFilter.accept(file)) continue;
            if (entry.isDirectory()) {
                exists = file.exists();
                if (exists) {
                    if (ignoreExisting) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("Ignored directory: name=" + name + " --> " + file);
                        continue;
                    }
                    if (!overwrite) {
                        throw new IOException("Target directory or file already exists: " + file);
                    }
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Restore directory: name=" + name + " --> " + file);
                    }
                    if (!file.mkdirs()) {
                        throw new IOException("Failed to create directory: " + file);
                    }
                }
            } else {
                exists = file.exists();
                if (exists) {
                    if (ignoreExisting) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("Ignored file: name=" + name + " --> " + file);
                        continue;
                    }
                    if (!overwrite) {
                        throw new IOException("Target file or directory already exists: " + file);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Restore file: name=" + name + " --> " + file);
                }
                this.restoreFile(entry, file);
            }
            if ((lastModified = entry.getTime()) == -1L) continue;
            file.setLastModified(lastModified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreFile(ZipEntry entry, File targetFile) throws IOException {
        boolean success = false;
        FileOutputStream fos = new FileOutputStream(targetFile);
        try {
            int n;
            while ((n = this.zis.read(this.buf)) >= 0) {
                fos.write(this.buf, 0, n);
            }
            success = true;
        }
        finally {
            fos.close();
            if (!success) {
                targetFile.delete();
            }
        }
    }
}

