/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.device;

import com.spacekiller.util.ListenerList;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.device.AudioDeviceListener;
import com.waxmonster.audio.device.AudioSourceDevice;
import com.waxmonster.audio.device.AudioTargetDevice;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.Properties;

public abstract class AudioDevice
extends Device {
    private AudioPort[] audioPorts;
    private ListenerList<AudioDeviceListener> audioDeviceListeners = new ListenerList(AudioDeviceListener.class);
    private AudioSourceDevice audioSourceDevice;
    private AudioTargetDevice audioTargetDevice;

    public AudioDevice(DeviceProvider provider, String name) {
        super(provider, name);
        this.audioPorts = new AudioPort[0];
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
    }

    public synchronized Component getCustomizer() {
        Component superComp = super.getCustomizer();
        return superComp;
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        return props;
    }

    protected void applyProperty(String key, String value) {
    }

    protected void setSubtitle(String subtitle) {
        super.setSubtitle(subtitle);
    }

    public synchronized void addAudioDeviceListener(AudioDeviceListener l) {
        if (l == null) {
            return;
        }
        this.audioDeviceListeners.add((Object)l);
    }

    public synchronized void removeAudioDeviceListener(AudioDeviceListener l) {
        if (l == null) {
            return;
        }
        this.audioDeviceListeners.remove((Object)l);
    }

    protected void fireAudioDeviceChanged(AudioDevice audioDevice) {
        for (AudioDeviceListener l : (AudioDeviceListener[])this.audioDeviceListeners.array()) {
            l.audioDeviceChanged(audioDevice);
        }
    }

    protected synchronized AudioPort[] getAudioPorts() {
        return this.audioPorts;
    }

    protected synchronized void setAudioPorts(AudioPort[] audioPorts) {
        if (this.audioPorts == audioPorts) {
            return;
        }
        this.audioPorts = audioPorts;
        this.fireAudioDeviceChanged(this);
    }

    final AudioSourceDevice getAudioSourceDevice() {
        return this.audioSourceDevice;
    }

    final void setAudioSourceDevice(AudioSourceDevice audioSourceDevice) {
        this.audioSourceDevice = audioSourceDevice;
    }

    final AudioTargetDevice getAudioTargetDevice() {
        return this.audioTargetDevice;
    }

    final void setAudioTargetDevice(AudioTargetDevice audioTargetDevice) {
        this.audioTargetDevice = audioTargetDevice;
    }
}

