/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.device;

import com.spacekiller.util.Tools;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.audio.device.AudioPartDevice;
import com.waxmonster.audio.device.AudioPartDeviceInfo;
import com.waxmonster.audio.device.AudioSourceDevice;
import com.waxmonster.audio.device.AudioTargetDevice;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class AudioDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "AudioDeviceProvider";
    public static final String AUDIO_SOURCE_NAME = "Audio Source";
    public static final String AUDIO_TARGET_NAME = "Audio Target";
    public static final String DEVICE_CATEGORY_NAME = "Audio Devices";
    private static final Logger logger = Logger.getLogger(AudioDeviceProvider.class.getName());
    private static final String CLASS_NAME = AudioDeviceProvider.class.getName();

    public AudioDeviceProvider() {
        super(PROVIDER_NAME);
        this.initAudioDeviceProvider();
    }

    protected void initAudioDeviceProvider() {
        String tooltip = "Audio Source (Input)";
        Icon icon = Tools.getIcon(AudioDeviceProvider.class, (String)"/com/waxmonster/audio/device/icons/audio_source_icon16.png");
        AudioPartDeviceInfo sourceInfo = new AudioPartDeviceInfo(AUDIO_SOURCE_NAME, 1, tooltip, icon);
        this.addDeviceInfo(sourceInfo);
        tooltip = "Audio Target (Output)";
        icon = Tools.getIcon(AudioDeviceProvider.class, (String)"/com/waxmonster/audio/device/icons/audio_target_icon16.png");
        AudioPartDeviceInfo destInfo = new AudioPartDeviceInfo(AUDIO_TARGET_NAME, 2, tooltip, icon);
        this.addDeviceInfo(destInfo);
    }

    public void refreshDeviceInfo() {
    }

    public synchronized Device createDevice(DeviceInfo info) throws StudioException {
        AudioPartDevice device;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createDevice", info);
        }
        if (info == null || !(info instanceof AudioPartDeviceInfo)) {
            throw new StudioException("Invalid DeviceInfo: " + info);
        }
        AudioPartDeviceInfo audioDeviceInfo = (AudioPartDeviceInfo)info;
        int type = audioDeviceInfo.getType();
        String devName = audioDeviceInfo.getDeviceName();
        Icon iconColor16 = audioDeviceInfo.getIcon(1);
        switch (type) {
            case 1: {
                AudioSourceDevice dev;
                device = dev = new AudioSourceDevice(this, devName, iconColor16, audioDeviceInfo);
                break;
            }
            case 2: {
                AudioTargetDevice dev = new AudioTargetDevice(this, devName, iconColor16, audioDeviceInfo);
                device = dev;
                break;
            }
            default: {
                throw new StudioException("Invalid audio device type: " + type);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "createDevice", (Object)device);
        }
        return device;
    }

    public PortType getPortType(String typeName) {
        return AudioPortType.getAudioPortType((String)typeName);
    }
}

