/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.device;

import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.device.AudioDevice;
import com.waxmonster.audio.device.AudioDeviceListener;
import com.waxmonster.audio.device.AudioDeviceProvider;
import com.waxmonster.audio.device.AudioPartDeviceInfo;
import com.waxmonster.audio.device.AudioPartDevicePanel;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioAdapter;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.StudioListener;
import java.awt.Component;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public abstract class AudioPartDevice
extends Device {
    private static final Logger logger = Logger.getLogger(AudioPartDevice.class.getName());
    private static final AudioPort[] NO_AUDIO_PORTS = new AudioPort[0];
    private static final String KEY_AUDIO_DEVICE_ID = "audioDeviceId";
    private final AudioDeviceProvider provider;
    private final AudioPartDeviceInfo info;
    private Studio currentStudio;
    private final StudioHandler studioHandler = new StudioHandler();
    private final AudioDeviceHandler audioDeviceHandler = new AudioDeviceHandler();
    private AudioPartDevicePanel audioPartDevicePanel;
    private String selectedAudioDeviceId;
    private boolean selectedAudioDeviceAlreadyInUse;
    private AudioDevice selectedAudioDevice;
    private AudioPort[] audioPorts;

    public AudioPartDevice(AudioDeviceProvider provider, String name, Icon iconColor16, AudioPartDeviceInfo info) {
        super((DeviceProvider)provider, name);
        this.setIconColor16(iconColor16);
        this.provider = provider;
        this.info = info;
    }

    public final AudioDeviceProvider getAudioDeviceProvider() {
        return this.provider;
    }

    public final AudioPartDeviceInfo getAudioDeviceInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate() throws StudioException {
        AudioDevice audioDevice = this.getSelectedAudioDevice();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("activate: " + (Object)((Object)this) + " -> audioDevice=" + (Object)((Object)audioDevice));
        }
        if (audioDevice != null) {
            try {
                audioDevice.activate();
            }
            finally {
                AudioPartDevicePanel panel = this.audioPartDevicePanel;
                if (panel != null) {
                    panel.refreshStatusInfoLater();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() throws StudioException {
        AudioDevice audioDevice = this.getSelectedAudioDevice();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("deactivate: " + (Object)((Object)this) + " -> audioDevice=" + (Object)((Object)audioDevice));
        }
        if (audioDevice != null) {
            try {
                audioDevice.deactivate();
            }
            finally {
                AudioPartDevicePanel panel = this.audioPartDevicePanel;
                if (panel != null) {
                    panel.refreshStatusInfoLater();
                }
            }
        }
    }

    public synchronized Component getCustomizer() {
        if (this.audioPartDevicePanel == null) {
            this.audioPartDevicePanel = new AudioPartDevicePanel();
            this.audioPartDevicePanel.setOpaque(false);
            this.audioPartDevicePanel.setPartAudioDevice(this);
        }
        return this.audioPartDevicePanel;
    }

    protected AudioPartDevicePanel getAudioPartDevicePanel() {
        return this.audioPartDevicePanel;
    }

    protected void setAudioPartDevicePanel(AudioPartDevicePanel audioPartDevicePanel) {
        this.audioPartDevicePanel = audioPartDevicePanel;
    }

    public String getSelectedAudioDeviceId() {
        return this.selectedAudioDeviceId;
    }

    protected void setSelectedAudioDeviceId(String selectedAudioDeviceId) {
        this.selectedAudioDeviceId = selectedAudioDeviceId;
    }

    public boolean isSelectedAudioDeviceAlreadyInUse() {
        return this.selectedAudioDeviceAlreadyInUse;
    }

    protected void setSelectedAudioDeviceAlreadyInUse(boolean selectedAudioDeviceAlreadyInUse) {
        this.selectedAudioDeviceAlreadyInUse = selectedAudioDeviceAlreadyInUse;
    }

    public AudioDevice getSelectedAudioDevice() {
        return this.selectedAudioDevice;
    }

    public synchronized void setSelectedAudioDevice(AudioDevice newAudioDevice) {
        Studio studio;
        if (this.selectedAudioDevice == newAudioDevice) {
            return;
        }
        if (this.selectedAudioDevice != null) {
            this.selectedAudioDevice.removeAudioDeviceListener(this.audioDeviceHandler);
        }
        this.selectedAudioDevice = newAudioDevice;
        if (this.selectedAudioDevice != null) {
            this.selectedAudioDevice.addAudioDeviceListener(this.audioDeviceHandler);
        }
        String selDevId = null;
        if (newAudioDevice != null && (studio = this.getStudio()) != null) {
            selDevId = studio.getDeviceId((Device)newAudioDevice);
        }
        this.setSelectedAudioDeviceId(selDevId);
        this.handleAudioDeviceChanged(newAudioDevice);
    }

    public synchronized Properties getProperties() {
        Studio studio;
        AudioDevice audioDevice;
        Properties props = super.getProperties();
        String audioDeviceId = this.selectedAudioDeviceId;
        if (audioDeviceId == null && (audioDevice = this.getSelectedAudioDevice()) != null && (studio = audioDevice.getStudio()) != null) {
            audioDeviceId = studio.getDeviceId((Device)audioDevice);
        }
        if (this.isSelectedAudioDeviceAlreadyInUse()) {
            audioDeviceId = null;
        }
        if (audioDeviceId != null) {
            props.setProperty(KEY_AUDIO_DEVICE_ID, audioDeviceId);
        } else {
            props.remove(KEY_AUDIO_DEVICE_ID);
        }
        return props;
    }

    protected void applyProperty(String key, String value) {
        if (KEY_AUDIO_DEVICE_ID.equals(key)) {
            this.setSelectedAudioDeviceId(value);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void studioChanged(Studio studio) {
        super.studioChanged(studio);
        StudioHandler studioHandler = this.studioHandler;
        synchronized (studioHandler) {
            if (this.currentStudio == studio) {
                return;
            }
            if (this.currentStudio != null) {
                this.currentStudio.removeStudioListener((StudioListener)this.studioHandler);
            }
            this.currentStudio = studio;
            if (this.currentStudio != null) {
                this.currentStudio.addStudioListener((StudioListener)this.studioHandler);
            }
        }
        if (studio == null) {
            String selDevId = this.getSelectedAudioDeviceId();
            this.setSelectedAudioDevice(null);
            this.setSelectedAudioDeviceId(selDevId);
        }
        this.handleAudioDevicesChanged();
    }

    protected void handleAudioDevicesChanged() {
        AudioPartDevicePanel panel;
        if (this.selectedAudioDevice == null && this.selectedAudioDeviceId != null) {
            AudioDevice selAudioDevice = null;
            Studio studio = this.getStudio();
            if (studio != null) {
                for (Device device : studio.getDevices()) {
                    AudioDevice audioDev;
                    String audioDevId;
                    if (device == null || !(device instanceof AudioDevice) || !this.selectedAudioDeviceId.equals(audioDevId = studio.getDeviceId((Device)(audioDev = (AudioDevice)device)))) continue;
                    selAudioDevice = audioDev;
                    break;
                }
            }
            this.setSelectedAudioDevice(selAudioDevice);
        }
        if ((panel = this.audioPartDevicePanel) != null) {
            panel.refreshLater();
        }
    }

    protected void handleAudioDeviceChanged(AudioDevice audioDevice) {
        boolean audioDeviceUpdated;
        AudioDevice selAudioDevice = this.getSelectedAudioDevice();
        if (audioDevice != selAudioDevice) {
            return;
        }
        AudioPartDeviceInfo info = this.getAudioDeviceInfo();
        Port[] oldPorts = this.getPorts();
        if (oldPorts == null) {
            oldPorts = NO_AUDIO_PORTS;
        }
        AudioPort[] newPorts = null;
        if (selAudioDevice != null && info != null) {
            int totalPorts;
            int type = info.getType();
            AudioPort[] portArray = null;
            try {
                portArray = selAudioDevice.getAudioPorts();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (portArray != null && (totalPorts = portArray.length) > 0) {
                AudioPort[] newArray = new AudioPort[totalPorts];
                int newCount = 0;
                block8: for (int i = 0; i < totalPorts; ++i) {
                    AudioPort audioPort = portArray[i];
                    if (audioPort == null) continue;
                    switch (type) {
                        case 1: {
                            if (!(audioPort instanceof AudioOutputPort)) continue block8;
                            newArray[newCount++] = audioPort;
                            continue block8;
                        }
                        case 2: {
                            if (!(audioPort instanceof AudioInputPort)) continue block8;
                            newArray[newCount++] = audioPort;
                        }
                    }
                }
                if (newCount > 0) {
                    if (newCount == newArray.length) {
                        newPorts = newArray;
                    } else {
                        newPorts = new AudioPort[newCount];
                        System.arraycopy(newArray, 0, newPorts, 0, newCount);
                    }
                }
            }
        }
        if (newPorts == null) {
            newPorts = NO_AUDIO_PORTS;
        }
        if (!(audioDeviceUpdated = this.checkUpdateAudioDevice(selAudioDevice))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Audio-Device is already used by another part-device: selAudioDevice=" + (Object)((Object)selAudioDevice));
            }
            newPorts = NO_AUDIO_PORTS;
        }
        this.setSelectedAudioDeviceAlreadyInUse(!audioDeviceUpdated);
        this.setAudioPorts(newPorts);
        try {
            this.replacePortsByName(oldPorts, (Port[])newPorts);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected AudioPort[] getAudioPorts() {
        return this.audioPorts;
    }

    protected void setAudioPorts(AudioPort[] audioPorts) {
        this.audioPorts = audioPorts;
    }

    protected abstract boolean checkUpdateAudioDevice(AudioDevice var1);

    protected class AudioDeviceHandler
    implements AudioDeviceListener {
        protected AudioDeviceHandler() {
        }

        @Override
        public void audioDeviceChanged(AudioDevice audioDevice) {
            AudioPartDevice.this.handleAudioDeviceChanged(audioDevice);
        }
    }

    protected class StudioHandler
    extends StudioAdapter {
        protected StudioHandler() {
        }

        public void deviceAdded(Device device) {
            super.deviceAdded(device);
            this.handleRefresh(device);
        }

        public void deviceRemoved(Device device) {
            super.deviceRemoved(device);
            this.handleRefresh(device);
        }

        public void deviceRenamed(Device device) {
            super.deviceRenamed(device);
            this.handleRefresh(device);
        }

        public void deviceTitleChanged(Device device) {
            super.deviceTitleChanged(device);
            this.handleRefresh(device);
        }

        protected void handleRefresh(Device device) {
            if (device != null && device instanceof AudioDevice) {
                AudioPartDevice.this.handleAudioDevicesChanged();
            }
        }
    }
}

