/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.device;

import com.waxmonster.audio.device.AudioDevice;
import com.waxmonster.audio.device.AudioPartDevice;
import com.waxmonster.audio.device.AudioPartDeviceInfo;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Studio;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class AudioPartDevicePanel
extends JPanel {
    private static final long serialVersionUID = 5393159672876403285L;
    private static final String NONE_DEVICE = "<Select Device>";
    private final Refresh refresh = new Refresh();
    private final RefreshStatusInfo refreshStatusInfo = new RefreshStatusInfo();
    private AudioPartDevice audioPartDevice;
    private boolean refreshing;
    private List audioDeviceList;
    private DefaultComboBoxModel audioDeviceModel;
    private JComboBox comboBoxAudioDevice;
    private JLabel labelStatusInfo;
    private JLabel labelDevice;

    public AudioPartDevicePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Audio Device", 4, 2, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.weighty = 1.0;
        gbc_panel.weightx = 1.0;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.insets = new Insets(4, 4, 4, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        panel.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        this.labelDevice = new JLabel("Device:");
        this.labelDevice.setToolTipText("Audio device");
        GridBagConstraints gbc_labelDevice = new GridBagConstraints();
        gbc_labelDevice.insets = new Insets(0, 0, 5, 5);
        gbc_labelDevice.anchor = 17;
        gbc_labelDevice.gridx = 0;
        gbc_labelDevice.gridy = 0;
        panel_1.add((Component)this.labelDevice, gbc_labelDevice);
        this.comboBoxAudioDevice = new JComboBox();
        this.comboBoxAudioDevice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioPartDevicePanel.this.refreshing && e.getStateChange() == 1) {
                    AudioPartDevicePanel.this.handleAudioDeviceSelected();
                }
            }
        });
        this.comboBoxAudioDevice.setToolTipText("Audio device");
        GridBagConstraints gbc_comboBoxAudioDevice = new GridBagConstraints();
        gbc_comboBoxAudioDevice.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxAudioDevice.weightx = 1.0;
        gbc_comboBoxAudioDevice.fill = 2;
        gbc_comboBoxAudioDevice.gridx = 1;
        gbc_comboBoxAudioDevice.gridy = 0;
        panel_1.add((Component)this.comboBoxAudioDevice, gbc_comboBoxAudioDevice);
        JLabel lblNewLabel_1 = new JLabel("Status:");
        lblNewLabel_1.setToolTipText("Device status");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 17;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 1;
        panel_1.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        this.labelStatusInfo = new JLabel("New label");
        this.labelStatusInfo.setToolTipText("Device status");
        GridBagConstraints gbc_labelStatusInfo = new GridBagConstraints();
        gbc_labelStatusInfo.anchor = 17;
        gbc_labelStatusInfo.weightx = 1.0;
        gbc_labelStatusInfo.gridx = 1;
        gbc_labelStatusInfo.gridy = 1;
        panel_1.add((Component)this.labelStatusInfo, gbc_labelStatusInfo);
        this.initPartAudioDevicePanel();
    }

    protected void initPartAudioDevicePanel() {
        this.audioDeviceList = new ArrayList();
        this.audioDeviceModel = new DefaultComboBoxModel();
        this.getComboBoxAudioDevice().setModel(this.audioDeviceModel);
        this.getComboBoxAudioDevice().setRenderer(new AudioDeviceListCellRenderer());
        this.refreshStatusInfo();
    }

    public AudioPartDevice getAudioPartDevice() {
        return this.audioPartDevice;
    }

    public void setPartAudioDevice(AudioPartDevice partAudioDevice) {
        this.audioPartDevice = partAudioDevice;
        this.refresh();
    }

    public void refreshLater() {
        SwingUtilities.invokeLater(this.refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            Studio studio;
            this.refreshing = true;
            AudioDevice selAudioDevice = this.getSelectedAudioDevice();
            if (this.audioPartDevice != null) {
                selAudioDevice = this.audioPartDevice.getSelectedAudioDevice();
            }
            this.audioDeviceList.clear();
            AudioPartDevice partAudioDevice = this.getAudioPartDevice();
            if (partAudioDevice != null && (studio = partAudioDevice.getStudio()) != null) {
                for (Device device : studio.getDevices()) {
                    if (device == null || !(device instanceof AudioDevice)) continue;
                    AudioDevice audioDevice = (AudioDevice)device;
                    this.audioDeviceList.add(audioDevice);
                }
            }
            this.audioDeviceModel.removeAllElements();
            this.audioDeviceModel.addElement(NONE_DEVICE);
            int selDeviceIndex = -1;
            for (AudioDevice audioDevice : this.audioDeviceList) {
                if (selAudioDevice == audioDevice) {
                    selDeviceIndex = this.audioDeviceModel.getSize();
                }
                this.audioDeviceModel.addElement(audioDevice);
            }
            if (selDeviceIndex < 0) {
                selDeviceIndex = 0;
            }
            this.getComboBoxAudioDevice().setSelectedIndex(selDeviceIndex);
            this.refreshStatusInfo();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JComboBox getComboBoxAudioDevice() {
        return this.comboBoxAudioDevice;
    }

    protected AudioDevice getSelectedAudioDevice() {
        int index = this.getComboBoxAudioDevice().getSelectedIndex();
        if (index < 1) {
            return null;
        }
        if (--index >= this.audioDeviceList.size()) {
            return null;
        }
        return (AudioDevice)((Object)this.audioDeviceList.get(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAudioDeviceSelected() {
        try {
            this.refreshing = true;
            AudioPartDevice audioPartDevice = this.getAudioPartDevice();
            if (audioPartDevice != null) {
                AudioDevice selectedAudioDevice = this.getSelectedAudioDevice();
                audioPartDevice.setSelectedAudioDevice(selectedAudioDevice);
            }
            this.refreshStatusInfo();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JLabel getLabelStatusInfo() {
        return this.labelStatusInfo;
    }

    public void refreshStatusInfoLater() {
        SwingUtilities.invokeLater(this.refreshStatusInfo);
    }

    protected void refreshStatusInfo() {
        AudioPartDevice audioPartDevice = this.getAudioPartDevice();
        AudioPartDeviceInfo audioDeviceInfo = null;
        if (audioPartDevice != null) {
            audioDeviceInfo = audioPartDevice.getAudioDeviceInfo();
        }
        String deviceLabelText = this.getDeviceLabelText(audioDeviceInfo);
        this.getLabelDevice().setText(deviceLabelText);
        String statusText = null;
        String statusTip = null;
        Object statusIcon = null;
        AudioDevice selectedAudioDevice = this.getSelectedAudioDevice();
        if (selectedAudioDevice == null) {
            if (this.audioDeviceList.isEmpty()) {
                statusText = "No audio device(s) available in project!";
                statusTip = "Please add an audio device to the project.";
                statusIcon = null;
            } else {
                statusText = "No audio device selected.";
                statusTip = "Please select an audio device.";
                statusIcon = null;
            }
        } else if (audioPartDevice != null) {
            if (audioPartDevice.isSelectedAudioDeviceAlreadyInUse()) {
                statusText = "Selected audio device is already in use!";
                statusTip = "Please select another audio device.";
                statusIcon = null;
            } else if (audioPartDevice.isActive()) {
                statusText = "Active";
                statusIcon = null;
            } else if (audioPartDevice.isEnabled()) {
                statusText = "Idle";
                statusIcon = null;
            } else {
                statusText = "Disabled";
                statusIcon = null;
            }
        }
        if (statusText == null) {
            statusText = "";
        }
        this.getLabelStatusInfo().setText(statusText);
        this.getLabelStatusInfo().setIcon(statusIcon);
        this.getLabelStatusInfo().setToolTipText(statusTip);
    }

    protected JLabel getLabelDevice() {
        return this.labelDevice;
    }

    protected String getDeviceLabelText(AudioPartDeviceInfo info) {
        if (info != null) {
            int type = info.getType();
            switch (type) {
                case 1: {
                    return "Source:";
                }
                case 2: {
                    return "Target:";
                }
            }
        }
        return "Device:";
    }

    protected class AudioDeviceListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -3468550508935989377L;

        protected AudioDeviceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            Icon icon = null;
            String tip = null;
            if (value != null && value instanceof AudioDevice) {
                AudioDevice audioDevice = (AudioDevice)((Object)value);
                if (text == null || text.length() < 1) {
                    text = audioDevice.getTitle();
                }
                if (text == null || text.length() < 1) {
                    text = audioDevice.getName();
                }
                if (icon == null) {
                    icon = audioDevice.getIcon(1);
                }
            }
            if (text == null) {
                text = String.valueOf(value);
            }
            this.setText(text);
            this.setIcon(icon);
            this.setToolTipText(tip);
            this.setOpaque(isSelected);
            return comp;
        }
    }

    protected class RefreshStatusInfo
    implements Runnable {
        protected RefreshStatusInfo() {
        }

        @Override
        public void run() {
            AudioPartDevicePanel.this.refreshStatusInfo();
        }
    }

    protected class Refresh
    implements Runnable {
        protected Refresh() {
        }

        @Override
        public void run() {
            AudioPartDevicePanel.this.refresh();
        }
    }
}

