/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.flac;

import com.spacekiller.util.Tools;
import com.spacekiller.util.format.AbstractFileFormat;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.format.SimpleFileFormatSignature;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.flac.FlacMediaScanner;

public class FlacMediaFileFormat
extends AbstractFileFormat
implements MediaFileFormat {
    public static final String FORMAT_NAME = "FLAC";
    private static final String DEFAULT_FILE_EXTENSION = ".flac";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{".flac"};
    private static final String FILE_FORMAT_TITLE = "Free Lossless Audio Codec";
    private SimpleFileFormatSignature flacFileSignature;
    private MediaScanner mediaScanner;

    public FlacMediaFileFormat() {
        super(FORMAT_NAME);
        this.initMediaFileFormat();
    }

    protected void initMediaFileFormat() {
        this.setFormatTitle(FILE_FORMAT_TITLE);
        this.setDefaultFormatIcon(Tools.getIcon(((Object)((Object)this)).getClass(), (String)"/com/spacekiller/util/media/flac/icons/flac_format.png"));
        this.setDefaultExtension(DEFAULT_FILE_EXTENSION);
        this.setSupportedExtensions(SUPPORTED_FILE_EXTENSIONS);
        this.flacFileSignature = new SimpleFileFormatSignature("FLAC Header", (FileFormat)this, 0, new byte[]{102, 76, 97, 67});
        this.setSupportedSignatures(new FileFormatSignature[]{this.flacFileSignature});
    }

    public int getSupportedMediaFlags() {
        return 1;
    }

    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            this.mediaScanner = new FlacMediaScanner();
        }
        return this.mediaScanner;
    }
}

