/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.flac;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.library.serato.Base64Decoder;
import com.spacekiller.util.media.library.serato.SeratoMarkers2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.VorbisComment;

public class FlacMediaScanner
implements MediaScanner {
    private static final Logger logger = Logger.getLogger(FlacMediaScanner.class.getName());
    public static final String FORMAT_FLAC = "FLAC";
    public static final String FLACTAG_TITLE = "TITLE";
    public static final String FLACTAG_ALBUM = "ALBUM";
    public static final String FLACTAG_ARTIST = "ARTIST";
    public static final String FLACTAG_DATE = "DATE";
    public static final String FLACTAG_GENRE = "GENRE";
    public static final String FLACTAG_TRACK_NUMBER = "TRACKNUMBER";
    public static final String FLACTAG_BPM = "BPM";
    private static final String FLACTAG_INITIAL_KEY = "INITIALKEY";
    private static final String FLACTAG_SERATO_MARKERS_V2 = "SERATO_MARKERS_V2";

    public MediaEntry scanMediaResource(Resource resource, MediaEntry me) throws IOException {
        String sMarkers;
        String sKey;
        String sBPM;
        String sTrack;
        Object mme = me != null && me instanceof MutableMediaEntry ? (MutableMediaEntry)me : new DefaultMediaEntry();
        AudioEntry ae = mme.getAudioEntry();
        Object mae = ae != null && ae instanceof MutableAudioEntry ? (MutableAudioEntry)ae : new DefaultAudioEntry();
        mme.setAudioEntry((AudioEntry)mae);
        mme.setResource(resource);
        Map tags = null;
        try {
            tags = this.getFlacTags(resource);
        }
        catch (UnsupportedAudioFileException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            throw new StreamCorruptedException(e.getMessage());
        }
        if (tags == null) {
            return null;
        }
        mme.setFormat(FORMAT_FLAC);
        Object value = tags.get(FLACTAG_TITLE);
        if (value != null) {
            mme.setTitle(String.valueOf(value));
        }
        if ((value = tags.get(FLACTAG_ALBUM)) != null) {
            mme.setAlbum(String.valueOf(value));
        }
        if ((value = tags.get(FLACTAG_ARTIST)) != null) {
            mme.setArtist(String.valueOf(value));
        }
        if ((value = tags.get(FLACTAG_GENRE)) != null) {
            mme.setGenre(String.valueOf(value));
        }
        if ((value = tags.get(FLACTAG_DATE)) != null) {
            mme.setYear(String.valueOf(value));
        }
        if ((value = tags.get(FLACTAG_TRACK_NUMBER)) != null && (sTrack = String.valueOf(value).trim()).length() > 0) {
            try {
                int track = Integer.parseInt(sTrack);
                if (track > 0) {
                    mme.setAlbumTrack(track);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((value = tags.get(FLACTAG_BPM)) != null && (sBPM = String.valueOf(value).trim()).length() > 0) {
            try {
                double bpm = Double.parseDouble(sBPM);
                if (bpm > 0.0) {
                    mae.setBpmStored(bpm);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((value = tags.get(FLACTAG_INITIAL_KEY)) == null || (sKey = String.valueOf(value).trim()).length() > 0) {
            // empty if block
        }
        if ((value = tags.get(FLACTAG_SERATO_MARKERS_V2)) != null && (sMarkers = String.valueOf(value).trim()).length() > 0) {
            try {
                byte[] base64Value = sMarkers.getBytes();
                byte[] base64MarkersV2 = Base64Decoder.decodeBase64((byte[])base64Value, (int)0, (int)base64Value.length);
                String base64MarkersV2String = new String(base64MarkersV2);
                int startIndex = base64MarkersV2String.indexOf("Serato Markers2");
                if (startIndex >= 0) {
                    byte[] base64Input = base64MarkersV2String.substring(startIndex += "Serato Markers2".length()).getBytes();
                    MediaMarker[] seratoMarkers = SeratoMarkers2.parseSeratoMarkers((byte[])base64Input);
                    SeratoMarkers2.updateMediaEntrySeratoMarkers((MutableMediaEntry)mme, (MediaMarker[])seratoMarkers);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return mme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getFlacTags(Resource resource) throws IOException, UnsupportedAudioFileException {
        HashMap<String, String> tags = null;
        InputStream in = resource.createInputStream();
        try {
            FLACDecoder decoder = new FLACDecoder(in);
            Metadata[] metaData = decoder.readMetadata();
            for (int i = 0; i < metaData.length; ++i) {
                String s;
                if (!(metaData[i] instanceof VorbisComment)) continue;
                VorbisComment vc = (VorbisComment)metaData[i];
                String comment = vc.toString();
                String key = null;
                StringBuffer buffer = new StringBuffer();
                BufferedReader reader = new BufferedReader(new StringReader(comment));
                while ((s = reader.readLine()) != null) {
                    int x = (s = s.trim()).indexOf("=");
                    if (x < 1) {
                        if (key == null) continue;
                        buffer.append(s);
                        continue;
                    }
                    if (key != null) {
                        if (tags == null) {
                            tags = new HashMap();
                        }
                        tags.put(key, buffer.toString());
                    }
                    buffer.delete(0, buffer.length());
                    key = s.substring(0, x).trim();
                    String value = s.substring(x + 1).trim();
                    buffer.append(value);
                }
                if (key == null) continue;
                if (tags == null) {
                    tags = new HashMap<String, String>();
                }
                tags.put(key, buffer.toString());
            }
        }
        finally {
            in.close();
        }
        return tags;
    }
}

