/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.akai;

import com.spacekiller.util.media.akai.AkaiBlock;
import com.spacekiller.util.media.akai.Keygroup;
import com.spacekiller.util.media.akai.Program;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class AkaiFormat {
    public static final int BLOCK_PROGRAM = 1;
    public static final int BLOCK_KEYGROUP = 2;

    private static AkaiBlock readAkaiBlock(String fdir, String fname, int ofs, InputStream io) throws Exception {
        AkaiBlock block = null;
        int d = io.read();
        switch (d) {
            case 1: {
                block = new Program(fdir, fname);
                break;
            }
            case 2: {
                block = new Keygroup();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Block-Type " + d);
            }
        }
        block.setNextOffset((char)io.read() + (char)io.read() * 256);
        block.setBlockSize(block.getNextOffset() - ofs - 3);
        block.setData(new byte[block.getBlockSize()]);
        io.read(block.getData());
        block.load();
        return block;
    }

    public static Vector readAkaiBlocks(String fdir, String fname, InputStream io) throws Exception {
        Vector<AkaiBlock> v = new Vector<AkaiBlock>();
        int ofs = 0;
        int avail = io.available();
        Program prog = null;
        while (avail > 0) {
            AkaiBlock block = AkaiFormat.readAkaiBlock(fdir, fname, ofs, io);
            if (block instanceof Program) {
                v.addElement(block);
                prog = (Program)block;
            } else if (prog != null && block instanceof Keygroup) {
                prog.addKeygroup((Keygroup)block);
            }
            ofs += avail - io.available();
            avail = io.available();
        }
        return v;
    }

    public static void writeAkaiBlocks(Program p, OutputStream io) throws Exception {
        byte[] d = p.getBytes();
        io.write(1);
        int i = d.length + 3;
        io.write(i & 0xFF);
        io.write(i >> 8);
        io.write(d);
        Enumeration en = p.keygroups.elements();
        while (en.hasMoreElements()) {
            d = ((AkaiBlock)en.nextElement()).getData();
            io.write(2);
            io.write((i += d.length + 3) & 0xFF);
            io.write(i >> 8);
            io.write(d);
        }
    }
}

