/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.akai;

public final class AkaiString {
    private static String akaiChars = "0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ#+-.";
    private byte[] bytes;

    public AkaiString(byte[] akaiString, int ofs, int len) {
        this.bytes = new byte[len];
        System.arraycopy(akaiString, ofs, this.bytes, 0, len);
    }

    public AkaiString(String javaString, int akaiLen) {
        this.bytes = AkaiString.string2Akai(javaString, akaiLen);
    }

    private static String akai2String(byte[] akai, int ofs, int len) {
        String s = "";
        for (int c = 0; c < len; ++c) {
            char i = (char)akai[ofs + c];
            s = i >= akaiChars.length() ? s + "?" : s + akaiChars.charAt(i);
        }
        return s;
    }

    public byte[] getBytes() {
        byte[] rc = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, rc, 0, this.bytes.length);
        return rc;
    }

    public String getString() {
        return AkaiString.akai2String(this.bytes, 0, this.bytes.length);
    }

    private static byte[] string2Akai(String s, int akaiLen) {
        if (s == null) {
            s = "";
        }
        while (s.length() < akaiLen) {
            s = s + " ";
        }
        if (s.length() > akaiLen) {
            throw new IllegalArgumentException("String is too long (>" + akaiLen + "): " + s);
        }
        byte[] str = new byte[s.length()];
        for (int c = 0; c < str.length; ++c) {
            String ss = s.substring(c, c + 1);
            int i = akaiChars.indexOf(ss);
            if (i < 0) {
                throw new IllegalArgumentException("Character '" + ss + "' not valid.");
            }
            str[c] = (byte)i;
        }
        return str;
    }

    public String toString() {
        return this.getString();
    }
}

