/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.akai;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public abstract class AudioFile {
    public int fileSize = 0;
    public int samples = 0;
    public int dataSize = 0;
    public int sampleBytes = 0;
    public int channels = 0;
    public int rate = 0;
    public byte[] data = new byte[0];
    public byte[] header = new byte[0];
    public String dir = "";
    public String name = "";
    public String ext = "";
    public String title = "";

    public void copySampleFrom(AudioFile f) throws Exception {
        this.setSamplingBytes(f.getSamplingBytes());
        this.setSamplingChannels(f.getSamplingChannels());
        this.setSamplingRate(f.getSamplingRate());
        this.setSamplingData(f.getSamplingData());
    }

    public String getFileDirectory() {
        return this.dir;
    }

    public byte[] getFileHeader() {
        return this.header;
    }

    public String getFileName() {
        return this.name + this.ext;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public abstract String getFormat();

    public String getName() {
        return this.name;
    }

    public int getSamples() {
        return this.samples;
    }

    public int getSampleSize() {
        return this.data.length;
    }

    public int getSamplingBytes() {
        return this.sampleBytes;
    }

    public int getSamplingChannels() {
        return this.channels;
    }

    public byte[] getSamplingData() throws Exception {
        if (!this.sampleDataAvailable()) {
            this.readSampleData();
        }
        return this.data;
    }

    public int getSamplingRate() {
        return this.rate;
    }

    public String getTitle() {
        return this.title;
    }

    public void readHeaderInfo() {
    }

    public void readSampleData() throws Exception {
    }

    public void releaseSampleData() {
        this.data = new byte[0];
    }

    public boolean sampleDataAvailable() {
        if (this.data == null) {
            return false;
        }
        return this.data.length != 0;
    }

    public void save() throws Exception {
        this.getSamplingData();
        FileOutputStream io = new FileOutputStream(this.dir + File.separator + this.name + this.ext);
        this.saveTo(io);
        io.close();
    }

    public void saveTo(OutputStream io) throws Exception {
    }

    public void setFileDirectory(String dir) {
        this.dir = dir;
    }

    public void setFileHeader(byte[] dat) {
        this.header = dat;
    }

    public void setFileName(String name) {
        int i = name.lastIndexOf(".");
        if (i >= 0) {
            this.name = name.substring(0, i);
            this.ext = name.substring(i);
        } else {
            this.name = name;
            this.ext = "";
        }
    }

    public void setFileSize(int s) {
        this.fileSize = s;
    }

    private void setSamples() {
        if (this.channels < 1 || this.sampleBytes < 1) {
            this.samples = 0;
            return;
        }
        this.samples = this.dataSize / this.sampleBytes / this.channels;
    }

    public void setSamplingBytes(int b) {
        this.sampleBytes = b;
        this.setSamples();
    }

    public void setSamplingChannels(int ch) {
        this.channels = ch;
        this.setSamples();
    }

    public void setSamplingData(byte[] dat) {
        this.data = dat;
        this.dataSize = dat.length;
        this.setSamples();
    }

    public void setSamplingData(int siz) {
        this.data = new byte[0];
        this.dataSize = siz;
        this.setSamples();
    }

    public void setSamplingRate(int r) {
        this.rate = r;
        this.setSamples();
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String toString() {
        return "Audiofile " + this.getTitle();
    }

    public void updateHeaderInfo() {
    }
}

