/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.akai;

import com.spacekiller.util.media.akai.AkaiBlock;
import com.spacekiller.util.media.akai.AkaiString;
import com.spacekiller.util.media.akai.AudioToolkit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Keygroup
extends AkaiBlock {
    public static final int ZPLAY_HEADER = 0;
    public static final int ZPLAY_NORMAL_LOOPING = 1;
    public static final int ZPLAY_UNTIL_RELEASE = 2;
    public static final int ZPLAY_NO_LOOPING = 3;
    public static final int ZPLAY_TO_END = 4;
    public String sampleFileName = "";
    public int lowerMidiKey = 0;
    public int upperMidiKey = 0;
    public int KGTUNOcent = 0;
    public int KGTUNOsemi = 0;
    public int FLIFRQ = 99;
    public int K_FREQ = 0;
    public int V_FREQ = 0;
    public int P_FREQ = 0;
    public int E_FREQ = 0;
    public int ATTAK1 = 0;
    public int DECAY1 = 50;
    public int SUSTN1 = 99;
    public int RELSE1 = 0;
    public int V_ATT1 = 0;
    public int V_REL1 = 0;
    public int O_REL1 = 0;
    public int K_DAR1 = 0;
    public int ATTAK2 = 0;
    public int DECAY2 = 41;
    public int SUSTN2 = 99;
    public int RELSE2 = 45;
    public int V_ATT2 = 0;
    public int V_REL2 = 0;
    public int O_REL2 = 0;
    public int K_DAR2 = 0;
    public int V_ENV2 = 25;
    public int E_PTCH = 0;
    public boolean VXFADE = false;
    public int VZONES = 0;
    public int LKXF = 0;
    public int RKXF = 0;
    public String[] SNAME = new String[4];
    public int[] LOVEL = new int[4];
    public int[] HIVEL = new int[]{127, 127, 127, 127};
    public int[] VTUNOcent = new int[4];
    public int[] VTUNOsemi = new int[4];
    public int[] VLOUD = new int[4];
    public int[] VFREQ = new int[4];
    public int[] VPANO = new int[]{-50, -50, -50, -50};
    public int[] ZPLAY = new int[4];
    public int[] LVXF = new int[4];
    public int[] HVXF = new int[4];
    public int[] SBADD = new int[4];
    public int KBEAT = 0;
    public int AHOLD = 0;
    public boolean CP1 = false;
    public boolean CP2 = false;
    public boolean CP3 = false;
    public boolean CP4 = false;
    public int VZOUT1 = 0;
    public int VZOUT2 = 0;
    public int VZOUT3 = 0;
    public int VZOUT4 = 0;
    public int VSS1 = 0;
    public int VSS2 = 0;
    public int VSS3 = 0;
    public int VSS4 = 0;
    public int KV_LPO = 0;
    private static final Logger logger = Logger.getLogger(Keygroup.class.getName());

    public Keygroup() {
        this.setBlockType(2);
    }

    public Keygroup(String nam, String fname, int lowerkey, int upperkey) {
        this.SNAME[0] = nam.toUpperCase();
        this.sampleFileName = fname.toUpperCase();
        this.upperMidiKey = upperkey;
        this.lowerMidiKey = lowerkey;
    }

    public void copyAllSettingsFrom(Keygroup k) {
        this.copyKeygroupSettingsFrom(k);
        this.copySampleSettingsFrom(k);
    }

    public void copyKeygroupSettingsFrom(Keygroup k) {
        this.sampleFileName = "";
        this.lowerMidiKey = k.lowerMidiKey;
        this.upperMidiKey = k.upperMidiKey;
        this.KGTUNOcent = k.KGTUNOcent;
        this.KGTUNOsemi = k.KGTUNOsemi;
        this.FLIFRQ = k.FLIFRQ;
        this.K_FREQ = k.K_FREQ;
        this.V_FREQ = k.V_FREQ;
        this.P_FREQ = k.P_FREQ;
        this.E_FREQ = k.E_FREQ;
        this.ATTAK1 = k.ATTAK1;
        this.DECAY1 = k.DECAY1;
        this.SUSTN1 = k.SUSTN1;
        this.RELSE1 = k.RELSE1;
        this.V_ATT1 = k.V_ATT1;
        this.V_REL1 = k.V_REL1;
        this.O_REL1 = k.O_REL1;
        this.K_DAR1 = k.K_DAR1;
        this.ATTAK2 = k.ATTAK2;
        this.DECAY2 = k.DECAY2;
        this.SUSTN2 = k.SUSTN2;
        this.RELSE2 = k.RELSE2;
        this.V_ATT2 = k.V_ATT2;
        this.V_REL2 = k.V_REL2;
        this.O_REL2 = k.O_REL2;
        this.K_DAR2 = k.K_DAR2;
        this.V_ENV2 = k.V_ENV2;
        this.E_PTCH = k.E_PTCH;
        this.VXFADE = k.VXFADE;
        this.VZONES = k.VZONES;
        this.LKXF = k.LKXF;
        this.RKXF = k.RKXF;
        this.KBEAT = k.KBEAT;
        this.AHOLD = k.AHOLD;
        this.CP1 = k.CP1;
        this.CP2 = k.CP2;
        this.CP3 = k.CP3;
        this.CP4 = k.CP4;
        this.VZOUT1 = k.VZOUT1;
        this.VZOUT2 = k.VZOUT2;
        this.VZOUT3 = k.VZOUT3;
        this.VZOUT4 = k.VZOUT4;
        this.VSS1 = k.VSS1;
        this.VSS2 = k.VSS2;
        this.VSS3 = k.VSS3;
        this.VSS4 = k.VSS4;
        this.KV_LPO = k.KV_LPO;
    }

    public void copySampleSettingsFrom(Keygroup k) {
        int num = 4;
        System.arraycopy(k.SNAME, 0, this.SNAME, 0, num);
        System.arraycopy(k.LOVEL, 0, this.LOVEL, 0, num);
        System.arraycopy(k.HIVEL, 0, this.HIVEL, 0, num);
        System.arraycopy(k.VTUNOcent, 0, this.VTUNOcent, 0, num);
        System.arraycopy(k.VTUNOsemi, 0, this.VTUNOsemi, 0, num);
        System.arraycopy(k.VLOUD, 0, this.VLOUD, 0, num);
        System.arraycopy(k.VFREQ, 0, this.VFREQ, 0, num);
        System.arraycopy(k.VPANO, 0, this.VPANO, 0, num);
        System.arraycopy(k.ZPLAY, 0, this.ZPLAY, 0, num);
        System.arraycopy(k.LVXF, 0, this.LVXF, 0, num);
        System.arraycopy(k.HVXF, 0, this.HVXF, 0, num);
        System.arraycopy(k.SBADD, 0, this.SBADD, 0, num);
    }

    public byte[] getBytes() throws Exception {
        byte[] dat = this.save();
        return dat;
    }

    public static int[] getCrackedBytes() {
        return new int[]{0, 1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42};
    }

    public String getFileName() {
        return this.sampleFileName;
    }

    public String getName() {
        return this.SNAME[0];
    }

    @Override
    public void load() {
        byte[] data = this.getData();
        this.lowerMidiKey = data[0];
        this.upperMidiKey = data[1];
        this.KGTUNOcent = data[2];
        this.KGTUNOsemi = data[3];
        this.FLIFRQ = data[4];
        this.K_FREQ = data[5];
        this.V_FREQ = data[6];
        this.P_FREQ = data[7];
        this.E_FREQ = data[8];
        this.ATTAK1 = data[9];
        this.DECAY1 = data[10];
        this.SUSTN1 = data[11];
        this.RELSE1 = data[12];
        this.V_ATT1 = data[13];
        this.V_REL1 = data[14];
        this.O_REL1 = data[15];
        this.K_DAR1 = data[16];
        this.ATTAK2 = data[17];
        this.DECAY2 = data[18];
        this.SUSTN2 = data[19];
        this.RELSE2 = data[20];
        this.V_ATT2 = data[21];
        this.V_REL2 = data[22];
        this.O_REL2 = data[23];
        this.K_DAR2 = data[24];
        this.V_ENV2 = data[25];
        this.E_PTCH = data[26];
        this.VXFADE = data[27] > 0;
        this.VZONES = data[28];
        this.LKXF = data[29];
        this.RKXF = data[30];
        int ofs = 31;
        for (int c = 0; c < 4; ++c) {
            this.SNAME[c] = new AkaiString(data, ofs, 12).toString().trim();
            this.LOVEL[c] = data[ofs + 12];
            this.HIVEL[c] = data[ofs + 13];
            this.VTUNOcent[c] = data[ofs + 14];
            this.VTUNOsemi[c] = data[ofs + 15];
            this.VLOUD[c] = data[ofs + 16];
            this.VFREQ[c] = data[ofs + 17];
            this.VPANO[c] = data[ofs + 18];
            this.ZPLAY[c] = data[ofs + 19];
            this.LVXF[c] = data[ofs + 20];
            this.HVXF[c] = data[ofs + 21];
            this.SBADD[c] = AudioToolkit.getInt1(data, ofs + 22);
            ofs += 24;
        }
        this.sampleFileName = this.SNAME[0] + ".s";
        this.KBEAT = data[127];
        this.AHOLD = data[128];
        this.CP1 = data[129] > 0;
        this.CP2 = data[130] > 0;
        this.CP3 = data[131] > 0;
        this.CP4 = data[132] > 0;
        this.VZOUT1 = data[133];
        this.VZOUT2 = data[134];
        this.VZOUT3 = data[135];
        this.VZOUT4 = data[136];
        this.VSS1 = AudioToolkit.getInt1(data, 137);
        this.VSS2 = AudioToolkit.getInt1(data, 139);
        this.VSS3 = AudioToolkit.getInt1(data, 141);
        this.VSS4 = AudioToolkit.getInt1(data, 143);
        this.KV_LPO = data[145];
    }

    private byte[] save() throws Exception {
        byte[] dat = new byte[147];
        dat[0] = (byte)this.lowerMidiKey;
        dat[1] = (byte)this.upperMidiKey;
        dat[2] = (byte)this.KGTUNOcent;
        dat[3] = (byte)this.KGTUNOsemi;
        dat[4] = (byte)this.FLIFRQ;
        dat[5] = (byte)this.K_FREQ;
        dat[6] = (byte)this.V_FREQ;
        dat[7] = (byte)this.P_FREQ;
        dat[8] = (byte)this.E_FREQ;
        dat[9] = (byte)this.ATTAK1;
        dat[10] = (byte)this.DECAY1;
        dat[11] = (byte)this.SUSTN1;
        dat[12] = (byte)this.RELSE1;
        dat[13] = (byte)this.V_ATT1;
        dat[14] = (byte)this.V_REL1;
        dat[15] = (byte)this.O_REL1;
        dat[16] = (byte)this.K_DAR1;
        dat[17] = (byte)this.ATTAK2;
        dat[18] = (byte)this.DECAY2;
        dat[19] = (byte)this.SUSTN2;
        dat[20] = (byte)this.RELSE2;
        dat[21] = (byte)this.V_ATT2;
        dat[22] = (byte)this.V_REL2;
        dat[23] = (byte)this.O_REL2;
        dat[24] = (byte)this.K_DAR2;
        dat[25] = (byte)this.V_ENV2;
        dat[26] = (byte)this.E_PTCH;
        dat[27] = 0;
        if (this.VXFADE) {
            dat[27] = 1;
        }
        dat[28] = (byte)this.VZONES;
        dat[29] = (byte)this.LKXF;
        dat[30] = (byte)this.RKXF;
        try {
            int ofs = 31;
            for (int c = 0; c < 4; ++c) {
                String name = this.SNAME[c];
                if (name == null) {
                    name = "";
                }
                byte[] s = new AkaiString(name, 12).getBytes();
                System.arraycopy(s, 0, dat, ofs, Math.min(12, s.length));
                dat[ofs + 12] = (byte)this.LOVEL[c];
                dat[ofs + 13] = (byte)this.HIVEL[c];
                dat[ofs + 14] = (byte)this.VTUNOcent[c];
                dat[ofs + 15] = (byte)this.VTUNOsemi[c];
                dat[ofs + 16] = (byte)this.VLOUD[c];
                dat[ofs + 17] = (byte)this.VFREQ[c];
                dat[ofs + 18] = (byte)this.VPANO[c];
                dat[ofs + 19] = (byte)this.ZPLAY[c];
                dat[ofs + 20] = (byte)this.LVXF[c];
                dat[ofs + 21] = (byte)this.HVXF[c];
                AudioToolkit.setInt1(dat, ofs + 22, this.SBADD[c]);
                ofs += 24;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        dat[127] = (byte)this.KBEAT;
        dat[128] = (byte)this.AHOLD;
        dat[129] = 0;
        if (this.CP1) {
            dat[129] = 1;
        }
        dat[130] = 0;
        if (this.CP2) {
            dat[130] = 1;
        }
        dat[131] = 0;
        if (this.CP3) {
            dat[131] = 1;
        }
        dat[132] = 0;
        if (this.CP4) {
            dat[132] = 1;
        }
        dat[133] = (byte)this.VZOUT1;
        dat[134] = (byte)this.VZOUT2;
        dat[135] = (byte)this.VZOUT3;
        dat[136] = (byte)this.VZOUT4;
        AudioToolkit.setInt1(dat, 137, this.VSS1);
        AudioToolkit.setInt1(dat, 139, this.VSS2);
        AudioToolkit.setInt1(dat, 141, this.VSS3);
        AudioToolkit.setInt1(dat, 143, this.VSS4);
        dat[145] = (byte)this.KV_LPO;
        return dat;
    }

    public String toString() {
        return "Keygroup Block (data=" + this.getData().length + ")  \r\n" + "  - Sample name: " + this.SNAME[0] + "\r\n" + this.dataString();
    }
}

