/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.akai;

import com.spacekiller.util.media.akai.AkaiBlock;
import com.spacekiller.util.media.akai.AkaiString;
import com.spacekiller.util.media.akai.Keygroup;
import java.util.Enumeration;
import java.util.Vector;

public class Program
extends AkaiBlock {
    private static final int firstFreeKey = 24;
    private static final int lastFreeKey = 127;
    public static final int PRIO_LOW = 0;
    public static final int PRIO_NORMAL = 1;
    public static final int PRIO_HIGH = 2;
    public static final int PRIO_HOLD = 3;
    public String fileName = "";
    public String fileDir = "";
    public Vector keygroups = new Vector();
    public String programName = "";
    public int MIDIprogram = 0;
    public int MIDIchannel = 0;
    public int polyphony = 15;
    public int priority = 1;
    public int playLo = 24;
    public int playHi = 127;
    public int playOct = 0;
    public int outNum = 0;
    public int leftRightLevel = 99;
    public int leftRightBalance = 0;
    public int basicLoudness = 99;
    public int velocityLoudness = 20;
    public int keyLoudness = 0;
    public int pressureLoudness = 0;
    public int panLFOrate = 0;
    public int panDepth = 0;
    public int panLFOdelay = 0;
    public int panPosition = 0;
    public int LFOspeed = 0;
    public int LFOfixedDepth = 0;
    public int LFOdelay = 0;
    public int LFOmodwheel = 9;
    public int LFOpressure = 0;
    public int LFOvelocity = 0;
    public int bendWheel = 0;
    public int pressurePitch = 0;
    public boolean crossfade = false;
    public byte[] keyTemperament = new byte[12];
    public boolean echoLevel = false;
    public int modwheelPan = 0;
    public boolean sampleStart = true;
    public boolean LFOdesync = false;
    public int pitchLaw = 0;
    public int voiceAlgo = 0;
    public int softPedalLoudness = 10;
    public int softPedalAttack = 10;
    public int softPedalFilter = 10;
    public int tuneOffsetCent = 0;
    public int tuneOffsetSemi = 0;
    public int keyLFOrate = 50;
    public int keyLFOdepth = 0;
    public int keyLFOdelay = 0;
    public int voiceScale = 0;
    public int stereoScale = 0;

    public Program(String fdir, String fname) {
        this.fileDir = fdir;
        this.fileName = fname;
        this.setBlockType(1);
    }

    public void addKeygroup(Keygroup kg) {
        this.keygroups.addElement(kg);
    }

    public void addKeygroupAuto(Keygroup kg) {
        int index = this.findFreeKeys(1);
        if (index < 0) {
            index = 0;
        }
        kg.lowerMidiKey = index;
        kg.upperMidiKey = index;
        this.addKeygroup(kg);
    }

    public void copySettingsFrom(Program p) {
        this.fileName = p.fileName;
        this.programName = p.programName;
        this.MIDIprogram = p.MIDIprogram;
        this.MIDIchannel = p.MIDIchannel;
        this.polyphony = p.polyphony;
        this.priority = p.priority;
        this.playLo = p.playLo;
        this.playHi = p.playHi;
        this.playOct = p.playOct;
        this.outNum = p.outNum;
        this.leftRightLevel = p.leftRightLevel;
        this.leftRightBalance = p.leftRightBalance;
        this.basicLoudness = p.basicLoudness;
        this.velocityLoudness = p.velocityLoudness;
        this.keyLoudness = p.keyLoudness;
        this.pressureLoudness = p.pressureLoudness;
        this.panLFOrate = p.panLFOrate;
        this.panDepth = p.panDepth;
        this.panLFOdelay = p.panLFOdelay;
        this.panPosition = p.panPosition;
        this.LFOspeed = p.LFOspeed;
        this.LFOfixedDepth = p.LFOfixedDepth;
        this.LFOdelay = p.LFOdelay;
        this.LFOmodwheel = p.LFOmodwheel;
        this.LFOpressure = p.LFOpressure;
        this.LFOvelocity = p.LFOvelocity;
        this.bendWheel = p.bendWheel;
        this.pressurePitch = p.pressurePitch;
        this.crossfade = p.crossfade;
        System.arraycopy(p.keyTemperament, 0, this.keyTemperament, 0, this.keyTemperament.length);
        this.echoLevel = p.echoLevel;
        this.modwheelPan = p.modwheelPan;
        this.sampleStart = p.sampleStart;
        this.LFOdesync = p.LFOdesync;
        this.pitchLaw = p.pitchLaw;
        this.voiceAlgo = p.voiceAlgo;
        this.softPedalLoudness = p.softPedalLoudness;
        this.softPedalAttack = p.softPedalAttack;
        this.softPedalFilter = p.softPedalFilter;
        this.tuneOffsetCent = p.tuneOffsetCent;
        this.tuneOffsetSemi = p.tuneOffsetSemi;
        this.keyLFOrate = p.keyLFOrate;
        this.keyLFOdepth = p.keyLFOdepth;
        this.keyLFOdelay = p.keyLFOdelay;
        this.voiceScale = p.voiceScale;
        this.stereoScale = p.stereoScale;
    }

    public int findFreeKeys(int num) {
        if (num > 104) {
            return -1;
        }
        int check = 24;
        if (check > 127) {
            return -1;
        }
        for (int c = 0; c < this.keygroups.size(); ++c) {
            Keygroup kg = (Keygroup)this.keygroups.elementAt(c);
            if (kg.lowerMidiKey > check + num - 1 || kg.upperMidiKey < check) continue;
            ++check;
        }
        return check;
    }

    public byte[] getBytes() throws Exception {
        return this.save();
    }

    public static int[] getCrackedBytes() {
        return new int[]{39};
    }

    public String getFileDirectory() {
        return this.fileDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getNumSamples() {
        return this.keygroups.size();
    }

    @Override
    public void load() {
        byte[] data = this.getData();
        this.programName = new AkaiString(data, 0, 12).toString().trim();
        this.MIDIprogram = data[12];
        this.MIDIchannel = data[13];
        this.polyphony = data[14];
        this.priority = data[15];
        this.playLo = data[16];
        this.playHi = data[17];
        this.playOct = data[18];
        this.outNum = data[19];
        this.leftRightLevel = data[20];
        this.leftRightBalance = data[21];
        this.basicLoudness = data[22];
        this.velocityLoudness = data[23];
        this.keyLoudness = data[24];
        this.pressureLoudness = data[25];
        this.panLFOrate = data[26];
        this.panDepth = data[27];
        this.panLFOdelay = data[28];
        this.panPosition = data[29];
        this.LFOspeed = data[30];
        this.LFOfixedDepth = data[31];
        this.LFOdelay = data[32];
        this.LFOmodwheel = data[33];
        this.LFOpressure = data[34];
        this.LFOvelocity = data[35];
        this.bendWheel = data[36];
        this.pressurePitch = data[37];
        this.crossfade = data[38] > 0;
        this.keyTemperament = new byte[12];
        System.arraycopy(data, 41, this.keyTemperament, 0, 12);
        this.echoLevel = data[53] > 0;
        this.modwheelPan = data[54];
        this.sampleStart = data[55] > 0;
        this.LFOdesync = data[56] > 0;
        this.pitchLaw = data[57];
        this.voiceAlgo = data[58];
        this.softPedalLoudness = data[59];
        this.softPedalAttack = data[60];
        this.softPedalFilter = data[61];
        this.tuneOffsetCent = data[62];
        this.tuneOffsetSemi = data[63];
        this.keyLFOrate = data[64];
        this.keyLFOdepth = data[65];
        this.keyLFOdelay = data[66];
        this.voiceScale = data[67];
        this.stereoScale = data[68];
    }

    public void removeKeygroup(Keygroup kg) {
        this.keygroups.removeElement(kg);
    }

    private byte[] save() throws Exception {
        byte[] dat = new byte[147];
        byte[] akai = new AkaiString(this.programName, 12).getBytes();
        System.arraycopy(akai, 0, dat, 0, 12);
        dat[12] = (byte)this.MIDIprogram;
        dat[13] = (byte)this.MIDIchannel;
        dat[14] = (byte)this.polyphony;
        dat[15] = (byte)this.priority;
        dat[16] = (byte)this.playLo;
        dat[17] = (byte)this.playHi;
        dat[18] = (byte)this.playOct;
        dat[19] = (byte)this.outNum;
        dat[20] = (byte)this.leftRightLevel;
        dat[21] = (byte)this.leftRightBalance;
        dat[22] = (byte)this.basicLoudness;
        dat[23] = (byte)this.velocityLoudness;
        dat[24] = (byte)this.keyLoudness;
        dat[25] = (byte)this.pressureLoudness;
        dat[26] = (byte)this.panLFOrate;
        dat[27] = (byte)this.panDepth;
        dat[28] = (byte)this.panLFOdelay;
        dat[29] = (byte)this.panPosition;
        dat[30] = (byte)this.LFOspeed;
        dat[31] = (byte)this.LFOfixedDepth;
        dat[32] = (byte)this.LFOdelay;
        dat[33] = (byte)this.LFOmodwheel;
        dat[34] = (byte)this.LFOpressure;
        dat[35] = (byte)this.LFOvelocity;
        dat[36] = (byte)this.bendWheel;
        dat[37] = (byte)this.pressurePitch;
        dat[38] = this.crossfade ? (byte)1 : 0;
        dat[39] = (byte)this.keygroups.size();
        dat[40] = 0;
        System.arraycopy(this.keyTemperament, 0, dat, 41, Math.max(12, this.keyTemperament.length));
        dat[53] = 0;
        if (this.echoLevel) {
            dat[53] = 1;
        }
        dat[54] = (byte)this.modwheelPan;
        dat[55] = 0;
        if (this.sampleStart) {
            dat[55] = 1;
        }
        dat[56] = 0;
        if (this.LFOdesync) {
            dat[56] = 1;
        }
        dat[57] = (byte)this.pitchLaw;
        dat[58] = (byte)this.voiceAlgo;
        dat[59] = (byte)this.softPedalLoudness;
        dat[60] = (byte)this.softPedalAttack;
        dat[61] = (byte)this.softPedalFilter;
        dat[62] = (byte)this.tuneOffsetCent;
        dat[63] = (byte)this.tuneOffsetSemi;
        dat[64] = (byte)this.keyLFOrate;
        dat[65] = (byte)this.keyLFOdepth;
        dat[66] = (byte)this.keyLFOdelay;
        dat[67] = (byte)this.voiceScale;
        dat[68] = (byte)this.stereoScale;
        return dat;
    }

    public void setFileDirectory(String fd) {
        this.fileDir = fd;
    }

    public String toString() {
        String s = "";
        Enumeration en = this.keygroups.elements();
        while (en.hasMoreElements()) {
            s = s + "  - " + en.nextElement() + " \r\n";
        }
        return "*Program Block (data=" + this.getData().length + ") \r\n" + s;
    }
}

