/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.akai;

import com.spacekiller.util.media.akai.AkaiString;
import com.spacekiller.util.media.akai.AudioFile;
import com.spacekiller.util.media.akai.AudioToolkit;
import com.spacekiller.util.media.akai.SampleAudioFileFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SampleAudioFile
extends AudioFile {
    public static final int SAMPLE_HEADER_SIZE = 150;
    public static byte[] SAMPLE_HEADER = new byte[]{3, 1, 60, 28, 18, 35, 10, 22, 19, 24, 15, 10, 1, 4, 10, -128, 0, 0, 0, 0, 0, 0, -64, -115, 94, 0, -64, -124, 1, 0, 32, 0, 0, 0, -73, -124, 1, 0, 0, -60, 1, 0, 0, 0, 44, 3, 0, 0, 0, 0, 0, -60, 1, 0, 0, 0, 44, 3, 0, 0, 0, 0, 0, -60, 1, 0, 0, 0, 44, 3, 0, 0, 0, 0, 0, -60, 1, 0, 0, 0, 44, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 68, -84, 0, 0, 0, -114, -61, -114, -37, -24, 41, 0};
    public static final int LOOP_IN_RELEASE = 0;
    public static final int LOOP_UNTIL_RELEASE = 1;
    public static final int LOOP_NONE = 2;
    public static final int LOOP_PLAY_TO_END = 3;
    int baseNote = 0;
    int sampleWords = 0;
    int startMarker = 0;
    int endMarker = 0;
    int loops = 0;
    int loopMode = 0;
    int fineTune = 0;
    int coarseTune = 0;
    int[] loopMarker = new int[8];
    int[] loopFineLength = new int[8];
    int[] loopCoarseLength = new int[8];
    int[] loopTime = new int[8];
    private static final Logger logger = Logger.getLogger(SampleAudioFile.class.getName());

    @Override
    public void copySampleFrom(AudioFile f) throws Exception {
        super.copySampleFrom(f);
        if (f instanceof SampleAudioFile) {
            SampleAudioFile s = (SampleAudioFile)f;
            this.setBaseNote(s.getBaseNote());
            this.sampleWords = s.sampleWords;
            this.startMarker = s.startMarker;
            this.endMarker = s.endMarker;
            this.loops = s.loops;
            this.loopMode = s.loopMode;
            this.fineTune = s.fineTune;
            this.coarseTune = s.coarseTune;
            System.arraycopy(s.loopMarker, 0, this.loopMarker, 0, 8);
            System.arraycopy(s.loopFineLength, 0, this.loopFineLength, 0, 8);
            System.arraycopy(s.loopCoarseLength, 0, this.loopCoarseLength, 0, 8);
            System.arraycopy(s.loopTime, 0, this.loopTime, 0, 8);
        }
    }

    public AudioFormat getAudioFormat() {
        float sampleRate;
        SampleAudioFile sample = this;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        int channels = sample.getSamplingChannels();
        int sampleBits = 16;
        int frameSize = sampleBits * channels / 8;
        float frameRate = sampleRate = (float)sample.getSamplingRate();
        boolean bigEndian = false;
        AudioFormat format = new AudioFormat(encoding, sampleRate, sampleBits, channels, frameSize, frameRate, bigEndian);
        return format;
    }

    public int getBaseNote() {
        return this.baseNote;
    }

    int[] createCrackedBytes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 19, 20, 21, 26, 27, 28, 29, 34, 35, 36, 37, 138, 139, 140, 141};
    }

    @Override
    public String getFormat() {
        return "Akai sample file";
    }

    public String getSamplePath() {
        return this.getFileDirectory() + File.separator + this.getFileName();
    }

    public boolean read() throws Exception {
        if (this.header == null) {
            return false;
        }
        this.setTitle(new AkaiString(this.header, 3, 12).getString());
        this.setBaseNote(AudioToolkit.getByte(this.header, 2));
        this.loops = AudioToolkit.getByte(this.header, 16);
        this.loopMode = AudioToolkit.getByte(this.header, 19);
        this.fineTune = AudioToolkit.getByte(this.header, 20);
        this.coarseTune = AudioToolkit.getByte(this.header, 21);
        this.sampleWords = AudioToolkit.getLong1(this.header, 26);
        this.startMarker = AudioToolkit.getLong1(this.header, 30);
        this.endMarker = AudioToolkit.getLong1(this.header, 34);
        for (int c = 0; c < 8; ++c) {
            this.loopMarker[c] = AudioToolkit.getLong1(this.header, 38 + c * 12);
            this.loopFineLength[c] = AudioToolkit.getInt1(this.header, 42 + c * 12);
            this.loopCoarseLength[c] = AudioToolkit.getLong1(this.header, 44 + c * 12);
            this.loopTime[c] = AudioToolkit.getInt1(this.header, 48 + c * 12);
        }
        this.setSamplingRate(AudioToolkit.getLong1(this.header, 138));
        this.setSamplingBytes(2);
        this.setSamplingChannels(1);
        return true;
    }

    @Override
    public void readSampleData() throws Exception {
        FileInputStream io = new FileInputStream(this.getSamplePath());
        ((InputStream)io).skip(150L);
        byte[] data = new byte[this.dataSize];
        ((InputStream)io).read(data);
        this.setSamplingData(data);
        ((InputStream)io).close();
    }

    public static SampleAudioFile readSampleFile(String fname, InputStream io) throws Exception {
        byte[] dat = new byte[150];
        int numRead = io.read(dat);
        if (numRead < 150) {
            throw new UnsupportedAudioFileException("Invalid sample file");
        }
        for (int c = 0; c < 3; ++c) {
            if (dat[c] == SAMPLE_HEADER[c]) continue;
            throw new UnsupportedAudioFileException("Invalid sample file header: ofs=" + c + ", value=" + dat[c] + " != " + SAMPLE_HEADER[c]);
        }
        SampleAudioFile s = new SampleAudioFile();
        s.setFileHeader(dat);
        System.arraycopy(dat, 0, SAMPLE_HEADER, 0, 150);
        s.read();
        int q = s.sampleWords * s.getSamplingBytes();
        s.setSamplingData(q);
        return s;
    }

    @Override
    public void saveTo(OutputStream io) throws Exception {
        int c;
        byte[] head = new byte[150];
        head[0] = 3;
        head[1] = 1;
        head[2] = (byte)this.getBaseNote();
        head[15] = -128;
        head[16] = (byte)this.loops;
        head[17] = 0;
        head[18] = 0;
        head[19] = (byte)this.loopMode;
        head[20] = (byte)this.fineTune;
        head[21] = (byte)this.coarseTune;
        head[22] = 0;
        head[23] = 8;
        head[24] = 2;
        head[25] = 0;
        AudioToolkit.setLong1(head, 26, this.getSamples());
        AudioToolkit.setLong1(head, 30, this.startMarker);
        AudioToolkit.setLong1(head, 34, this.endMarker);
        for (c = 0; c < 8; ++c) {
            AudioToolkit.setLong1(head, 38 + c * 12, this.loopMarker[c]);
            AudioToolkit.setInt1(head, 42 + c * 12, this.loopFineLength[c]);
            AudioToolkit.setLong1(head, 44 + c * 12, this.loopCoarseLength[c]);
            AudioToolkit.setInt1(head, 48 + c * 12, this.loopTime[c]);
        }
        head[134] = 0;
        head[135] = 0;
        head[136] = -1;
        head[137] = -1;
        AudioToolkit.setLong1(head, 138, this.getSamplingRate());
        for (c = 142; c < 150; ++c) {
            head[c] = 0;
        }
        String n = this.name.toUpperCase();
        byte[] st = new AkaiString(n, 12).getBytes();
        System.arraycopy(st, 0, head, 3, st.length);
        io.write(head);
        io.write(this.getSamplingData());
    }

    public void setBaseNote(int n) {
        this.baseNote = n;
    }

    @Override
    public String toString() {
        return "Akai-Sample " + this.getTitle();
    }

    private static SampleAudioFileFormat getSampleFileFormat(SampleAudioFile sampleFile) {
        AudioFormat audioFormat = sampleFile.getAudioFormat();
        int frames = sampleFile.getSamples();
        return new SampleAudioFileFormat(SampleAudioFileFormat.SAMPLE, audioFormat, frames);
    }

    public static AudioFileFormat getAudioFileFormat(InputStream in) throws IOException, UnsupportedAudioFileException {
        in.mark(256);
        try {
            String fileName = "unknown";
            SampleAudioFile sampleFile = SampleAudioFile.readSampleFile(fileName, in);
            return SampleAudioFile.getSampleFileFormat(sampleFile);
        }
        catch (UnsupportedAudioFileException e) {
            in.reset();
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            in.reset();
            throw new IOException("" + e);
        }
    }

    public static AudioInputStream getAudioInputStream(InputStream in) throws IOException, UnsupportedAudioFileException {
        in.mark(256);
        try {
            String fileName = "unknown";
            SampleAudioFile sampleFile = SampleAudioFile.readSampleFile(fileName, in);
            SampleAudioFileFormat sampleFileFormat = SampleAudioFile.getSampleFileFormat(sampleFile);
            AudioFormat audioFormat = sampleFileFormat.getFormat();
            long frameLength = sampleFileFormat.getFrameLength();
            return new AudioInputStream(in, audioFormat, frameLength);
        }
        catch (UnsupportedAudioFileException e) {
            in.reset();
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            in.reset();
            throw new IOException("" + e);
        }
    }
}

