/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.akai;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.akai.SampleAudioFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SampleAudioFileMediaScanner
implements MediaScanner {
    private static final Logger logger = Logger.getLogger(SampleAudioFileMediaScanner.class.getName());
    public static final String FORMAT_AKAI = "AKAI";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEntry scanMediaResource(Resource resource, MediaEntry me) throws IOException {
        AudioFileFormat format = null;
        InputStream in = resource.createInputStream();
        try {
            format = SampleAudioFile.getAudioFileFormat(in);
        }
        catch (UnsupportedAudioFileException e) {
            MediaEntry mediaEntry = null;
            return mediaEntry;
        }
        catch (IOException e) {
            MediaEntry mediaEntry = null;
            return mediaEntry;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            MediaEntry mediaEntry = null;
            return mediaEntry;
        }
        finally {
            in.close();
        }
        if (format == null) {
            return null;
        }
        Object mme = me != null && me instanceof MutableMediaEntry ? (MutableMediaEntry)me : new DefaultMediaEntry();
        AudioEntry ae = mme.getAudioEntry();
        Object mae = ae != null && ae instanceof MutableAudioEntry ? (MutableAudioEntry)ae : new DefaultAudioEntry();
        mme.setAudioEntry((AudioEntry)mae);
        mme.setResource(resource);
        mme.setFormat(FORMAT_AKAI);
        return mme;
    }
}

