/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.akai;

import com.spacekiller.util.Tools;
import com.spacekiller.util.format.AbstractFileFormat;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.format.SimpleFileFormatSignature;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.akai.SampleAudioFileMediaScanner;

public class SampleMediaFileFormat
extends AbstractFileFormat
implements MediaFileFormat {
    public static final String FORMAT_NAME = "AKAI";
    private static final String DEFAULT_FILE_EXTENSION = ".s";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{".s"};
    private static final String FILE_FORMAT_TITLE = "AKAI Audio Sample File";
    private static final String FILE_FORMAT_ICON = "/com/spacekiller/util/media/akai/icons/akai_sample.gif";
    private SimpleFileFormatSignature sampleFileSignature;
    private MediaScanner mediaScanner;

    public SampleMediaFileFormat() {
        super(FORMAT_NAME);
        this.initMediaFileFormat();
    }

    protected void initMediaFileFormat() {
        this.setFormatTitle(FILE_FORMAT_TITLE);
        this.setDefaultFormatIcon(Tools.getIcon(((Object)((Object)this)).getClass(), (String)FILE_FORMAT_ICON));
        this.setDefaultExtension(DEFAULT_FILE_EXTENSION);
        this.setSupportedExtensions(SUPPORTED_FILE_EXTENSIONS);
        this.sampleFileSignature = new SimpleFileFormatSignature("AKAI Sample Header", (FileFormat)this, 0, new byte[]{3, 1, 60});
        this.setSupportedSignatures(new FileFormatSignature[]{this.sampleFileSignature});
    }

    public int getSupportedMediaFlags() {
        return 1;
    }

    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            this.mediaScanner = new SampleAudioFileMediaScanner();
        }
        return this.mediaScanner;
    }
}

