/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import com.waxmonster.audio.jsound.JSoundLineProperties;
import com.waxmonster.audio.jsound.JSoundMixerProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class AudioSystemManager {
    private static final Logger logger = Logger.getLogger(AudioSystemManager.class.getName());
    private static AudioSystemManager INSTANCE;
    private List mixerProps;

    protected AudioSystemManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AudioSystemManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AudioSystemManager> clazz = AudioSystemManager.class;
        synchronized (AudioSystemManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = AudioSystemManager.createInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static AudioSystemManager createInstance() {
        return new AudioSystemManager();
    }

    public synchronized JSoundMixerProperties[] getJSoundMixerProperties() {
        if (this.mixerProps == null) {
            this.refreshJSoundMixerProperties();
        }
        return this.mixerProps.toArray(new JSoundMixerProperties[this.mixerProps.size()]);
    }

    public synchronized void refreshJSoundMixerProperties() {
        LinkedList<JSoundMixerProperties> newProps = new LinkedList<JSoundMixerProperties>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of available audio mixers: " + mixerInfos.length);
        }
        for (int i = 0; i < mixerInfos.length; ++i) {
            Mixer.Info mixerInfo = mixerInfos[i];
            try {
                String mixerName = mixerInfo.getName();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Audio mixer #" + i + ": name=" + mixerName + ", version=" + mixerInfo.getVersion() + ", vendor=" + mixerInfo.getVendor() + ", description=" + mixerInfo.getDescription());
                }
                JSoundMixerProperties mixerProps = new JSoundMixerProperties(mixerName, mixerInfo);
                Mixer mixer = AudioSystem.getMixer(mixerInfo);
                LinkedList<JSoundLineProperties> inputLineProps = new LinkedList<JSoundLineProperties>();
                Line.Info[] infos = mixer.getTargetLineInfo();
                for (int k = 0; k < infos.length; ++k) {
                    Line.Info lineInfo = infos[k];
                    Class<?> lineClass = lineInfo.getLineClass();
                    if (lineClass == null || !TargetDataLine.class.isAssignableFrom(lineClass)) continue;
                    String lineName = mixerName;
                    try {
                        Line line = mixer.getLine(lineInfo);
                        if (line == null || !(line instanceof TargetDataLine)) continue;
                        TargetDataLine targetLine = (TargetDataLine)line;
                        AudioFormat audioFormat = targetLine.getFormat();
                        int bufferSize = targetLine.getBufferSize();
                        JSoundLineProperties lineProps = new JSoundLineProperties(mixerProps, lineName, lineInfo, audioFormat, bufferSize);
                        inputLineProps.add(lineProps);
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                LinkedList<JSoundLineProperties> outputLineProps = new LinkedList<JSoundLineProperties>();
                infos = mixer.getSourceLineInfo();
                for (int k = 0; k < infos.length; ++k) {
                    Line.Info lineInfo = infos[k];
                    Class<?> lineClass = lineInfo.getLineClass();
                    if (lineClass == null || !SourceDataLine.class.isAssignableFrom(lineClass)) continue;
                    String lineName = mixerName;
                    try {
                        Line line = mixer.getLine(lineInfo);
                        if (line == null || !(line instanceof SourceDataLine)) continue;
                        SourceDataLine sourceLine = (SourceDataLine)line;
                        AudioFormat audioFormat = sourceLine.getFormat();
                        int bufferSize = sourceLine.getBufferSize();
                        JSoundLineProperties lineProps = new JSoundLineProperties(mixerProps, lineName, lineInfo, audioFormat, bufferSize);
                        outputLineProps.add(lineProps);
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                JSoundLineProperties[] inputArray = inputLineProps.toArray(new JSoundLineProperties[inputLineProps.size()]);
                JSoundLineProperties[] outputArray = outputLineProps.toArray(new JSoundLineProperties[outputLineProps.size()]);
                if (logger.isLoggable(Level.FINER)) {
                    JSoundLineProperties lineProps;
                    int k;
                    logger.finer(" - Mixer lines: inputs=" + inputArray.length + ", outputs=" + outputArray.length);
                    for (k = 0; k < inputArray.length; ++k) {
                        lineProps = inputArray[k];
                        logger.finer(" <- Input line #" + k + ": name=" + lineProps.getLineName() + ", audioFormat=" + lineProps.getAudioFormat() + ", bufferSize=" + lineProps.getBufferSize());
                    }
                    for (k = 0; k < outputArray.length; ++k) {
                        lineProps = outputArray[k];
                        logger.finer(" -> Output line #" + k + ": name=" + lineProps.getLineName() + ", audioFormat=" + lineProps.getAudioFormat() + ", bufferSize=" + lineProps.getBufferSize());
                    }
                }
                mixerProps.setInputLines(inputArray);
                mixerProps.setOutputLines(outputArray);
                newProps.add(mixerProps);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.mixerProps = newProps;
    }

    public synchronized Mixer openMixer(Mixer.Info mixerInfo) throws LineUnavailableException {
        Mixer mixer;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Loading JSound mixer: " + mixerInfo);
        }
        if ((mixer = AudioSystem.getMixer(mixerInfo)) != null) {
            mixer.open();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Loaded JSound mixer: " + mixerInfo + " => " + mixer);
        }
        return mixer;
    }

    public synchronized void closeMixer(Mixer mixer) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closing JSound mixer: " + mixer);
        }
        mixer.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closed JSound mixer: " + mixer);
        }
    }

    public synchronized TargetDataLine openTargetDataLine(Mixer mixer, Line.Info lineInfo, AudioFormat audioFormat, int bufferSize) throws LineUnavailableException {
        Line line;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Opening TargetDataLine: mixer=" + mixer.getMixerInfo() + ", line=" + lineInfo);
        }
        if ((line = mixer.getLine(lineInfo)) == null) {
            return null;
        }
        TargetDataLine target = (TargetDataLine)line;
        if (target != null) {
            if (audioFormat == null) {
                target.open();
            } else if (bufferSize < 1) {
                target.open(audioFormat);
            } else {
                target.open(audioFormat, bufferSize);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Opened TargetDataLine: line=" + target + ", format=" + target.getFormat() + ", bufferSize=" + target.getBufferSize());
        }
        return target;
    }

    public synchronized void closeTargetDataLine(TargetDataLine line) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closing TargetDataLine: " + line);
        }
        if (line.isActive()) {
            line.stop();
        }
        if (line.isOpen()) {
            line.close();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closed TargetDataLine: " + line);
        }
    }

    public synchronized SourceDataLine openSourceDataLine(Mixer mixer, Line.Info lineInfo, AudioFormat audioFormat, int bufferSize) throws LineUnavailableException {
        Line line;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Opening SourceDataLine: mixer=" + mixer.getMixerInfo() + ", line=" + lineInfo);
        }
        if ((line = mixer.getLine(lineInfo)) == null) {
            return null;
        }
        SourceDataLine source = (SourceDataLine)line;
        if (source != null) {
            if (audioFormat == null) {
                source.open();
            } else if (bufferSize < 1) {
                source.open(audioFormat);
            } else {
                source.open(audioFormat, bufferSize);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Opened SourceDataLine: line=" + source + ", format=" + source.getFormat() + ", bufferSize=" + source.getBufferSize());
        }
        return source;
    }

    public synchronized void closeSourceDataLine(SourceDataLine line) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closing SourceDataLine: " + line);
        }
        if (line.isActive()) {
            line.stop();
        }
        if (line.isOpen()) {
            line.close();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closed SourceDataLine: " + line);
        }
    }
}

