/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.sound.sampled.AudioFormat;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BufferSizeChooser
extends JPanel
implements ItemSelectable {
    private static final long serialVersionUID = 7553597857750124380L;
    private static final String UNIT_MILLIS = "millis";
    private static final String UNIT_FRAMES = "frames";
    private static final String UNIT_BYTES = "bytes";
    private AudioFormat audioFormat;
    private int bufferSize;
    private boolean refreshingSlider = false;
    private boolean refreshingTextField = false;
    private JTextField jTextFieldBufferSize = null;
    private JSlider jSliderBufferSize = null;
    private transient ItemListener itemListeners;
    private JComboBox jComboBoxUnit = null;

    public BufferSizeChooser() {
        this.initialize();
        this.initBufferSizeChooser();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints3.gridx = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.gridx = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(381, 40));
        this.add((Component)this.getJTextFieldBufferSize(), gridBagConstraints);
        this.add((Component)this.getJSliderBufferSize(), gridBagConstraints1);
        this.add((Component)this.getJComboBoxUnit(), gridBagConstraints3);
    }

    private JTextField getJTextFieldBufferSize() {
        if (this.jTextFieldBufferSize == null) {
            this.jTextFieldBufferSize = new JTextField();
            this.jTextFieldBufferSize.setPreferredSize(new Dimension(60, 20));
            this.jTextFieldBufferSize.setMinimumSize(new Dimension(60, 20));
            this.jTextFieldBufferSize.setColumns(4);
            this.jTextFieldBufferSize.setOpaque(false);
        }
        return this.jTextFieldBufferSize;
    }

    private JSlider getJSliderBufferSize() {
        if (this.jSliderBufferSize == null) {
            this.jSliderBufferSize = new JSlider();
            this.jSliderBufferSize.setOpaque(false);
            this.jSliderBufferSize.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!BufferSizeChooser.this.refreshingSlider) {
                        int value = BufferSizeChooser.this.jSliderBufferSize.getValue();
                        if (BufferSizeChooser.this.audioFormat != null) {
                            int frameSize = BufferSizeChooser.this.audioFormat.getFrameSize();
                            value = value / frameSize * frameSize;
                        }
                        BufferSizeChooser.this.setBufferSize(value);
                    }
                }
            });
        }
        return this.jSliderBufferSize;
    }

    protected void fireItemStateChanged(ItemEvent e) {
        if (this.itemListeners == null) {
            return;
        }
        this.itemListeners.itemStateChanged(e);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners((EventListener)this.itemListeners, ItemListener.class);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        if (!this.refreshingSlider) {
            this.refreshBufferSizeSlider();
        }
        if (!this.refreshingTextField) {
            this.refreshBufferSizeTextField();
        }
        this.fireItemStateChanged(new ItemEvent(this, 701, null, 1));
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
        int min = 0;
        int max = 0;
        int minorTickSpacing = 1;
        int majorTickSpacing = 10;
        if (audioFormat != null) {
            float frameRate = audioFormat.getFrameRate();
            int frameSize = audioFormat.getFrameSize();
            max = frameSize * (int)(frameRate / 5.0f);
            min = (int)(frameRate / 1000.0f);
            min = this.nextHigherPowerOf2(min) * frameSize;
            minorTickSpacing = frameSize * 64;
            majorTickSpacing = frameSize * 1024;
        }
        this.getJSliderBufferSize().setMinimum(min);
        this.getJSliderBufferSize().setMaximum(max);
        this.getJSliderBufferSize().setValue(this.bufferSize);
        this.getJSliderBufferSize().setMinorTickSpacing(minorTickSpacing);
        this.getJSliderBufferSize().setMajorTickSpacing(majorTickSpacing);
    }

    private int nextHigherPowerOf2(int value) {
        int v;
        for (v = 1; v < value; v <<= 1) {
        }
        return v;
    }

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.jSliderBufferSize.setEnabled(enabled);
        this.jTextFieldBufferSize.setEnabled(enabled);
        this.jComboBoxUnit.setEnabled(enabled);
    }

    private JComboBox getJComboBoxUnit() {
        if (this.jComboBoxUnit == null) {
            this.jComboBoxUnit = new JComboBox();
            this.jComboBoxUnit.setOpaque(false);
            this.jComboBoxUnit.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!BufferSizeChooser.this.refreshingTextField) {
                        BufferSizeChooser.this.refreshBufferSizeTextField();
                    }
                }
            });
        }
        return this.jComboBoxUnit;
    }

    private void initBufferSizeChooser() {
        this.getJTextFieldBufferSize().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BufferSizeChooser.this.handleBufferSizeTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BufferSizeChooser.this.handleBufferSizeTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BufferSizeChooser.this.handleBufferSizeTextChanged();
            }
        });
        this.getJComboBoxUnit().removeAllItems();
        this.getJComboBoxUnit().addItem(UNIT_MILLIS);
        this.getJComboBoxUnit().addItem(UNIT_FRAMES);
        this.getJComboBoxUnit().addItem(UNIT_BYTES);
        this.getJComboBoxUnit().setSelectedItem(UNIT_FRAMES);
        this.getJSliderBufferSize().setSnapToTicks(true);
        this.getJSliderBufferSize().setPaintTicks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshBufferSizeSlider() {
        try {
            this.refreshingSlider = true;
            this.getJSliderBufferSize().setValue(this.bufferSize);
        }
        finally {
            this.refreshingSlider = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshBufferSizeTextField() {
        try {
            String text;
            this.refreshingTextField = true;
            Object unit = this.getJComboBoxUnit().getSelectedItem();
            if (unit == UNIT_MILLIS) {
                double ms = 0.0;
                if (this.audioFormat != null) {
                    int bytesPerSecond = (int)this.audioFormat.getFrameRate() * this.audioFormat.getFrameSize();
                    ms = (double)this.bufferSize * 1000.0 / (double)bytesPerSecond;
                }
                text = String.valueOf((double)Math.round(ms * 100.0) / 100.0);
            } else if (unit == UNIT_FRAMES) {
                int frames = 0;
                if (this.audioFormat != null) {
                    frames = this.bufferSize / this.audioFormat.getFrameSize();
                }
                text = String.valueOf(frames);
            } else {
                text = String.valueOf(this.bufferSize);
            }
            this.getJTextFieldBufferSize().setText(text);
        }
        finally {
            this.refreshingTextField = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleBufferSizeTextChanged() {
        if (this.refreshingTextField) {
            return;
        }
        int newBufferSize = 0;
        try {
            String text = this.getJTextFieldBufferSize().getText().trim();
            Object unit = this.getJComboBoxUnit().getSelectedItem();
            if (unit == UNIT_MILLIS) {
                if (this.audioFormat == null) {
                    return;
                }
                int frameSize = this.audioFormat.getFrameSize();
                int bytesPerSecond = (int)this.audioFormat.getFrameRate() * frameSize;
                double ms = Double.parseDouble(text);
                newBufferSize = (int)(ms * (double)bytesPerSecond / 1000.0);
                newBufferSize = newBufferSize / frameSize * frameSize;
            } else if (unit == UNIT_FRAMES) {
                if (this.audioFormat == null) {
                    return;
                }
                int frames = Integer.parseInt(text);
                newBufferSize = frames * this.audioFormat.getFrameSize();
            } else {
                newBufferSize = Integer.parseInt(text);
            }
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            this.refreshingTextField = true;
            this.setBufferSize(newBufferSize);
        }
        finally {
            this.refreshingTextField = false;
        }
    }
}

