/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import com.spacekiller.util.Clock;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SoundUtil;
import com.waxmonster.audio.AudioContext;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.AbstractAudioEngine;
import com.waxmonster.audio.impl.AudioContextImpl;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.Wrapper;
import com.waxmonster.audio.impl.WrapperInputPort;
import com.waxmonster.audio.impl.WrapperOutputPort;
import com.waxmonster.audio.impl.WrapperPort;
import com.waxmonster.audio.jsound.AudioSystemManager;
import com.waxmonster.audio.jsound.JSoundAudioInputPort;
import com.waxmonster.audio.jsound.JSoundAudioOutputPort;
import com.waxmonster.audio.jsound.JSoundAudioReader;
import com.waxmonster.audio.jsound.JSoundAudioSupport;
import com.waxmonster.audio.jsound.JSoundAudioSyncGroup;
import com.waxmonster.audio.jsound.JSoundAudioThread;
import com.waxmonster.audio.jsound.JSoundAudioWriter;
import com.waxmonster.audio.jsound.JSoundDevice;
import com.waxmonster.audio.jsound.JSoundLineProperties;
import com.waxmonster.audio.jsound.JSoundMixerProperties;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class JSoundAudioEngine
extends AbstractAudioEngine {
    private static final Logger logger = Logger.getLogger(JSoundAudioEngine.class.getName());
    private final String name;
    private final Clock clock;
    private final ThreadManager threadManager;
    private final int threadPriority;
    private JSoundAudioSupport jsoundAudioSupport;
    private JSoundAudioSyncGroup jsoundSyncGroup;
    private AudioContextImpl audioContext;
    private AudioSystemManager audioSystemManager;
    private Mixer mixer;
    private SourceDataLine sourceDataLine;
    private TargetDataLine targetDataLine;
    private Wrapper syncGroupWrapper;
    private JSoundSourceInfo jsoundSourceInfo;
    private JSoundTargetInfo jsoundTargetInfo;
    private JSoundAudioThread audioThread;

    public JSoundAudioEngine(String name, Clock clock, ThreadManager threadManager, int threadPriority, AudioEngineConfig config) {
        super(config);
        this.name = name;
        this.clock = clock;
        this.threadManager = threadManager;
        this.threadPriority = threadPriority;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    public void prepare(AudioSyncGroup group, AudioContext context) throws AudioException {
        AudioContextImpl syncGroupContext = this.getAudioContextImpl(context);
        if (group == null || !(group instanceof JSoundAudioSyncGroup)) {
            throw new AudioException("Invalid AudioSyncGroup: " + group);
        }
        JSoundAudioSyncGroup jsoundGroup = (JSoundAudioSyncGroup)group;
        JSoundAudioSupport jsoundSupport = jsoundGroup.getJSoundSupport();
        this.prepareJSoundDriver(jsoundSupport, syncGroupContext);
    }

    public void start() throws AudioException {
        this.startJSoundDriver();
    }

    final void activateJSoundAudioDevice(JSoundDevice device, JSoundAudioSyncGroup syncGroup) throws StudioException {
        AudioContextImpl syncGroupContext;
        Studio studio = device.getStudio();
        if (studio == null) {
            throw new StudioException("Device is not assigned to a studio: " + (Object)((Object)device));
        }
        JSoundAudioSupport jsoundSupport = syncGroup.getJSoundSupport();
        boolean prepared = this.prepareJSoundDriver(jsoundSupport, syncGroupContext = this.createAudioContextImpl(studio));
        if (prepared) {
            this.startJSoundDriver();
        }
    }

    final void deactivateJSoundAudioDevice(JSoundDevice device, JSoundAudioSyncGroup syncGroup) throws AudioException {
        JSoundAudioSupport jsoundSupport = syncGroup.getJSoundSupport();
        this.deactivateJSoundDriver(jsoundSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareJSoundDriver(JSoundAudioSupport support, AudioContextImpl syncGroupContext) throws AudioException {
        JSoundAudioSyncGroup syncGroup;
        JSoundAudioEngine jSoundAudioEngine = this;
        synchronized (jSoundAudioEngine) {
            if (this.jsoundAudioSupport == support) {
                return false;
            }
            if (this.jsoundAudioSupport != null) {
                throw new AudioException("JSoundAudioEngine is already activated: " + (Object)((Object)this));
            }
            syncGroup = support.getJSoundAudioSyncGroup();
            if (syncGroup == null) {
                throw new AudioException("No JSoundAudioSyncGroup available: " + (Object)((Object)support));
            }
            JSoundAudioEngine engine = syncGroup.getJSoundEngine();
            if (engine != this) {
                throw new AudioException("Invalid JSoundAudioEngine: " + (Object)((Object)engine) + " != " + (Object)((Object)this));
            }
            this.jsoundAudioSupport = support;
            this.jsoundSyncGroup = syncGroup;
            this.audioContext = syncGroupContext;
        }
        boolean success = false;
        try {
            SampleBufferProxy bufferProxy;
            ByteArraySampleBuffer rsb;
            JSoundMixerProperties mixerProps;
            AudioSyncGroup sourceGroup2;
            AudioSupport sourceSupport;
            Device sourceDevice;
            AudioOutputPort sourcePort2;
            JSoundSourceInfo sourceInfo = null;
            JSoundAudioOutputPort jsoundOutputPort = syncGroup.getJSoundAudioOutputPort();
            if (jsoundOutputPort != null) {
                LinkedList<AudioInputPort> targetPortList = new LinkedList<AudioInputPort>();
                LinkedList<AudioSyncGroup> targetGroupList = new LinkedList<AudioSyncGroup>();
                Connection[] conns = jsoundOutputPort.getConnections();
                for (int k = 0; k < conns.length; ++k) {
                    Port partner = conns[k].getPartner((Port)jsoundOutputPort);
                    if (partner == null) continue;
                    if (partner instanceof AudioInputPort) {
                        AudioSyncGroup destGroup;
                        AudioSupport destSupport;
                        AudioInputPort destPort = (AudioInputPort)partner;
                        Device destDevice = destPort.getDevice();
                        if (!destDevice.isEnabled() || (destSupport = destPort.getAudioSupport()) == null || (destGroup = destSupport.getAudioSyncGroup((AudioPort)destPort)) == null) continue;
                        targetPortList.add(destPort);
                        targetGroupList.add(destGroup);
                        continue;
                    }
                    throw new StudioException("Unsupported partner port: " + partner);
                }
                if (targetPortList != null) {
                    AudioInputPort[] targetPorts = targetPortList.toArray(new AudioInputPort[targetPortList.size()]);
                    AudioSyncGroup[] targetGroups = targetGroupList.toArray(new AudioSyncGroup[targetGroupList.size()]);
                    sourceInfo = new JSoundSourceInfo(jsoundOutputPort, 0, targetPorts, targetGroups);
                }
            }
            JSoundTargetInfo targetInfo = null;
            JSoundAudioInputPort jsoundInputPort = syncGroup.getJSoundAudioInputPort();
            if (jsoundInputPort != null && (sourcePort2 = jsoundInputPort.getSourcePort()) != null && (sourceDevice = sourcePort2.getDevice()).isEnabled() && (sourceSupport = sourcePort2.getAudioSupport()) != null && (sourceGroup2 = sourceSupport.getAudioSyncGroup((AudioPort)sourcePort2)) != null) {
                targetInfo = new JSoundTargetInfo(sourcePort2, sourceGroup2, jsoundInputPort, 0);
            }
            if (sourceInfo == null && targetInfo == null) {
                success = true;
                boolean sourcePort2 = false;
                return sourcePort2;
            }
            JSoundDevice jsoundDevice = support.getDevice();
            JSoundLineProperties lineProps = jsoundDevice.getLineProperties();
            JSoundMixerProperties jSoundMixerProperties = mixerProps = lineProps == null ? null : lineProps.getMixerProperties();
            if (mixerProps == null) {
                success = true;
                boolean sourceGroup2 = false;
                return sourceGroup2;
            }
            Mixer.Info mixerInfo = mixerProps.getMixerInfo();
            this.audioSystemManager = AudioSystemManager.getInstance();
            this.mixer = this.audioSystemManager.openMixer(mixerInfo);
            Line.Info lineInfo = lineProps.getLineInfo();
            AudioFormat audioFormat = jsoundDevice.getAudioFormat();
            float frameRate = audioFormat.getFrameRate();
            int channels = audioFormat.getChannels();
            int frameSize = audioFormat.getFrameSize();
            int bufferFrames = jsoundDevice.getBufferSize();
            int bufferBytes = bufferFrames * frameSize;
            int procBufferFrames = bufferFrames;
            if (sourceInfo != null) {
                sourceInfo.dataLine = this.targetDataLine = this.audioSystemManager.openTargetDataLine(this.mixer, lineInfo, audioFormat, bufferBytes);
            } else {
                this.mixer = this.audioSystemManager.openMixer(mixerInfo);
                targetInfo.dataLine = this.sourceDataLine = this.audioSystemManager.openSourceDataLine(this.mixer, lineInfo, audioFormat, bufferBytes);
            }
            Wrapper wrapper = syncGroupContext.getGroupWrapper((AudioSyncGroup)syncGroup);
            wrapper.setFrameRate(frameRate);
            wrapper.setBufferSize(procBufferFrames);
            this.syncGroupWrapper = wrapper;
            this.jsoundSourceInfo = sourceInfo;
            this.jsoundTargetInfo = targetInfo;
            SampleType sampleType = SoundUtil.guessSampleType((AudioFormat)audioFormat);
            if (sampleType == null) {
                throw new Exception("Unsupported audio format: " + audioFormat);
            }
            if (procBufferFrames < 1) {
                throw new AudioException("Invalid process buffer size: " + procBufferFrames);
            }
            int samples = procBufferFrames * channels;
            if (sourceInfo != null) {
                rsb = sampleType.createByteArraySampleBuffer(channels, frameRate, samples);
                WrapperOutputPort outputPort = wrapper.getOutputPortAt(0);
                bufferProxy = new SampleBufferProxy((WrapperPort)outputPort, (SampleBuffer)rsb);
                outputPort.setSampleBufferProxy(bufferProxy);
                sourceInfo.sampleBuffer = rsb;
            }
            if (targetInfo != null) {
                rsb = sampleType.createByteArraySampleBuffer(channels, frameRate, samples);
                WrapperInputPort inputPort = wrapper.getInputPortAt(0);
                bufferProxy = new SampleBufferProxy((WrapperPort)inputPort, (SampleBuffer)rsb);
                inputPort.setSampleBufferProxy(bufferProxy);
                targetInfo.sampleBuffer = rsb;
            }
            this.prepareAudioSyncGroup(this.jsoundSyncGroup, syncGroupContext);
            success = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JSound engine prepared: " + (Object)((Object)this));
            }
            boolean bl = true;
            return bl;
        }
        catch (AudioException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AudioException((Throwable)e);
        }
        finally {
            if (!success) {
                try {
                    this.deactivateJSoundDriver(support);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startJSoundDriver() throws AudioException {
        JSoundAudioSupport support;
        JSoundAudioEngine jSoundAudioEngine = this;
        synchronized (jSoundAudioEngine) {
            support = this.jsoundAudioSupport;
            if (support == null) {
                throw new AudioException("JSoundAudioEngine is not prepared: " + (Object)((Object)this));
            }
        }
        boolean success = false;
        try {
            ByteArraySampleBuffer rsb;
            int i;
            if (this.syncGroupWrapper.isStarted()) {
                throw new AudioException("JSoundAudioEngine is already started: " + (Object)((Object)this));
            }
            AudioProcessor[] postProcessors = this.syncGroupWrapper.createPostProcessors();
            AudioProcessor[] contextProcessors = this.createAudioProcessors(this.audioContext);
            AudioProcessor[] preProcessors = this.syncGroupWrapper.createPreProcessors();
            LinkedList<AudioProcessor> apList = new LinkedList<AudioProcessor>();
            for (i = 0; i < postProcessors.length; ++i) {
                apList.add(postProcessors[i]);
            }
            for (i = 0; i < contextProcessors.length; ++i) {
                apList.add(contextProcessors[i]);
            }
            for (i = 0; i < preProcessors.length; ++i) {
                apList.add(preProcessors[i]);
            }
            AudioProcessor[] audioProcessors = apList.toArray(new AudioProcessor[apList.size()]);
            if (this.jsoundSourceInfo != null) {
                rsb = this.jsoundSourceInfo.sampleBuffer;
                String threadName = "JSoundAudioReader-" + this.name;
                this.audioThread = new JSoundAudioReader(threadName, this.threadPriority, this.targetDataLine, rsb, audioProcessors, this.clock, this.threadManager);
            } else {
                rsb = this.jsoundTargetInfo.sampleBuffer;
                WrapperInputPort inputPort = this.syncGroupWrapper.getInputPortAt(0);
                SampleBufferProxy bufferProxy = inputPort.getSampleBufferProxy();
                if (bufferProxy == null) {
                    throw new AudioException("SampleBufferProxy not available for port: " + inputPort.getAudioInputPort());
                }
                SampleBuffer src = bufferProxy.getSampleBuffer();
                String threadName = "JSoundAudioWriter-" + this.name;
                this.audioThread = new JSoundAudioWriter(threadName, this.threadPriority, audioProcessors, src, rsb, this.sourceDataLine, this.clock, this.threadManager);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating " + this.audioThread + ": name=" + this.name + ", buffer=" + rsb + ", frameRate=" + rsb.getFrameRate() + ", processors=" + audioProcessors.length);
            }
            if (logger.isLoggable(Level.FINER)) {
                for (int i2 = 0; i2 < audioProcessors.length; ++i2) {
                    logger.finer(" - AudioProcessor #" + i2 + ": " + audioProcessors[i2]);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting JSound thread: " + this.audioThread);
            }
            this.audioThread.start();
            this.syncGroupWrapper.setStarted(true);
            success = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JSound engine started: " + (Object)((Object)this));
            }
            this.startAudioEngines(this.audioContext);
        }
        catch (AudioException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AudioException((Throwable)e);
        }
        finally {
            if (!success) {
                try {
                    this.deactivateJSoundDriver(support);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateJSoundDriver(JSoundAudioSupport support) throws AudioException {
        TargetDataLine targetLine;
        SourceDataLine sourceLine;
        AudioSystemManager audioMan;
        JSoundAudioThread thread;
        JSoundAudioEngine jSoundAudioEngine = this;
        synchronized (jSoundAudioEngine) {
            if (this.jsoundAudioSupport != support) {
                return;
            }
            thread = this.audioThread;
            audioMan = this.audioSystemManager;
            sourceLine = this.sourceDataLine;
            targetLine = this.targetDataLine;
        }
        if (thread != null) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Stopping JSound thread: " + thread);
                }
                thread.stop();
                thread.join();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JSound thread stopped: " + thread);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (sourceLine != null) {
            try {
                if (audioMan != null) {
                    audioMan.closeSourceDataLine(sourceLine);
                } else {
                    sourceLine.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (targetLine != null) {
            try {
                if (audioMan != null) {
                    audioMan.closeTargetDataLine(targetLine);
                } else {
                    targetLine.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        jSoundAudioEngine = this;
        synchronized (jSoundAudioEngine) {
            this.audioThread = null;
            this.targetDataLine = null;
            this.sourceDataLine = null;
            this.mixer = null;
            this.audioSystemManager = null;
            this.audioContext = null;
            this.jsoundSyncGroup = null;
            this.jsoundAudioSupport = null;
        }
        if (support != null) {
            support.reset();
        }
    }

    protected class JSoundTargetInfo {
        protected final AudioOutputPort sourcePort;
        protected final AudioSyncGroup sourceGroup;
        protected final JSoundAudioInputPort targetPort;
        protected final int targetPortIndex;
        protected SourceDataLine dataLine;
        protected ByteArraySampleBuffer sampleBuffer;

        public JSoundTargetInfo(AudioOutputPort sourcePort, AudioSyncGroup sourceGroup, JSoundAudioInputPort targetPort, int targetPortIndex) {
            this.sourcePort = sourcePort;
            this.sourceGroup = sourceGroup;
            this.targetPort = targetPort;
            this.targetPortIndex = targetPortIndex;
        }
    }

    protected class JSoundSourceInfo {
        protected final JSoundAudioOutputPort sourcePort;
        protected final int sourcePortIndex;
        protected final AudioInputPort[] targetPorts;
        protected final AudioSyncGroup[] targetGroups;
        protected TargetDataLine dataLine;
        protected ByteArraySampleBuffer sampleBuffer;

        public JSoundSourceInfo(JSoundAudioOutputPort sourcePort, int sourcePortIndex, AudioInputPort[] targetPorts, AudioSyncGroup[] targetGroups) {
            this.sourcePort = sourcePort;
            this.sourcePortIndex = sourcePortIndex;
            this.targetPorts = targetPorts;
            this.targetGroups = targetGroups;
        }
    }
}

