/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import com.spacekiller.util.Clock;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.jsound.JSoundAudioThread;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.TargetDataLine;

public class JSoundAudioReader
extends JSoundAudioThread {
    private static final Logger logger = Logger.getLogger(JSoundAudioReader.class.getName());
    private final TargetDataLine line;
    private final ByteArraySampleBuffer rsb;
    private final AudioProcessor[] pr;
    private final Clock ck;
    private final double frameRate;
    private final int bufferSize;

    public JSoundAudioReader(String name, int threadPrio, TargetDataLine line, ByteArraySampleBuffer rsb, AudioProcessor[] processors, Clock clock, ThreadManager threadManager) {
        super(name, threadPrio, threadManager);
        int bufferFrames;
        this.line = line;
        this.rsb = rsb;
        this.pr = processors;
        this.ck = clock;
        this.frameRate = rsb.getFrameRate();
        this.bufferSize = bufferFrames = rsb.getSamples() / rsb.getChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JSoundAudioReader started: " + this);
            }
            if (this.threadManager != null) {
                this.threadManager.registerThread(Thread.currentThread());
            }
            int n = this.rsb.getByteLength();
            AudioProcessor[] x = this.pr;
            int z = x.length;
            int bf = this.bufferSize;
            double fns = 1.0E9 / this.frameRate;
            long bns = Math.round((double)bf * fns);
            int nc = this.rsb.getChannels();
            int fs = nc * this.rsb.getSampleSize();
            this.line.start();
            while (this.process) {
                int i;
                int r = this.line.read(this.rsb.array(), 0, n);
                long t = this.ck.nanos();
                if (r == n) {
                    for (i = 0; i < z; ++i) {
                        x[i].process(t - bns, bf);
                    }
                    continue;
                }
                int f = r / fs;
                if (f < 1) {
                    break;
                }
                for (i = 0; i < z; ++i) {
                    x[i].process(t - (long)((double)f * fns), f);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (this.line != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Flushing TargetDataLine: " + this.line);
                }
                this.line.flush();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Stopping TargetDataLine: " + this.line);
                }
                this.line.stop();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("TargetDataLine stopped: " + this.line);
                }
            }
            for (int i = 0; i < this.pr.length; ++i) {
                try {
                    this.pr[i].shutdown();
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JSoundAudioReader stopped: " + this);
            }
            if (this.threadManager != null) {
                this.threadManager.unregisterThread(Thread.currentThread());
            }
        }
    }
}

