/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import com.spacekiller.util.Clock;
import com.spacekiller.util.ThreadManager;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.jsound.JSoundAudioEngine;
import com.waxmonster.audio.jsound.JSoundAudioInputPort;
import com.waxmonster.audio.jsound.JSoundAudioOutputPort;
import com.waxmonster.audio.jsound.JSoundAudioSyncGroup;
import com.waxmonster.audio.jsound.JSoundDevice;
import com.waxmonster.studio.Studio;

public class JSoundAudioSupport
extends AudioSupport {
    private final JSoundDevice device;
    private AudioEngineConfig config;
    private JSoundAudioSyncGroup syncGroup;

    public JSoundAudioSupport(JSoundDevice device, AudioEngineConfig config) {
        this.device = device;
        this.config = config;
    }

    public synchronized void reset() {
        if (this.syncGroup != null) {
            this.syncGroup = null;
        }
    }

    public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
        return this.getJSoundAudioSyncGroup();
    }

    public synchronized JSoundAudioSyncGroup getJSoundAudioSyncGroup() {
        if (this.syncGroup == null) {
            JSoundAudioInputPort inputPort = null;
            JSoundAudioOutputPort outputPort = null;
            JSoundDevice dev = this.device;
            if (dev == null) {
                return null;
            }
            AudioPort[] ports = dev.getAudioPorts();
            for (int i = 0; i < ports.length; ++i) {
                AudioPort p = ports[i];
                if (p == null) continue;
                if (p instanceof JSoundAudioOutputPort) {
                    outputPort = (JSoundAudioOutputPort)p;
                    break;
                }
                if (!(p instanceof JSoundAudioInputPort)) continue;
                inputPort = (JSoundAudioInputPort)p;
                break;
            }
            if (inputPort == null && outputPort == null) {
                return null;
            }
            String name = String.valueOf(dev.getName());
            Studio studio = this.device.getStudio();
            Clock clock = studio.getClock();
            ThreadManager threadManager = studio.getThreadManager();
            int threadPriority = 6;
            JSoundAudioEngine engine = new JSoundAudioEngine(name, clock, threadManager, threadPriority, this.config);
            if (inputPort != null) {
                this.syncGroup = new JSoundAudioSyncGroup(name, inputPort, engine, this);
            } else if (outputPort != null) {
                this.syncGroup = new JSoundAudioSyncGroup(name, outputPort, engine, this);
            }
        }
        return this.syncGroup;
    }

    public JSoundDevice getDevice() {
        return this.device;
    }
}

