/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import com.spacekiller.util.Clock;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.jsound.JSoundAudioThread;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.SourceDataLine;

public class JSoundAudioWriter
extends JSoundAudioThread {
    private static final Logger logger = Logger.getLogger(JSoundAudioWriter.class.getName());
    private final Clock ck;
    private final double frameRate;
    private final int bufferSize;
    private final AudioProcessor[] pr;
    private final SourceDataLine line;
    private final SampleBuffer src;
    private final ByteArraySampleBuffer rsb;

    public JSoundAudioWriter(String name, int threadPrio, AudioProcessor[] processors, SampleBuffer src, ByteArraySampleBuffer rsb, SourceDataLine line, Clock clock, ThreadManager threadManager) {
        super(name, threadPrio, threadManager);
        int bufferFrames;
        this.src = src == rsb ? null : src;
        this.rsb = rsb;
        this.line = line;
        this.ck = clock;
        this.pr = processors;
        this.frameRate = rsb.getFrameRate();
        this.bufferSize = bufferFrames = rsb.getSamples() / rsb.getChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JSoundAudioWriter started: " + this);
            }
            if (this.threadManager != null) {
                this.threadManager.registerThread(Thread.currentThread());
            }
            int n = this.rsb.getByteLength();
            int s = this.rsb.getSamples();
            AudioProcessor[] x = this.pr;
            int z = x.length;
            int bf = this.bufferSize;
            double fns = 1.0E9 / this.frameRate;
            long bns = Math.round((double)bf * fns);
            this.line.start();
            this.line.write(this.rsb.array(), 0, n);
            long t = this.ck.nanos();
            while (this.process) {
                int r;
                for (int i = 0; i < z; ++i) {
                    x[i].process(t + bns, bf);
                }
                if (this.src != null) {
                    this.rsb.set(0, this.src, 0, s);
                }
                if ((r = this.line.write(this.rsb.array(), 0, n)) < n) {
                    break;
                }
                t = this.ck.nanos();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (this.line != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Draining SourceDataLine: " + this.line);
                }
                this.line.drain();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Stopping SourceDataLine: " + this.line);
                }
                this.line.stop();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("SourceDataLine stopped: " + this.line);
                }
            }
            for (int i = 0; i < this.pr.length; ++i) {
                try {
                    this.pr[i].shutdown();
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JSoundAudioWriter stopped: " + this);
            }
            if (this.threadManager != null) {
                this.threadManager.unregisterThread(Thread.currentThread());
            }
        }
    }
}

