/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import com.spacekiller.util.media.control.AbstractAudioFormatControl;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.device.AudioDevice;
import com.waxmonster.audio.jsound.AudioSystemManager;
import com.waxmonster.audio.jsound.JSoundAudioInputPort;
import com.waxmonster.audio.jsound.JSoundAudioOutputPort;
import com.waxmonster.audio.jsound.JSoundAudioSupport;
import com.waxmonster.audio.jsound.JSoundDeviceInfo;
import com.waxmonster.audio.jsound.JSoundDevicePanel;
import com.waxmonster.audio.jsound.JSoundDeviceProvider;
import com.waxmonster.audio.jsound.JSoundLineProperties;
import com.waxmonster.audio.jsound.JSoundMixerProperties;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.swing.Icon;

public class JSoundDevice
extends AudioDevice {
    private static final Logger logger = Logger.getLogger(JSoundDevice.class.getName());
    public static final String LINE_TYPE_SOURCE = "source";
    public static final String LINE_TYPE_TARGET = "target";
    private static final String KEY_LINE_TYPE = "lineType";
    private static final String KEY_LINE_NAME = "lineName";
    private static final String KEY_BUFFER_SIZE = "bufferSize";
    private final JSoundDeviceProvider provider;
    private final JSoundDeviceInfo info;
    private JSoundDevicePanel devicePanel;
    private String lineType;
    private String lineName;
    private JSoundLineProperties lineProperties;
    private AudioFormat audioFormat;
    private int bufferSize;

    public JSoundDevice(JSoundDeviceProvider provider, String name, Icon iconColor16, JSoundDeviceInfo info) {
        super((DeviceProvider)provider, name);
        this.setIconColor16(iconColor16);
        this.provider = provider;
        this.info = info;
        this.lineType = LINE_TYPE_TARGET;
    }

    protected synchronized AudioPort[] getAudioPorts() {
        return super.getAudioPorts();
    }

    protected synchronized void refreshAudioPorts() {
        AudioPort[] oldPorts;
        AudioFormat newFormat = this.audioFormat;
        int channels = newFormat == null ? 0 : newFormat.getChannels();
        String lineType = this.lineType;
        AudioOutputPortType newAudioPortType = null;
        AudioOutputPortType newOutputPortType = null;
        AudioInputPortType newInputPortType = null;
        if (LINE_TYPE_SOURCE.equals(lineType) && channels > 0) {
            newAudioPortType = newOutputPortType = AudioOutputPortType.getAudioOutputPortType((int)channels);
        } else if (LINE_TYPE_TARGET.equals(lineType) && channels > 0) {
            newInputPortType = AudioInputPortType.getAudioInputPortType((int)channels);
            newAudioPortType = newInputPortType;
        }
        int totalPortCount = 0;
        if (newAudioPortType != null) {
            ++totalPortCount;
        }
        if (totalPortCount == (oldPorts = this.getAudioPorts()).length) {
            boolean changed = false;
            for (int i = 0; i < totalPortCount; ++i) {
                PortType oldPortType;
                AudioPort oldPort = oldPorts[i];
                if (oldPort != null && (oldPortType = oldPort.getType()) == newAudioPortType) continue;
                changed = true;
                break;
            }
            if (!changed) {
                return;
            }
        }
        AudioPort[] newPorts = new AudioPort[totalPortCount];
        if (totalPortCount > 0) {
            JSoundAudioSupport audioSupport = new JSoundAudioSupport(this, this.provider.getConfig());
            for (int i = 0; i < totalPortCount; ++i) {
                Object newPort;
                String portName;
                if (newOutputPortType != null) {
                    portName = channels == 1 ? "Mono-Out" : (channels == 2 ? "Stereo-Out" : "Out");
                    newPort = new JSoundAudioOutputPort(portName, newOutputPortType, audioSupport);
                } else {
                    portName = channels == 1 ? "Mono-In" : (channels == 2 ? "Stereo-In" : "In");
                    newPort = new JSoundAudioInputPort(portName, newInputPortType, audioSupport);
                }
                newPorts[i] = newPort;
            }
        }
        this.setAudioPorts(newPorts);
    }

    public final JSoundDeviceProvider getJSoundDeviceProvider() {
        return this.provider;
    }

    public final JSoundDeviceInfo getJSoundDeviceInfo() {
        return this.info;
    }

    protected void activate() throws StudioException {
        this.provider.activate(this);
    }

    protected void deactivate() throws StudioException {
        this.provider.deactivate(this);
    }

    public synchronized Component getCustomizer() {
        if (this.devicePanel == null) {
            this.devicePanel = new JSoundDevicePanel();
            this.devicePanel.setOpaque(false);
            this.devicePanel.setDevice(this);
        }
        return this.devicePanel;
    }

    protected void setSubtitle(String subtitle) {
        super.setSubtitle(subtitle);
    }

    public synchronized Properties getProperties() {
        int bufferSize;
        Properties props = super.getProperties();
        String selType = this.lineType;
        if (selType != null) {
            props.setProperty(KEY_LINE_TYPE, selType);
        } else {
            props.remove(KEY_LINE_TYPE);
        }
        String selName = this.lineName;
        JSoundLineProperties selLine = this.lineProperties;
        if (selLine != null) {
            selName = selLine.getLineName();
        }
        if (selName != null) {
            props.setProperty(KEY_LINE_NAME, selName);
        } else {
            props.remove(KEY_LINE_NAME);
        }
        AudioFormat format = this.audioFormat;
        if (format != null) {
            String keyPrefix = "";
            Properties formatProps = AbstractAudioFormatControl.getAudioFormatProperties((AudioFormat)format, (String)keyPrefix);
            props.putAll((Map<?, ?>)formatProps);
        }
        if ((bufferSize = this.bufferSize) > 0) {
            props.setProperty(KEY_BUFFER_SIZE, String.valueOf(bufferSize));
        } else {
            props.remove(KEY_BUFFER_SIZE);
        }
        return props;
    }

    public synchronized void setProperties(Properties newProperties) {
        int bufferSize;
        String s;
        super.setProperties(newProperties);
        String selType = newProperties.getProperty(KEY_LINE_TYPE);
        this.setLineType(selType);
        String selName = newProperties.getProperty(KEY_LINE_NAME);
        this.setLineName(selName);
        JSoundLineProperties selLine = this.getJSoundLineProperties(selName);
        this.setLineProperties(selLine);
        String keyPrefix = "";
        AudioFormat audioFormat = AbstractAudioFormatControl.parseAudioFormatProperties((Properties)newProperties, (String)keyPrefix);
        if (audioFormat != null) {
            this.setAudioFormat(audioFormat);
        }
        if ((s = newProperties.getProperty(KEY_BUFFER_SIZE)) != null && (bufferSize = this.parseIntProperty(KEY_BUFFER_SIZE, s)) > 0) {
            this.setBufferSize(bufferSize);
        }
    }

    protected JSoundLineProperties getJSoundLineProperties(String name) {
        if (name == null) {
            return null;
        }
        try {
            String lineType = this.getLineType();
            AudioSystemManager manager = AudioSystemManager.getInstance();
            JSoundMixerProperties[] mixerProps = manager.getJSoundMixerProperties();
            for (int i = 0; i < mixerProps.length; ++i) {
                JSoundMixerProperties mixer = mixerProps[i];
                JSoundLineProperties[] lineProps = null;
                if (LINE_TYPE_SOURCE.equals(lineType)) {
                    lineProps = mixer.getInputLines();
                } else if (LINE_TYPE_TARGET.equals(lineType)) {
                    lineProps = mixer.getOutputLines();
                }
                if (lineProps == null) continue;
                for (int k = 0; k < lineProps.length; ++k) {
                    JSoundLineProperties line = lineProps[k];
                    if (!name.equals(line.getLineName())) continue;
                    return line;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    protected void applyProperty(String key, String value) {
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public synchronized void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
        this.refreshAudioPorts();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getLineType() {
        return this.lineType;
    }

    public void setLineType(String lineType) {
        this.lineType = lineType;
    }

    public String getLineName() {
        return this.lineName;
    }

    public void setLineName(String lineName) {
        this.lineName = lineName;
    }

    public JSoundLineProperties getLineProperties() {
        return this.lineProperties;
    }

    public void setLineProperties(JSoundLineProperties lineProperties) {
        this.lineProperties = lineProperties;
    }
}

