/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import com.spacekiller.util.media.control.AbstractAudioFormatControl;
import com.spacekiller.util.media.control.AudioFormatControl;
import com.spacekiller.util.media.control.AudioFormatControlPanel;
import com.waxmonster.audio.jsound.AudioSystemManager;
import com.waxmonster.audio.jsound.BufferSizeChooser;
import com.waxmonster.audio.jsound.JSoundDevice;
import com.waxmonster.audio.jsound.JSoundLineProperties;
import com.waxmonster.audio.jsound.JSoundMixerProperties;
import com.waxmonster.studio.Connection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class JSoundDevicePanel
extends JPanel {
    private static final long serialVersionUID = -716207785463866040L;
    private static final String NONE_LINE = "<Select Line>";
    private JSoundDevice device;
    private boolean refreshing;
    private AudioFormatControlImpl audioFormatControl = new AudioFormatControlImpl();
    private Set deviceNames = new HashSet();
    private JLabel jLabel = null;
    private JComboBox comboBoxLine;
    private AudioFormatControlPanel audioFormatControlPanel;
    private BufferSizeChooser bufferSizeChooser;
    private JPanel panel_1;
    private JButton btnRefresh;
    private JLabel lblNewLabel;
    private JPanel panel_2;
    private JRadioButton rdbtnInputLine;
    private JRadioButton rdbtnOutputLine;

    public JSoundDevicePanel() {
        this.initialize();
        this.initJSoundDevicePanel();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{0};
        gridBagLayout.columnWidths = new int[]{168};
        gridBagLayout.rowWeights = new double[]{0.0};
        gridBagLayout.columnWeights = new double[]{1.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(536, 206));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Device Settings", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weightx = 1.0;
        gbc_panel.anchor = 11;
        gbc_panel.insets = new Insets(2, 4, 2, 4);
        gbc_panel.fill = 2;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.lblNewLabel = new JLabel("Line Type:");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(5, 5, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        panel.add((Component)this.lblNewLabel, gbc_lblNewLabel);
        this.panel_2 = new JPanel();
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(0, 4, 5, 0);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 1;
        gbc_panel_2.gridy = 0;
        panel.add((Component)this.panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_2.setLayout(gbl_panel_2);
        this.rdbtnInputLine = new JRadioButton("Input Line");
        this.rdbtnInputLine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JSoundDevicePanel.this.refreshing) {
                    JSoundDevicePanel.this.applyLineType();
                }
            }
        });
        GridBagConstraints gbc_rdbtnInputLine = new GridBagConstraints();
        gbc_rdbtnInputLine.insets = new Insets(0, 0, 0, 5);
        gbc_rdbtnInputLine.gridx = 0;
        gbc_rdbtnInputLine.gridy = 0;
        this.panel_2.add((Component)this.rdbtnInputLine, gbc_rdbtnInputLine);
        this.rdbtnOutputLine = new JRadioButton("Output Line");
        this.rdbtnOutputLine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JSoundDevicePanel.this.refreshing) {
                    JSoundDevicePanel.this.applyLineType();
                }
            }
        });
        GridBagConstraints gbc_rdbtnOutputLine = new GridBagConstraints();
        gbc_rdbtnOutputLine.gridx = 1;
        gbc_rdbtnOutputLine.gridy = 0;
        this.panel_2.add((Component)this.rdbtnOutputLine, gbc_rdbtnOutputLine);
        JLabel lblLine = new JLabel("Audio Line:");
        GridBagConstraints gbc_lblLine = new GridBagConstraints();
        gbc_lblLine.anchor = 17;
        gbc_lblLine.insets = new Insets(0, 5, 5, 5);
        gbc_lblLine.gridx = 0;
        gbc_lblLine.gridy = 1;
        panel.add((Component)lblLine, gbc_lblLine);
        this.panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(0, 4, 5, 0);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 1;
        gbc_panel_1.gridy = 1;
        panel.add((Component)this.panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_1.setLayout(gbl_panel_1);
        this.comboBoxLine = new JComboBox();
        GridBagConstraints gbc_comboBoxLine = new GridBagConstraints();
        gbc_comboBoxLine.weightx = 1.0;
        gbc_comboBoxLine.fill = 1;
        gbc_comboBoxLine.gridx = 0;
        gbc_comboBoxLine.gridy = 0;
        this.panel_1.add((Component)this.comboBoxLine, gbc_comboBoxLine);
        this.comboBoxLine.setOpaque(false);
        this.comboBoxLine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JSoundDevicePanel.this.refreshing) {
                    JSoundDevicePanel.this.applySelectedLine();
                }
            }
        });
        this.btnRefresh = new JButton("");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean refreshMixers = true;
                JSoundDevicePanel.this.refresh(refreshMixers);
            }
        });
        this.btnRefresh.setMargin(new Insets(2, 2, 2, 2));
        this.btnRefresh.setToolTipText("Refresh audio lines");
        this.btnRefresh.setIcon(new ImageIcon(JSoundDevicePanel.class.getResource("/com/waxmonster/audio/jsound/icons/refresh_devices.gif")));
        GridBagConstraints gbc_btnRefresh = new GridBagConstraints();
        gbc_btnRefresh.gridx = 1;
        gbc_btnRefresh.gridy = 0;
        this.panel_1.add((Component)this.btnRefresh, gbc_btnRefresh);
        JLabel lblFormat = new JLabel("Audio Format:");
        GridBagConstraints gbc_lblFormat = new GridBagConstraints();
        gbc_lblFormat.anchor = 17;
        gbc_lblFormat.insets = new Insets(0, 5, 5, 5);
        gbc_lblFormat.gridx = 0;
        gbc_lblFormat.gridy = 2;
        panel.add((Component)lblFormat, gbc_lblFormat);
        this.audioFormatControlPanel = new AudioFormatControlPanel();
        this.audioFormatControlPanel.setToolTipText("Audio format");
        this.audioFormatControlPanel.setOpaque(false);
        GridBagConstraints gbc_audioFormatControlPanel = new GridBagConstraints();
        gbc_audioFormatControlPanel.weightx = 1.0;
        gbc_audioFormatControlPanel.insets = new Insets(0, 4, 5, 0);
        gbc_audioFormatControlPanel.fill = 2;
        gbc_audioFormatControlPanel.gridx = 1;
        gbc_audioFormatControlPanel.gridy = 2;
        panel.add((Component)this.audioFormatControlPanel, gbc_audioFormatControlPanel);
        this.jLabel = new JLabel();
        GridBagConstraints gbc_jLabel = new GridBagConstraints();
        gbc_jLabel.anchor = 17;
        gbc_jLabel.insets = new Insets(0, 5, 5, 5);
        gbc_jLabel.gridx = 0;
        gbc_jLabel.gridy = 3;
        panel.add((Component)this.jLabel, gbc_jLabel);
        this.jLabel.setText("Buffer Size:");
        this.bufferSizeChooser = new BufferSizeChooser();
        this.bufferSizeChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JSoundDevicePanel.this.refreshing) {
                    JSoundDevicePanel.this.applyBufferSize();
                }
            }
        });
        this.bufferSizeChooser.setToolTipText("Line buffer size");
        this.bufferSizeChooser.setOpaque(false);
        GridBagConstraints gbc_bufferSizeChooser = new GridBagConstraints();
        gbc_bufferSizeChooser.insets = new Insets(0, 0, 5, 0);
        gbc_bufferSizeChooser.fill = 2;
        gbc_bufferSizeChooser.gridx = 1;
        gbc_bufferSizeChooser.gridy = 3;
        panel.add((Component)this.bufferSizeChooser, gbc_bufferSizeChooser);
    }

    public JSoundDevice getDevice() {
        return this.device;
    }

    public synchronized void setDevice(JSoundDevice device) {
        this.device = device;
        this.refresh(false);
    }

    protected void initJSoundDevicePanel() {
        ButtonGroup buttonGroupLineType = new ButtonGroup();
        buttonGroupLineType.add(this.getRdbtnInputLine());
        buttonGroupLineType.add(this.getRdbtnOutputLine());
        ImageIcon missingDeviceIcon = new ImageIcon(JSoundDevicePanel.class.getResource("/com/waxmonster/audio/jsound/icons/missing_jsound_device_icon16.png"));
        JSoundDeviceRenderer renderer = new JSoundDeviceRenderer(missingDeviceIcon);
        this.getComboBoxLine().setRenderer(renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(boolean refreshMixers) {
        block14: {
            try {
                this.refreshing = true;
                this.deviceNames.clear();
                this.getComboBoxLine().removeAllItems();
                this.getComboBoxLine().addItem(NONE_LINE);
                if (this.device == null) break block14;
                String lineType = this.device.getLineType();
                String selLineName = this.device.getLineName();
                int selLineIndex = -1;
                AudioSystemManager manager = AudioSystemManager.getInstance();
                if (refreshMixers) {
                    manager.refreshJSoundMixerProperties();
                }
                JSoundMixerProperties[] mixerPropArray = manager.getJSoundMixerProperties();
                for (int k = 0; k < mixerPropArray.length; ++k) {
                    JSoundLineProperties line;
                    int i;
                    JSoundMixerProperties mixerProps = mixerPropArray[k];
                    if (mixerProps == null) continue;
                    if ("source".equals(lineType)) {
                        if (!this.rdbtnInputLine.isSelected()) {
                            this.rdbtnInputLine.setSelected(true);
                        }
                        JSoundLineProperties[] inputLines = mixerProps.getInputLines();
                        for (i = 0; i < inputLines.length; ++i) {
                            line = inputLines[i];
                            if (selLineName != null && selLineName.equals(line.getLineName())) {
                                selLineIndex = this.comboBoxLine.getItemCount();
                            }
                            this.comboBoxLine.addItem(line);
                            this.deviceNames.add(line.getLineName());
                        }
                        continue;
                    }
                    if (!"target".equals(lineType)) continue;
                    if (!this.rdbtnOutputLine.isSelected()) {
                        this.rdbtnOutputLine.setSelected(true);
                    }
                    JSoundLineProperties[] outputLines = mixerProps.getOutputLines();
                    for (i = 0; i < outputLines.length; ++i) {
                        line = outputLines[i];
                        if (selLineName != null && selLineName.equals(line.getLineName())) {
                            selLineIndex = this.comboBoxLine.getItemCount();
                        }
                        this.comboBoxLine.addItem(line);
                        this.deviceNames.add(line.getLineName());
                    }
                }
                if (selLineIndex < 0 && selLineName != null && selLineName.length() > 0) {
                    selLineIndex = this.comboBoxLine.getItemCount();
                    this.comboBoxLine.addItem(selLineName);
                }
                if (selLineIndex >= 0) {
                    this.comboBoxLine.setSelectedIndex(selLineIndex);
                }
            }
            finally {
                this.refreshing = false;
            }
        }
        this.refreshDetails();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshDetails() {
        try {
            this.refreshing = true;
            LinkedList<AudioFormat> formatList = new LinkedList<AudioFormat>();
            AudioFormat audioFormat = null;
            int bufferFrames = 0;
            if (this.device != null) {
                AudioFormat af;
                JSoundLineProperties lineProps;
                audioFormat = this.device.getAudioFormat();
                bufferFrames = this.device.getBufferSize();
                if (audioFormat != null) {
                    formatList.add(audioFormat);
                }
                if (!((lineProps = this.device.getLineProperties()) == null || (af = lineProps.getAudioFormat()) == null || audioFormat != null && audioFormat.matches(af))) {
                    formatList.add(af);
                }
            }
            AudioFormat[] audioFormats = formatList.toArray(new AudioFormat[formatList.size()]);
            this.audioFormatControl.setAudioFormats(audioFormats);
            this.audioFormatControl.setAudioFormat(audioFormat);
            this.getAudioFormatControlPanel().setAudioFormatControl((AudioFormatControl)this.audioFormatControl);
            int bufferSize = 0;
            if (audioFormat != null) {
                bufferSize = bufferFrames * audioFormat.getFrameSize();
            }
            this.getBufferSizeChooser().setAudioFormat(audioFormat);
            this.getBufferSizeChooser().setBufferSize(bufferSize);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JComboBox getComboBoxLine() {
        return this.comboBoxLine;
    }

    protected AudioFormatControlPanel getAudioFormatControlPanel() {
        return this.audioFormatControlPanel;
    }

    public boolean isAudioFormatSupported(AudioFormat format) {
        if (format == null) {
            return false;
        }
        AudioFormat.Encoding encoding = format.getEncoding();
        return AudioFormat.Encoding.PCM_SIGNED.equals(encoding);
    }

    protected void applyLineType() {
        String lineType;
        if (this.device == null) {
            return;
        }
        String string = lineType = this.getRdbtnInputLine().isSelected() ? "source" : "target";
        if (lineType.equals(this.device.getLineType())) {
            return;
        }
        this.device.setLineName(null);
        this.device.setLineProperties(null);
        this.device.setLineType(lineType);
        boolean refreshMixers = false;
        this.refresh(refreshMixers);
    }

    protected void applySelectedLine() {
        if (this.device == null) {
            return;
        }
        String lineName = null;
        JSoundLineProperties selLine = null;
        Object item = this.getComboBoxLine().getSelectedItem();
        if (item != null && !NONE_LINE.equals(item)) {
            if (item instanceof JSoundLineProperties) {
                selLine = (JSoundLineProperties)item;
                lineName = selLine.getLineName();
            } else {
                lineName = String.valueOf(item);
            }
        }
        this.device.setLineName(lineName);
        this.device.setLineProperties(selLine);
        AudioFormat audioFormat = null;
        if (selLine != null) {
            audioFormat = selLine.getAudioFormat();
        }
        this.device.setAudioFormat(audioFormat);
        if (audioFormat != null) {
            int bufferSize = selLine.getBufferSize();
            int frameSize = audioFormat.getFrameSize();
            if (bufferSize > 0 && frameSize > 0) {
                int bufferFrames = bufferSize / frameSize;
                this.device.setBufferSize(bufferFrames);
            }
        }
        this.refreshDetails();
    }

    protected void applyAudioFormat(AudioFormat audioFormat) {
        if (audioFormat == null) {
            return;
        }
        if (this.device == null) {
            return;
        }
        AudioFormat oldFormat = this.device.getAudioFormat();
        int oldChannels = oldFormat == null ? 0 : oldFormat.getChannels();
        int newChannels = audioFormat.getChannels();
        if (newChannels != oldChannels) {
            int messageType;
            int optionType;
            String title;
            String message;
            int rc;
            int connCount = 0;
            Connection[] conns = this.device.getConnections();
            if (conns != null) {
                connCount += conns.length;
            }
            if ((conns = this.device.getInvalidConnections()) != null) {
                connCount += conns.length;
            }
            if (connCount > 0 && (rc = JOptionPane.showConfirmDialog(this, message = "About to change the number of audio channels.\nThe audio port will be disconnected. Are you sure ?", title = "Disconnect ?", optionType = 2, messageType = 3)) != 0) {
                this.refreshDetails();
                return;
            }
        }
        this.device.setAudioFormat(audioFormat);
        int bufferSize = this.bufferSizeChooser.getBufferSize();
        this.bufferSizeChooser.setAudioFormat(audioFormat);
        int newBufferSize = bufferSize;
        if (newBufferSize != bufferSize) {
            this.bufferSizeChooser.setBufferSize(newBufferSize);
        }
    }

    protected void applyBufferSize() {
        if (this.device == null) {
            return;
        }
        int bufferSize = this.bufferSizeChooser.getBufferSize();
        if (bufferSize < 1) {
            return;
        }
        AudioFormat format = this.bufferSizeChooser.getAudioFormat();
        if (format == null) {
            return;
        }
        int bufferFrames = bufferSize / format.getFrameSize();
        this.device.setBufferSize(bufferFrames);
    }

    protected BufferSizeChooser getBufferSizeChooser() {
        return this.bufferSizeChooser;
    }

    protected JRadioButton getRdbtnInputLine() {
        return this.rdbtnInputLine;
    }

    protected JRadioButton getRdbtnOutputLine() {
        return this.rdbtnOutputLine;
    }

    protected class AudioFormatControlImpl
    extends AbstractAudioFormatControl {
        protected AudioFormatControlImpl() {
        }

        protected void setAudioFormats(AudioFormat[] audioFormats) {
            super.setAudioFormats(audioFormats);
        }

        public boolean isAudioFormatSupported(AudioFormat format) {
            return JSoundDevicePanel.this.isAudioFormatSupported(format);
        }

        protected void applyAudioFormat(AudioFormat audioFormat) {
            if (!JSoundDevicePanel.this.refreshing) {
                JSoundDevicePanel.this.applyAudioFormat(audioFormat);
            }
        }
    }

    protected class JSoundDeviceRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -2011477912850014231L;
        private Icon missingDeviceIcon;

        public JSoundDeviceRenderer(Icon missingDeviceIcon) {
            this.missingDeviceIcon = missingDeviceIcon;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = null;
            String tip = null;
            String devName = String.valueOf(value);
            if (!JSoundDevicePanel.NONE_LINE.equals(devName) && !JSoundDevicePanel.this.deviceNames.contains(devName)) {
                icon = this.missingDeviceIcon;
                tip = "Device not found: " + devName;
            }
            this.setIcon(icon);
            this.setToolTipText(tip);
            this.setOpaque(isSelected);
            return comp;
        }
    }
}

