/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jsound;

import com.spacekiller.util.Tools;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.jsound.JSoundAudioInputPort;
import com.waxmonster.audio.jsound.JSoundAudioOutputPort;
import com.waxmonster.audio.jsound.JSoundAudioSupport;
import com.waxmonster.audio.jsound.JSoundAudioSyncGroup;
import com.waxmonster.audio.jsound.JSoundDevice;
import com.waxmonster.audio.jsound.JSoundDeviceInfo;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class JSoundDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "JSoundDeviceProvider";
    public static final String JSOUND_DEVICE_NAME = "Java-Sound";
    public static final String DEVICE_CATEGORY_NAME = "Audio Devices";
    private static final Logger logger = Logger.getLogger(JSoundDeviceProvider.class.getName());
    private static final String CLASS_NAME = JSoundDeviceProvider.class.getName();
    private AudioEngineConfig config = new AudioEngineConfig();

    public JSoundDeviceProvider() {
        super(PROVIDER_NAME);
        this.initJSoundDeviceProvider();
    }

    protected void initJSoundDeviceProvider() {
        String tooltip = "Java-Sound Device";
        Icon icon = Tools.getIcon(JSoundDeviceProvider.class, (String)"/com/waxmonster/audio/jsound/icons/jsound_audio_icon16.png");
        JSoundDeviceInfo sourceInfo = new JSoundDeviceInfo(JSOUND_DEVICE_NAME, tooltip, icon);
        this.addDeviceInfo(sourceInfo);
    }

    public synchronized void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createDevice", info);
        }
        if (info == null || !(info instanceof JSoundDeviceInfo)) {
            throw new StudioException("Invalid DeviceInfo: " + info);
        }
        JSoundDeviceInfo devInfo = (JSoundDeviceInfo)info;
        String devName = devInfo.getDeviceName();
        Icon iconColor16 = info.getIcon(1);
        JSoundDevice dev = new JSoundDevice(this, devName, iconColor16, devInfo);
        String title = JSOUND_DEVICE_NAME;
        String subtitle = null;
        dev.setTitle(title);
        dev.setSubtitle(subtitle);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "createDevice", (Object)dev);
        }
        return dev;
    }

    protected synchronized void activate(JSoundDevice device) throws StudioException {
        HashSet<JSoundAudioSyncGroup> groups = new HashSet<JSoundAudioSyncGroup>();
        AudioPort[] ports = device.getAudioPorts();
        for (int i = 0; i < ports.length; ++i) {
            JSoundAudioSupport support;
            AudioPort port = ports[i];
            if (port instanceof JSoundAudioInputPort) {
                JSoundAudioInputPort inputPort = (JSoundAudioInputPort)port;
                support = inputPort.getJSoundAudioSupport();
                groups.add(support.getJSoundAudioSyncGroup());
                continue;
            }
            if (!(port instanceof JSoundAudioOutputPort)) continue;
            JSoundAudioOutputPort outputPort = (JSoundAudioOutputPort)port;
            support = outputPort.getJSoundAudioSupport();
            groups.add(support.getJSoundAudioSyncGroup());
        }
        for (JSoundAudioSyncGroup group : groups) {
            group.getJSoundEngine().activateJSoundAudioDevice(device, group);
        }
    }

    protected synchronized void deactivate(JSoundDevice device) throws StudioException {
        HashSet<JSoundAudioSyncGroup> groups = new HashSet<JSoundAudioSyncGroup>();
        AudioPort[] ports = device.getAudioPorts();
        for (int i = 0; i < ports.length; ++i) {
            JSoundAudioSupport support;
            AudioPort port = ports[i];
            if (port instanceof JSoundAudioInputPort) {
                JSoundAudioInputPort inputPort = (JSoundAudioInputPort)port;
                support = inputPort.getJSoundAudioSupport();
                groups.add(support.getJSoundAudioSyncGroup());
                continue;
            }
            if (!(port instanceof JSoundAudioOutputPort)) continue;
            JSoundAudioOutputPort outputPort = (JSoundAudioOutputPort)port;
            support = outputPort.getJSoundAudioSupport();
            groups.add(support.getJSoundAudioSyncGroup());
        }
        for (JSoundAudioSyncGroup group : groups) {
            group.getJSoundEngine().deactivateJSoundAudioDevice(device, group);
        }
    }

    public AudioEngineConfig getConfig() {
        return this.config;
    }

    public void setConfig(AudioEngineConfig config) {
        this.config = config;
    }

    public PortType getPortType(String typeName) {
        return AudioPortType.getAudioPortType((String)typeName);
    }
}

