/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Filter;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.AdvancedSearchOptions;
import com.spacekiller.util.media.manager.MediaTableEntry;
import java.util.Set;

public class AdvancedMediaFilter
implements Filter {
    private final Set formats;
    private final double minDuration;
    private final double maxDuration;
    private final double minBpm;
    private final double maxBpm;
    private final double minRms;
    private final double maxRms;
    private final double minPeakRms;
    private final double maxPeakRms;
    private final double minFrameRate;
    private final double maxFrameRate;

    public AdvancedMediaFilter(AdvancedSearchOptions options) {
        this.formats = options.getFormats();
        this.minDuration = options.getMinDuration();
        this.maxDuration = options.getMaxDuration();
        this.minBpm = options.getMinBpm();
        this.maxBpm = options.getMaxBpm();
        this.minRms = options.getMinRms();
        this.maxRms = options.getMaxRms();
        this.minPeakRms = options.getMinPeakRms();
        this.maxPeakRms = options.getMaxPeakRms();
        this.minFrameRate = options.getMinFrameRate();
        this.maxFrameRate = options.getMaxFrameRate();
    }

    public boolean accept(Object o) {
        double frameRate;
        double peakRms;
        double rms;
        double bpm;
        double duration;
        MediaCrateEntry entry = (MediaCrateEntry)o;
        if (entry == null) {
            return false;
        }
        MediaTableEntry mce = null;
        MediaEntry me = null;
        AudioEntry ae = null;
        if (entry instanceof MediaTableEntry && (me = (mce = (MediaTableEntry)entry).getMediaEntry()) != null) {
            ae = me.getAudioEntry();
        }
        if (!(this.formats == null || me != null && this.formats.contains(me.getFormat()))) {
            return false;
        }
        double d = duration = me == null ? Double.NaN : me.getDuration();
        if (this.minDuration >= 0.0 && (duration < this.minDuration || Double.isNaN(duration))) {
            return false;
        }
        if (this.maxDuration >= 0.0 && (duration > this.maxDuration || Double.isNaN(duration))) {
            return false;
        }
        double d2 = bpm = ae == null ? Double.NaN : ae.getBpm();
        if (this.minBpm >= 0.0 && (bpm < this.minBpm || Double.isNaN(bpm))) {
            return false;
        }
        if (this.maxBpm >= 0.0 && (bpm > this.maxBpm || Double.isNaN(bpm))) {
            return false;
        }
        double d3 = rms = ae == null ? Double.NaN : ae.getRms();
        if (this.minRms >= 0.0 && (rms < this.minRms || Double.isNaN(rms))) {
            return false;
        }
        if (this.maxRms >= 0.0 && (rms > this.maxRms || Double.isNaN(rms))) {
            return false;
        }
        double d4 = peakRms = ae == null ? Double.NaN : ae.getPeakRms();
        if (this.minPeakRms >= 0.0 && (peakRms < this.minPeakRms || Double.isNaN(peakRms))) {
            return false;
        }
        if (this.maxPeakRms >= 0.0 && (peakRms > this.maxPeakRms || Double.isNaN(peakRms))) {
            return false;
        }
        double d5 = frameRate = ae == null ? Double.NaN : (double)ae.getFrameRate();
        if (this.minFrameRate >= 0.0 && (frameRate < this.minFrameRate || Double.isNaN(frameRate))) {
            return false;
        }
        return !(this.maxFrameRate >= 0.0) || !(frameRate > this.maxFrameRate) && !Double.isNaN(frameRate);
    }
}

