/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.control.AbstractTextControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.TextControl;
import com.spacekiller.util.media.control.TextFieldControlPanel;
import com.spacekiller.util.media.manager.AdvancedSearchOptions;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import com.spacekiller.util.sound.AudioMath;
import com.spacekiller.util.sound.AudioMathImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class AdvancedSearchPanel
extends JPanel {
    private static final long serialVersionUID = -4613054925559922641L;
    private static final Logger logger = Logger.getLogger(AdvancedSearchPanel.class.getName());
    private static final String ACTION_ENTER = "enter";
    private static final String ACTION_ESCAPE = "escape";
    private AudioMath audioMath;
    private MediaTableToolContext mediaTableToolContext;
    private Window owner;
    private AdvancedSearchOptions options;
    private Set formats;
    private TextControl regexControl = new SearchTextControl();
    private TextControl minTimeControl = new SearchNumberControl();
    private TextControl maxTimeControl = new SearchNumberControl();
    private TextControl minBpmControl = new SearchNumberControl();
    private TextControl maxBpmControl = new SearchNumberControl();
    private TextControl minRmsControl = new SearchNumberControl();
    private TextControl maxRmsControl = new SearchNumberControl();
    private TextControl minPeakRmsControl = new SearchNumberControl();
    private TextControl maxPeakRmsControl = new SearchNumberControl();
    private TextControl minSampleRateControl = new SearchNumberControl();
    private TextControl maxSampleRateControl = new SearchNumberControl();
    private TextFieldControlPanel textFieldControlPanelRegex;
    private TextFieldControlPanel textFieldControlPanelMinTime;
    private TextFieldControlPanel textFieldControlPanelMaxTime;
    private TextFieldControlPanel textFieldControlPanelMinBPM;
    private TextFieldControlPanel textFieldControlPanelMaxBPM;
    private TextFieldControlPanel textFieldControlPanelMinRms;
    private TextFieldControlPanel textFieldControlPanelMaxRms;
    private TextFieldControlPanel textFieldControlPanelMinPeakRms;
    private TextFieldControlPanel textFieldControlPanelMaxPeakRms;
    private TextFieldControlPanel textFieldControlPanelMinSampleRate;
    private TextFieldControlPanel textFieldControlPanelMaxSampleRate;
    private JButton btnSearch;
    private JButton btnReset;
    private JButton btnClear;
    private JCheckBox chckbxKeepDialogOpen;
    private JTabbedPane tabbedPane;
    private JPanel panelAudioTab;
    private JPanel panel_1;
    private JPanel panelMediaTab;
    private JPanel panelMediaOptions;
    private JPanel panel;
    private JPanel panel_2;
    private JLabel lblFileFormats;
    private JPanel panelFileFormats;
    private JTextField textFieldFileFormats;
    private JButton btnBrowseIncludeFileFormats;

    public AdvancedSearchPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.insets = new Insets(8, 8, 8, 8);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        this.add((Component)this.panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_1.setLayout(gbl_panel_1);
        JLabel lblRegex = new JLabel("Regex. Search:");
        GridBagConstraints gbc_lblRegex = new GridBagConstraints();
        gbc_lblRegex.insets = new Insets(4, 4, 5, 5);
        gbc_lblRegex.gridx = 0;
        gbc_lblRegex.gridy = 0;
        this.panel_1.add((Component)lblRegex, gbc_lblRegex);
        lblRegex.setToolTipText("Regular expression pattern");
        this.textFieldControlPanelRegex = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelRegex = new GridBagConstraints();
        gbc_textFieldControlPanelRegex.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldControlPanelRegex.fill = 2;
        gbc_textFieldControlPanelRegex.weightx = 1.0;
        gbc_textFieldControlPanelRegex.gridx = 1;
        gbc_textFieldControlPanelRegex.gridy = 0;
        this.panel_1.add((Component)this.textFieldControlPanelRegex, gbc_textFieldControlPanelRegex);
        this.textFieldControlPanelRegex.setColumns(30);
        this.textFieldControlPanelRegex.setToolTipText("");
        this.tabbedPane = new JTabbedPane(1);
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.weighty = 1.0;
        gbc_tabbedPane.weightx = 1.0;
        gbc_tabbedPane.insets = new Insets(0, 8, 8, 8);
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 1;
        this.add((Component)this.tabbedPane, gbc_tabbedPane);
        this.panelMediaTab = new JPanel();
        this.tabbedPane.addTab("Media", null, this.panelMediaTab, null);
        GridBagLayout gbl_panelMediaTab = new GridBagLayout();
        gbl_panelMediaTab.columnWidths = new int[]{0, 0};
        gbl_panelMediaTab.rowHeights = new int[]{0, 0};
        gbl_panelMediaTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMediaTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelMediaTab.setLayout(gbl_panelMediaTab);
        this.panel = new JPanel();
        this.panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Media Options", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.weightx = 1.0;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.panelMediaTab.add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.panelMediaOptions = new JPanel();
        GridBagConstraints gbc_panelMediaOptions = new GridBagConstraints();
        gbc_panelMediaOptions.insets = new Insets(4, 4, 4, 4);
        gbc_panelMediaOptions.weightx = 1.0;
        gbc_panelMediaOptions.fill = 1;
        gbc_panelMediaOptions.gridx = 0;
        gbc_panelMediaOptions.gridy = 0;
        this.panel.add((Component)this.panelMediaOptions, gbc_panelMediaOptions);
        this.panelMediaOptions.setBorder(null);
        GridBagLayout gbl_panelMediaOptions = new GridBagLayout();
        gbl_panelMediaOptions.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelMediaOptions.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelMediaOptions.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMediaOptions.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.panelMediaOptions.setLayout(gbl_panelMediaOptions);
        this.lblFileFormats = new JLabel("File Formats:");
        GridBagConstraints gbc_lblFileFormats = new GridBagConstraints();
        gbc_lblFileFormats.anchor = 17;
        gbc_lblFileFormats.insets = new Insets(0, 0, 5, 5);
        gbc_lblFileFormats.gridx = 0;
        gbc_lblFileFormats.gridy = 0;
        this.panelMediaOptions.add((Component)this.lblFileFormats, gbc_lblFileFormats);
        this.panelFileFormats = new JPanel();
        GridBagConstraints gbc_panelFileFormats = new GridBagConstraints();
        gbc_panelFileFormats.insets = new Insets(0, 0, 5, 0);
        gbc_panelFileFormats.gridwidth = 3;
        gbc_panelFileFormats.weighty = 1.0;
        gbc_panelFileFormats.weightx = 1.0;
        gbc_panelFileFormats.fill = 1;
        gbc_panelFileFormats.gridx = 1;
        gbc_panelFileFormats.gridy = 0;
        this.panelMediaOptions.add((Component)this.panelFileFormats, gbc_panelFileFormats);
        GridBagLayout gbl_panelFileFormats = new GridBagLayout();
        gbl_panelFileFormats.columnWidths = new int[]{0, 0, 0};
        gbl_panelFileFormats.rowHeights = new int[]{0, 0};
        gbl_panelFileFormats.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelFileFormats.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelFileFormats.setLayout(gbl_panelFileFormats);
        this.textFieldFileFormats = new JTextField();
        this.textFieldFileFormats.setEditable(false);
        this.textFieldFileFormats.setOpaque(false);
        GridBagConstraints gbc_textFieldFileFormats = new GridBagConstraints();
        gbc_textFieldFileFormats.weightx = 1.0;
        gbc_textFieldFileFormats.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldFileFormats.fill = 1;
        gbc_textFieldFileFormats.gridx = 0;
        gbc_textFieldFileFormats.gridy = 0;
        this.panelFileFormats.add((Component)this.textFieldFileFormats, gbc_textFieldFileFormats);
        this.textFieldFileFormats.setColumns(10);
        this.btnBrowseIncludeFileFormats = new JButton("");
        this.btnBrowseIncludeFileFormats.setMargin(new Insets(0, 0, 0, 0));
        this.btnBrowseIncludeFileFormats.setIcon(new ImageIcon(AdvancedSearchPanel.class.getResource("/com/spacekiller/util/media/manager/icons/list_group.gif")));
        this.btnBrowseIncludeFileFormats.setToolTipText("Browse file formats...");
        this.btnBrowseIncludeFileFormats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSearchPanel.this.actionBrowseFileFormats();
            }
        });
        GridBagConstraints gbc_btnBrowseIncludeFileFormats = new GridBagConstraints();
        gbc_btnBrowseIncludeFileFormats.gridx = 1;
        gbc_btnBrowseIncludeFileFormats.gridy = 0;
        this.panelFileFormats.add((Component)this.btnBrowseIncludeFileFormats, gbc_btnBrowseIncludeFileFormats);
        JLabel lblMinTime = new JLabel("Min. Duration:");
        GridBagConstraints gbc_lblMinTime = new GridBagConstraints();
        gbc_lblMinTime.anchor = 17;
        gbc_lblMinTime.insets = new Insets(0, 0, 5, 5);
        gbc_lblMinTime.gridx = 0;
        gbc_lblMinTime.gridy = 1;
        this.panelMediaOptions.add((Component)lblMinTime, gbc_lblMinTime);
        lblMinTime.setToolTipText("Minimum duration in seconds");
        this.textFieldControlPanelMinTime = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMinTime = new GridBagConstraints();
        gbc_textFieldControlPanelMinTime.fill = 2;
        gbc_textFieldControlPanelMinTime.weightx = 1.0;
        gbc_textFieldControlPanelMinTime.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldControlPanelMinTime.gridx = 1;
        gbc_textFieldControlPanelMinTime.gridy = 1;
        this.panelMediaOptions.add((Component)this.textFieldControlPanelMinTime, gbc_textFieldControlPanelMinTime);
        this.textFieldControlPanelMinTime.setColumns(8);
        this.textFieldControlPanelMinTime.setToolTipText("Minimum duration in seconds");
        JLabel lblMaxtime = new JLabel("Max. Duration:");
        GridBagConstraints gbc_lblMaxtime = new GridBagConstraints();
        gbc_lblMaxtime.anchor = 17;
        gbc_lblMaxtime.insets = new Insets(0, 5, 5, 5);
        gbc_lblMaxtime.gridx = 2;
        gbc_lblMaxtime.gridy = 1;
        this.panelMediaOptions.add((Component)lblMaxtime, gbc_lblMaxtime);
        lblMaxtime.setToolTipText("Maximum duration in seconds");
        this.textFieldControlPanelMaxTime = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMaxTime = new GridBagConstraints();
        gbc_textFieldControlPanelMaxTime.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelMaxTime.fill = 2;
        gbc_textFieldControlPanelMaxTime.weightx = 1.0;
        gbc_textFieldControlPanelMaxTime.gridx = 3;
        gbc_textFieldControlPanelMaxTime.gridy = 1;
        this.panelMediaOptions.add((Component)this.textFieldControlPanelMaxTime, gbc_textFieldControlPanelMaxTime);
        this.textFieldControlPanelMaxTime.setColumns(8);
        this.textFieldControlPanelMaxTime.setToolTipText("Maximum duration in seconds");
        this.panelAudioTab = new JPanel();
        this.tabbedPane.addTab("Audio", null, this.panelAudioTab, null);
        GridBagLayout gbl_panelAudioTab = new GridBagLayout();
        gbl_panelAudioTab.columnWidths = new int[]{0, 0};
        gbl_panelAudioTab.rowHeights = new int[]{0, 0};
        gbl_panelAudioTab.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelAudioTab.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelAudioTab.setLayout(gbl_panelAudioTab);
        this.panel_2 = new JPanel();
        this.panel_2.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Audio Options", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.weightx = 1.0;
        gbc_panel_2.insets = new Insets(4, 4, 4, 4);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 0;
        this.panelAudioTab.add((Component)this.panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel_2.setLayout(gbl_panel_2);
        JPanel panelAudioOptions = new JPanel();
        GridBagConstraints gbc_panelAudioOptions = new GridBagConstraints();
        gbc_panelAudioOptions.insets = new Insets(4, 4, 4, 4);
        gbc_panelAudioOptions.weightx = 1.0;
        gbc_panelAudioOptions.fill = 2;
        gbc_panelAudioOptions.gridx = 0;
        gbc_panelAudioOptions.gridy = 0;
        this.panel_2.add((Component)panelAudioOptions, gbc_panelAudioOptions);
        GridBagLayout gbl_panelAudioOptions = new GridBagLayout();
        gbl_panelAudioOptions.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelAudioOptions.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panelAudioOptions.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelAudioOptions.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelAudioOptions.setLayout(gbl_panelAudioOptions);
        JLabel lblMinBpm = new JLabel("Min. Tempo (BPM):");
        lblMinBpm.setToolTipText("Minimum tempo (BPM) e.g. 80");
        GridBagConstraints gbc_lblMinBpm = new GridBagConstraints();
        gbc_lblMinBpm.anchor = 17;
        gbc_lblMinBpm.insets = new Insets(0, 0, 5, 5);
        gbc_lblMinBpm.gridx = 0;
        gbc_lblMinBpm.gridy = 0;
        panelAudioOptions.add((Component)lblMinBpm, gbc_lblMinBpm);
        this.textFieldControlPanelMinBPM = new TextFieldControlPanel();
        this.textFieldControlPanelMinBPM.setToolTipText("");
        GridBagConstraints gbc_textFieldControlPanelMinBPM = new GridBagConstraints();
        gbc_textFieldControlPanelMinBPM.weightx = 1.0;
        gbc_textFieldControlPanelMinBPM.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldControlPanelMinBPM.fill = 1;
        gbc_textFieldControlPanelMinBPM.gridx = 1;
        gbc_textFieldControlPanelMinBPM.gridy = 0;
        panelAudioOptions.add((Component)this.textFieldControlPanelMinBPM, gbc_textFieldControlPanelMinBPM);
        JLabel lblMaxBpm = new JLabel("Max. Tempo (BPM):");
        lblMaxBpm.setToolTipText("Maximum tempo (BPM) e.g. 120");
        GridBagConstraints gbc_lblMaxBpm = new GridBagConstraints();
        gbc_lblMaxBpm.anchor = 17;
        gbc_lblMaxBpm.insets = new Insets(0, 5, 5, 5);
        gbc_lblMaxBpm.gridx = 2;
        gbc_lblMaxBpm.gridy = 0;
        panelAudioOptions.add((Component)lblMaxBpm, gbc_lblMaxBpm);
        this.textFieldControlPanelMaxBPM = new TextFieldControlPanel();
        this.textFieldControlPanelMaxBPM.setToolTipText("");
        GridBagConstraints gbc_textFieldControlPanelMaxBPM = new GridBagConstraints();
        gbc_textFieldControlPanelMaxBPM.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelMaxBPM.weightx = 1.0;
        gbc_textFieldControlPanelMaxBPM.fill = 1;
        gbc_textFieldControlPanelMaxBPM.gridx = 3;
        gbc_textFieldControlPanelMaxBPM.gridy = 0;
        panelAudioOptions.add((Component)this.textFieldControlPanelMaxBPM, gbc_textFieldControlPanelMaxBPM);
        JLabel lblMinDb = new JLabel("Min. dB (RMS):");
        lblMinDb.setToolTipText("Minimum decibel (RMS) e.g. -14");
        GridBagConstraints gbc_lblMinDb = new GridBagConstraints();
        gbc_lblMinDb.anchor = 17;
        gbc_lblMinDb.insets = new Insets(0, 0, 5, 5);
        gbc_lblMinDb.gridx = 0;
        gbc_lblMinDb.gridy = 1;
        panelAudioOptions.add((Component)lblMinDb, gbc_lblMinDb);
        this.textFieldControlPanelMinRms = new TextFieldControlPanel();
        this.textFieldControlPanelMinRms.setToolTipText("");
        GridBagConstraints gbc_textFieldControlPanelMinRms = new GridBagConstraints();
        gbc_textFieldControlPanelMinRms.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldControlPanelMinRms.fill = 1;
        gbc_textFieldControlPanelMinRms.gridx = 1;
        gbc_textFieldControlPanelMinRms.gridy = 1;
        panelAudioOptions.add((Component)this.textFieldControlPanelMinRms, gbc_textFieldControlPanelMinRms);
        JLabel lblMaxDb = new JLabel("Max. dB (RMS):");
        lblMaxDb.setToolTipText("Maximum decibel (RMS) e.g. -8");
        GridBagConstraints gbc_lblMaxDb = new GridBagConstraints();
        gbc_lblMaxDb.anchor = 17;
        gbc_lblMaxDb.insets = new Insets(0, 5, 5, 5);
        gbc_lblMaxDb.gridx = 2;
        gbc_lblMaxDb.gridy = 1;
        panelAudioOptions.add((Component)lblMaxDb, gbc_lblMaxDb);
        this.textFieldControlPanelMaxRms = new TextFieldControlPanel();
        this.textFieldControlPanelMaxRms.setToolTipText("");
        GridBagConstraints gbc_textFieldControlPanelMaxRms = new GridBagConstraints();
        gbc_textFieldControlPanelMaxRms.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelMaxRms.fill = 1;
        gbc_textFieldControlPanelMaxRms.gridx = 3;
        gbc_textFieldControlPanelMaxRms.gridy = 1;
        panelAudioOptions.add((Component)this.textFieldControlPanelMaxRms, gbc_textFieldControlPanelMaxRms);
        JLabel lblMinPeak = new JLabel("Min. Peak dB:");
        lblMinPeak.setToolTipText("Minimum peak decibel (RMS) e.g. -12");
        GridBagConstraints gbc_lblMinPeak = new GridBagConstraints();
        gbc_lblMinPeak.anchor = 17;
        gbc_lblMinPeak.insets = new Insets(0, 0, 5, 5);
        gbc_lblMinPeak.gridx = 0;
        gbc_lblMinPeak.gridy = 2;
        panelAudioOptions.add((Component)lblMinPeak, gbc_lblMinPeak);
        this.textFieldControlPanelMinPeakRms = new TextFieldControlPanel();
        this.textFieldControlPanelMinPeakRms.setToolTipText("");
        GridBagConstraints gbc_textFieldControlPanelMinPeakRms = new GridBagConstraints();
        gbc_textFieldControlPanelMinPeakRms.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldControlPanelMinPeakRms.fill = 1;
        gbc_textFieldControlPanelMinPeakRms.gridx = 1;
        gbc_textFieldControlPanelMinPeakRms.gridy = 2;
        panelAudioOptions.add((Component)this.textFieldControlPanelMinPeakRms, gbc_textFieldControlPanelMinPeakRms);
        JLabel lblMaxPeak = new JLabel("Max. Peak dB:");
        lblMaxPeak.setToolTipText("Maximum peak decibel (RMS) e.g. -6");
        GridBagConstraints gbc_lblMaxPeak = new GridBagConstraints();
        gbc_lblMaxPeak.anchor = 17;
        gbc_lblMaxPeak.insets = new Insets(0, 5, 5, 5);
        gbc_lblMaxPeak.gridx = 2;
        gbc_lblMaxPeak.gridy = 2;
        panelAudioOptions.add((Component)lblMaxPeak, gbc_lblMaxPeak);
        this.textFieldControlPanelMaxPeakRms = new TextFieldControlPanel();
        this.textFieldControlPanelMaxPeakRms.setToolTipText("");
        GridBagConstraints gbc_textFieldControlPanelMaxPeakRms = new GridBagConstraints();
        gbc_textFieldControlPanelMaxPeakRms.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelMaxPeakRms.fill = 1;
        gbc_textFieldControlPanelMaxPeakRms.gridx = 3;
        gbc_textFieldControlPanelMaxPeakRms.gridy = 2;
        panelAudioOptions.add((Component)this.textFieldControlPanelMaxPeakRms, gbc_textFieldControlPanelMaxPeakRms);
        JLabel lblMinRate = new JLabel("Min. Sample Rate:");
        lblMinRate.setToolTipText("Minimum sample rate (e.g. 44100 Hz)");
        GridBagConstraints gbc_lblMinRate = new GridBagConstraints();
        gbc_lblMinRate.anchor = 17;
        gbc_lblMinRate.insets = new Insets(0, 0, 0, 5);
        gbc_lblMinRate.gridx = 0;
        gbc_lblMinRate.gridy = 3;
        panelAudioOptions.add((Component)lblMinRate, gbc_lblMinRate);
        this.textFieldControlPanelMinSampleRate = new TextFieldControlPanel();
        this.textFieldControlPanelMinSampleRate.setToolTipText("");
        GridBagConstraints gbc_textFieldControlPanelMinSampleRate = new GridBagConstraints();
        gbc_textFieldControlPanelMinSampleRate.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldControlPanelMinSampleRate.fill = 1;
        gbc_textFieldControlPanelMinSampleRate.gridx = 1;
        gbc_textFieldControlPanelMinSampleRate.gridy = 3;
        panelAudioOptions.add((Component)this.textFieldControlPanelMinSampleRate, gbc_textFieldControlPanelMinSampleRate);
        JLabel lblMaxRate = new JLabel("Max. Sample Rate:");
        lblMaxRate.setToolTipText("Maximum sample rate (e.g. 96000 Hz)");
        GridBagConstraints gbc_lblMaxRate = new GridBagConstraints();
        gbc_lblMaxRate.anchor = 17;
        gbc_lblMaxRate.insets = new Insets(0, 5, 0, 5);
        gbc_lblMaxRate.gridx = 2;
        gbc_lblMaxRate.gridy = 3;
        panelAudioOptions.add((Component)lblMaxRate, gbc_lblMaxRate);
        this.textFieldControlPanelMaxSampleRate = new TextFieldControlPanel();
        this.textFieldControlPanelMaxSampleRate.setToolTipText("");
        GridBagConstraints gbc_textFieldControlPanelMaxSampleRate = new GridBagConstraints();
        gbc_textFieldControlPanelMaxSampleRate.fill = 1;
        gbc_textFieldControlPanelMaxSampleRate.gridx = 3;
        gbc_textFieldControlPanelMaxSampleRate.gridy = 3;
        panelAudioOptions.add((Component)this.textFieldControlPanelMaxSampleRate, gbc_textFieldControlPanelMaxSampleRate);
        JPanel panelActions = new JPanel();
        GridBagConstraints gbc_panelActions = new GridBagConstraints();
        gbc_panelActions.insets = new Insets(0, 8, 8, 8);
        gbc_panelActions.fill = 2;
        gbc_panelActions.gridx = 0;
        gbc_panelActions.gridy = 2;
        this.add((Component)panelActions, gbc_panelActions);
        GridBagLayout gbl_panelActions = new GridBagLayout();
        gbl_panelActions.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelActions.rowHeights = new int[]{0, 0};
        gbl_panelActions.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelActions.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelActions.setLayout(gbl_panelActions);
        this.btnSearch = new JButton("Search");
        this.btnSearch.setToolTipText("Perform advanced search");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSearchPanel.this.actionSearch();
            }
        });
        this.btnReset = new JButton("Reset");
        this.btnReset.setDefaultCapable(false);
        this.btnReset.setToolTipText("Reset search options");
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSearchPanel.this.actionReset();
            }
        });
        GridBagConstraints gbc_btnReset = new GridBagConstraints();
        gbc_btnReset.insets = new Insets(0, 0, 0, 5);
        gbc_btnReset.gridx = 0;
        gbc_btnReset.gridy = 0;
        panelActions.add((Component)this.btnReset, gbc_btnReset);
        this.btnClear = new JButton("Clear");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedSearchPanel.this.actionClear();
            }
        });
        this.btnClear.setDefaultCapable(false);
        GridBagConstraints gbc_btnClear = new GridBagConstraints();
        gbc_btnClear.insets = new Insets(0, 0, 0, 5);
        gbc_btnClear.gridx = 1;
        gbc_btnClear.gridy = 0;
        panelActions.add((Component)this.btnClear, gbc_btnClear);
        this.chckbxKeepDialogOpen = new JCheckBox("Keep dialog open");
        GridBagConstraints gbc_chckbxKeepDialogOpen = new GridBagConstraints();
        gbc_chckbxKeepDialogOpen.weightx = 1.0;
        gbc_chckbxKeepDialogOpen.insets = new Insets(0, 0, 0, 5);
        gbc_chckbxKeepDialogOpen.gridx = 2;
        gbc_chckbxKeepDialogOpen.gridy = 0;
        panelActions.add((Component)this.chckbxKeepDialogOpen, gbc_chckbxKeepDialogOpen);
        GridBagConstraints gbc_btnSearch = new GridBagConstraints();
        gbc_btnSearch.anchor = 13;
        gbc_btnSearch.gridx = 3;
        gbc_btnSearch.gridy = 0;
        panelActions.add((Component)this.btnSearch, gbc_btnSearch);
        this.initAdvancedSearchPanel();
    }

    protected void initAdvancedSearchPanel() {
        InputMap inputMap;
        this.audioMath = new AudioMathImpl();
        this.textFieldControlPanelRegex.setControl((Control)this.regexControl);
        this.textFieldControlPanelMinTime.setControl((Control)this.minTimeControl);
        this.textFieldControlPanelMaxTime.setControl((Control)this.maxTimeControl);
        this.textFieldControlPanelMinBPM.setControl((Control)this.minBpmControl);
        this.textFieldControlPanelMaxBPM.setControl((Control)this.maxBpmControl);
        this.textFieldControlPanelMinRms.setControl((Control)this.minRmsControl);
        this.textFieldControlPanelMaxRms.setControl((Control)this.maxRmsControl);
        this.textFieldControlPanelMinPeakRms.setControl((Control)this.minPeakRmsControl);
        this.textFieldControlPanelMaxPeakRms.setControl((Control)this.maxPeakRmsControl);
        this.textFieldControlPanelMinSampleRate.setControl((Control)this.minSampleRateControl);
        this.textFieldControlPanelMaxSampleRate.setControl((Control)this.maxSampleRateControl);
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null) {
            actionMap.put(ACTION_ENTER, new EnterAction());
            actionMap.put(ACTION_ESCAPE, new EscapeAction());
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0), ACTION_ENTER);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), ACTION_ESCAPE);
        }
    }

    public AdvancedSearchOptions getOptions() {
        return this.options;
    }

    public void setOptions(AdvancedSearchOptions options) {
        this.options = options;
        this.refresh();
    }

    protected void refresh() {
        AdvancedSearchOptions o = this.options;
        if (o != null) {
            this.regexControl.setText(o.getRegex());
            double v = o.getMinDuration();
            this.minTimeControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = o.getMaxDuration();
            this.maxTimeControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = o.getMinBpm();
            this.minBpmControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = o.getMaxBpm();
            this.maxBpmControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = this.rmsToDecibel(o.getMinRms());
            this.minRmsControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = this.rmsToDecibel(o.getMaxRms());
            this.maxRmsControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = this.rmsToDecibel(o.getMinPeakRms());
            this.minPeakRmsControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = this.rmsToDecibel(o.getMaxPeakRms());
            this.maxPeakRmsControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = o.getMinFrameRate();
            this.minSampleRateControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            v = o.getMaxFrameRate();
            this.maxSampleRateControl.setText(Double.isNaN(v) ? null : Double.toString(v));
            this.formats = o.getFormats();
            this.refreshFormats();
        }
    }

    protected void refreshFormats() {
        StringBuffer sb = new StringBuffer();
        if (this.formats != null && !this.formats.isEmpty()) {
            TreeSet set = new TreeSet();
            set.addAll(this.formats);
            Iterator i = set.iterator();
            while (i.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(i.next()));
            }
        }
        this.textFieldFileFormats.setText(sb.toString());
    }

    protected void actionReset() {
        AdvancedSearchOptions o = this.options;
        if (o == null) {
            o = new AdvancedSearchOptions();
        }
        this.setOptions(o);
    }

    protected void actionClear() {
        AdvancedSearchOptions o = new AdvancedSearchOptions();
        this.setOptions(o);
    }

    protected void actionCancel() {
        if (this.owner != null) {
            this.owner.dispose();
        }
    }

    protected void actionSearch() {
        AdvancedSearchOptions o = this.options;
        if (o == null) {
            return;
        }
        o.setRegex(this.regexControl.getText());
        o.setFormats(this.formats);
        o.setMinDuration(this.parseDouble(this.minTimeControl, Double.NaN));
        o.setMaxDuration(this.parseDouble(this.maxTimeControl, Double.NaN));
        o.setMinBpm(this.parseDouble(this.minBpmControl, Double.NaN));
        o.setMaxBpm(this.parseDouble(this.maxBpmControl, Double.NaN));
        o.setMinRms(this.decibelToRms(this.parseDouble(this.minRmsControl, Double.NaN)));
        o.setMaxRms(this.decibelToRms(this.parseDouble(this.maxRmsControl, Double.NaN)));
        o.setMinPeakRms(this.decibelToRms(this.parseDouble(this.minPeakRmsControl, Double.NaN)));
        o.setMaxPeakRms(this.decibelToRms(this.parseDouble(this.maxPeakRmsControl, Double.NaN)));
        o.setMinFrameRate(this.parseDouble(this.minSampleRateControl, Double.NaN));
        o.setMaxFrameRate(this.parseDouble(this.maxSampleRateControl, Double.NaN));
        MediaTableToolContext context = this.mediaTableToolContext;
        if (context != null) {
            context.setAdvancedSearchOptions(o);
        }
        if (!this.chckbxKeepDialogOpen.isSelected() && this.owner != null) {
            this.owner.dispose();
        }
    }

    protected double parseDouble(TextControl control, double defaultValue) {
        try {
            String text = control.getText();
            if (text != null && (text = text.trim()).length() > 0) {
                return Double.parseDouble(text);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return defaultValue;
    }

    protected double decibelToRms(double decibel) {
        if (Double.isNaN(decibel)) {
            return Double.NaN;
        }
        return this.audioMath.decibel2Rms(decibel);
    }

    protected double rmsToDecibel(double rms) {
        if (Double.isNaN(rms)) {
            return Double.NaN;
        }
        return this.audioMath.rms2Decibel(rms);
    }

    protected JButton getBtnSearch() {
        return this.btnSearch;
    }

    protected TextFieldControlPanel getTextFieldControlPanelRegex() {
        return this.textFieldControlPanelRegex;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMinBPM() {
        return this.textFieldControlPanelMinBPM;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMaxBPM() {
        return this.textFieldControlPanelMaxBPM;
    }

    protected JButton getBtnReset() {
        return this.btnReset;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMinTime() {
        return this.textFieldControlPanelMinTime;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMaxTime() {
        return this.textFieldControlPanelMaxTime;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMinRms() {
        return this.textFieldControlPanelMinRms;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMaxRms() {
        return this.textFieldControlPanelMaxRms;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMinPeakRms() {
        return this.textFieldControlPanelMinPeakRms;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMaxPeakRms() {
        return this.textFieldControlPanelMaxPeakRms;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMinSampleRate() {
        return this.textFieldControlPanelMinSampleRate;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMaxSampleRate() {
        return this.textFieldControlPanelMaxSampleRate;
    }

    public MediaTableToolContext getMediaTableToolContext() {
        return this.mediaTableToolContext;
    }

    public void setMediaTableToolContext(MediaTableToolContext mediaTableToolContext) {
        this.mediaTableToolContext = mediaTableToolContext;
    }

    public Window getOwner() {
        return this.owner;
    }

    public void setOwner(Window owner) {
        this.owner = owner;
    }

    protected JCheckBox getChckbxKeepDialogOpen() {
        return this.chckbxKeepDialogOpen;
    }

    protected JTextField getTextFieldFileFormats() {
        return this.textFieldFileFormats;
    }

    protected void actionBrowseFileFormats() {
        try {
            String format;
            Set selFormats = this.formats;
            String[] fileFormats = this.mediaTableToolContext.enumerateFileFormats();
            int num = fileFormats.length;
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(num, 1));
            JCheckBox[] checkBoxes = new JCheckBox[num];
            for (int i = 0; i < num; ++i) {
                JCheckBox cb = new JCheckBox();
                format = String.valueOf(fileFormats[i]);
                cb.setText(format);
                if (selFormats == null || selFormats.isEmpty() || selFormats.contains(format)) {
                    cb.setSelected(true);
                }
                checkBoxes[i] = cb;
                panel.add(cb);
            }
            JPanel message = panel;
            String title = "File Format(s)";
            int optionType = 2;
            int messageType = -1;
            int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
            if (rc != 0) {
                return;
            }
            HashSet<String> newFormats = new HashSet<String>();
            if (selFormats != null) {
                newFormats.addAll(selFormats);
            }
            boolean allSelected = true;
            for (int i = 0; i < num; ++i) {
                format = fileFormats[i];
                if (checkBoxes[i].isSelected()) {
                    newFormats.add(format);
                    continue;
                }
                newFormats.remove(format);
                allSelected = false;
            }
            if (newFormats.isEmpty() || allSelected) {
                newFormats = null;
            }
            this.formats = newFormats;
            this.refreshFormats();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected class EscapeAction
    extends AbstractAction {
        private static final long serialVersionUID = 7779972779673791792L;

        protected EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedSearchPanel.this.actionCancel();
        }
    }

    protected class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = -3070405239835617010L;

        protected EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedSearchPanel.this.actionSearch();
        }
    }

    protected class SearchNumberControl
    extends AbstractTextControl {
        protected void applyText(String text) {
        }
    }

    protected class SearchTextControl
    extends AbstractTextControl {
        protected void applyText(String text) {
        }
    }
}

