/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.AbstractEntryPropertiesPanel;
import com.spacekiller.util.media.manager.column.EntryBitRateTableColumnProvider;
import com.spacekiller.util.sound.AudioMath;
import com.spacekiller.util.sound.AudioMathImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AudioEntryPropertiesPanel
extends AbstractEntryPropertiesPanel {
    private static final long serialVersionUID = -7404499671599883672L;
    private AudioMath audioMath;
    private JTextField textFieldAudioCodec;
    private JTextField textFieldAudioFormat;
    private JTextField textFieldBPM;
    private JTextField textFieldRMS;
    private JTextField textFieldPeakRMS;
    private JTextField textFieldZeroCrossings;
    private JTextField textFieldBitRate;
    private JTextField textFieldAmp;
    private JCheckBox chckbxNormalized;
    private JTextField textFieldSoundRange;

    public AudioEntryPropertiesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelAudioMain = new JPanel();
        GridBagConstraints gbc_panelAudioMain = new GridBagConstraints();
        gbc_panelAudioMain.insets = new Insets(4, 4, 4, 4);
        gbc_panelAudioMain.fill = 2;
        gbc_panelAudioMain.weightx = 1.0;
        gbc_panelAudioMain.gridx = 0;
        gbc_panelAudioMain.gridy = 0;
        this.add((Component)panelAudioMain, gbc_panelAudioMain);
        GridBagLayout gbl_panelAudioMain = new GridBagLayout();
        gbl_panelAudioMain.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelAudioMain.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panelAudioMain.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelAudioMain.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelAudioMain.setLayout(gbl_panelAudioMain);
        JLabel lblCodec = new JLabel("Codec:");
        lblCodec.setToolTipText("Audio Codec");
        GridBagConstraints gbc_lblCodec = new GridBagConstraints();
        gbc_lblCodec.insets = new Insets(0, 0, 5, 5);
        gbc_lblCodec.anchor = 17;
        gbc_lblCodec.gridx = 0;
        gbc_lblCodec.gridy = 0;
        panelAudioMain.add((Component)lblCodec, gbc_lblCodec);
        this.textFieldAudioCodec = new JTextField();
        this.textFieldAudioCodec.setToolTipText("Audio Codec");
        this.textFieldAudioCodec.setEditable(false);
        GridBagConstraints gbc_textFieldAudioCodec = new GridBagConstraints();
        gbc_textFieldAudioCodec.weightx = 1.0;
        gbc_textFieldAudioCodec.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldAudioCodec.fill = 2;
        gbc_textFieldAudioCodec.gridx = 1;
        gbc_textFieldAudioCodec.gridy = 0;
        panelAudioMain.add((Component)this.textFieldAudioCodec, gbc_textFieldAudioCodec);
        this.textFieldAudioCodec.setColumns(10);
        JLabel lblBitRate = new JLabel("Bit Rate:");
        lblBitRate.setToolTipText("Audio Bit Rate");
        GridBagConstraints gbc_lblBitRate = new GridBagConstraints();
        gbc_lblBitRate.anchor = 17;
        gbc_lblBitRate.insets = new Insets(0, 0, 5, 5);
        gbc_lblBitRate.gridx = 2;
        gbc_lblBitRate.gridy = 0;
        panelAudioMain.add((Component)lblBitRate, gbc_lblBitRate);
        this.textFieldBitRate = new JTextField();
        this.textFieldBitRate.setToolTipText("Audio Bit Rate");
        this.textFieldBitRate.setEditable(false);
        GridBagConstraints gbc_textFieldBitRate = new GridBagConstraints();
        gbc_textFieldBitRate.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldBitRate.fill = 2;
        gbc_textFieldBitRate.gridx = 3;
        gbc_textFieldBitRate.gridy = 0;
        panelAudioMain.add((Component)this.textFieldBitRate, gbc_textFieldBitRate);
        this.textFieldBitRate.setColumns(10);
        JLabel lblFormat = new JLabel("Format:");
        lblFormat.setToolTipText("Audio Format");
        GridBagConstraints gbc_lblFormat = new GridBagConstraints();
        gbc_lblFormat.anchor = 17;
        gbc_lblFormat.insets = new Insets(0, 0, 5, 5);
        gbc_lblFormat.gridx = 0;
        gbc_lblFormat.gridy = 1;
        panelAudioMain.add((Component)lblFormat, gbc_lblFormat);
        this.textFieldAudioFormat = new JTextField();
        this.textFieldAudioFormat.setToolTipText("Audio Format");
        this.textFieldAudioFormat.setEditable(false);
        GridBagConstraints gbc_textFieldAudioFormat = new GridBagConstraints();
        gbc_textFieldAudioFormat.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldAudioFormat.fill = 2;
        gbc_textFieldAudioFormat.gridx = 1;
        gbc_textFieldAudioFormat.gridy = 1;
        panelAudioMain.add((Component)this.textFieldAudioFormat, gbc_textFieldAudioFormat);
        this.textFieldAudioFormat.setColumns(10);
        JLabel lblTempo = new JLabel("Tempo:");
        lblTempo.setToolTipText("BPM");
        GridBagConstraints gbc_lblTempo = new GridBagConstraints();
        gbc_lblTempo.anchor = 17;
        gbc_lblTempo.insets = new Insets(0, 0, 5, 5);
        gbc_lblTempo.gridx = 2;
        gbc_lblTempo.gridy = 1;
        panelAudioMain.add((Component)lblTempo, gbc_lblTempo);
        this.textFieldBPM = new JTextField();
        this.textFieldBPM.setToolTipText("BPM");
        this.textFieldBPM.setEditable(false);
        GridBagConstraints gbc_textFieldBPM = new GridBagConstraints();
        gbc_textFieldBPM.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldBPM.fill = 2;
        gbc_textFieldBPM.gridx = 3;
        gbc_textFieldBPM.gridy = 1;
        panelAudioMain.add((Component)this.textFieldBPM, gbc_textFieldBPM);
        this.textFieldBPM.setColumns(10);
        JLabel lblAmp = new JLabel("Amp:");
        lblAmp.setToolTipText("Max. Amplitude (%)");
        GridBagConstraints gbc_lblAmp = new GridBagConstraints();
        gbc_lblAmp.anchor = 17;
        gbc_lblAmp.insets = new Insets(0, 0, 5, 5);
        gbc_lblAmp.gridx = 0;
        gbc_lblAmp.gridy = 2;
        panelAudioMain.add((Component)lblAmp, gbc_lblAmp);
        this.textFieldAmp = new JTextField();
        this.textFieldAmp.setToolTipText("Max. Amplitude (%)");
        this.textFieldAmp.setEditable(false);
        GridBagConstraints gbc_textFieldAmp = new GridBagConstraints();
        gbc_textFieldAmp.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldAmp.fill = 2;
        gbc_textFieldAmp.gridx = 1;
        gbc_textFieldAmp.gridy = 2;
        panelAudioMain.add((Component)this.textFieldAmp, gbc_textFieldAmp);
        this.textFieldAmp.setColumns(10);
        this.chckbxNormalized = new JCheckBox("Normalized");
        this.chckbxNormalized.setToolTipText("Normalized ?");
        this.chckbxNormalized.setEnabled(false);
        GridBagConstraints gbc_chckbxNormalized = new GridBagConstraints();
        gbc_chckbxNormalized.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxNormalized.anchor = 17;
        gbc_chckbxNormalized.gridwidth = 2;
        gbc_chckbxNormalized.gridx = 2;
        gbc_chckbxNormalized.gridy = 2;
        panelAudioMain.add((Component)this.chckbxNormalized, gbc_chckbxNormalized);
        JLabel lblRms = new JLabel("RMS:");
        lblRms.setToolTipText("dB (RMS)");
        GridBagConstraints gbc_lblRms = new GridBagConstraints();
        gbc_lblRms.anchor = 17;
        gbc_lblRms.insets = new Insets(0, 0, 5, 5);
        gbc_lblRms.gridx = 0;
        gbc_lblRms.gridy = 3;
        panelAudioMain.add((Component)lblRms, gbc_lblRms);
        this.textFieldRMS = new JTextField();
        this.textFieldRMS.setToolTipText("dB (RMS)");
        this.textFieldRMS.setEditable(false);
        GridBagConstraints gbc_textFieldRMS = new GridBagConstraints();
        gbc_textFieldRMS.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldRMS.fill = 2;
        gbc_textFieldRMS.gridx = 1;
        gbc_textFieldRMS.gridy = 3;
        panelAudioMain.add((Component)this.textFieldRMS, gbc_textFieldRMS);
        this.textFieldRMS.setColumns(10);
        JLabel lblPeak = new JLabel("Peak:");
        lblPeak.setToolTipText("dB (RMS)");
        GridBagConstraints gbc_lblPeak = new GridBagConstraints();
        gbc_lblPeak.anchor = 17;
        gbc_lblPeak.insets = new Insets(0, 0, 5, 5);
        gbc_lblPeak.gridx = 2;
        gbc_lblPeak.gridy = 3;
        panelAudioMain.add((Component)lblPeak, gbc_lblPeak);
        this.textFieldPeakRMS = new JTextField();
        this.textFieldPeakRMS.setToolTipText("dB (RMS)");
        this.textFieldPeakRMS.setEditable(false);
        GridBagConstraints gbc_textFieldPeakRMS = new GridBagConstraints();
        gbc_textFieldPeakRMS.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldPeakRMS.fill = 2;
        gbc_textFieldPeakRMS.gridx = 3;
        gbc_textFieldPeakRMS.gridy = 3;
        panelAudioMain.add((Component)this.textFieldPeakRMS, gbc_textFieldPeakRMS);
        this.textFieldPeakRMS.setColumns(10);
        JLabel lblRange = new JLabel("Range:");
        lblRange.setToolTipText("Sound range start/end position");
        GridBagConstraints gbc_lblRange = new GridBagConstraints();
        gbc_lblRange.anchor = 17;
        gbc_lblRange.insets = new Insets(0, 0, 0, 5);
        gbc_lblRange.gridx = 0;
        gbc_lblRange.gridy = 4;
        panelAudioMain.add((Component)lblRange, gbc_lblRange);
        this.textFieldSoundRange = new JTextField();
        this.textFieldSoundRange.setToolTipText("Sound range start/end position");
        this.textFieldSoundRange.setEditable(false);
        GridBagConstraints gbc_textFieldSoundRange = new GridBagConstraints();
        gbc_textFieldSoundRange.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldSoundRange.fill = 2;
        gbc_textFieldSoundRange.gridx = 1;
        gbc_textFieldSoundRange.gridy = 4;
        panelAudioMain.add((Component)this.textFieldSoundRange, gbc_textFieldSoundRange);
        this.textFieldSoundRange.setColumns(10);
        JLabel lblZerocrossings = new JLabel("Zero~:");
        lblZerocrossings.setToolTipText("Zero-Crossings");
        GridBagConstraints gbc_lblZerocrossings = new GridBagConstraints();
        gbc_lblZerocrossings.anchor = 17;
        gbc_lblZerocrossings.insets = new Insets(0, 0, 0, 5);
        gbc_lblZerocrossings.gridx = 2;
        gbc_lblZerocrossings.gridy = 4;
        panelAudioMain.add((Component)lblZerocrossings, gbc_lblZerocrossings);
        this.textFieldZeroCrossings = new JTextField();
        this.textFieldZeroCrossings.setToolTipText("Zero-Crossings");
        this.textFieldZeroCrossings.setEditable(false);
        GridBagConstraints gbc_textFieldZeroCrossings = new GridBagConstraints();
        gbc_textFieldZeroCrossings.fill = 2;
        gbc_textFieldZeroCrossings.gridx = 3;
        gbc_textFieldZeroCrossings.gridy = 4;
        panelAudioMain.add((Component)this.textFieldZeroCrossings, gbc_textFieldZeroCrossings);
        this.textFieldZeroCrossings.setColumns(10);
        this.initAudioEntryPropertiesPanel();
    }

    protected void initAudioEntryPropertiesPanel() {
        this.setTitle("Audio");
        this.setTooltip("Audio Properties");
        this.audioMath = new AudioMathImpl();
        this.refresh();
    }

    @Override
    public synchronized void refresh() {
        AudioEntry audioEntry;
        MediaEntry mediaEntry = this.getMediaEntry();
        String audioCodec = null;
        String audioBitRateInfo = null;
        String audioFormatInfo = null;
        String bpmInfo = null;
        String ampInfo = null;
        int normalized = 0;
        String rmsInfo = null;
        String peakInfo = null;
        String soundRangeInfo = null;
        long zeroCrossings = -1L;
        AudioEntry audioEntry2 = audioEntry = mediaEntry == null ? null : mediaEntry.getAudioEntry();
        if (audioEntry != null) {
            double peak;
            double rms;
            double bpm;
            int audioChannels;
            float frameRate;
            double bitRate;
            audioCodec = audioEntry.getAudioCodec();
            if (audioCodec == null) {
                audioCodec = mediaEntry.getFormat();
            }
            if ((bitRate = EntryBitRateTableColumnProvider.getBitRate(mediaEntry)) >= 0.0) {
                double rate = Math.floor(bitRate / 1000.0);
                audioBitRateInfo = Long.toString(Math.round(rate)) + " Kb/s";
            }
            audioFormatInfo = (double)(frameRate = audioEntry.getFrameRate()) > 0.0 ? Integer.toString(Math.round(frameRate)) + " Hz, " : "";
            int bitDepth = audioEntry.getBitDepth();
            if (bitDepth > 0) {
                audioFormatInfo = audioFormatInfo + Integer.toString(bitDepth) + " bit, ";
            }
            if ((audioChannels = audioEntry.getChannels()) > 0) {
                switch (audioChannels) {
                    case 1: {
                        audioFormatInfo = audioFormatInfo + "mono";
                        break;
                    }
                    case 2: {
                        audioFormatInfo = audioFormatInfo + "stereo";
                        break;
                    }
                    default: {
                        audioFormatInfo = audioFormatInfo + Integer.toString(audioChannels) + " channels";
                    }
                }
            }
            if ((bpm = audioEntry.getBpm()) > 0.0) {
                bpmInfo = String.valueOf(bpm) + " BPM";
            }
            if (!Double.isNaN(rms = audioEntry.getRms())) {
                double dB = this.audioMath.rms2Decibel(rms);
                rmsInfo = Double.toString((double)Math.round(dB * 100.0) / 100.0) + " dB";
            }
            if (!Double.isNaN(peak = audioEntry.getPeakRms())) {
                double dB = this.audioMath.rms2Decibel(peak);
                peakInfo = Double.toString((double)Math.round(dB * 100.0) / 100.0) + " dB";
            }
            double minAmp = audioEntry.getMinAmplitude();
            double maxAmp = audioEntry.getMaxAmplitude();
            if (!Double.isNaN(minAmp) && !Double.isNaN(maxAmp)) {
                double amp = Math.max(Math.abs(minAmp), Math.abs(maxAmp));
                ampInfo = Double.toString((double)Math.round(amp * 10000.0) / 100.0) + " %";
            }
            normalized = audioEntry.getNormalized();
            double firstSoundMillis = audioEntry.getFirstSoundMillis();
            double lastSoundMillis = audioEntry.getLastSoundMillis();
            if (!Double.isNaN(firstSoundMillis) && !Double.isNaN(lastSoundMillis)) {
                soundRangeInfo = this.formatTimeMillis(Math.floor(firstSoundMillis));
                soundRangeInfo = soundRangeInfo + "  >>  ";
                soundRangeInfo = soundRangeInfo + this.formatTimeMillis(Math.ceil(lastSoundMillis));
            }
            zeroCrossings = audioEntry.getZeroCrossings();
        }
        this.textFieldAudioCodec.setText(audioCodec == null ? "" : audioCodec);
        this.textFieldAudioCodec.setCaretPosition(0);
        this.textFieldBitRate.setText(audioBitRateInfo == null ? "" : audioBitRateInfo);
        this.textFieldBitRate.setCaretPosition(0);
        this.textFieldAudioFormat.setText(audioFormatInfo == null ? "" : audioFormatInfo);
        this.textFieldAudioFormat.setCaretPosition(0);
        this.textFieldBPM.setText(bpmInfo == null ? "" : bpmInfo);
        this.textFieldBPM.setCaretPosition(0);
        this.textFieldAmp.setText(ampInfo == null ? "" : ampInfo);
        this.textFieldAmp.setCaretPosition(0);
        this.chckbxNormalized.setSelected(normalized > 0);
        this.textFieldRMS.setText(rmsInfo == null ? "" : rmsInfo);
        this.textFieldRMS.setCaretPosition(0);
        this.textFieldPeakRMS.setText(peakInfo == null ? "" : peakInfo);
        this.textFieldPeakRMS.setCaretPosition(0);
        this.textFieldSoundRange.setText(soundRangeInfo == null ? "" : soundRangeInfo);
        this.textFieldSoundRange.setCaretPosition(0);
        this.textFieldZeroCrossings.setText(zeroCrossings < 0L ? "" : Long.toString(zeroCrossings));
        this.textFieldZeroCrossings.setCaretPosition(0);
    }

    protected JTextField getTextFieldAudioCodec() {
        return this.textFieldAudioCodec;
    }

    protected JTextField getTextFieldAudioFormat() {
        return this.textFieldAudioFormat;
    }

    protected JTextField getTextFieldRMS() {
        return this.textFieldRMS;
    }

    protected JTextField getTextFieldZeroCrossings() {
        return this.textFieldZeroCrossings;
    }

    protected JTextField getTextFieldBitRate() {
        return this.textFieldBitRate;
    }

    protected JTextField getTextFieldBPM() {
        return this.textFieldBPM;
    }

    protected JTextField getTextFieldPeakRMS() {
        return this.textFieldPeakRMS;
    }

    protected JCheckBox getChckbxNormalized() {
        return this.chckbxNormalized;
    }

    protected JTextField getTextFieldAmp() {
        return this.textFieldAmp;
    }

    protected JTextField getTextFieldSoundRange() {
        return this.textFieldSoundRange;
    }

    protected String formatTimeMillis(double ms) {
        long millis;
        long seconds;
        long minutes;
        long hours;
        StringBuffer sb = new StringBuffer();
        if (ms < 0.0) {
            sb.append('-');
            ms = Math.abs(ms);
        }
        if ((hours = (minutes = (seconds = (millis = Math.round(ms)) / 1000L) / 60L) / 60L) > 0L) {
            sb.append(Long.toString(hours));
            sb.append(':');
        }
        sb.append(Long.toString(100L + (minutes %= 60L)).substring(1));
        sb.append(':');
        sb.append(Long.toString(100L + (seconds %= 60L)).substring(1));
        sb.append('.');
        sb.append(Long.toString(1000L + (millis %= 1000L)).substring(1));
        return sb.toString();
    }
}

