/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.library.m3u.M3uMediaCrate;
import com.spacekiller.util.media.library.remote.RemoteMediaCrate;
import com.spacekiller.util.media.library.serato.SeratoMediaCrate;
import com.spacekiller.util.media.manager.CrateTreeNode;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class CrateTreeCellRenderer
extends AbstractCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = 27115773023424732L;
    private JLabel label;
    private Icon defaultCrateIcon;
    private Icon directoryCrateIcon;
    private Icon crateFileIcon;
    private Icon remoteCrateIcon;
    private Icon remoteSubCrateIcon;
    private Icon seratoCrateIcon;
    private Icon m3uCrateIcon;
    private Font normalFont;
    private Font activeFont;
    private Font currentFont;
    private volatile CrateTreeNode currentNode;

    public CrateTreeCellRenderer() {
        this.setOpaque(false);
        this.label = new JLabel();
        this.label.setFont(this.getFont());
        this.setLayout(new GridLayout(1, 1));
        this.add(this.label);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Font font;
        String text = null;
        Icon icon = null;
        this.currentNode = null;
        if (value != null && value instanceof CrateTreeNode) {
            CrateTreeNode node = (CrateTreeNode)value;
            MediaCrate crate = node.getCrate();
            if (crate != null) {
                text = crate.getName();
                icon = this.getCrateIcon(crate);
            }
            this.currentNode = node;
        }
        Font font2 = font = selected ? this.activeFont : this.normalFont;
        if (font != this.currentFont) {
            this.label.setFont(font);
            this.currentFont = font;
        }
        if (text == null) {
            text = "";
        }
        this.label.setText(text);
        this.label.setIcon(icon);
        this.setSelected(selected);
        this.setFocus(hasFocus);
        return this;
    }

    protected Icon getCrateIcon(MediaCrate crate) {
        if (crate instanceof DirectoryMediaCrate) {
            return this.directoryCrateIcon;
        }
        if (crate instanceof CrateFileMediaCrate) {
            return this.crateFileIcon;
        }
        if (crate instanceof RemoteMediaCrate) {
            MediaCrate parent = crate.getParent();
            if (parent != null) {
                if (parent instanceof RemoteMediaCrate) {
                    return this.remoteSubCrateIcon;
                }
                return this.remoteCrateIcon;
            }
            return this.remoteSubCrateIcon;
        }
        if (crate instanceof SeratoMediaCrate) {
            return this.seratoCrateIcon;
        }
        if (crate instanceof M3uMediaCrate) {
            return this.m3uCrateIcon;
        }
        return this.defaultCrateIcon;
    }

    public Icon getDefaultCrateIcon() {
        return this.defaultCrateIcon;
    }

    public void setDefaultCrateIcon(Icon defaultCrateIcon) {
        this.defaultCrateIcon = defaultCrateIcon;
    }

    public Icon getDirectoryCrateIcon() {
        return this.directoryCrateIcon;
    }

    public void setDirectoryCrateIcon(Icon directoryCrateIcon) {
        this.directoryCrateIcon = directoryCrateIcon;
    }

    public String getToolTipText() {
        return this.getCurrentNodeToolTipText();
    }

    public String getToolTipText(MouseEvent event) {
        return this.getCurrentNodeToolTipText();
    }

    public String getCurrentNodeToolTipText() {
        CrateTreeNode node = this.currentNode;
        if (node != null) {
            return String.valueOf(node);
        }
        return null;
    }

    public Icon getSeratoCrateIcon() {
        return this.seratoCrateIcon;
    }

    public void setSeratoCrateIcon(Icon seratoCrateIcon) {
        this.seratoCrateIcon = seratoCrateIcon;
    }

    public Icon getCrateFileIcon() {
        return this.crateFileIcon;
    }

    public void setCrateFileIcon(Icon crateFileIcon) {
        this.crateFileIcon = crateFileIcon;
    }

    public Icon getM3uCrateIcon() {
        return this.m3uCrateIcon;
    }

    public void setM3uCrateIcon(Icon m3uCrateIcon) {
        this.m3uCrateIcon = m3uCrateIcon;
    }

    public Icon getRemoteCrateIcon() {
        return this.remoteCrateIcon;
    }

    public void setRemoteCrateIcon(Icon remoteCrateIcon) {
        this.remoteCrateIcon = remoteCrateIcon;
    }

    public Icon getRemoteSubCrateIcon() {
        return this.remoteSubCrateIcon;
    }

    public void setRemoteSubCrateIcon(Icon remoteSubCrateIcon) {
        this.remoteSubCrateIcon = remoteSubCrateIcon;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public void setNormalFont(Font normalFont) {
        this.normalFont = normalFont;
    }

    public Font getActiveFont() {
        return this.activeFont;
    }

    public void setActiveFont(Font activeFont) {
        this.activeFont = activeFont;
    }
}

