/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateListener;
import com.spacekiller.util.media.manager.CrateTreeModel;
import com.spacekiller.util.media.manager.CrateTreeNode;
import com.spacekiller.util.media.manager.DefaultCrateRootNode;
import com.spacekiller.util.media.manager.DefaultCrateTreeNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DefaultCrateTreeModel
extends DefaultTreeModel
implements CrateTreeModel {
    private static final long serialVersionUID = 7549181000816892170L;
    private static final Logger logger = Logger.getLogger(DefaultCrateTreeModel.class.getName());
    private final CrateHandler crateHandler = new CrateHandler();
    private MediaCrate rootCrate;
    private DefaultCrateRootNode rootCrateNode;
    private Map crateMap = new HashMap();

    public DefaultCrateTreeModel() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrateTreeNode getCrateTreeNode(MediaCrate crate) {
        Map map = this.crateMap;
        synchronized (map) {
            return (CrateTreeNode)this.crateMap.get(crate);
        }
    }

    @Override
    public synchronized MediaCrate getRootCrate() {
        return this.rootCrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootCrate(MediaCrate rootCrate) {
        DefaultCrateRootNode newRootNode = null;
        DefaultCrateTreeModel defaultCrateTreeModel = this;
        synchronized (defaultCrateTreeModel) {
            MediaCrate crate;
            MediaCrate oldRootCrate = this.rootCrate;
            if (rootCrate == oldRootCrate) {
                return;
            }
            if (oldRootCrate != null) {
                oldRootCrate.removeMediaCrateListener((MediaCrateListener)this.crateHandler);
            }
            if (rootCrate != null) {
                newRootNode = new DefaultCrateRootNode(rootCrate, this);
            }
            this.rootCrate = rootCrate;
            this.rootCrateNode = newRootNode;
            Map map = this.crateMap;
            synchronized (map) {
                this.crateMap.clear();
                if (rootCrate != null) {
                    this.crateMap.put(rootCrate, newRootNode);
                }
            }
            if (newRootNode != null && (crate = this.rootCrateNode.getCrate()) != null) {
                crate.addMediaCrateListener((MediaCrateListener)this.crateHandler);
            }
        }
        super.setRoot(newRootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerNodes(List list) {
        int num = list.size();
        Map map = this.crateMap;
        synchronized (map) {
            for (int i = 0; i < num; ++i) {
                CrateTreeNode crateNode;
                MediaCrate crate;
                Object node = list.get(i);
                if (node == null || !(node instanceof CrateTreeNode) || (crate = (crateNode = (CrateTreeNode)node).getCrate()) == null) continue;
                this.crateMap.put(crate, crateNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterNodes(List list) {
        int num = list.size();
        Map map = this.crateMap;
        synchronized (map) {
            for (int i = 0; i < num; ++i) {
                CrateTreeNode crateNode;
                MediaCrate crate;
                Object node = list.get(i);
                if (node == null || !(node instanceof CrateTreeNode) || (crate = (crateNode = (CrateTreeNode)node).getCrate()) == null || this.crateMap.get(crate) != crateNode) continue;
                this.crateMap.remove(crate);
            }
        }
    }

    protected class CrateHandler
    implements MediaCrateListener {
        protected CrateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void structureChanged(MediaCrate crate) {
            CrateTreeNode crateNode;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("structureChanged: crate=" + crate);
            }
            Map map = DefaultCrateTreeModel.this.crateMap;
            synchronized (map) {
                crateNode = (CrateTreeNode)DefaultCrateTreeModel.this.crateMap.get(crate);
            }
            if (crateNode != null) {
                crateNode.refresh();
                DefaultCrateTreeModel.this.fireTreeStructureChanged(this, DefaultCrateTreeModel.this.getPathToRoot(crateNode), null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void crateUpdated(MediaCrate crate) {
            CrateTreeNode childNode;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("crateUpdated: crate=" + crate);
            }
            Map map = DefaultCrateTreeModel.this.crateMap;
            synchronized (map) {
                childNode = (CrateTreeNode)DefaultCrateTreeModel.this.crateMap.get(crate);
            }
            if (childNode == null) {
                return;
            }
            TreeNode parentNode = childNode.getParent();
            if (parentNode == null) {
                DefaultCrateTreeModel.this.fireTreeNodesChanged(this, DefaultCrateTreeModel.this.getPathToRoot(childNode), null, null);
            } else {
                int childIndex = parentNode.getIndex(childNode);
                if (childIndex >= 0) {
                    Object[] path = DefaultCrateTreeModel.this.getPathToRoot(parentNode);
                    int[] childIndices = new int[]{childIndex};
                    Object[] children = new Object[]{childNode};
                    DefaultCrateTreeModel.this.fireTreeNodesChanged(this, path, childIndices, children);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void crateInserted(MediaCrate parent, MediaCrate child, int index) {
            CrateTreeNode childNode;
            CrateTreeNode parentNode;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("crateInserted: parent=" + parent + ", child=" + child + ", index=" + index);
            }
            Map map = DefaultCrateTreeModel.this.crateMap;
            synchronized (map) {
                parentNode = (CrateTreeNode)DefaultCrateTreeModel.this.crateMap.get(parent);
                if (parentNode == null) {
                    return;
                }
            }
            parentNode.getChildCount();
            boolean insert = false;
            Map map2 = DefaultCrateTreeModel.this.crateMap;
            synchronized (map2) {
                childNode = (CrateTreeNode)DefaultCrateTreeModel.this.crateMap.get(child);
                if (childNode == null) {
                    childNode = new DefaultCrateTreeNode(child);
                    DefaultCrateTreeModel.this.crateMap.put(child, childNode);
                    insert = true;
                } else if (childNode.getParent() != parentNode) {
                    insert = true;
                }
            }
            if (insert) {
                parentNode.insert(childNode, index);
            }
            Object[] path = DefaultCrateTreeModel.this.getPathToRoot(parentNode);
            int[] childIndices = new int[]{index};
            Object[] children = new Object[]{childNode};
            DefaultCrateTreeModel.this.fireTreeNodesInserted(this, path, childIndices, children);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void crateRemoved(MediaCrate parent, MediaCrate child, int index) {
            int childIndex;
            CrateTreeNode childNode;
            CrateTreeNode parentNode;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("crateRemoved: parent=" + parent + ", child=" + child + ", index=" + index);
            }
            Map map = DefaultCrateTreeModel.this.crateMap;
            synchronized (map) {
                parentNode = (CrateTreeNode)DefaultCrateTreeModel.this.crateMap.get(parent);
                if (parentNode == null) {
                    return;
                }
                childNode = (CrateTreeNode)DefaultCrateTreeModel.this.crateMap.get(child);
            }
            if (childNode == null) {
                return;
            }
            if (index >= 0 && index < parentNode.getChildCount() && parentNode.getChildAt(index) == childNode) {
                childIndex = index;
            } else {
                childIndex = parentNode.getIndex(childNode);
                if (childIndex < 0) {
                    return;
                }
            }
            parentNode.remove(childIndex);
            Object[] path = DefaultCrateTreeModel.this.getPathToRoot(parentNode);
            int[] childIndices = new int[]{childIndex};
            Object[] children = new Object[]{childNode};
            DefaultCrateTreeModel.this.fireTreeNodesRemoved(this, path, childIndices, children);
        }
    }
}

