/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.manager.CrateTreeNode;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class DefaultCrateTreeNode
implements CrateTreeNode {
    private MediaCrate crate;
    private CrateTreeNode parent;
    private Vector children;

    public DefaultCrateTreeNode(MediaCrate crate) {
        this.crate = crate;
    }

    public String toString() {
        return String.valueOf(this.crate);
    }

    @Override
    public MediaCrate getCrate() {
        return this.crate;
    }

    protected void setCrate(MediaCrate crate) {
        this.crate = crate;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CrateTreeNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        Vector v = this.children;
        if (v == null) {
            return this.crate.isLeafCrate();
        }
        return v.isEmpty();
    }

    @Override
    public int getChildCount() {
        Vector v = this.children;
        if (v == null) {
            if (this.crate.isLeafCrate()) {
                return 0;
            }
            v = this.lazyInit();
        }
        return v.size();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (CrateTreeNode)this.lazyInit().get(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        Vector v = this.lazyInit();
        return v == null ? -1 : v.indexOf(node);
    }

    public Enumeration children() {
        return this.lazyInit().elements();
    }

    @Override
    public void insert(CrateTreeNode child, int index) {
        this.lazyInit();
        child.removeFromParent();
        child.setParent(this);
        this.children.insertElementAt(child, index);
    }

    @Override
    public void remove(int index) {
        this.lazyInit();
        CrateTreeNode child = (CrateTreeNode)this.children.remove(index);
        if (child != null) {
            child.setParent(null);
        }
    }

    @Override
    public void remove(CrateTreeNode child) {
        this.lazyInit();
        if (this.children.remove(child)) {
            child.setParent(null);
        }
    }

    @Override
    public void removeFromParent() {
        CrateTreeNode p = this.parent;
        if (p != null) {
            p.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Vector v;
        DefaultCrateTreeNode defaultCrateTreeNode = this;
        synchronized (defaultCrateTreeNode) {
            v = this.children;
            this.children = null;
        }
        if (v != null) {
            this.unregisterNodes(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector lazyInit() {
        Vector<DefaultCrateTreeNode> v = this.children;
        if (v != null) {
            return v;
        }
        DefaultCrateTreeNode defaultCrateTreeNode = this;
        synchronized (defaultCrateTreeNode) {
            v = this.children;
            if (v != null) {
                return v;
            }
            int num = this.crate.getCrateCount();
            v = new Vector<DefaultCrateTreeNode>(num);
            for (int i = 0; i < num; ++i) {
                MediaCrate child = this.crate.getCrateAt(i);
                if (child == null) continue;
                DefaultCrateTreeNode node = new DefaultCrateTreeNode(child);
                node.setParent(this);
                v.add(node);
            }
            this.children = v;
        }
        this.registerNodes(v);
        return v;
    }

    @Override
    public void registerNodes(List list) {
        CrateTreeNode p = this.parent;
        if (p != null) {
            p.registerNodes(list);
        }
    }

    @Override
    public void unregisterNodes(List list) {
        CrateTreeNode p = this.parent;
        if (p != null) {
            p.unregisterNodes(list);
        }
    }
}

