/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.PlaybackHistory;
import com.spacekiller.util.media.PlaybackHistoryEntry;
import com.spacekiller.util.media.manager.DefaultPlaybackHistoryEntry;

public class DefaultPlaybackHistory
implements PlaybackHistory {
    private DefaultPlaybackHistoryEntry next;
    private DefaultPlaybackHistoryEntry head;
    private DefaultPlaybackHistoryEntry tail;

    public DefaultPlaybackHistory(int limit) {
        DefaultPlaybackHistoryEntry prev = this.next = new DefaultPlaybackHistoryEntry();
        for (int i = 1; i < limit; ++i) {
            DefaultPlaybackHistoryEntry entry = new DefaultPlaybackHistoryEntry();
            entry.prev = prev;
            prev.next = entry;
            prev = entry;
        }
        this.next.prev = prev;
        prev.next = this.next;
    }

    public synchronized PlaybackHistoryEntry getFirstEntry() {
        return this.head;
    }

    public synchronized PlaybackHistoryEntry getLastEntry() {
        return this.tail;
    }

    public synchronized PlaybackHistoryEntry getPrevEntry(PlaybackHistoryEntry entry) {
        if (entry == this.head) {
            return null;
        }
        return ((DefaultPlaybackHistoryEntry)entry).prev;
    }

    public synchronized PlaybackHistoryEntry getNextEntry(PlaybackHistoryEntry entry) {
        if (entry == this.tail) {
            return null;
        }
        return ((DefaultPlaybackHistoryEntry)entry).next;
    }

    public synchronized PlaybackHistoryEntry appendEntry(MediaCrateEntry mce, int expectedRow, long playbackStartTime, long playbackEndTime) {
        DefaultPlaybackHistoryEntry entry = this.next;
        this.next = this.next.next;
        entry.setMediaCrateEntry(mce);
        entry.setExpectedRow(expectedRow);
        entry.setPlaybackStartTime(playbackStartTime);
        entry.setPlaybackEndTime(playbackEndTime);
        if (this.head == entry) {
            this.head = entry.next;
        } else if (this.head == null) {
            this.head = entry;
        }
        this.tail = entry;
        return entry;
    }

    public synchronized void clear() {
        this.head = null;
        this.tail = null;
    }

    public synchronized void truncateAfter(PlaybackHistoryEntry entry) {
        if (this.head == null) {
            return;
        }
        this.tail = (DefaultPlaybackHistoryEntry)entry;
    }
}

