/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.media.manager.MediaTableModel;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public abstract class EntryTableCellRenderer
extends AbstractCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = -2987630954995320442L;
    private static final Paint DEFAULT_EVEN_ROW_BACKGROUND = new Color(1.0f, 1.0f, 1.0f);
    private static final Paint DEFAULT_ODD_ROW_BACKGROUND = new Color(0.95f, 0.95f, 0.95f);
    protected JLabel label;
    private Font normalFont;
    private Font activeFont;
    private Font currentFont;
    private Paint oddRowBackground = DEFAULT_ODD_ROW_BACKGROUND;
    private Paint evenRowBackground = DEFAULT_EVEN_ROW_BACKGROUND;
    protected int currentRow;
    protected int currentCol;
    protected Object currentValue;
    protected boolean currentActive;

    public EntryTableCellRenderer() {
        this.setOpaque(false);
        this.setLayout(new GridLayout(1, 1));
        this.label = new JLabel();
        this.label.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.add(this.label);
        Font labelFont = this.label.getFont();
        if (labelFont != null) {
            this.normalFont = new Font(labelFont.getName(), 0, labelFont.getSize());
            this.activeFont = new Font(labelFont.getName(), 1, labelFont.getSize());
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setSelected(isSelected);
        this.setFocus(hasFocus);
        this.currentValue = value;
        this.currentRow = row;
        this.currentCol = column;
        this.currentActive = false;
        Font font = this.normalFont;
        if (value != null && value instanceof MediaTableEntry) {
            MediaTableEntry entry = (MediaTableEntry)value;
            MediaTableModel model = (MediaTableModel)table.getModel();
            if (model.isActiveEntry(entry)) {
                this.currentActive = true;
                font = this.activeFont;
            }
        }
        if (font != this.currentFont) {
            this.label.setFont(font);
            this.currentFont = font;
        }
        this.setCellBackground((row & 1) == 0 ? this.evenRowBackground : this.oddRowBackground);
        return this;
    }

    public String getToolTipText() {
        return this.getCurrentEntryToolTipText();
    }

    public String getToolTipText(MouseEvent event) {
        return this.getCurrentEntryToolTipText();
    }

    public String getCurrentEntryToolTipText() {
        MediaTableEntry mte;
        Resource res;
        Object value;
        if ((this.currentActive || this.isSelected() || this.hasFocus()) && (value = this.currentValue) != null && value instanceof MediaTableEntry && (res = (mte = (MediaTableEntry)value).getResource()) != null) {
            return res.toString();
        }
        return null;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public void setNormalFont(Font normalFont) {
        this.normalFont = normalFont;
    }

    public Font getActiveFont() {
        return this.activeFont;
    }

    public void setActiveFont(Font activeFont) {
        this.activeFont = activeFont;
    }

    public Paint getOddRowBackground() {
        return this.oddRowBackground;
    }

    public void setOddRowBackground(Paint oddRowBackground) {
        this.oddRowBackground = oddRowBackground;
    }

    public Paint getEvenRowBackground() {
        return this.evenRowBackground;
    }

    public void setEvenRowBackground(Paint evenRowBackground) {
        this.evenRowBackground = evenRowBackground;
    }
}

