/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Tools;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.EntryTableSortModel;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableCellRenderer;

public class EntryTableHeaderRenderer
extends AbstractCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 5480362431343926755L;
    private static Icon defaultAscendingIcon;
    private static Icon defaultDescendingIcon;
    protected JLabel label = new JLabel();
    protected EntryTableSortModel entryTableSortModel;
    protected EntryTableColumnProvider entryTableColumnProvider;
    protected Icon ascendingIcon;
    protected Icon descendingIcon;

    public EntryTableHeaderRenderer(EntryTableSortModel entryTableSortModel, EntryTableColumnProvider entryTableColumnProvider) {
        this.entryTableSortModel = entryTableSortModel;
        this.entryTableColumnProvider = entryTableColumnProvider;
        this.ascendingIcon = EntryTableHeaderRenderer.getDefaultAscendingIcon();
        this.descendingIcon = EntryTableHeaderRenderer.getDefaultDescendingIcon();
        this.label.setHorizontalTextPosition(2);
        this.setOpaque(false);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.label);
        this.setBorder(new EtchedBorder(1));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String title = String.valueOf(value);
        Icon icon = null;
        if (this.entryTableSortModel != null) {
            int order = this.entryTableSortModel.getSortColumnOrder(this.entryTableColumnProvider);
            switch (order) {
                case 1: {
                    icon = this.ascendingIcon;
                    break;
                }
                case -1: {
                    icon = this.descendingIcon;
                }
            }
        }
        this.label.setText(title);
        this.label.setIcon(icon);
        return this;
    }

    public Icon getAscendingIcon() {
        return this.ascendingIcon;
    }

    public void setAscendingIcon(Icon ascendingIcon) {
        this.ascendingIcon = ascendingIcon;
    }

    public Icon getDescendingIcon() {
        return this.descendingIcon;
    }

    public void setDescendingIcon(Icon descendingIcon) {
        this.descendingIcon = descendingIcon;
    }

    private static Icon getDefaultAscendingIcon() {
        if (defaultAscendingIcon == null) {
            defaultAscendingIcon = Tools.getIcon(EntryTableHeaderRenderer.class, (String)"/com/spacekiller/util/media/manager/icons/sort_ascending.png");
        }
        return defaultAscendingIcon;
    }

    private static Icon getDefaultDescendingIcon() {
        if (defaultDescendingIcon == null) {
            defaultDescendingIcon = Tools.getIcon(EntryTableHeaderRenderer.class, (String)"/com/spacekiller/util/media/manager/icons/sort_descending.png");
        }
        return defaultDescendingIcon;
    }

    public String getToolTipText() {
        return this.entryTableColumnProvider.getTooltipText();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.label.setFont(font);
    }
}

