/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.EntryTableSortComparator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class EntryTableSortModel {
    public static final int NONE = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private EntryTableSortComparator currentComparator;
    private Map sortColumnMap = new HashMap();
    private LinkedList sortColumnList = new LinkedList();
    private boolean valid;

    public synchronized EntryTableSortComparator getEntryTableSortComparator() {
        this.validate();
        return this.currentComparator;
    }

    public boolean isValid() {
        return this.valid;
    }

    public synchronized void invalidate() {
        this.valid = false;
    }

    public synchronized void validate() {
        if (this.valid) {
            return;
        }
        LinkedList<EntryTableColumnComparator> comparatorList = new LinkedList<EntryTableColumnComparator>();
        for (SortColumn sortColumn : this.sortColumnList) {
            boolean ascending;
            EntryTableColumnComparator columnComp;
            int order;
            EntryTableColumnProvider columnProvider = sortColumn.getColumnProvider();
            if (columnProvider == null || (order = sortColumn.getOrder()) == 0 || (columnComp = columnProvider.createColumnComparator(ascending = order == 1)) == null) continue;
            comparatorList.add(columnComp);
        }
        int num = comparatorList.size();
        if (num > 0) {
            Comparator[] comparators = comparatorList.toArray(new Comparator[num]);
            this.currentComparator = new EntryTableSortComparator(comparators);
        } else {
            this.currentComparator = null;
        }
        this.valid = true;
    }

    public synchronized void reset() {
        for (SortColumn sortColumn : this.sortColumnList) {
            sortColumn.setOrder(0);
        }
        this.invalidate();
    }

    public synchronized void sortByColumn(EntryTableColumnProvider columnProvider) {
        SortColumn sortColumn = this.getSortColumn(columnProvider);
        if (sortColumn == null) {
            return;
        }
        int newOrder = 0;
        int order = sortColumn.getOrder();
        switch (order) {
            case 0: {
                newOrder = 1;
                break;
            }
            case 1: {
                newOrder = -1;
                break;
            }
            case -1: {
                newOrder = 0;
            }
        }
        if (newOrder == order) {
            return;
        }
        this.reset();
        sortColumn.setOrder(newOrder);
        this.sortColumnList.remove(sortColumn);
        this.sortColumnList.addFirst(sortColumn);
        this.invalidate();
    }

    public synchronized SortColumn getSortColumn(EntryTableColumnProvider columnProvider) {
        if (columnProvider == null) {
            return null;
        }
        SortColumn sortColumn = (SortColumn)this.sortColumnMap.get(columnProvider);
        if (sortColumn == null) {
            sortColumn = new SortColumn(columnProvider);
            this.sortColumnMap.put(columnProvider, sortColumn);
            this.sortColumnList.add(sortColumn);
        }
        return sortColumn;
    }

    public synchronized int getSortColumnOrder(EntryTableColumnProvider columnProvider) {
        SortColumn sc = (SortColumn)this.sortColumnMap.get(columnProvider);
        if (sc != null) {
            return sc.getOrder();
        }
        return 0;
    }

    protected class SortColumn {
        private final EntryTableColumnProvider columnProvider;
        private int order;

        public SortColumn(EntryTableColumnProvider columnProvider) {
            this.columnProvider = columnProvider;
        }

        public EntryTableColumnProvider getColumnProvider() {
            return this.columnProvider;
        }

        public int getOrder() {
            return this.order;
        }

        protected void setOrder(int order) {
            this.order = order;
        }
    }
}

