/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.DefaultMediaCrate;
import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.library.m3u.M3uMediaCrate;
import com.spacekiller.util.media.library.remote.RemoteMediaCrate;
import com.spacekiller.util.media.library.serato.SeratoMediaCrate;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MediaCratePropertiesPanel
extends JPanel {
    private static final long serialVersionUID = -130429999250540215L;
    private MediaCrate mediaCrate;
    private JTextField textFieldName;
    private JTextField textFieldDescr;
    private JTextField textFieldCrateTypeInfo;
    private JLabel lblCrateId;
    private JTextField textFieldCrateId;

    public MediaCratePropertiesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblName = new JLabel("Name:");
        GridBagConstraints gbc_lblName = new GridBagConstraints();
        gbc_lblName.anchor = 17;
        gbc_lblName.insets = new Insets(4, 4, 5, 5);
        gbc_lblName.gridx = 0;
        gbc_lblName.gridy = 0;
        this.add((Component)lblName, gbc_lblName);
        this.textFieldName = new JTextField();
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.weightx = 1.0;
        gbc_textFieldName.insets = new Insets(4, 4, 5, 0);
        gbc_textFieldName.fill = 2;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        this.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(10);
        JLabel lblDescription = new JLabel("Description:");
        GridBagConstraints gbc_lblDescription = new GridBagConstraints();
        gbc_lblDescription.anchor = 17;
        gbc_lblDescription.insets = new Insets(4, 4, 5, 5);
        gbc_lblDescription.gridx = 0;
        gbc_lblDescription.gridy = 1;
        this.add((Component)lblDescription, gbc_lblDescription);
        this.textFieldDescr = new JTextField();
        GridBagConstraints gbc_textFieldDescr = new GridBagConstraints();
        gbc_textFieldDescr.insets = new Insets(4, 4, 5, 0);
        gbc_textFieldDescr.fill = 2;
        gbc_textFieldDescr.gridx = 1;
        gbc_textFieldDescr.gridy = 1;
        this.add((Component)this.textFieldDescr, gbc_textFieldDescr);
        this.textFieldDescr.setColumns(10);
        JLabel lblCrateType = new JLabel("Crate Type:");
        GridBagConstraints gbc_lblCrateType = new GridBagConstraints();
        gbc_lblCrateType.anchor = 17;
        gbc_lblCrateType.insets = new Insets(4, 4, 5, 5);
        gbc_lblCrateType.gridx = 0;
        gbc_lblCrateType.gridy = 2;
        this.add((Component)lblCrateType, gbc_lblCrateType);
        this.textFieldCrateTypeInfo = new JTextField();
        this.textFieldCrateTypeInfo.setOpaque(false);
        this.textFieldCrateTypeInfo.setEditable(false);
        GridBagConstraints gbc_textFieldCrateTypeInfo = new GridBagConstraints();
        gbc_textFieldCrateTypeInfo.insets = new Insets(4, 4, 5, 0);
        gbc_textFieldCrateTypeInfo.anchor = 17;
        gbc_textFieldCrateTypeInfo.fill = 2;
        gbc_textFieldCrateTypeInfo.gridx = 1;
        gbc_textFieldCrateTypeInfo.gridy = 2;
        this.add((Component)this.textFieldCrateTypeInfo, gbc_textFieldCrateTypeInfo);
        this.textFieldCrateTypeInfo.setColumns(10);
        this.lblCrateId = new JLabel("Crate ID:");
        GridBagConstraints gbc_lblCrateId = new GridBagConstraints();
        gbc_lblCrateId.anchor = 17;
        gbc_lblCrateId.insets = new Insets(4, 4, 5, 5);
        gbc_lblCrateId.gridx = 0;
        gbc_lblCrateId.gridy = 3;
        this.add((Component)this.lblCrateId, gbc_lblCrateId);
        this.textFieldCrateId = new JTextField();
        this.textFieldCrateId.setEditable(false);
        GridBagConstraints gbc_textFieldCrateId = new GridBagConstraints();
        gbc_textFieldCrateId.insets = new Insets(4, 4, 5, 0);
        gbc_textFieldCrateId.fill = 2;
        gbc_textFieldCrateId.gridx = 1;
        gbc_textFieldCrateId.gridy = 3;
        this.add((Component)this.textFieldCrateId, gbc_textFieldCrateId);
        this.textFieldCrateId.setColumns(10);
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    protected JTextField getTextFieldDescr() {
        return this.textFieldDescr;
    }

    public MediaCrate getMediaCrate() {
        return this.mediaCrate;
    }

    public void setMediaCrate(MediaCrate mediaCrate) {
        this.mediaCrate = mediaCrate;
        this.refresh();
    }

    public void refresh() {
        String id = null;
        String name = null;
        String descr = null;
        String typeInfo = null;
        MediaCrate crate = this.mediaCrate;
        if (crate != null) {
            id = crate.getId();
            name = crate.getName();
            descr = crate.getDescription();
            typeInfo = this.getCrateTypeInfo(crate);
        }
        if (name == null) {
            name = "";
        }
        this.textFieldName.setText(name);
        this.textFieldName.setCaretPosition(0);
        if (descr == null) {
            descr = "";
        }
        this.textFieldDescr.setText(descr);
        this.textFieldDescr.setCaretPosition(0);
        if (typeInfo == null) {
            typeInfo = "";
        }
        this.textFieldCrateTypeInfo.setText(typeInfo);
        this.textFieldCrateTypeInfo.setCaretPosition(0);
        if (id == null) {
            id = "";
        }
        this.textFieldCrateId.setText(id);
        this.textFieldCrateId.setCaretPosition(0);
    }

    protected String getCrateTypeInfo(MediaCrate crate) {
        Class<?> clazz = crate.getClass();
        if (clazz == DefaultMediaCrate.class) {
            return "Default Crate";
        }
        if (crate instanceof DirectoryMediaCrate) {
            DirectoryMediaCrate dmc = (DirectoryMediaCrate)crate;
            return "Directory: " + dmc.getPath();
        }
        if (crate instanceof CrateFileMediaCrate) {
            CrateFileMediaCrate cfmc = (CrateFileMediaCrate)crate;
            return "Crates File: " + cfmc.getPath();
        }
        if (crate instanceof SeratoMediaCrate) {
            SeratoMediaCrate smc = (SeratoMediaCrate)crate;
            return "Serato Crate: " + smc.getPath();
        }
        if (crate instanceof M3uMediaCrate) {
            M3uMediaCrate m3mc = (M3uMediaCrate)crate;
            return "M3U Crate: " + m3mc.getPath();
        }
        if (crate instanceof RemoteMediaCrate) {
            RemoteMediaCrate rmc = (RemoteMediaCrate)crate;
            return "Remote Crate: " + rmc.getCrateId();
        }
        return "Unknown Crate: " + clazz.getName();
    }

    public String getNewName() {
        return this.textFieldName.getText();
    }

    public String getNewDescription() {
        return this.textFieldDescr.getText();
    }

    protected JTextField getTextFieldCrateTypeInfo() {
        return this.textFieldCrateTypeInfo;
    }

    protected JTextField getTextFieldCrateId() {
        return this.textFieldCrateId;
    }
}

