/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.manager.AbstractEntryPropertiesPanel;
import com.spacekiller.util.media.manager.MediaMarkerEditorPanel;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import com.spacekiller.util.media.manager.column.EntryBitRateTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryFileSizeTableColumnProvider;
import com.spacekiller.util.swing.BorderUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MediaEntryOverviewPanel
extends AbstractEntryPropertiesPanel {
    private static final long serialVersionUID = -638484328729387102L;
    private static final Logger logger = Logger.getLogger(MediaEntryOverviewPanel.class.getName());
    private boolean refreshing;
    private Color commentColor = Color.BLACK;
    private Color commentEditColor = Color.BLUE;
    private JTextField textFieldTitle;
    private JTextField textFieldArtist;
    private JTextField textFieldAlbum;
    private JTextField textFieldGenre;
    private JTextField textFieldDuration;
    private JTextArea textAreaUserComment;
    private JSlider sliderUserRating;
    private JButton btnDislike;
    private JButton btnLike;
    private JTextField textFieldContentInfo;
    private JButton btnApplyComment;
    private JButton btnResetComment;
    private JTextField textFieldYear;

    public MediaEntryOverviewPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelMediaEntry = new JPanel();
        GridBagConstraints gbc_panelMediaEntry = new GridBagConstraints();
        gbc_panelMediaEntry.insets = new Insets(4, 4, 4, 4);
        gbc_panelMediaEntry.fill = 1;
        gbc_panelMediaEntry.weighty = 1.0;
        gbc_panelMediaEntry.weightx = 1.0;
        gbc_panelMediaEntry.gridx = 0;
        gbc_panelMediaEntry.gridy = 0;
        this.add((Component)panelMediaEntry, gbc_panelMediaEntry);
        GridBagLayout gbl_panelMediaEntry = new GridBagLayout();
        gbl_panelMediaEntry.columnWidths = new int[]{0, 0, 0};
        gbl_panelMediaEntry.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panelMediaEntry.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMediaEntry.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelMediaEntry.setLayout(gbl_panelMediaEntry);
        JLabel lblTitle = new JLabel("Title:");
        lblTitle.setToolTipText("Track Title");
        GridBagConstraints gbc_lblTitle = new GridBagConstraints();
        gbc_lblTitle.anchor = 17;
        gbc_lblTitle.insets = new Insets(0, 0, 5, 5);
        gbc_lblTitle.gridx = 0;
        gbc_lblTitle.gridy = 0;
        panelMediaEntry.add((Component)lblTitle, gbc_lblTitle);
        this.textFieldTitle = new JTextField();
        this.textFieldTitle.setOpaque(false);
        this.textFieldTitle.setToolTipText("Track Title");
        this.textFieldTitle.setEditable(false);
        GridBagConstraints gbc_textFieldTitle = new GridBagConstraints();
        gbc_textFieldTitle.weightx = 1.0;
        gbc_textFieldTitle.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldTitle.fill = 2;
        gbc_textFieldTitle.gridx = 1;
        gbc_textFieldTitle.gridy = 0;
        panelMediaEntry.add((Component)this.textFieldTitle, gbc_textFieldTitle);
        this.textFieldTitle.setColumns(10);
        JLabel lblArtist = new JLabel("Artist:");
        lblArtist.setToolTipText("Artist name");
        GridBagConstraints gbc_lblArtist = new GridBagConstraints();
        gbc_lblArtist.anchor = 17;
        gbc_lblArtist.insets = new Insets(0, 0, 5, 5);
        gbc_lblArtist.gridx = 0;
        gbc_lblArtist.gridy = 1;
        panelMediaEntry.add((Component)lblArtist, gbc_lblArtist);
        this.textFieldArtist = new JTextField();
        this.textFieldArtist.setOpaque(false);
        this.textFieldArtist.setToolTipText("Artist name");
        this.textFieldArtist.setEditable(false);
        GridBagConstraints gbc_textFieldArtist = new GridBagConstraints();
        gbc_textFieldArtist.weightx = 1.0;
        gbc_textFieldArtist.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldArtist.fill = 2;
        gbc_textFieldArtist.gridx = 1;
        gbc_textFieldArtist.gridy = 1;
        panelMediaEntry.add((Component)this.textFieldArtist, gbc_textFieldArtist);
        this.textFieldArtist.setColumns(10);
        JLabel lblAlbum = new JLabel("Album:");
        lblAlbum.setToolTipText("Album name");
        GridBagConstraints gbc_lblAlbum = new GridBagConstraints();
        gbc_lblAlbum.anchor = 17;
        gbc_lblAlbum.insets = new Insets(0, 0, 5, 5);
        gbc_lblAlbum.gridx = 0;
        gbc_lblAlbum.gridy = 2;
        panelMediaEntry.add((Component)lblAlbum, gbc_lblAlbum);
        this.textFieldAlbum = new JTextField();
        this.textFieldAlbum.setOpaque(false);
        this.textFieldAlbum.setToolTipText("Album name");
        this.textFieldAlbum.setEditable(false);
        GridBagConstraints gbc_textFieldAlbum = new GridBagConstraints();
        gbc_textFieldAlbum.weightx = 1.0;
        gbc_textFieldAlbum.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldAlbum.fill = 2;
        gbc_textFieldAlbum.gridx = 1;
        gbc_textFieldAlbum.gridy = 2;
        panelMediaEntry.add((Component)this.textFieldAlbum, gbc_textFieldAlbum);
        this.textFieldAlbum.setColumns(10);
        JLabel lblGenre = new JLabel("Genre:");
        lblGenre.setToolTipText("Genre");
        GridBagConstraints gbc_lblGenre = new GridBagConstraints();
        gbc_lblGenre.anchor = 17;
        gbc_lblGenre.insets = new Insets(0, 0, 5, 5);
        gbc_lblGenre.gridx = 0;
        gbc_lblGenre.gridy = 3;
        panelMediaEntry.add((Component)lblGenre, gbc_lblGenre);
        JPanel panel_3 = new JPanel();
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.insets = new Insets(0, 0, 5, 0);
        gbc_panel_3.fill = 1;
        gbc_panel_3.gridx = 1;
        gbc_panel_3.gridy = 3;
        panelMediaEntry.add((Component)panel_3, gbc_panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel_3.rowHeights = new int[]{0, 0};
        gbl_panel_3.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_3.setLayout(gbl_panel_3);
        this.textFieldGenre = new JTextField();
        GridBagConstraints gbc_textFieldGenre = new GridBagConstraints();
        gbc_textFieldGenre.fill = 2;
        gbc_textFieldGenre.weightx = 1.0;
        gbc_textFieldGenre.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldGenre.gridx = 0;
        gbc_textFieldGenre.gridy = 0;
        panel_3.add((Component)this.textFieldGenre, gbc_textFieldGenre);
        this.textFieldGenre.setOpaque(false);
        this.textFieldGenre.setToolTipText("Genre");
        this.textFieldGenre.setEditable(false);
        this.textFieldGenre.setColumns(10);
        JLabel lblYear = new JLabel("Year:");
        GridBagConstraints gbc_lblYear = new GridBagConstraints();
        gbc_lblYear.anchor = 13;
        gbc_lblYear.insets = new Insets(0, 0, 0, 5);
        gbc_lblYear.gridx = 1;
        gbc_lblYear.gridy = 0;
        panel_3.add((Component)lblYear, gbc_lblYear);
        this.textFieldYear = new JTextField();
        this.textFieldYear.setToolTipText("Year / Date");
        this.textFieldYear.setHorizontalAlignment(4);
        this.textFieldYear.setEditable(false);
        GridBagConstraints gbc_textFieldYear = new GridBagConstraints();
        gbc_textFieldYear.fill = 2;
        gbc_textFieldYear.gridx = 2;
        gbc_textFieldYear.gridy = 0;
        panel_3.add((Component)this.textFieldYear, gbc_textFieldYear);
        this.textFieldYear.setColumns(6);
        JLabel lblContent = new JLabel("Content:");
        lblContent.setToolTipText("Content Info");
        GridBagConstraints gbc_lblContent = new GridBagConstraints();
        gbc_lblContent.anchor = 17;
        gbc_lblContent.insets = new Insets(0, 0, 5, 5);
        gbc_lblContent.gridx = 0;
        gbc_lblContent.gridy = 4;
        panelMediaEntry.add((Component)lblContent, gbc_lblContent);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 1;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 4;
        panelMediaEntry.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.textFieldContentInfo = new JTextField();
        GridBagConstraints gbc_textFieldContentInfo = new GridBagConstraints();
        gbc_textFieldContentInfo.weightx = 1.0;
        gbc_textFieldContentInfo.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldContentInfo.fill = 2;
        gbc_textFieldContentInfo.gridx = 0;
        gbc_textFieldContentInfo.gridy = 0;
        panel.add((Component)this.textFieldContentInfo, gbc_textFieldContentInfo);
        this.textFieldContentInfo.setOpaque(false);
        this.textFieldContentInfo.setToolTipText("Content Info");
        this.textFieldContentInfo.setEditable(false);
        this.textFieldContentInfo.setColumns(10);
        JLabel lblDuration = new JLabel("Duration:");
        GridBagConstraints gbc_lblDuration = new GridBagConstraints();
        gbc_lblDuration.insets = new Insets(0, 0, 0, 5);
        gbc_lblDuration.gridx = 1;
        gbc_lblDuration.gridy = 0;
        panel.add((Component)lblDuration, gbc_lblDuration);
        lblDuration.setToolTipText("Media duration (min:sec)");
        this.textFieldDuration = new JTextField();
        GridBagConstraints gbc_textFieldDuration = new GridBagConstraints();
        gbc_textFieldDuration.gridx = 2;
        gbc_textFieldDuration.gridy = 0;
        panel.add((Component)this.textFieldDuration, gbc_textFieldDuration);
        this.textFieldDuration.setHorizontalAlignment(4);
        this.textFieldDuration.setOpaque(false);
        this.textFieldDuration.setToolTipText("Media duration (min:sec)");
        this.textFieldDuration.setEditable(false);
        this.textFieldDuration.setColumns(6);
        JLabel lblRating = new JLabel("Rating:");
        lblRating.setToolTipText("User rating");
        GridBagConstraints gbc_lblRating = new GridBagConstraints();
        gbc_lblRating.anchor = 17;
        gbc_lblRating.insets = new Insets(0, 0, 5, 5);
        gbc_lblRating.gridx = 0;
        gbc_lblRating.gridy = 5;
        panelMediaEntry.add((Component)lblRating, gbc_lblRating);
        JPanel panelUserRating = new JPanel();
        panelUserRating.setOpaque(false);
        GridBagConstraints gbc_panelUserRating = new GridBagConstraints();
        gbc_panelUserRating.fill = 1;
        gbc_panelUserRating.insets = new Insets(0, 0, 5, 0);
        gbc_panelUserRating.gridx = 1;
        gbc_panelUserRating.gridy = 5;
        panelMediaEntry.add((Component)panelUserRating, gbc_panelUserRating);
        GridBagLayout gbl_panelUserRating = new GridBagLayout();
        gbl_panelUserRating.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelUserRating.rowHeights = new int[]{0, 0};
        gbl_panelUserRating.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelUserRating.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelUserRating.setLayout(gbl_panelUserRating);
        this.btnDislike = new JButton("");
        this.btnDislike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaEntryOverviewPanel.this.actionDislike();
            }
        });
        this.btnDislike.setMargin(new Insets(2, 2, 2, 2));
        this.btnDislike.setIcon(new ImageIcon(MediaEntryOverviewPanel.class.getResource("/com/spacekiller/util/media/manager/icons/rating_decrease_icon16.png")));
        this.btnDislike.setToolTipText("Dislike");
        GridBagConstraints gbc_btnDislike = new GridBagConstraints();
        gbc_btnDislike.insets = new Insets(0, 0, 0, 5);
        gbc_btnDislike.gridx = 0;
        gbc_btnDislike.gridy = 0;
        panelUserRating.add((Component)this.btnDislike, gbc_btnDislike);
        this.sliderUserRating = new JSlider();
        this.sliderUserRating.setValue(0);
        this.sliderUserRating.setMinimum(-100);
        this.sliderUserRating.setPaintLabels(true);
        this.sliderUserRating.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!MediaEntryOverviewPanel.this.refreshing) {
                    MediaEntryOverviewPanel.this.actionSliderMoved();
                }
            }
        });
        this.sliderUserRating.setMajorTickSpacing(50);
        this.sliderUserRating.setMinorTickSpacing(10);
        this.sliderUserRating.setPaintTicks(true);
        this.sliderUserRating.setOpaque(false);
        GridBagConstraints gbc_sliderUserRating = new GridBagConstraints();
        gbc_sliderUserRating.insets = new Insets(0, 0, 0, 5);
        gbc_sliderUserRating.weightx = 1.0;
        gbc_sliderUserRating.fill = 2;
        gbc_sliderUserRating.gridx = 1;
        gbc_sliderUserRating.gridy = 0;
        panelUserRating.add((Component)this.sliderUserRating, gbc_sliderUserRating);
        this.btnLike = new JButton("");
        this.btnLike.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaEntryOverviewPanel.this.actionLike();
            }
        });
        this.btnLike.setMargin(new Insets(2, 2, 2, 2));
        this.btnLike.setIcon(new ImageIcon(MediaEntryOverviewPanel.class.getResource("/com/spacekiller/util/media/manager/icons/rating_increase_icon16.png")));
        this.btnLike.setToolTipText("Like");
        GridBagConstraints gbc_btnLike = new GridBagConstraints();
        gbc_btnLike.gridx = 2;
        gbc_btnLike.gridy = 0;
        panelUserRating.add((Component)this.btnLike, gbc_btnLike);
        JLabel lblComment = new JLabel("Comment:");
        GridBagConstraints gbc_lblComment = new GridBagConstraints();
        gbc_lblComment.anchor = 18;
        gbc_lblComment.insets = new Insets(4, 0, 0, 5);
        gbc_lblComment.gridx = 0;
        gbc_lblComment.gridy = 6;
        panelMediaEntry.add((Component)lblComment, gbc_lblComment);
        lblComment.setToolTipText("User comment");
        JPanel panelComment = new JPanel();
        GridBagConstraints gbc_panelComment = new GridBagConstraints();
        gbc_panelComment.weighty = 1.0;
        gbc_panelComment.fill = 1;
        gbc_panelComment.gridx = 1;
        gbc_panelComment.gridy = 6;
        panelMediaEntry.add((Component)panelComment, gbc_panelComment);
        GridBagLayout gbl_panelComment = new GridBagLayout();
        gbl_panelComment.columnWidths = new int[]{0, 0, 0};
        gbl_panelComment.rowHeights = new int[]{0, 0};
        gbl_panelComment.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelComment.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelComment.setLayout(gbl_panelComment);
        JScrollPane scrollPane_1 = new JScrollPane();
        GridBagConstraints gbc_scrollPane_1 = new GridBagConstraints();
        gbc_scrollPane_1.insets = new Insets(0, 0, 0, 5);
        gbc_scrollPane_1.weighty = 1.0;
        gbc_scrollPane_1.weightx = 1.0;
        gbc_scrollPane_1.fill = 1;
        gbc_scrollPane_1.gridx = 0;
        gbc_scrollPane_1.gridy = 0;
        panelComment.add((Component)scrollPane_1, gbc_scrollPane_1);
        this.textAreaUserComment = new JTextArea();
        this.textAreaUserComment.setOpaque(false);
        scrollPane_1.setViewportView(this.textAreaUserComment);
        this.textAreaUserComment.setToolTipText("User comment");
        this.textAreaUserComment.setColumns(10);
        JPanel panel_6 = new JPanel();
        GridBagConstraints gbc_panel_6 = new GridBagConstraints();
        gbc_panel_6.fill = 1;
        gbc_panel_6.gridx = 1;
        gbc_panel_6.gridy = 0;
        panelComment.add((Component)panel_6, gbc_panel_6);
        GridBagLayout gbl_panel_6 = new GridBagLayout();
        gbl_panel_6.columnWidths = new int[]{0, 0};
        gbl_panel_6.rowHeights = new int[]{0, 0, 0};
        gbl_panel_6.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_6.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel_6.setLayout(gbl_panel_6);
        this.btnApplyComment = new JButton("");
        this.btnApplyComment.setToolTipText("Apply comment");
        this.btnApplyComment.setIcon(new ImageIcon(MediaEntryOverviewPanel.class.getResource("/com/spacekiller/util/media/manager/icons/apply_icon12.png")));
        this.btnApplyComment.setOpaque(false);
        this.btnApplyComment.setMargin(new Insets(0, 0, 0, 0));
        this.btnApplyComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaEntryOverviewPanel.this.actionApplyComment();
            }
        });
        GridBagConstraints gbc_btnApplyComment = new GridBagConstraints();
        gbc_btnApplyComment.gridx = 0;
        gbc_btnApplyComment.gridy = 0;
        panel_6.add((Component)this.btnApplyComment, gbc_btnApplyComment);
        this.btnResetComment = new JButton("");
        this.btnResetComment.setIcon(new ImageIcon(MediaEntryOverviewPanel.class.getResource("/com/spacekiller/util/media/manager/icons/cancel_icon12.png")));
        this.btnResetComment.setToolTipText("Reset comment");
        this.btnResetComment.setOpaque(false);
        this.btnResetComment.setMargin(new Insets(0, 0, 0, 0));
        this.btnResetComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaEntryOverviewPanel.this.actionResetComment();
            }
        });
        GridBagConstraints gbc_btnResetComment = new GridBagConstraints();
        gbc_btnResetComment.gridx = 0;
        gbc_btnResetComment.gridy = 1;
        panel_6.add((Component)this.btnResetComment, gbc_btnResetComment);
        this.initMediaEntryOverviewPanel();
    }

    protected void initMediaEntryOverviewPanel() {
        this.setTitle("Media");
        this.setTooltip("Media Properties");
        this.textAreaUserComment.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                MediaEntryOverviewPanel.this.handleUserCommentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MediaEntryOverviewPanel.this.handleUserCommentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MediaEntryOverviewPanel.this.handleUserCommentChanged();
            }
        });
        BorderUtil.setCompoundJButtonBorder((JButton)this.btnApplyComment);
        BorderUtil.setCompoundJButtonBorder((JButton)this.btnResetComment);
        this.refresh();
    }

    protected void handleUserCommentChanged() {
        if (this.refreshing) {
            return;
        }
        this.textAreaUserComment.setForeground(this.commentEditColor);
        this.btnApplyComment.setEnabled(true);
        this.btnResetComment.setEnabled(true);
    }

    protected Icon getMarkerIcon(MediaMarker marker) {
        if (marker == null) {
            return null;
        }
        int markerType = marker.getType();
        return MediaMarkerEditorPanel.getMarkerIcon(markerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refresh() {
        try {
            this.refreshing = true;
            MediaEntry mediaEntry = this.getMediaEntry();
            String contentInfo = null;
            String title = null;
            String artist = null;
            String album = null;
            String genre = null;
            String year = null;
            double duration = -1.0;
            String audioBitRateInfo = null;
            if (mediaEntry != null) {
                double bitRate;
                AudioEntry audioEntry;
                title = mediaEntry.getTitle();
                artist = mediaEntry.getArtist();
                album = mediaEntry.getAlbum();
                genre = mediaEntry.getGenre();
                year = mediaEntry.getYear();
                duration = mediaEntry.getDuration();
                String format = mediaEntry.getFormat();
                contentInfo = format == null ? "" : format;
                long fileSize = mediaEntry.getFileSize();
                if (fileSize >= 0L) {
                    contentInfo = contentInfo + " (" + EntryFileSizeTableColumnProvider.getFileSizeString(fileSize) + ")";
                }
                AudioEntry audioEntry2 = audioEntry = mediaEntry == null ? null : mediaEntry.getAudioEntry();
                if (audioEntry != null && (bitRate = EntryBitRateTableColumnProvider.getBitRate(mediaEntry)) >= 0.0) {
                    double rate = Math.floor(bitRate / 1000.0);
                    audioBitRateInfo = Long.toString(Math.round(rate)) + " Kb/s";
                }
                if (audioBitRateInfo != null) {
                    contentInfo = contentInfo + " @" + audioBitRateInfo;
                }
                if (!mediaEntry.isExisting()) {
                    contentInfo = contentInfo + " (missing!)";
                }
            }
            this.textFieldContentInfo.setText(contentInfo == null ? "" : contentInfo);
            this.textFieldContentInfo.setCaretPosition(0);
            this.textFieldTitle.setText(title == null ? "" : title);
            this.textFieldTitle.setCaretPosition(0);
            this.textFieldArtist.setText(artist == null ? "" : artist);
            this.textFieldArtist.setCaretPosition(0);
            this.textFieldAlbum.setText(album == null ? "" : album);
            this.textFieldAlbum.setCaretPosition(0);
            this.textFieldGenre.setText(genre == null ? "" : genre);
            this.textFieldGenre.setCaretPosition(0);
            this.textFieldYear.setText(year == null ? "" : year);
            this.textFieldYear.setCaretPosition(0);
            String durationInfo = null;
            if (duration >= 0.0) {
                long secs = Math.round(Math.ceil(duration));
                long mins = secs / 60L;
                durationInfo = mins > 0L ? Long.toString(mins) + ":" + Long.toString(100L + (secs %= 60L)).substring(1) : "0:" + Long.toString(100L + secs).substring(1);
            }
            this.textFieldDuration.setText(durationInfo == null ? "" : durationInfo);
            this.textFieldDuration.setCaretPosition(0);
            this.btnLike.setEnabled(mediaEntry != null);
            this.btnDislike.setEnabled(mediaEntry != null);
            String userComment = null;
            boolean userCommentEditable = false;
            if (mediaEntry != null) {
                userComment = mediaEntry.getUserComment();
                userCommentEditable = mediaEntry instanceof MutableMediaEntry;
            }
            this.textAreaUserComment.setForeground(this.commentColor);
            this.textAreaUserComment.setEditable(userCommentEditable);
            this.textAreaUserComment.setText(userComment == null ? null : userComment);
            this.textAreaUserComment.setCaretPosition(0);
            this.btnApplyComment.setEnabled(false);
            this.btnResetComment.setEnabled(false);
        }
        finally {
            this.refreshing = false;
        }
        this.refreshUserRatingSlider();
    }

    protected void actionLike() {
        MediaEntry entry = this.getMediaEntry();
        if (entry == null) {
            return;
        }
        if (entry instanceof MutableMediaEntry) {
            MutableMediaEntry mme = (MutableMediaEntry)entry;
            double rating = mme.getUserRating();
            if (Double.isNaN(rating)) {
                rating = 0.0;
            }
            double newRating = rating + 0.1;
            this.applyUserRating(mme, newRating);
            this.refreshUserRatingSlider();
            this.sliderUserRating.setEnabled(true);
        }
    }

    protected void actionDislike() {
        MediaEntry entry = this.getMediaEntry();
        if (entry == null) {
            return;
        }
        if (entry instanceof MutableMediaEntry) {
            MutableMediaEntry mme = (MutableMediaEntry)entry;
            double rating = mme.getUserRating();
            if (Double.isNaN(rating)) {
                rating = 0.0;
            }
            double newRating = rating + -0.1;
            this.applyUserRating(mme, newRating);
            this.refreshUserRatingSlider();
            this.sliderUserRating.setEnabled(true);
        }
    }

    protected void actionSliderMoved() {
        MediaEntry entry = this.getMediaEntry();
        if (entry == null) {
            return;
        }
        if (entry instanceof MutableMediaEntry) {
            MutableMediaEntry mme = (MutableMediaEntry)entry;
            int value = this.sliderUserRating.getValue();
            int min = this.sliderUserRating.getMinimum();
            int max = this.sliderUserRating.getMaximum();
            double newRating = -1.0 + 2.0 * (double)(value - min) / (double)(max - min);
            this.applyUserRating(mme, newRating);
        }
    }

    protected boolean applyUserRating(MutableMediaEntry entry, double newRating) {
        MediaTableToolContext mttc;
        boolean done = false;
        MediaPlayerContext mpc = this.getMediaPlayerContext();
        if (mpc != null && mpc.updateUserRating(entry, newRating)) {
            done = true;
        }
        if ((mttc = this.getMediaTableToolContext()) != null && mttc.setUserRating(entry, newRating)) {
            done = true;
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshUserRatingSlider() {
        try {
            this.refreshing = true;
            double userRating = Double.NaN;
            MediaEntry mediaEntry = this.getMediaEntry();
            if (mediaEntry != null) {
                userRating = mediaEntry.getUserRating();
            }
            if (Double.isNaN(userRating)) {
                userRating = 0.0;
                this.sliderUserRating.setEnabled(false);
            } else {
                this.sliderUserRating.setEnabled(true);
            }
            int min = this.sliderUserRating.getMinimum();
            int max = this.sliderUserRating.getMaximum();
            double ratingFactor = (userRating - -1.0) / 2.0;
            int value = (int)Math.round((double)min + (double)(max - min) * ratingFactor);
            this.sliderUserRating.setValue(value);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void actionApplyComment() {
        try {
            MediaEntry me = this.getMediaEntry();
            MutableMediaEntry mme = null;
            if (me != null && me instanceof MutableMediaEntry) {
                mme = (MutableMediaEntry)me;
            }
            if (mme == null) {
                return;
            }
            String comment = this.textAreaUserComment.getText();
            mme.setUserComment(comment);
            this.applyUserComment(mme, comment);
            this.textAreaUserComment.setForeground(this.commentColor);
            this.btnApplyComment.setEnabled(false);
            this.btnResetComment.setEnabled(false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionResetComment() {
        this.refresh();
    }

    protected boolean applyUserComment(MutableMediaEntry entry, String newComment) {
        MediaTableToolContext mttc;
        boolean done = false;
        MediaPlayerContext mpc = this.getMediaPlayerContext();
        if (mpc != null && mpc.updateUserComment(entry, newComment)) {
            done = true;
        }
        if ((mttc = this.getMediaTableToolContext()) != null && mttc.setUserComment(entry, newComment)) {
            done = true;
        }
        return done;
    }

    protected JTextField getTextFieldTitle() {
        return this.textFieldTitle;
    }

    protected JTextField getTextFieldArtist() {
        return this.textFieldArtist;
    }

    protected JTextField getTextFieldAlbum() {
        return this.textFieldAlbum;
    }

    protected JTextField getTextFieldGenre() {
        return this.textFieldGenre;
    }

    protected JTextField getTextFieldDuration() {
        return this.textFieldDuration;
    }

    protected JSlider getSliderUserRating() {
        return this.sliderUserRating;
    }

    protected JButton getBtnDislike() {
        return this.btnDislike;
    }

    protected JButton getBtnLike() {
        return this.btnLike;
    }

    protected JTextField getTextFieldContentInfo() {
        return this.textFieldContentInfo;
    }

    protected JTextArea getTextAreaUserComment() {
        return this.textAreaUserComment;
    }

    public AbstractButton getIncreaseRatingButton() {
        return this.getBtnLike();
    }

    public AbstractButton getDecreaseRatingButton() {
        return this.getBtnDislike();
    }

    protected JButton getBtnApplyComment() {
        return this.btnApplyComment;
    }

    protected JButton getBtnResetComment() {
        return this.btnResetComment;
    }

    protected JTextField getTextFieldYear() {
        return this.textFieldYear;
    }
}

