/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.manager.AbstractEntryPropertiesPanel;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MediaEntryTabbedPanel
extends AbstractEntryPropertiesPanel {
    private static final long serialVersionUID = 5918191438067197064L;
    private AbstractEntryPropertiesPanel[] tabPanels;
    private JTextField textFieldResource;
    private JTabbedPane tabbedPane;

    public MediaEntryTabbedPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MediaEntryTabbedPanel.this.handleTabbedPaneChanged();
            }
        });
        GridBagConstraints gbc_tabbedPane = new GridBagConstraints();
        gbc_tabbedPane.weighty = 1.0;
        gbc_tabbedPane.weightx = 1.0;
        gbc_tabbedPane.fill = 1;
        gbc_tabbedPane.gridx = 0;
        gbc_tabbedPane.gridy = 1;
        this.add((Component)this.tabbedPane, gbc_tabbedPane);
        JPanel panelHeader = new JPanel();
        GridBagConstraints gbc_panelHeader = new GridBagConstraints();
        gbc_panelHeader.fill = 1;
        gbc_panelHeader.gridx = 0;
        gbc_panelHeader.gridy = 0;
        this.add((Component)panelHeader, gbc_panelHeader);
        GridBagLayout gbl_panelHeader = new GridBagLayout();
        gbl_panelHeader.columnWidths = new int[]{0, 0};
        gbl_panelHeader.rowHeights = new int[]{0, 0};
        gbl_panelHeader.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelHeader.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelHeader.setLayout(gbl_panelHeader);
        this.textFieldResource = new JTextField();
        GridBagConstraints gbc_textFieldResource = new GridBagConstraints();
        gbc_textFieldResource.fill = 2;
        gbc_textFieldResource.weightx = 1.0;
        gbc_textFieldResource.gridx = 0;
        gbc_textFieldResource.gridy = 0;
        panelHeader.add((Component)this.textFieldResource, gbc_textFieldResource);
        this.textFieldResource.setOpaque(false);
        this.textFieldResource.setToolTipText("Resource");
        this.textFieldResource.setEditable(false);
        this.textFieldResource.setColumns(10);
        this.initMediaEntryPropertiesPanel();
    }

    protected void initMediaEntryPropertiesPanel() {
        this.setTitle("Media");
        this.setTooltip("Media Properties");
        this.tabPanels = new AbstractEntryPropertiesPanel[0];
    }

    public AbstractEntryPropertiesPanel[] getMediaEntryPropertiesPanels() {
        int num = this.tabPanels.length;
        AbstractEntryPropertiesPanel[] copy = new AbstractEntryPropertiesPanel[num];
        System.arraycopy(this.tabPanels, 0, copy, 0, num);
        return copy;
    }

    public synchronized void setMediaEntryPropertiesPanels(AbstractEntryPropertiesPanel[] panels) {
        int old = this.tabbedPane.getTabCount();
        for (int i = old - 1; i >= 0; --i) {
            this.tabbedPane.removeTabAt(i);
        }
        int num = panels == null ? 0 : panels.length;
        this.tabPanels = new AbstractEntryPropertiesPanel[num];
        for (int i = 0; i < num; ++i) {
            AbstractEntryPropertiesPanel panel;
            this.tabPanels[i] = panel = panels[i];
            String title = panel.getTitle();
            Icon icon = panel.getIcon();
            String tip = panel.getTooltip();
            if (title == null) {
                title = "";
            }
            this.tabbedPane.addTab(title, icon, panel, tip);
        }
        this.refresh();
    }

    @Override
    public synchronized void refresh() {
        MediaEntry mediaEntry = this.getMediaEntry();
        Resource resource = mediaEntry == null ? null : mediaEntry.getResource();
        this.textFieldResource.setText(resource == null ? "" : resource.toString());
        this.handleTabbedPaneChanged();
    }

    public JTextField getTextFieldResource() {
        return this.textFieldResource;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    protected void handleTabbedPaneChanged() {
        int index = this.tabbedPane.getSelectedIndex();
        AbstractEntryPropertiesPanel panel = null;
        if (index >= 0 && index < this.tabPanels.length) {
            panel = this.tabPanels[index];
        }
        if (panel != null) {
            this.refreshTabbedPane(panel);
        }
    }

    protected void refreshTabbedPane(AbstractEntryPropertiesPanel panel) {
        panel.setMediaEntry(this.getMediaEntry());
        panel.refresh();
    }

    @Override
    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        super.setMediaPlayer(mediaPlayer);
        for (AbstractEntryPropertiesPanel panel : this.tabPanels) {
            panel.setMediaPlayer(mediaPlayer);
        }
    }

    @Override
    public void setMediaPlayerContext(MediaPlayerContext mediaPlayerContext) {
        super.setMediaPlayerContext(mediaPlayerContext);
        for (AbstractEntryPropertiesPanel panel : this.tabPanels) {
            panel.setMediaPlayerContext(mediaPlayerContext);
        }
    }

    @Override
    public void setMediaTableToolContext(MediaTableToolContext mediaTableToolContext) {
        super.setMediaTableToolContext(mediaTableToolContext);
        for (AbstractEntryPropertiesPanel panel : this.tabPanels) {
            panel.setMediaTableToolContext(mediaTableToolContext);
        }
    }
}

