/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.media.DirectoryMediaIndex;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.library.DefaultMediaContext;
import com.spacekiller.util.media.library.LibraryFile;
import com.spacekiller.util.media.library.LibraryFileUtil;
import com.spacekiller.util.media.library.dir.DefaultDirectoryMediaIndex;
import com.spacekiller.util.sound.SoundSystem;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class MediaLibraryConverter {
    public static void main(String[] args) {
        try {
            String srcLibraryPath = "C:/Users/bene/waxmonster/instance/config/media.registry";
            String dstLibraryPath = "D:/test/crates/media-converted.registry";
            File srcLibraryFile = new File(srcLibraryPath);
            File dstLibraryFile = new File(dstLibraryPath);
            System.out.println("MediaLibraryConverter...");
            System.out.println("srcLibraryFile: " + srcLibraryFile);
            System.out.println("dstLibraryFile: " + dstLibraryFile);
            MediaLibraryConverter converter = new MediaLibraryConverter();
            converter.convertMediaLibrary(srcLibraryFile, dstLibraryFile);
            System.out.println("Done.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertMediaLibrary(File srcLibraryFile, File dstLibraryFile) throws Exception {
        if (dstLibraryFile.exists()) {
            throw new IOException("Target library file already exists: " + dstLibraryFile);
        }
        MediaContext parentContext = null;
        DefaultDirectoryMediaIndex directoryMediaIndex = new DefaultDirectoryMediaIndex();
        SoundSystem soundSystem = null;
        Heap mediaHeap = null;
        int blockSize = -1;
        boolean readOnly = true;
        DefaultMediaContext context = new DefaultMediaContext(parentContext, (DirectoryMediaIndex)directoryMediaIndex, soundSystem, mediaHeap, blockSize);
        LibraryFile srcLibrary = LibraryFileUtil.openLibraryFile((MediaContext)context, (File)srcLibraryFile, (boolean)readOnly);
        try {
            LinkedList srcEntries = new LinkedList();
            srcLibrary.getAllMediaEntries(srcEntries);
            LinkedList<MediaEntry> dstEntries = new LinkedList<MediaEntry>();
            for (MediaEntry srcEntry : srcEntries) {
                System.out.println("Converting media entry: " + srcEntry.getResource());
                MediaEntry dstEntry = this.convertMediaEntry(srcEntry);
                if (dstEntry == null) continue;
                dstEntries.add(dstEntry);
            }
            readOnly = false;
            LibraryFile dstLibrary = LibraryFileUtil.openLibraryFile((MediaContext)context, (File)dstLibraryFile, (boolean)readOnly);
            try {
                for (MediaEntry me : dstEntries) {
                    Resource res;
                    if (me == null || (res = me.getResource()) == null) continue;
                    dstLibrary.putMediaEntry(res, me);
                }
            }
            finally {
                dstLibrary.close();
            }
        }
        finally {
            srcLibrary.close();
        }
    }

    protected MediaEntry convertMediaEntry(MediaEntry me) throws Exception {
        FileResource fileRes;
        File srcFile;
        MutableMediaEntry mme;
        Resource res;
        if (me == null) {
            return null;
        }
        if (me instanceof MutableMediaEntry && (res = (mme = (MutableMediaEntry)me).getResource()) != null && res instanceof FileResource && (srcFile = (fileRes = (FileResource)res).getFile()) != null) {
            String filePath = srcFile.getPath();
            if (filePath == null) {
                return null;
            }
            if (filePath.startsWith("D:\\sound\\") || filePath.startsWith("D:\\audio\\")) {
                filePath = filePath.substring(2);
                filePath = filePath.replace('\\', '/');
                System.out.println("convertMediaEntry: " + srcFile + " => " + filePath);
                File dstFile = new File(filePath);
                Field fieldPath = File.class.getDeclaredField("path");
                fieldPath.setAccessible(true);
                fieldPath.set(dstFile, filePath);
                FileResource dstResource = new FileResource(dstFile);
                mme.setResource((Resource)dstResource);
                return mme;
            }
        }
        return null;
    }
}

