/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import com.spacekiller.util.media.manager.MediaTreeToolContext;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.TMenu;
import com.spacekiller.util.tooling.TToggleAction;
import com.spacekiller.util.tooling.ToolContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class MediaManagerExtensions {
    private MediaManagerExtensions() {
    }

    public static class PlayWithAction
    implements ActionListener {
        private MediaTableToolContext context;
        private MediaPlayer player;

        public PlayWithAction(MediaTableToolContext context, MediaPlayer player) {
            this.context = context;
            this.player = player;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.context.setSelectedMediaPlayer(this.player);
            this.context.invokeDefaultEntryAction();
        }
    }

    public static class PlayWithMenu
    extends TMenu {
        protected void refreshInstance(Object c) {
            super.refreshInstance(c);
            if (c != null && c instanceof JMenu) {
                JMenu menu = (JMenu)c;
                menu.removeAll();
                ToolContext context = this.getToolContext(c);
                if (context != null && context instanceof MediaTableToolContext) {
                    MediaTableToolContext tableContext = (MediaTableToolContext)context;
                    this.refreshPlayerMenu(menu, tableContext);
                }
            }
        }

        protected void refreshPlayerMenu(JMenu menu, MediaTableToolContext context) {
            menu.removeAll();
            MediaPlayer sel = context.getSelectedMediaPlayer();
            MediaPlayer[] players = context.getMediaPlayers();
            int num = players == null ? 0 : players.length;
            for (int i = 0; i < num; ++i) {
                MediaPlayer player = players[i];
                JCheckBoxMenuItem item = new JCheckBoxMenuItem();
                item.setSelected(player == sel);
                item.addActionListener(new PlayWithAction(context, player));
                item.setText(String.valueOf(player.getPlayerName()));
                item.setIcon(player.getPlayerIcon(1));
                menu.add(item);
            }
        }
    }

    public static class PlayButtonPlayerHandler
    implements ActionListener {
        private MediaTableToolContext context;
        private int index;

        public PlayButtonPlayerHandler(MediaTableToolContext context, int index) {
            this.context = context;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int num;
            MediaPlayer[] players = this.context.getMediaPlayers();
            int n = num = players == null ? 0 : players.length;
            if (this.index >= num) {
                return;
            }
            MediaPlayer player = players[this.index];
            this.context.setSelectedMediaPlayer(player);
        }
    }

    public static class PlayButtonHandler
    extends MouseAdapter
    implements ActionListener {
        private MediaTableToolContext context;
        private AbstractButton button;
        private JPopupMenu popupMenu;
        private List popupItems;

        public PlayButtonHandler(AbstractButton button, MediaTableToolContext context) {
            this.context = context;
            this.button = button;
            this.popupMenu = new JPopupMenu();
            this.popupItems = new ArrayList();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.popupMenu.setVisible(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.getButton() != 1) {
                this.showPlayButtonPopupMenu();
            }
        }

        protected void showPlayButtonPopupMenu() {
            int i;
            if (this.context == null) {
                return;
            }
            this.popupMenu.removeAll();
            MediaPlayer sel = this.context.getSelectedMediaPlayer();
            MediaPlayer[] players = this.context.getMediaPlayers();
            int num = players == null ? 0 : players.length;
            int old = this.popupItems.size();
            for (i = 0; i < num; ++i) {
                MediaPlayer player = players[i];
                JCheckBoxMenuItem item = null;
                if (i < old) {
                    item = (JCheckBoxMenuItem)this.popupItems.get(i);
                } else {
                    item = new JCheckBoxMenuItem();
                    item.addActionListener(new PlayButtonPlayerHandler(this.context, i));
                    this.popupItems.add(item);
                }
                item.setSelected(player == sel);
                item.setText(String.valueOf(player.getPlayerName()));
                item.setIcon(player.getPlayerIcon(1));
                this.popupMenu.add(item);
            }
            if (old > num) {
                for (i = old - 1; i >= num; --i) {
                    this.popupItems.remove(i);
                }
            }
            this.popupMenu.show(this.button, 0, this.button.getHeight());
        }
    }

    public static class PlayButtonTool
    extends TAction {
        public Object createInstance(ToolContext context, Class type) {
            Object instance = super.createInstance(context, type);
            if (instance != null && instance instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)instance;
                if (context != null && context instanceof MediaTableToolContext) {
                    MediaTableToolContext tableContext = (MediaTableToolContext)context;
                    PlayButtonHandler handler = new PlayButtonHandler(button, tableContext);
                    button.addActionListener(handler);
                    button.addMouseListener(handler);
                }
            }
            return instance;
        }

        public void invoke(Object instance) {
            MediaTableToolContext tableContext = (MediaTableToolContext)this.getToolContext(instance);
            tableContext.invokeDefaultEntryAction();
        }
    }

    public static class SaveAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.saveCrates();
        }
    }

    public static class SaveAsAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showSaveCrateDialog();
        }
    }

    public static class OpenAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showOpenCrateDialog();
        }
    }

    public static class CratePropertiesAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showCratePropertiesDialog();
        }
    }

    public static class CrateConvertAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showCrateConvertDialog();
        }
    }

    public static class CrateRefreshAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.refreshSelectedCrates();
        }
    }

    public static class CrateMoveDownAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.moveSelectedCratesDown();
        }
    }

    public static class CrateMoveUpAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.moveSelectedCratesUp();
        }
    }

    public static class AdvancedSearchAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.openAdvancedSearchDialog();
        }
    }

    public static class ShowTableFontDialog
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.showTableFontDialog();
        }
    }

    public static class ShowTableExportWizard
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.showTableExportWizard();
        }
    }

    public static class LayoutTableToFitValuesAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.layoutTableToFitValues();
        }
    }

    public static class LayoutTableToFitWindowAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.layoutTableToFitWindow();
        }
    }

    public static class ShowHideTableColumnAction
    implements ActionListener {
        protected MediaTableToolContext tableContext;
        protected EntryTableColumnProvider columnProvider;

        public ShowHideTableColumnAction(MediaTableToolContext tableContext, EntryTableColumnProvider columnProvider) {
            this.tableContext = tableContext;
            this.columnProvider = columnProvider;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean enabled = this.tableContext.isEntryTableColumnProviderEnabled(this.columnProvider);
            this.tableContext.setEntryTableColumnProviderEnabled(this.columnProvider, !enabled);
        }
    }

    public static class ShowHideTableColumnMenu
    extends TMenu {
        protected void refreshInstance(Object c) {
            super.refreshInstance(c);
            if (c != null && c instanceof JMenu) {
                JMenu menu = (JMenu)c;
                menu.removeAll();
                ToolContext context = this.getToolContext(c);
                if (context != null && context instanceof MediaTableToolContext) {
                    MediaTableToolContext tableContext = (MediaTableToolContext)context;
                    EntryTableColumnProvider[] entryTableColumnProviders = tableContext.getEntryTableColumnProviders();
                    int count = entryTableColumnProviders == null ? 0 : entryTableColumnProviders.length;
                    for (int i = 0; i < count; ++i) {
                        EntryTableColumnProvider tcp = entryTableColumnProviders[i];
                        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
                        item.setText(String.valueOf(tcp.getHeaderValue()));
                        item.setToolTipText(tcp.getTooltipText());
                        item.setSelected(tableContext.isEntryTableColumnProviderEnabled(tcp));
                        item.addActionListener(new ShowHideTableColumnAction(tableContext, tcp));
                        menu.add(item);
                    }
                }
            }
        }
    }

    public static class ResetTableSortingOrderAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.resetSortingOrder();
        }
    }

    public static class ApplyTableSortingOrderAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.applySortingOrder();
        }
    }

    public static class DecreaseSelectedUserRatingAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.decreaseSelectedUserRating();
        }
    }

    public static class IncreaseSelectedUserRatingAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.increaseSelectedUserRating();
        }
    }

    public static class EntryMoveDownAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.moveSelectedEntriesDown();
        }
    }

    public static class EntryMoveUpAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.moveSelectedEntriesUp();
        }
    }

    public static class DetectDuplicatesAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.detectDuplicateEntries();
        }
    }

    public static class RemoveMissingFilesAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.removeMissingFileEntries();
        }
    }

    public static class RelocateFilesAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.openRelocateFilesDialog();
        }
    }

    public static class AnalyzeFilesAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.analyzeSelectedEntries();
        }
    }

    public static class RescanFilesAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.rescanSelectedEntries();
        }
    }

    public static class EntryLocationAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.openSelectedFileLocation();
        }
    }

    public static class EntryPathCopyAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.copySelectedPathsToClipboard();
        }
    }

    public static class EntryPropertiesAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.showEntryPropertiesDialog();
        }
    }

    public static class CrateAutoLoadToggleAction
    extends TToggleAction {
        public void invoke(Object instance) {
            boolean autoLoad = this.isSelected(instance);
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.setAutoLoadSelectedCrates(autoLoad);
        }
    }

    public static class M3uExportAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showM3uExportDialog();
        }
    }

    public static class SeratoExportAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showSeratoExportDialog();
        }
    }

    public static class SeratoLoadAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showSeratoLoadDialog();
        }
    }

    public static class CrateExportAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showCrateExportDialog();
        }
    }

    public static class CrateImportAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.showCrateImportDialog();
        }
    }

    public static class AddRemoteResourceAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTableToolContext ctx = (MediaTableToolContext)this.getToolContext(instance);
            ctx.addRemoteResource();
        }
    }

    public static class NewRemoteCrateAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.newRemoteCrate();
        }
    }

    public static class NewFileCrateAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.newFileCrate();
        }
    }

    public static class NewDirectoryCrateAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.newDirectoryCrate();
        }
    }

    public static class NewDefaultCrateAction
    extends TAction {
        public void invoke(Object instance) {
            MediaTreeToolContext ctx = (MediaTreeToolContext)this.getToolContext(instance);
            ctx.newDefaultCrate();
        }
    }
}

