/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Editor;
import com.spacekiller.util.EditorContext;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MutableMediaCrate;
import com.spacekiller.util.media.library.CrateFile;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.manager.CratesFileFilter;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.media.manager.MediaManagerToolContext;
import com.spacekiller.util.media.manager.MediaTableEntryLoader;
import com.spacekiller.util.media.manager.MediaTableEntryPool;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import com.spacekiller.util.media.manager.MediaTableView;
import com.spacekiller.util.media.manager.MediaTableViewPanel;
import com.spacekiller.util.media.manager.MediaTreeToolContext;
import com.spacekiller.util.media.manager.MediaTreeView;
import com.spacekiller.util.media.manager.MediaTreeViewPanel;
import com.spacekiller.util.swing.DocumentAdapter;
import com.spacekiller.util.table.TableExportWizard;
import com.spacekiller.util.table.TableViewPanel;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.tooling.AbstractToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;

public class MediaManagerPanel
extends JPanel
implements Editor {
    private static final long serialVersionUID = -412302527498015001L;
    private static final Logger logger = Logger.getLogger(MediaManagerPanel.class.getName());
    private static final String KEY_LIBRARY_FONT_NAME = "libraryFontName";
    private static final String KEY_LIBRARY_FONT_SIZE = "libraryFontSize";
    private static final String KEY_SPLIT_DIV_LOCATION = "splitDividerLocation";
    private static final int FOCUS_PANEL_TREE = 0;
    private static final int FOCUS_PANEL_TABLE = 1;
    private final RefreshMediaPlayersImpl refreshMediaPlayersImpl = new RefreshMediaPlayersImpl();
    private volatile boolean refreshMediaPlayersPending;
    private final CratesFileFilter cratesFileFilter = new CratesFileFilter();
    private MediaLibrary mediaLibrary;
    private MediaPlayer[] mediaPlayers;
    private MediaPlayer mediaPlayer;
    private String mediaPlayerName;
    private MutableMediaCrate rootCrate;
    private File rootCrateFile;
    private Filter loadFilter;
    private Icon loadProgressIcon;
    private int prevFilterCount = -1;
    private int prevTotalCount = -1;
    private View mediaManagerView;
    private MediaTreeView mediaTreeView;
    private MediaTableView mediaTableView;
    private MediaManagerToolContext mediaManagerToolContext;
    private JToolBar crateToolBar;
    private JToolBar crateLoadBar;
    private JPopupMenu cratePopupMenu;
    private JToolBar entryToolBar;
    private JPopupMenu entryPopupMenu;
    private JPopupMenu tableHeaderPopupMenu;
    private JPopupMenu tableCornerPopupMenu;
    private TableExportWizard tableExportWizard;
    private ToolGroup showHideColumnMenuGroup;
    private BeansToolkit beansToolkit;
    private ClipboardManager clipboardManager;
    private BeanDropSupport beanDropSupport;
    private UndoManager undoManager;
    private File currentDirectory;
    private int maxTableEntries = 1000000;
    private MediaTableEntryPool tableEntryPool;
    private ThreadPool workerThreadPool;
    private ThreadPool loaderThreadPool;
    private ThreadPool pictureThreadPool;
    private LoadAsync currentLoadAsync;
    private MediaTableEntryLoader crateEntryLoader;
    private Color searchAdjustingColor = Color.BLUE;
    private Color searchFilterColor = Color.BLACK;
    private int focusPanelIndex;
    private Font normalFont;
    private Font activeFont;
    private MediaTableViewPanel mediaTablePanel;
    private JLabel lblEntryCount;
    private JPanel panelCrates;
    private JPanel panelEntries;
    private JPanel panelEntrySearch;
    private JTextField textFieldSearch;
    private JPanel panelCrateTools;
    private JPanel panelEntryTools;
    private JPanel panelLoadTools;
    private MediaTreeViewPanel mediaTreePanel;
    private JSplitPane splitPane;

    public MediaManagerPanel() {
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.splitPane = new JSplitPane();
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.add(this.splitPane);
        this.panelCrates = new JPanel();
        this.splitPane.setLeftComponent(this.panelCrates);
        GridBagLayout gbl_panelCrates = new GridBagLayout();
        gbl_panelCrates.columnWidths = new int[]{0, 0};
        gbl_panelCrates.rowHeights = new int[]{0, 0, 0};
        gbl_panelCrates.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelCrates.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.panelCrates.setLayout(gbl_panelCrates);
        JPanel panelCratesHead = new JPanel();
        GridBagConstraints gbc_panelCratesHead = new GridBagConstraints();
        gbc_panelCratesHead.weightx = 1.0;
        gbc_panelCratesHead.fill = 1;
        gbc_panelCratesHead.gridx = 0;
        gbc_panelCratesHead.gridy = 0;
        this.panelCrates.add((Component)panelCratesHead, gbc_panelCratesHead);
        GridBagLayout gbl_panelCratesHead = new GridBagLayout();
        gbl_panelCratesHead.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelCratesHead.rowHeights = new int[]{0, 0, 0};
        gbl_panelCratesHead.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelCratesHead.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        panelCratesHead.setLayout(gbl_panelCratesHead);
        this.panelCrateTools = new JPanel();
        GridBagConstraints gbc_panelCrateTools = new GridBagConstraints();
        gbc_panelCrateTools.weightx = 1.0;
        gbc_panelCrateTools.fill = 1;
        gbc_panelCrateTools.gridx = 0;
        gbc_panelCrateTools.gridy = 0;
        panelCratesHead.add((Component)this.panelCrateTools, gbc_panelCrateTools);
        this.panelCrateTools.setLayout(new GridLayout(1, 0, 0, 0));
        this.panelLoadTools = new JPanel();
        GridBagConstraints gbc_panelLoadTools = new GridBagConstraints();
        gbc_panelLoadTools.anchor = 13;
        gbc_panelLoadTools.fill = 1;
        gbc_panelLoadTools.gridx = 2;
        gbc_panelLoadTools.gridy = 0;
        panelCratesHead.add((Component)this.panelLoadTools, gbc_panelLoadTools);
        this.panelLoadTools.setLayout(new GridLayout(1, 0, 0, 0));
        this.mediaTreePanel = new MediaTreeViewPanel();
        GridBagConstraints gbc_mediaTreePanel = new GridBagConstraints();
        gbc_mediaTreePanel.fill = 1;
        gbc_mediaTreePanel.gridx = 0;
        gbc_mediaTreePanel.gridy = 1;
        this.panelCrates.add((Component)this.mediaTreePanel, gbc_mediaTreePanel);
        this.panelEntries = new JPanel();
        this.splitPane.setRightComponent(this.panelEntries);
        GridBagLayout gbl_panelEntries = new GridBagLayout();
        gbl_panelEntries.columnWidths = new int[]{0, 0};
        gbl_panelEntries.rowHeights = new int[]{0, 0, 0};
        gbl_panelEntries.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelEntries.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panelEntries.setLayout(gbl_panelEntries);
        JPanel panelEntriesHead = new JPanel();
        GridBagConstraints gbc_panelEntriesHead = new GridBagConstraints();
        gbc_panelEntriesHead.fill = 1;
        gbc_panelEntriesHead.gridx = 0;
        gbc_panelEntriesHead.gridy = 0;
        this.panelEntries.add((Component)panelEntriesHead, gbc_panelEntriesHead);
        GridBagLayout gbl_panelEntriesHead = new GridBagLayout();
        gbl_panelEntriesHead.columnWidths = new int[]{0, 0, 0};
        gbl_panelEntriesHead.rowHeights = new int[]{0, 0, 0};
        gbl_panelEntriesHead.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelEntriesHead.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        panelEntriesHead.setLayout(gbl_panelEntriesHead);
        this.panelEntrySearch = new JPanel();
        GridBagConstraints gbc_panelEntrySearch = new GridBagConstraints();
        gbc_panelEntrySearch.weightx = 1.0;
        gbc_panelEntrySearch.fill = 2;
        gbc_panelEntrySearch.gridx = 1;
        gbc_panelEntrySearch.gridy = 0;
        panelEntriesHead.add((Component)this.panelEntrySearch, gbc_panelEntrySearch);
        GridBagLayout gbl_panelEntrySearch = new GridBagLayout();
        gbl_panelEntrySearch.columnWidths = new int[]{0, 0, 0};
        gbl_panelEntrySearch.rowHeights = new int[]{0, 0};
        gbl_panelEntrySearch.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelEntrySearch.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelEntrySearch.setLayout(gbl_panelEntrySearch);
        this.lblEntryCount = new JLabel("0");
        GridBagConstraints gbc_lblEntryCount = new GridBagConstraints();
        gbc_lblEntryCount.insets = new Insets(0, 4, 0, 8);
        gbc_lblEntryCount.gridx = 1;
        gbc_lblEntryCount.gridy = 0;
        this.panelEntrySearch.add((Component)this.lblEntryCount, gbc_lblEntryCount);
        this.lblEntryCount.setToolTipText("Number of entries");
        this.textFieldSearch = new JTextField();
        this.textFieldSearch.setMinimumSize(new Dimension(10, 26));
        this.textFieldSearch.setPreferredSize(new Dimension(50, 26));
        this.textFieldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaManagerPanel.this.actionSearch();
            }
        });
        this.textFieldSearch.setToolTipText("Search filter");
        this.textFieldSearch.setOpaque(false);
        GridBagConstraints gbc_textFieldSearch = new GridBagConstraints();
        gbc_textFieldSearch.weightx = 1.0;
        gbc_textFieldSearch.insets = new Insets(0, 4, 0, 4);
        gbc_textFieldSearch.fill = 2;
        gbc_textFieldSearch.gridx = 0;
        gbc_textFieldSearch.gridy = 0;
        this.panelEntrySearch.add((Component)this.textFieldSearch, gbc_textFieldSearch);
        this.textFieldSearch.setColumns(10);
        this.panelEntryTools = new JPanel();
        GridBagConstraints gbc_panelEntryTools = new GridBagConstraints();
        gbc_panelEntryTools.fill = 1;
        gbc_panelEntryTools.gridx = 0;
        gbc_panelEntryTools.gridy = 0;
        panelEntriesHead.add((Component)this.panelEntryTools, gbc_panelEntryTools);
        this.panelEntryTools.setLayout(new GridLayout(1, 0, 0, 0));
        this.mediaTablePanel = new MediaTableViewPanel();
        GridBagConstraints gbc_mediaTablePanel = new GridBagConstraints();
        gbc_mediaTablePanel.weighty = 1.0;
        gbc_mediaTablePanel.weightx = 1.0;
        gbc_mediaTablePanel.fill = 1;
        gbc_mediaTablePanel.gridx = 0;
        gbc_mediaTablePanel.gridy = 1;
        this.panelEntries.add((Component)((Object)this.mediaTablePanel), gbc_mediaTablePanel);
        this.initMediaManagerPanel();
    }

    protected TableViewPanel getMediaTablePanel() {
        return this.mediaTablePanel;
    }

    protected void initMediaManagerPanel() {
        this.mediaTreeView = new MediaTreeView(this.mediaTreePanel);
        this.mediaTreePanel.setMediaTreeView(this.mediaTreeView);
        this.mediaTreePanel.setMediaManagerToolContext(this.getMediaManagerToolContext());
        this.mediaTableView = new MediaTableView(this.mediaTablePanel);
        this.mediaTablePanel.setMediaTableView(this.mediaTableView);
        this.mediaTablePanel.setMediaManagerPanel(this);
        String fontName = null;
        int fontSize = 12;
        Font font = this.getFont();
        if (font != null) {
            fontName = font.getName();
            fontSize = font.getSize();
        }
        this.applyFont(fontName, fontSize);
        this.loadProgressIcon = Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/load_progress_icon16.png");
        this.textFieldSearch.setForeground(this.searchFilterColor);
        this.textFieldSearch.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void handle(DocumentEvent e) {
                MediaManagerPanel.this.textFieldSearch.setForeground(MediaManagerPanel.this.searchAdjustingColor);
            }
        });
        this.initActionMap();
        this.initInputMap();
    }

    protected void initActionMap() {
        ActionMap actionMap = this.getActionMap();
        if (actionMap == null) {
            return;
        }
        actionMap.put("focusSearchField", new FocusSearchFieldAction());
    }

    protected void initInputMap() {
        InputMap inputMap = this.getInputMap(1);
        if (inputMap == null) {
            return;
        }
        inputMap.put(KeyStroke.getKeyStroke(70, 128), "focusSearchField");
    }

    protected JLabel getLblEntryCount() {
        return this.lblEntryCount;
    }

    public MutableMediaCrate getRootCrate() {
        return this.rootCrate;
    }

    public void setRootCrate(MutableMediaCrate rootCrate) {
        this.rootCrate = rootCrate;
        this.mediaTreePanel.setRootCrate(rootCrate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionLoadEntries(boolean requestTableFocus) {
        LinkedList crates = new LinkedList();
        this.mediaTreePanel.getSelectedCrates(crates);
        if (crates.isEmpty()) {
            return;
        }
        LoadAsync loadAsync = new LoadAsync(crates);
        MediaManagerPanel mediaManagerPanel = this;
        synchronized (mediaManagerPanel) {
            this.currentLoadAsync = loadAsync;
        }
        ThreadPool pool = this.getLoaderThreadPool();
        if (pool != null) {
            try {
                pool.start((Runnable)loadAsync);
                return;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        new Thread(loadAsync).start();
    }

    protected void actionCancelLoader() {
        MediaTableEntryLoader loader = this.crateEntryLoader;
        if (loader != null && loader.isActive()) {
            loader.cancel();
        }
        this.mediaTablePanel.cancelMediaScanner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEntries(LoadAsync loadAsync, List crates) {
        MediaTableEntryLoader loader;
        MediaManagerPanel mediaManagerPanel = this;
        synchronized (mediaManagerPanel) {
            if (loadAsync != this.currentLoadAsync) {
                return;
            }
        }
        MediaTableEntryLoader oldLoader = this.crateEntryLoader;
        if (oldLoader != null) {
            oldLoader.cancel();
            oldLoader.join();
        }
        this.mediaTablePanel.cancelMediaScanner();
        final MediaCrate[] crateArray = crates.toArray(new MediaCrate[crates.size()]);
        MediaManagerPanel mediaManagerPanel2 = this;
        synchronized (mediaManagerPanel2) {
            if (loadAsync != this.currentLoadAsync) {
                return;
            }
            this.crateEntryLoader = loader = new MediaTableEntryLoader(this, crateArray, this.loadFilter, this.maxTableEntries);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MediaManagerPanel.this.mediaTablePanel.setLoadedCrates(crateArray);
                    MediaManagerPanel.this.lblEntryCount.setIcon(MediaManagerPanel.this.loadProgressIcon);
                    Cursor cursor = Cursor.getPredefinedCursor(3);
                    if (cursor != null) {
                        MediaManagerPanel.this.lblEntryCount.setCursor(cursor);
                        MediaManagerPanel.this.mediaTablePanel.setCursor(cursor);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        loader.run();
        mediaManagerPanel2 = this;
        synchronized (mediaManagerPanel2) {
            if (loadAsync != this.currentLoadAsync) {
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MediaManagerPanel.this.lblEntryCount.setIcon(null);
                Cursor cursor = Cursor.getDefaultCursor();
                MediaManagerPanel.this.lblEntryCount.setCursor(cursor);
                MediaManagerPanel.this.mediaTablePanel.setCursor(cursor);
            }
        });
        this.mediaTablePanel.scanEntries();
    }

    public int getMaxTableEntries() {
        return this.maxTableEntries;
    }

    public void setMaxTableEntries(int maxTableEntries) {
        this.maxTableEntries = maxTableEntries;
    }

    protected JPanel getPanelCrates() {
        return this.panelCrates;
    }

    protected JPanel getPanelEntries() {
        return this.panelEntries;
    }

    protected void loadEntries(List entryList) {
        this.mediaTablePanel.loadEntries(entryList);
    }

    public void updateEntryCount() {
        int totalCount = this.mediaTablePanel.getLoadedEntryCount();
        int filterCount = this.mediaTablePanel.getFilterEntryCount();
        if (this.prevTotalCount == totalCount && this.prevFilterCount == filterCount) {
            return;
        }
        this.prevTotalCount = totalCount;
        this.prevFilterCount = filterCount;
        String text = filterCount == totalCount ? Integer.toString(totalCount) : Integer.toString(filterCount) + " / " + Integer.toString(totalCount);
        this.lblEntryCount.setText(text);
    }

    protected void actionSearch() {
        String search = this.textFieldSearch.getText();
        this.textFieldSearch.setForeground(this.searchFilterColor);
        this.mediaTablePanel.setSimpleSearchText(search);
    }

    public JToolBar getCrateToolBar() {
        return this.crateToolBar;
    }

    public void setCrateToolBar(JToolBar crateToolBar) {
        this.crateToolBar = crateToolBar;
        this.panelCrateTools.removeAll();
        if (crateToolBar != null) {
            this.panelCrateTools.add(crateToolBar);
        }
        this.panelCrateTools.validate();
        this.panelCrateTools.repaint();
    }

    public JToolBar getCrateLoadBar() {
        return this.crateLoadBar;
    }

    public void setCrateLoadBar(JToolBar crateLoadBar) {
        this.crateLoadBar = crateLoadBar;
        this.panelLoadTools.removeAll();
        if (crateLoadBar != null) {
            this.panelLoadTools.add(crateLoadBar);
        }
        this.panelLoadTools.validate();
        this.panelLoadTools.repaint();
    }

    public JPopupMenu getCratePopupMenu() {
        return this.cratePopupMenu;
    }

    public void setCratePopupMenu(JPopupMenu cratePopupMenu) {
        this.cratePopupMenu = cratePopupMenu;
        this.mediaTreePanel.setCratePopupMenu(cratePopupMenu);
    }

    public JToolBar getEntryToolBar() {
        return this.entryToolBar;
    }

    public void setEntryToolBar(JToolBar entryToolBar) {
        this.entryToolBar = entryToolBar;
        this.panelEntryTools.removeAll();
        if (entryToolBar != null) {
            this.panelEntryTools.add(entryToolBar);
        }
        this.panelEntryTools.validate();
        this.panelEntryTools.repaint();
    }

    public JPopupMenu getEntryPopupMenu() {
        return this.entryPopupMenu;
    }

    public void setEntryPopupMenu(JPopupMenu entryPopupMenu) {
        this.entryPopupMenu = entryPopupMenu;
        this.mediaTablePanel.setTablePopupMenu(entryPopupMenu);
    }

    protected JPanel getPanelCrateTools() {
        return this.panelCrateTools;
    }

    protected JPanel getPanelLoadTools() {
        return this.panelLoadTools;
    }

    protected JPanel getPanelEntryTools() {
        return this.panelEntryTools;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        this.mediaTreePanel.setBeansToolkit(beansToolkit);
        this.mediaTablePanel.setBeansToolkit(beansToolkit);
    }

    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    public void setClipboardManager(ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
        this.mediaTreePanel.setClipboardManager(clipboardManager);
        this.mediaTablePanel.setClipboardManager(clipboardManager);
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
        this.mediaTreePanel.setBeanDropSupport(beanDropSupport);
        this.mediaTablePanel.setBeanDropSupport(beanDropSupport);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
        this.mediaTreePanel.setUndoManager(undoManager);
        this.mediaTablePanel.setUndoManager(undoManager);
    }

    public JPopupMenu getTableCornerPopupMenu() {
        return this.tableCornerPopupMenu;
    }

    public void setTableCornerPopupMenu(JPopupMenu tableCornerPopupMenu) {
        this.tableCornerPopupMenu = tableCornerPopupMenu;
        this.mediaTablePanel.setTableCornerPopupMenu(tableCornerPopupMenu);
    }

    public TableExportWizard getTableExportWizard() {
        return this.tableExportWizard;
    }

    public void setTableExportWizard(TableExportWizard tableExportWizard) {
        this.tableExportWizard = tableExportWizard;
        this.mediaTablePanel.setTableExportWizard(tableExportWizard);
    }

    public MediaManagerToolContext getMediaManagerToolContext() {
        if (this.mediaManagerToolContext == null) {
            this.setMediaManagerToolContext(this.createMediaManagerToolContext());
        }
        return this.mediaManagerToolContext;
    }

    protected void setMediaManagerToolContext(MediaManagerToolContext mediaManagerToolContext) {
        this.mediaManagerToolContext = mediaManagerToolContext;
    }

    protected MediaManagerToolContext createMediaManagerToolContext() {
        return new ToolContextImpl();
    }

    public View getMediaManagerView() {
        return this.mediaManagerView;
    }

    public void setMediaManagerView(View mediaManagerView) {
        this.mediaManagerView = mediaManagerView;
    }

    protected MediaTreeViewPanel getMediaTreePanel() {
        return this.mediaTreePanel;
    }

    public MediaTreeView getMediaTreeView() {
        return this.mediaTreeView;
    }

    protected void setMediaTreeView(MediaTreeView mediaTreeView) {
        this.mediaTreeView = mediaTreeView;
    }

    public MediaTableView getMediaTableView() {
        return this.mediaTableView;
    }

    protected void setMediaTableView(MediaTableView mediaTableView) {
        this.mediaTableView = mediaTableView;
    }

    public MediaTreeToolContext getMediaTreeToolContext() {
        return this.mediaTreePanel.getMediaTreeToolContext();
    }

    public MediaTableToolContext getMediaTableToolContext() {
        return this.mediaTablePanel.getMediaTableToolContext();
    }

    public MediaLibrary getMediaLibrary() {
        return this.mediaLibrary;
    }

    public synchronized void setMediaLibrary(MediaLibrary mediaLibrary) {
        if (this.mediaLibrary == mediaLibrary) {
            return;
        }
        this.mediaLibrary = mediaLibrary;
        this.mediaTreePanel.setMediaLibrary(mediaLibrary);
        this.mediaTablePanel.setMediaLibrary(mediaLibrary);
    }

    public void showOpenCrateDialog() {
        try {
            int messageType;
            int optionType;
            String title;
            String message;
            int confirm;
            int rc;
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Open Crates File");
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(this.cratesFileFilter);
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            if (this.rootCrateFile != null) {
                chooser.setSelectedFile(this.rootCrateFile);
            }
            if ((rc = chooser.showOpenDialog(this)) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            this.currentDirectory = chooser.getCurrentDirectory();
            if (this.rootCrate != null && this.rootCrate.isDirty() && (confirm = JOptionPane.showConfirmDialog(this, message = "There are unsaved changes. Are you sure ?", title = "Discard Changes ?", optionType = 2, messageType = 3)) != 0) {
                return;
            }
            this.openRootCrateFile(file);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void openRootCrateFile(final File file) throws IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.openRootCrateFileImpl(file);
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        MediaManagerPanel.this.openRootCrateFileImpl(file);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void openRootCrateFileImpl(File file) throws IOException {
        CrateFileMediaCrate newRoot;
        MediaLibrary library = this.getMediaLibrary();
        String rootId = null;
        if (file != null) {
            newRoot = new CrateFileMediaCrate(rootId, (Component)this, library, file);
        } else {
            String name = "root";
            String crateFilePath = null;
            newRoot = new CrateFileMediaCrate(rootId, (Component)this, library, name, crateFilePath);
        }
        this.setRootCrateFile(file);
        this.setRootCrate((MutableMediaCrate)newRoot);
    }

    public void showSaveCrateDialog() {
        try {
            int messageType;
            int optionType;
            String title;
            String message;
            int rc;
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Save Crates File");
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(this.cratesFileFilter);
            String proposedName = null;
            View mmv = this.getMediaManagerView();
            if (mmv != null && (proposedName = mmv.getTitle()) == null) {
                proposedName = mmv.getName();
            }
            if (proposedName == null) {
                proposedName = "media";
            }
            proposedName = proposedName + ".crates";
            chooser.setSelectedFile(new File(proposedName));
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            if ((rc = chooser.showSaveDialog(this)) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            this.currentDirectory = chooser.getCurrentDirectory();
            String fileName = file.getName();
            if (!fileName.toLowerCase().endsWith(".crates".toLowerCase())) {
                file = new File(file.getPath() + ".crates");
            }
            if (file.exists() && (rc = JOptionPane.showConfirmDialog(this, message = "Are you sure to overwrite the existing file ?", title = "Overwrite Existing File ?", optionType = 2, messageType = 3)) != 0) {
                return;
            }
            this.rootCrateFile = file;
            boolean backup = true;
            this.saveCrates(file, backup);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void saveCrates() throws IOException {
        if (this.rootCrate == null) {
            return;
        }
        File file = this.getRootCrateFile();
        if (file == null) {
            this.showSaveCrateDialog();
            return;
        }
        boolean backup = true;
        this.saveCrates(file, backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCrates(File targetFile, boolean backup) throws IOException {
        File backupFile = null;
        if (backup && targetFile.exists() && targetFile.isFile()) {
            backupFile = new File(targetFile.getPath() + ".bak");
            if (backupFile.exists() && !backupFile.delete()) {
                throw new IOException("Failed to delete old crate backup file: " + backupFile);
            }
            if (!targetFile.renameTo(backupFile)) {
                throw new IOException("Failed to rename old crate file: " + targetFile + " -> " + backupFile);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Writing root crate file: " + targetFile);
        }
        boolean success = false;
        try {
            MutableMediaCrate root = this.rootCrate;
            int num = root.getCrateCount();
            MediaCrate[] crateArray = new MediaCrate[num];
            for (int i = 0; i < num; ++i) {
                crateArray[i] = root.getCrateAt(i);
            }
            MediaLibrary library = this.getMediaLibrary();
            MediaContext context = library.getContext();
            CrateFile crateFile = new CrateFile(targetFile, library, context, (Component)this);
            crateFile.writeMediaCrateFile(crateArray);
            root.setDirty(false);
            success = true;
        }
        finally {
            if (!success) {
                if (targetFile.delete()) {
                    if (backupFile != null) {
                        if (backupFile.renameTo(targetFile)) {
                            logger.info("Restored backup file: " + backupFile + " -> " + targetFile);
                        } else {
                            logger.warning("Failed to restore backup file: " + backupFile + " -> " + targetFile);
                        }
                    }
                } else {
                    logger.warning("Failed to delete corrupted file: " + targetFile);
                }
            }
        }
    }

    public void setEditorContext(EditorContext context) {
    }

    public boolean isDirty() throws IOException {
        MutableMediaCrate root = this.rootCrate;
        return root != null && root.isDirty();
    }

    public void save() throws Exception {
        this.saveCrates();
    }

    public File getRootCrateFile() {
        return this.rootCrateFile;
    }

    public void setRootCrateFile(File rootCrateFile) {
        this.rootCrateFile = rootCrateFile;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
        this.mediaTreePanel.setCurrentDirectory(currentDirectory);
    }

    public ThreadPool getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    public synchronized void setWorkerThreadPool(ThreadPool workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
        this.mediaTablePanel.setWorkerThreadPool(workerThreadPool);
    }

    public ThreadPool getLoaderThreadPool() {
        return this.loaderThreadPool;
    }

    public synchronized void setLoaderThreadPool(ThreadPool loaderThreadPool) {
        this.loaderThreadPool = loaderThreadPool;
        this.mediaTablePanel.setScannerThreadPool(loaderThreadPool);
    }

    public ThreadPool getPictureThreadPool() {
        return this.pictureThreadPool;
    }

    public synchronized void setPictureThreadPool(ThreadPool pictureThreadPool) {
        this.pictureThreadPool = pictureThreadPool;
        this.mediaTablePanel.setPictureThreadPool(pictureThreadPool);
    }

    public MediaTableEntryPool getTableEntryPool() {
        return this.tableEntryPool;
    }

    public void setTableEntryPool(MediaTableEntryPool tableEntryPool) {
        this.tableEntryPool = tableEntryPool;
        this.mediaTablePanel.setTableEntryPool(tableEntryPool);
    }

    public Filter getLoadFilter() {
        return this.loadFilter;
    }

    public synchronized void setLoadFilter(Filter loadFilter) {
        this.loadFilter = loadFilter;
        this.mediaTablePanel.setLoadFilter(loadFilter);
    }

    public Icon getLoadProgressIcon() {
        return this.loadProgressIcon;
    }

    public void setLoadProgressIcon(Icon loadProgressIcon) {
        this.loadProgressIcon = loadProgressIcon;
    }

    public Color getSearchAdjustingColor() {
        return this.searchAdjustingColor;
    }

    public void setSearchAdjustingColor(Color searchAdjustingColor) {
        this.searchAdjustingColor = searchAdjustingColor;
    }

    public Color getSearchFilterColor() {
        return this.searchFilterColor;
    }

    public void setSearchFilterColor(Color searchFilterColor) {
        this.searchFilterColor = searchFilterColor;
    }

    public JPopupMenu getTableHeaderPopupMenu() {
        return this.tableHeaderPopupMenu;
    }

    public void setTableHeaderPopupMenu(JPopupMenu tableHeaderPopupMenu) {
        this.tableHeaderPopupMenu = tableHeaderPopupMenu;
        this.mediaTablePanel.setTableHeaderPopupMenu(tableHeaderPopupMenu);
    }

    public boolean navigateCrateTree() {
        this.mediaTreePanel.requestCrateTreeFocus();
        this.setFocusPanelIndex(0);
        return true;
    }

    public boolean navigatePlayList() {
        this.mediaTablePanel.requestEntryTableFocus();
        this.setFocusPanelIndex(1);
        return true;
    }

    public ToolGroup getShowHideColumnMenuGroup() {
        return this.showHideColumnMenuGroup;
    }

    public void setShowHideColumnMenuGroup(ToolGroup showHideColumnMenuGroup) {
        this.showHideColumnMenuGroup = showHideColumnMenuGroup;
        this.mediaTablePanel.setShowHideColumnMenuGroup(showHideColumnMenuGroup);
    }

    public void saveViewPreferences(Properties props) {
        Font libFont = this.normalFont;
        if (libFont != null) {
            String fontName = libFont.getName();
            int fontSize = libFont.getSize();
            props.setProperty(KEY_LIBRARY_FONT_NAME, String.valueOf(fontName));
            props.setProperty(KEY_LIBRARY_FONT_SIZE, String.valueOf(fontSize));
        }
        int dividerLocation = this.splitPane.getDividerLocation();
        props.setProperty(KEY_SPLIT_DIV_LOCATION, Integer.toString(dividerLocation));
        this.mediaTreePanel.saveViewPreferences(props);
        this.mediaTablePanel.saveViewPreferences(props);
    }

    public void loadViewPreferences(Properties props) {
        String splitLocation;
        String libFontSize = props.getProperty(KEY_LIBRARY_FONT_SIZE);
        if (libFontSize != null) {
            try {
                int fontSize = Integer.parseInt(libFontSize.trim());
                if (fontSize > 0) {
                    String fontName = props.getProperty(KEY_LIBRARY_FONT_NAME);
                    this.applyFont(fontName, fontSize);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((splitLocation = props.getProperty(KEY_SPLIT_DIV_LOCATION)) != null) {
            try {
                int dividerLocation = Integer.parseInt(splitLocation.trim());
                if (dividerLocation >= 0) {
                    this.splitPane.setDividerLocation(dividerLocation);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.mediaTreePanel.loadViewPreferences(props);
        this.mediaTablePanel.loadViewPreferences(props);
    }

    public void mediaPlayerAdded(MediaPlayer player) {
        this.refreshMediaPlayersLater();
    }

    public void mediaPlayerRemoved(MediaPlayer player) {
        this.refreshMediaPlayersLater();
    }

    protected void refreshMediaPlayersLater() {
        if (this.refreshMediaPlayersPending) {
            return;
        }
        this.refreshMediaPlayersPending = true;
        SwingUtilities.invokeLater(this.refreshMediaPlayersImpl);
    }

    protected void refreshMediaPlayersImpl() {
        this.refreshMediaPlayersPending = false;
        try {
            MediaPlayer[] mediaPlayers = null;
            if (Platform.isInstanceAvailable()) {
                MediaManagerPlugin plugin = MediaManagerPlugin.getInstance();
                mediaPlayers = plugin.getMediaPlayers();
            }
            if (mediaPlayers == null) {
                mediaPlayers = new MediaPlayer[]{};
            }
            this.setMediaPlayers(mediaPlayers);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public synchronized MediaPlayer[] getMediaPlayers() {
        int num = this.mediaPlayers == null ? 0 : this.mediaPlayers.length;
        MediaPlayer[] arr = new MediaPlayer[num];
        if (num > 0) {
            System.arraycopy(this.mediaPlayers, 0, arr, 0, num);
        }
        return arr;
    }

    public synchronized void setMediaPlayers(MediaPlayer[] mediaPlayers) {
        this.mediaPlayers = mediaPlayers;
        this.mediaTablePanel.setMediaPlayers(mediaPlayers);
        MediaPlayer oldPlayer = this.getMediaPlayer();
        if (oldPlayer == null && mediaPlayers != null && mediaPlayers.length > 0) {
            MediaPlayer newPlayer = null;
            if (this.mediaPlayerName != null) {
                for (int i = 0; i < mediaPlayers.length; ++i) {
                    MediaPlayer player = mediaPlayers[i];
                    if (player == null || !this.mediaPlayerName.equals(player.getPlayerName())) continue;
                    newPlayer = player;
                    break;
                }
            }
            if (newPlayer != null) {
                this.setMediaPlayer(newPlayer);
            }
        }
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public synchronized void setMediaPlayer(MediaPlayer mediaPlayer) {
        if (this.mediaPlayer == mediaPlayer) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("setMediaPlayer: " + this + " => " + mediaPlayer);
        }
        this.mediaPlayer = mediaPlayer;
        this.mediaPlayerName = mediaPlayer == null ? null : mediaPlayer.getPlayerName();
        this.mediaTablePanel.setMediaPlayer(mediaPlayer);
    }

    public String getMediaPlayerName() {
        return this.mediaPlayerName;
    }

    public void setMediaPlayerName(String mediaPlayerName) {
        this.mediaPlayerName = mediaPlayerName;
    }

    public boolean navigateMove(int amount) {
        int focus = this.focusPanelIndex;
        if (focus == 0) {
            MediaTreeViewPanel mtvp = this.mediaTreePanel;
            if (mtvp != null) {
                return mtvp.moveMediaCursor(amount);
            }
            return false;
        }
        if (focus == 1) {
            MediaTableViewPanel mtvp = this.mediaTablePanel;
            if (mtvp != null) {
                return mtvp.moveMediaCursor(amount);
            }
            return false;
        }
        return false;
    }

    public boolean navigatePush(MediaPlayer player) {
        int focus = this.focusPanelIndex;
        if (focus == 0) {
            MediaTreeViewPanel mtvp = this.mediaTreePanel;
            if (mtvp != null) {
                return mtvp.pushMediaCursor(player);
            }
            return false;
        }
        if (focus == 1) {
            MediaTableViewPanel mtvp = this.mediaTablePanel;
            if (mtvp != null) {
                return mtvp.pushMediaCursor(player);
            }
            return false;
        }
        return false;
    }

    public boolean navigateBack() {
        int focus = this.focusPanelIndex;
        if (focus == 0) {
            MediaTreeViewPanel mtvp = this.mediaTreePanel;
            if (mtvp != null) {
                return mtvp.backMediaCursor();
            }
            return false;
        }
        if (focus == 1) {
            this.navigateCrateTree();
            return true;
        }
        return false;
    }

    public int getFocusPanelIndex() {
        return this.focusPanelIndex;
    }

    public void setFocusPanelIndex(int focusPanelIndex) {
        this.focusPanelIndex = focusPanelIndex;
    }

    public void showFontDialog() {
        String initialSelectionValue;
        Object[] selectionValues;
        Icon icon;
        int messageType;
        String title;
        String message;
        Object result;
        String fontName = null;
        int fontSize = 12;
        Font font = this.normalFont;
        if (font != null) {
            fontName = font.getName();
            fontSize = font.getSize();
        }
        if ((result = JOptionPane.showInputDialog(this, message = "Font Size:", title = "Font", messageType = -1, icon = null, selectionValues = null, initialSelectionValue = Integer.toString(fontSize))) == null) {
            return;
        }
        try {
            fontSize = Integer.parseInt(String.valueOf(result).trim());
            if (fontSize < 1) {
                return;
            }
            if (fontSize > 100) {
                return;
            }
            this.applyFont(fontName, fontSize);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    protected void applyFont(String name, int size) {
        this.normalFont = new Font(name, 0, size);
        this.activeFont = new Font(name, 1, size);
        this.applyFont();
    }

    public void applyFont() {
        this.mediaTablePanel.setNormalFont(this.normalFont);
        this.mediaTablePanel.setActiveFont(this.activeFont);
        this.mediaTablePanel.applyTableFont();
        this.mediaTreePanel.setNormalFont(this.normalFont);
        this.mediaTreePanel.setActiveFont(this.activeFont);
        this.mediaTreePanel.applyTreeFont();
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public void setNormalFont(Font normalFont) {
        this.normalFont = normalFont;
    }

    public Font getActiveFont() {
        return this.activeFont;
    }

    public void setActiveFont(Font activeFont) {
        this.activeFont = activeFont;
    }

    protected JSplitPane getSplitPane() {
        return this.splitPane;
    }

    protected class FocusSearchFieldAction
    extends AbstractAction {
        private static final long serialVersionUID = -5645647896403L;
        protected static final String ACTION_KEY = "focusSearchField";

        protected FocusSearchFieldAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaManagerPanel.this.textFieldSearch.selectAll();
            MediaManagerPanel.this.textFieldSearch.requestFocus();
        }
    }

    protected class RefreshMediaPlayersImpl
    implements Runnable {
        protected RefreshMediaPlayersImpl() {
        }

        @Override
        public void run() {
            MediaManagerPanel.this.refreshMediaPlayersImpl();
        }
    }

    protected class LoadAsync
    implements Runnable {
        private List crates;

        public LoadAsync(List crates) {
            this.crates = crates;
        }

        @Override
        public void run() {
            MediaManagerPanel.this.loadEntries(this, this.crates);
        }
    }

    protected class ToolContextImpl
    extends AbstractToolContext
    implements MediaManagerToolContext {
        public Workbench getWorkbench() {
            Perspective pers = this.getPerspective();
            if (pers != null) {
                return pers.getWorkbench();
            }
            return null;
        }

        public Perspective getPerspective() {
            return MediaManagerPanel.this.mediaManagerView.getPerspective();
        }

        public View getView() {
            return MediaManagerPanel.this.mediaManagerView;
        }

        @Override
        public MediaManagerPanel getMediaManagerPanel() {
            return MediaManagerPanel.this;
        }

        @Override
        public void showOpenCrateDialog() {
            MediaManagerPanel.this.showOpenCrateDialog();
        }

        @Override
        public void showSaveCrateDialog() {
            MediaManagerPanel.this.showSaveCrateDialog();
        }

        @Override
        public void saveCrates() {
            try {
                MediaManagerPanel.this.saveCrates();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        @Override
        public void loadSelectedCrates() {
            MediaManagerPanel.this.actionLoadEntries(true);
        }

        @Override
        public boolean isAutoLoadSelectedCrates() {
            return MediaManagerPanel.this.mediaTreePanel.isAutoLoadSelectedCrates();
        }

        @Override
        public void setAutoLoadSelectedCrates(boolean enabled) {
            MediaManagerPanel.this.mediaTreePanel.setAutoLoadSelectedCrates(enabled);
        }

        @Override
        public boolean navigateCrateTree(MediaPlayer player) {
            return MediaManagerPanel.this.navigateCrateTree();
        }

        @Override
        public boolean navigatePlayList(MediaPlayer player) {
            return MediaManagerPanel.this.navigatePlayList();
        }

        @Override
        public boolean navigateMove(MediaPlayer player, int amount) {
            return MediaManagerPanel.this.navigateMove(amount);
        }

        @Override
        public boolean navigatePush(MediaPlayer player) {
            return MediaManagerPanel.this.navigatePush(player);
        }

        @Override
        public boolean navigateBack(MediaPlayer player) {
            return MediaManagerPanel.this.navigateBack();
        }
    }
}

