/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Extension;
import com.spacekiller.util.ExtensionPoint;
import com.spacekiller.util.ListenerList;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.PluginDescriptor;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.Resource;
import com.spacekiller.util.format.FileFormatDetector;
import com.spacekiller.util.format.FileFormatManager;
import com.spacekiller.util.heap.AreaConfig;
import com.spacekiller.util.heap.DefaultAreaConfig;
import com.spacekiller.util.heap.DefaultHeapConfig;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.heap.HeapConfig;
import com.spacekiller.util.heap.HeapManager;
import com.spacekiller.util.heap.ManagedHeap;
import com.spacekiller.util.heap.plugin.HeapManagerPlugin;
import com.spacekiller.util.media.DefaultMediaAnalyzer;
import com.spacekiller.util.media.DirectoryMediaIndex;
import com.spacekiller.util.media.MediaAnalyzer;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.DefaultMediaContext;
import com.spacekiller.util.media.library.LibraryFile;
import com.spacekiller.util.media.library.LibraryFileMediaLibrary;
import com.spacekiller.util.media.library.LibraryFileUtil;
import com.spacekiller.util.media.library.dir.CachedDirectoryMediaIndex;
import com.spacekiller.util.media.library.dir.DefaultDirectoryMediaIndex;
import com.spacekiller.util.media.manager.MediaManagerPluginListener;
import com.spacekiller.util.media.manager.MediaManagerViewProvider;
import com.spacekiller.util.media.manager.MediaTableEntryPool;
import com.spacekiller.util.media.manager.MultiMediaScanner;
import com.spacekiller.util.sound.SoundSystem;
import com.spacekiller.util.sound.plugin.SoundPlugin;
import com.spacekiller.util.tooling.ToolGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MediaManagerPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(MediaManagerPlugin.class.getName());
    public static final String MEDIA_MANAGER_PLUGIN_ID = "com.spacekiller.util.media.manager.plugin";
    public static final String MEDIA_MANAGER_VIEW_PROVIDER_ID = "MediaManagerViewProvider";
    public static final String PLAY_WITH_MENU_GROUP_ID = "Menu_MediaManager_PlayWith";
    private static final String DEFAULT_MEDIA_LIBRARY_FILE_NAME = "media.registry";
    private static final String DIRECTORY_CACHE_LIBRARY_FILE_NAME = "media.directory";
    private static final int DEFAULT_ENTRY_POOL_SIZE = 100000;
    private static final int DEFAULT_ENTRY_POOL_LIMIT = 200000;
    private static final int DEFAULT_HEAP_PAGE_SIZE = 0x100000;
    private static final long DEFAULT_JAVA_HEAP_SIZE = 0x8000000L;
    private static final long DEFAULT_DIRECT_HEAP_SIZE = 0L;
    private static final long DEFAULT_SWAP_FILE_SIZE = -1L;
    private static final int DEFAULT_BLOCK_SIZE = 262144;
    private static final int DEFAULT_COPY_BUFFER_SIZE = 262144;
    private SoundSystem soundSystem;
    private BaseMediaContext mediaContext;
    private LibraryFile mediaLibraryFile;
    private LibraryFileMediaLibrary mediaLibrary;
    private LibraryFile directoryLibraryFile;
    private DirectoryMediaIndex directoryMediaIndex;
    private ManagedHeap managedHeap;
    private MediaScanner mediaScanner;
    private List mediaScanners = new ArrayList();
    private MediaAnalyzer mediaAnalyzer;
    private List mediaAnalyzers = new ArrayList();
    private List mediaPlayers = new ArrayList();
    private Map mediaPlayerMap = new HashMap();
    private MediaTableEntryPool mediaTableEntryPool;
    private ListenerList<MediaManagerPluginListener> pluginListeners = new ListenerList(MediaManagerPluginListener.class);

    public static MediaManagerPlugin getInstance() throws Exception {
        return (MediaManagerPlugin)Platform.getInstance().getPlugin(MEDIA_MANAGER_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        MediaManagerPlugin mediaManagerPlugin = this;
        synchronized (mediaManagerPlugin) {
            LibraryFile dirCacheFile;
            LibraryFile libraryFile = this.getMediaLibraryFile();
            if (libraryFile != null) {
                try {
                    libraryFile.close();
                    libraryFile = null;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if ((dirCacheFile = this.getDirectoryLibraryFile()) != null) {
                try {
                    dirCacheFile.close();
                    dirCacheFile = null;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        super.shutdown();
    }

    protected LibraryFile getMediaLibraryFile() {
        return this.mediaLibraryFile;
    }

    protected void setMediaLibraryFile(LibraryFile libraryFile) {
        this.mediaLibraryFile = libraryFile;
    }

    protected LibraryFile getDirectoryLibraryFile() {
        return this.directoryLibraryFile;
    }

    protected void setDirectoryLibraryFile(LibraryFile directoryLibraryFile) {
        this.directoryLibraryFile = directoryLibraryFile;
    }

    protected BaseMediaContext createMediaContext() throws IOException {
        MediaContext parent = null;
        DirectoryMediaIndex index = this.getDirectoryMediaIndex();
        SoundSystem soundSystem = this.getSoundSystem();
        Heap mediaHeap = this.getMediaHeap();
        int blockSize = 262144;
        return new DefaultMediaContext(parent, index, soundSystem, mediaHeap, blockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseMediaContext getMediaContext() throws IOException {
        if (this.mediaContext == null) {
            MediaManagerPlugin mediaManagerPlugin = this;
            synchronized (mediaManagerPlugin) {
                if (this.mediaContext == null) {
                    this.setMediaContext(this.createMediaContext());
                }
            }
        }
        return this.mediaContext;
    }

    private void setMediaContext(BaseMediaContext mediaContext) {
        this.mediaContext = mediaContext;
    }

    protected DirectoryMediaIndex createDirectoryMediaIndex() {
        DefaultDirectoryMediaIndex index = null;
        DefaultDirectoryMediaIndex defaultIndex = new DefaultDirectoryMediaIndex();
        try {
            MediaContext context = null;
            LibraryFile directoryLibraryFile = this.getDirectoryLibraryFile();
            if (directoryLibraryFile == null) {
                File configDir = Platform.getInstance().getConfigDir();
                File libFile = new File(configDir, DIRECTORY_CACHE_LIBRARY_FILE_NAME);
                boolean readOnly = false;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Opening directory cache file: " + libFile);
                }
                directoryLibraryFile = this.openLibraryFile(libFile, readOnly, context);
                this.setDirectoryLibraryFile(directoryLibraryFile);
            }
            CachedDirectoryMediaIndex cachedIndex = new CachedDirectoryMediaIndex((DirectoryMediaIndex)defaultIndex, directoryLibraryFile);
            index = cachedIndex;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (index == null) {
            index = defaultIndex;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DirectoryMediaIndex: " + index);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectoryMediaIndex getDirectoryMediaIndex() {
        if (this.directoryMediaIndex == null) {
            MediaManagerPlugin mediaManagerPlugin = this;
            synchronized (mediaManagerPlugin) {
                if (this.directoryMediaIndex == null) {
                    this.setDirectoryMediaIndex(this.createDirectoryMediaIndex());
                }
            }
        }
        return this.directoryMediaIndex;
    }

    private void setDirectoryMediaIndex(DirectoryMediaIndex directoryMediaIndex) {
        this.directoryMediaIndex = directoryMediaIndex;
    }

    protected synchronized LibraryFileMediaLibrary createMediaLibrary() throws IOException {
        BaseMediaContext context = this.getMediaContext();
        MediaScanner scanner = this.getMediaScanner();
        MediaAnalyzer analyzer = this.getMediaAnalyzer();
        LibraryFile libraryFile = this.getMediaLibraryFile();
        if (libraryFile == null) {
            File configDir = Platform.getInstance().getConfigDir();
            File libFile = new File(configDir, DEFAULT_MEDIA_LIBRARY_FILE_NAME);
            boolean readOnly = false;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Opening media library file: " + libFile);
            }
            libraryFile = this.openLibraryFile(libFile, readOnly, (MediaContext)context);
            this.setMediaLibraryFile(libraryFile);
        }
        String libraryId = "";
        LibraryFileMediaLibrary mediaLib = new LibraryFileMediaLibrary(libraryId, context, libraryFile, scanner, analyzer);
        context.registerMediaLibrary((MediaLibrary)mediaLib);
        return mediaLib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaLibrary getMediaLibrary() throws IOException {
        if (this.mediaLibrary == null) {
            MediaManagerPlugin mediaManagerPlugin = this;
            synchronized (mediaManagerPlugin) {
                if (this.mediaLibrary == null) {
                    this.setMediaLibrary(this.createMediaLibrary());
                }
            }
        }
        return this.mediaLibrary;
    }

    protected void setMediaLibrary(LibraryFileMediaLibrary mediaLibrary) {
        this.mediaLibrary = mediaLibrary;
    }

    protected synchronized LibraryFile openLibraryFile(File libFile, boolean readOnly, MediaContext context) throws IOException {
        LibraryFile libraryFile = LibraryFileUtil.openLibraryFile((MediaContext)context, (File)libFile, (boolean)readOnly);
        return libraryFile;
    }

    public long checkMediaLibrary() throws IOException {
        this.getMediaLibrary();
        LibraryFile libFile = this.getMediaLibraryFile();
        if (libFile == null) {
            return 0L;
        }
        return libFile.check();
    }

    public long compactMediaLibrary() throws IOException {
        this.getMediaLibrary();
        LibraryFile libFile = this.getMediaLibraryFile();
        if (libFile == null) {
            return 0L;
        }
        return libFile.compact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long exportMediaLibrary(File targetFile) throws IOException {
        MediaLibrary library = this.getMediaLibrary();
        MediaContext context = library.getContext();
        LibraryFile libFile = this.getMediaLibraryFile();
        if (libFile == null) {
            return 0L;
        }
        LinkedList entries = new LinkedList();
        libFile.getAllMediaEntries(entries);
        int exportedCount = 0;
        boolean readOnly = false;
        LibraryFile exportLibFile = LibraryFileUtil.openLibraryFile((MediaContext)context, (File)targetFile, (boolean)readOnly);
        try {
            for (MediaEntry me : entries) {
                Resource res;
                if (me == null || (res = me.getResource()) == null) continue;
                exportLibFile.putMediaEntry(res, me);
                ++exportedCount;
            }
        }
        finally {
            exportLibFile.close();
        }
        return exportedCount;
    }

    public void clearDirectoryCache() throws IOException {
        DirectoryMediaIndex index = this.getDirectoryMediaIndex();
        index.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            MediaManagerPlugin mediaManagerPlugin = this;
            synchronized (mediaManagerPlugin) {
                if (this.mediaScanner == null) {
                    this.setMediaScanner(this.createMediaScanner());
                }
            }
        }
        return this.mediaScanner;
    }

    protected void setMediaScanner(MediaScanner mediaScanner) {
        this.mediaScanner = mediaScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaScanner createMediaScanner() {
        MediaScanner[] scanners;
        List list = this.mediaScanners;
        synchronized (list) {
            scanners = this.mediaScanners.toArray(new MediaScanner[this.mediaScanners.size()]);
        }
        FileFormatDetector detector = FileFormatManager.getInstance().createFileFormatDetector();
        MultiMediaScanner scanner = new MultiMediaScanner(scanners, detector);
        return scanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaAnalyzer getMediaAnalyzer() {
        if (this.mediaAnalyzer == null) {
            MediaManagerPlugin mediaManagerPlugin = this;
            synchronized (mediaManagerPlugin) {
                if (this.mediaAnalyzer == null) {
                    this.setMediaAnalyzer(this.createMediaAnalyzer());
                }
            }
        }
        return this.mediaAnalyzer;
    }

    protected void setMediaAnalyzer(MediaAnalyzer mediaAnalyzer) {
        this.mediaAnalyzer = mediaAnalyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaAnalyzer createMediaAnalyzer() {
        MediaAnalyzer[] analyzers;
        List list = this.mediaAnalyzers;
        synchronized (list) {
            analyzers = this.mediaAnalyzers.toArray(new MediaAnalyzer[this.mediaAnalyzers.size()]);
        }
        DefaultMediaAnalyzer analyzer = new DefaultMediaAnalyzer(analyzers);
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extensionAvailable(ExtensionPoint point, Extension x) {
        super.extensionAvailable(point, x);
        String pointId = point.getId();
        if ("com.spacekiller.util.media.MediaScanner".equals(pointId)) {
            block16: {
                try {
                    Object obj = this.getExtensionInstance(x);
                    if (obj instanceof MediaScanner) {
                        MediaScanner scanner = (MediaScanner)obj;
                        List list = this.mediaScanners;
                        synchronized (list) {
                            this.mediaScanners.add(scanner);
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("MediaScanner: " + scanner);
                        }
                        break block16;
                    }
                    logger.warning("Invalid MediaScanner class: " + obj.getClass().getName());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return;
        }
        if ("com.spacekiller.util.media.MediaAnalyzer".equals(pointId)) {
            block17: {
                try {
                    Object obj = this.getExtensionInstance(x);
                    if (obj instanceof MediaAnalyzer) {
                        MediaAnalyzer analyzer = (MediaAnalyzer)obj;
                        List list = this.mediaAnalyzers;
                        synchronized (list) {
                            this.mediaAnalyzers.add(analyzer);
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("MediaAnalyzer: " + analyzer);
                        }
                        break block17;
                    }
                    logger.warning("Invalid MediaAnalyzer class: " + obj.getClass().getName());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return;
        }
        logger.info("extensionAvailable: " + x);
    }

    public SoundSystem getSoundSystem() {
        if (this.soundSystem == null) {
            this.setSoundSystem(this.lookupSoundSystem());
        }
        return this.soundSystem;
    }

    protected void setSoundSystem(SoundSystem soundSystem) {
        this.soundSystem = soundSystem;
    }

    protected SoundSystem lookupSoundSystem() {
        try {
            return SoundPlugin.getInstance().getSoundSystem();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public Heap getMediaHeap() throws IOException {
        return this.getManagedHeap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Heap getManagedHeap() throws IOException {
        if (this.managedHeap == null) {
            MediaManagerPlugin mediaManagerPlugin = this;
            synchronized (mediaManagerPlugin) {
                if (this.managedHeap == null) {
                    this.setManagedHeap(this.createManagedHeap());
                }
            }
        }
        return this.managedHeap;
    }

    protected void setManagedHeap(ManagedHeap mediaHeap) {
        this.managedHeap = mediaHeap;
    }

    protected ManagedHeap createManagedHeap() throws IOException {
        DefaultHeapConfig config = null;
        try {
            Object obj;
            boolean useCustomHeap;
            PreferencesRegistry registry = Platform.getInstance().getPreferencesRegistry();
            Preferences prefs = registry.getPreferences("media-manager");
            if (prefs != null && prefs.contains("customHeapEnabled") && (useCustomHeap = prefs.getBoolean("customHeapEnabled")) && prefs.contains("customHeapConfig") && (obj = prefs.getObject("customHeapConfig")) != null && obj instanceof HeapConfig) {
                config = (HeapConfig)obj;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (config == null) {
            config = MediaManagerPlugin.createDefaultHeapConfig();
        }
        try {
            HeapManagerPlugin heapManagerPlugin = HeapManagerPlugin.getInstance();
            if (heapManagerPlugin == null) {
                throw new RuntimeException("HeapManagerPlugin is not available !");
            }
            HeapManager manager = heapManagerPlugin.getHeapManager();
            if (manager == null) {
                throw new RuntimeException("HeapManager is not available !");
            }
            ManagedHeap heap = manager.createHeap((HeapConfig)config);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created media heap: " + heap);
            }
            return heap;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static DefaultHeapConfig createDefaultHeapConfig() {
        DefaultHeapConfig config = new DefaultHeapConfig();
        config.setName("Media-Heap");
        config.setDefaultPageSize(0x100000);
        config.setCopyBufferSize(262144);
        config.setJavaHeapPreferred(true);
        DefaultAreaConfig javaHeapAreaConfig = new DefaultAreaConfig();
        javaHeapAreaConfig.setMaxAreaSize(0x8000000L);
        javaHeapAreaConfig.setAreaEnabled(javaHeapAreaConfig.getMaxAreaSize() > 0L);
        config.setJavaHeapAreaConfig((AreaConfig)javaHeapAreaConfig);
        DefaultAreaConfig directHeapAreaConfig = new DefaultAreaConfig();
        directHeapAreaConfig.setMaxAreaSize(0L);
        directHeapAreaConfig.setAreaEnabled(directHeapAreaConfig.getMaxAreaSize() > 0L);
        config.setDirectHeapAreaConfig((AreaConfig)directHeapAreaConfig);
        DefaultAreaConfig swapFileAreaConfig = new DefaultAreaConfig();
        swapFileAreaConfig.setAreaEnabled(true);
        swapFileAreaConfig.setMaxAreaSize(-1L);
        config.setSwapFileAreaConfig((AreaConfig)swapFileAreaConfig);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaTableEntryPool getMediaTableEntryPool() {
        if (this.mediaTableEntryPool == null) {
            MediaManagerPlugin mediaManagerPlugin = this;
            synchronized (mediaManagerPlugin) {
                if (this.mediaTableEntryPool == null) {
                    this.setMediaTableEntryPool(this.createMediaTableEntryPool());
                }
            }
        }
        return this.mediaTableEntryPool;
    }

    protected void setMediaTableEntryPool(MediaTableEntryPool mediaTableEntryPool) {
        this.mediaTableEntryPool = mediaTableEntryPool;
    }

    protected MediaTableEntryPool createMediaTableEntryPool() {
        int size = 100000;
        int limit = 200000;
        return new MediaTableEntryPool(size, limit);
    }

    public void addPluginListener(MediaManagerPluginListener listener) {
        if (listener == null) {
            return;
        }
        this.pluginListeners.add((Object)listener);
    }

    public void removePluginListener(MediaManagerPluginListener listener) {
        if (listener == null) {
            return;
        }
        this.pluginListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerMediaPlayer(MediaPlayer player, Object owner) {
        if (player == null || owner == null) {
            return false;
        }
        List list = this.mediaPlayers;
        synchronized (list) {
            if (this.mediaPlayerMap.containsKey(player)) {
                return false;
            }
            this.mediaPlayerMap.put(player, owner);
            this.mediaPlayers.add(player);
            for (MediaManagerPluginListener l : (MediaManagerPluginListener[])this.pluginListeners.array()) {
                l.mediaPlayerAdded(player);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterMediaPlayer(MediaPlayer player, Object owner) {
        if (player == null || owner == null) {
            return false;
        }
        List list = this.mediaPlayers;
        synchronized (list) {
            Object realOwner = this.mediaPlayerMap.get(player);
            if (realOwner == null || realOwner != owner) {
                return false;
            }
            this.mediaPlayerMap.remove(player);
            this.mediaPlayers.remove(player);
            for (MediaManagerPluginListener l : (MediaManagerPluginListener[])this.pluginListeners.array()) {
                l.mediaPlayerRemoved(player);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaPlayer[] getMediaPlayers() {
        List list = this.mediaPlayers;
        synchronized (list) {
            return this.mediaPlayers.toArray(new MediaPlayer[this.mediaPlayers.size()]);
        }
    }

    public ToolGroup getPlayWithMenuGroup() throws Exception {
        PluginDescriptor descr = this.getDescriptor();
        if (descr == null) {
            return null;
        }
        Extension ext = descr.getExtension(PLAY_WITH_MENU_GROUP_ID);
        if (ext == null) {
            return null;
        }
        return (ToolGroup)this.getExtensionInstance(ext);
    }

    public MediaManagerViewProvider getMediaManagerViewProvider() throws Exception {
        PluginDescriptor descr = this.getDescriptor();
        if (descr == null) {
            return null;
        }
        Extension ext = descr.getExtension(MEDIA_MANAGER_VIEW_PROVIDER_ID);
        if (ext == null) {
            return null;
        }
        return (MediaManagerViewProvider)((Object)this.getExtensionInstance(ext));
    }
}

