/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.heap.DefaultHeapConfig;
import com.spacekiller.util.heap.HeapConfig;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.media.manager.MediaManagerPreferencesPanel;
import com.spacekiller.util.workbench.AbstractPreferencesPage;
import com.spacekiller.util.workbench.View;
import java.awt.Component;

public class MediaManagerPreferencesPage
extends AbstractPreferencesPage {
    public static final String PREFERENCES_MEDIA_MANAGER = "media-manager";
    public static final String PROPERTY_CUSTOM_HEAP_ENABLED = "customHeapEnabled";
    public static final String PROPERTY_CUSTOM_HEAP_CONFIG = "customHeapConfig";
    private PreferencesRegistry registry;
    private MediaManagerPreferencesPanel mediaManagerPreferencesPanel;

    protected MediaManagerPreferencesPanel createMediaManagerPreferencesPanel() {
        return new MediaManagerPreferencesPanel();
    }

    public MediaManagerPreferencesPanel getMediaManagerPreferencesPanel() {
        if (this.mediaManagerPreferencesPanel == null) {
            this.setMediaManagerPreferencesPanel(this.createMediaManagerPreferencesPanel());
        }
        return this.mediaManagerPreferencesPanel;
    }

    public void setMediaManagerPreferencesPanel(MediaManagerPreferencesPanel mediaManagerPreferencesPanel) {
        this.mediaManagerPreferencesPanel = mediaManagerPreferencesPanel;
    }

    public Component createComponent() {
        return this.getMediaManagerPreferencesPanel();
    }

    public void refreshPreferences(View view) throws Exception {
        MediaManagerPreferencesPanel panel = this.getMediaManagerPreferencesPanel();
        boolean useCustomHeap = false;
        DefaultHeapConfig customConfig = null;
        Preferences prefs = this.getPreferences();
        if (prefs != null) {
            Object obj;
            if (prefs.contains(PROPERTY_CUSTOM_HEAP_ENABLED)) {
                useCustomHeap = prefs.getBoolean(PROPERTY_CUSTOM_HEAP_ENABLED);
            }
            if (prefs.contains(PROPERTY_CUSTOM_HEAP_CONFIG) && (obj = prefs.getObject(PROPERTY_CUSTOM_HEAP_CONFIG)) != null && obj instanceof HeapConfig) {
                customConfig = (HeapConfig)obj;
            }
        }
        DefaultHeapConfig defaultConfig = MediaManagerPlugin.createDefaultHeapConfig();
        if (customConfig == null) {
            customConfig = MediaManagerPlugin.createDefaultHeapConfig();
        }
        panel.setDefaultHeapConfig((HeapConfig)defaultConfig);
        panel.setCustomHeapConfig((HeapConfig)customConfig);
        panel.setUseCustomHeap(useCustomHeap);
    }

    public void resetPreferences(View view) throws Exception {
        this.refreshPreferences(view);
    }

    public void savePreferences(View view) throws Exception {
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            this.getRegistry().removePreferences(PREFERENCES_MEDIA_MANAGER);
            prefs = this.getRegistry().createPreferences(PREFERENCES_MEDIA_MANAGER);
        }
        boolean useCustomHeap = this.getMediaManagerPreferencesPanel().isUseCustomHeap();
        HeapConfig customConfig = this.getMediaManagerPreferencesPanel().getCustomHeapConfig();
        if (customConfig != null) {
            prefs.setObject(PROPERTY_CUSTOM_HEAP_CONFIG, (Object)customConfig);
        } else {
            useCustomHeap = false;
        }
        prefs.setBoolean(PROPERTY_CUSTOM_HEAP_ENABLED, useCustomHeap);
        this.getRegistry().savePreferences(prefs);
    }

    protected PreferencesRegistry createRegistry() {
        return Platform.getInstance().getPreferencesRegistry();
    }

    protected PreferencesRegistry getRegistry() {
        if (this.registry == null) {
            this.setRegistry(this.createRegistry());
        }
        return this.registry;
    }

    protected void setRegistry(PreferencesRegistry registry) {
        this.registry = registry;
    }

    protected Preferences getPreferences() throws Exception {
        return this.getRegistry().getPreferences(PREFERENCES_MEDIA_MANAGER);
    }
}

