/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Resource;
import com.spacekiller.util.heap.DefaultHeapConfig;
import com.spacekiller.util.heap.HeapConfig;
import com.spacekiller.util.heap.view.DefaultHeapConfigPanel;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.library.LibraryFile;
import com.spacekiller.util.media.library.LibraryFileFilter;
import com.spacekiller.util.media.library.LibraryFileUtil;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class MediaManagerPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = -473644293721526669L;
    private static final Logger logger = Logger.getLogger(MediaManagerPreferencesPanel.class.getName());
    private HeapConfig defaultHeapConfig;
    private HeapConfig customHeapConfig;
    private boolean useCustomHeap;
    private JRadioButton rdbtnDefaultHeap;
    private JRadioButton rdbtnCustomHeap;
    private JButton btnResetDefaults;
    private JButton btnConfigureHeap;

    public MediaManagerPreferencesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelMediaLibrary = new JPanel();
        panelMediaLibrary.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Media Library", 4, 2, null, null));
        GridBagConstraints gbc_panelMediaLibrary = new GridBagConstraints();
        gbc_panelMediaLibrary.weightx = 1.0;
        gbc_panelMediaLibrary.fill = 1;
        gbc_panelMediaLibrary.insets = new Insets(4, 4, 5, 0);
        gbc_panelMediaLibrary.gridx = 0;
        gbc_panelMediaLibrary.gridy = 0;
        this.add((Component)panelMediaLibrary, gbc_panelMediaLibrary);
        GridBagLayout gbl_panelMediaLibrary = new GridBagLayout();
        gbl_panelMediaLibrary.columnWidths = new int[]{0, 0};
        gbl_panelMediaLibrary.rowHeights = new int[]{0, 0};
        gbl_panelMediaLibrary.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMediaLibrary.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelMediaLibrary.setLayout(gbl_panelMediaLibrary);
        JPanel panel2 = new JPanel();
        GridBagConstraints gbc_panel2 = new GridBagConstraints();
        gbc_panel2.weightx = 1.0;
        gbc_panel2.insets = new Insets(4, 4, 4, 4);
        gbc_panel2.fill = 1;
        gbc_panel2.gridx = 0;
        gbc_panel2.gridy = 0;
        panelMediaLibrary.add((Component)panel2, gbc_panel2);
        panel2.setBorder(null);
        GridBagLayout gbl_panel2 = new GridBagLayout();
        gbl_panel2.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panel2.rowHeights = new int[]{0, 0};
        gbl_panel2.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel2.setLayout(gbl_panel2);
        JButton btnImport = new JButton("Import...");
        btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaManagerPreferencesPanel.this.actionImportLibrary();
            }
        });
        btnImport.setToolTipText("Import media library...");
        btnImport.setMargin(new Insets(2, 4, 2, 4));
        btnImport.setIcon(new ImageIcon(MediaManagerPreferencesPanel.class.getResource("/com/spacekiller/util/media/manager/icons/import-crate_icon16.gif")));
        GridBagConstraints gbc_btnImport = new GridBagConstraints();
        gbc_btnImport.insets = new Insets(0, 0, 0, 5);
        gbc_btnImport.gridx = 0;
        gbc_btnImport.gridy = 0;
        panel2.add((Component)btnImport, gbc_btnImport);
        JButton btnExport = new JButton("Export...");
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaManagerPreferencesPanel.this.actionExportLibrary();
            }
        });
        btnExport.setToolTipText("Export media library...");
        btnExport.setMargin(new Insets(2, 4, 2, 4));
        btnExport.setIcon(new ImageIcon(MediaManagerPreferencesPanel.class.getResource("/com/spacekiller/util/media/manager/icons/export-crate_icon16.gif")));
        GridBagConstraints gbc_btnExport = new GridBagConstraints();
        gbc_btnExport.insets = new Insets(0, 4, 0, 5);
        gbc_btnExport.gridx = 1;
        gbc_btnExport.gridy = 0;
        panel2.add((Component)btnExport, gbc_btnExport);
        JButton btnCompact = new JButton("Compact");
        btnCompact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaManagerPreferencesPanel.this.actionCompactLibrary();
            }
        });
        JButton btnCheck = new JButton("Check");
        btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaManagerPreferencesPanel.this.actionCheckLibrary();
            }
        });
        btnCheck.setIcon(new ImageIcon(MediaManagerPreferencesPanel.class.getResource("/com/spacekiller/util/media/manager/icons/button-settings.gif")));
        btnCheck.setToolTipText("Check media library database...");
        btnCheck.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnCheck = new GridBagConstraints();
        gbc_btnCheck.insets = new Insets(0, 4, 0, 5);
        gbc_btnCheck.gridx = 2;
        gbc_btnCheck.gridy = 0;
        panel2.add((Component)btnCheck, gbc_btnCheck);
        btnCompact.setToolTipText("Compact media library database...");
        btnCompact.setMargin(new Insets(2, 4, 2, 4));
        btnCompact.setIcon(new ImageIcon(MediaManagerPreferencesPanel.class.getResource("/com/spacekiller/util/media/manager/icons/button-settings.gif")));
        GridBagConstraints gbc_btnCompact = new GridBagConstraints();
        gbc_btnCompact.insets = new Insets(0, 4, 0, 0);
        gbc_btnCompact.gridx = 3;
        gbc_btnCompact.gridy = 0;
        panel2.add((Component)btnCompact, gbc_btnCompact);
        JPanel panelDirectoryCache = new JPanel();
        panelDirectoryCache.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Directory Cache", 4, 2, null, null));
        GridBagConstraints gbc_panelDirectoryCache = new GridBagConstraints();
        gbc_panelDirectoryCache.weightx = 1.0;
        gbc_panelDirectoryCache.insets = new Insets(4, 4, 5, 0);
        gbc_panelDirectoryCache.fill = 1;
        gbc_panelDirectoryCache.gridx = 0;
        gbc_panelDirectoryCache.gridy = 1;
        this.add((Component)panelDirectoryCache, gbc_panelDirectoryCache);
        GridBagLayout gbl_panelDirectoryCache = new GridBagLayout();
        gbl_panelDirectoryCache.columnWidths = new int[]{0, 0};
        gbl_panelDirectoryCache.rowHeights = new int[]{0, 0};
        gbl_panelDirectoryCache.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelDirectoryCache.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panelDirectoryCache.setLayout(gbl_panelDirectoryCache);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        panelDirectoryCache.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JButton btnClearCache = new JButton("Clear Cache");
        btnClearCache.setToolTipText("Clear media directory cache");
        btnClearCache.setIcon(new ImageIcon(MediaManagerPreferencesPanel.class.getResource("/com/spacekiller/util/media/manager/icons/cancel_icon12.png")));
        btnClearCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MediaManagerPreferencesPanel.this.actionClearDirectoryCache();
            }
        });
        btnClearCache.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnClearCache = new GridBagConstraints();
        gbc_btnClearCache.gridx = 0;
        gbc_btnClearCache.gridy = 0;
        panel.add((Component)btnClearCache, gbc_btnClearCache);
        JPanel panelMediaHeap = new JPanel();
        panelMediaHeap.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Media Heap", 4, 2, null, null));
        GridBagConstraints gbc_panelMediaHeap = new GridBagConstraints();
        gbc_panelMediaHeap.insets = new Insets(4, 4, 0, 0);
        gbc_panelMediaHeap.fill = 1;
        gbc_panelMediaHeap.gridx = 0;
        gbc_panelMediaHeap.gridy = 2;
        this.add((Component)panelMediaHeap, gbc_panelMediaHeap);
        GridBagLayout gbl_panelMediaHeap = new GridBagLayout();
        gbl_panelMediaHeap.columnWidths = new int[]{0, 0};
        gbl_panelMediaHeap.rowHeights = new int[]{0, 0};
        gbl_panelMediaHeap.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMediaHeap.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelMediaHeap.setLayout(gbl_panelMediaHeap);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.insets = new Insets(4, 4, 4, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        panelMediaHeap.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        this.rdbtnDefaultHeap = new JRadioButton("Default Heap");
        this.rdbtnDefaultHeap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MediaManagerPreferencesPanel.this.refreshHeapConfig();
            }
        });
        JLabel lblHeapinfo = new JLabel("Note: Changes require a restart to take effect.");
        GridBagConstraints gbc_lblHeapinfo = new GridBagConstraints();
        gbc_lblHeapinfo.gridwidth = 3;
        gbc_lblHeapinfo.insets = new Insets(0, 0, 5, 0);
        gbc_lblHeapinfo.gridx = 0;
        gbc_lblHeapinfo.gridy = 0;
        panel_1.add((Component)lblHeapinfo, gbc_lblHeapinfo);
        lblHeapinfo.setIcon(new ImageIcon(MediaManagerPreferencesPanel.class.getResource("/com/spacekiller/util/media/manager/icons/crate-refresh_icon16.png")));
        this.rdbtnDefaultHeap.setToolTipText("Use default heap settings");
        GridBagConstraints gbc_rdbtnDefaultHeap = new GridBagConstraints();
        gbc_rdbtnDefaultHeap.anchor = 17;
        gbc_rdbtnDefaultHeap.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnDefaultHeap.gridx = 0;
        gbc_rdbtnDefaultHeap.gridy = 1;
        panel_1.add((Component)this.rdbtnDefaultHeap, gbc_rdbtnDefaultHeap);
        this.rdbtnCustomHeap = new JRadioButton("Custom Heap");
        this.rdbtnCustomHeap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MediaManagerPreferencesPanel.this.refreshHeapConfig();
            }
        });
        this.rdbtnCustomHeap.setToolTipText("Use custom heap settings");
        GridBagConstraints gbc_rdbtnCustomHeap = new GridBagConstraints();
        gbc_rdbtnCustomHeap.insets = new Insets(4, 4, 5, 5);
        gbc_rdbtnCustomHeap.anchor = 17;
        gbc_rdbtnCustomHeap.gridx = 0;
        gbc_rdbtnCustomHeap.gridy = 2;
        panel_1.add((Component)this.rdbtnCustomHeap, gbc_rdbtnCustomHeap);
        this.btnConfigureHeap = new JButton("Configure...");
        this.btnConfigureHeap.setToolTipText("Open config dialog...");
        this.btnConfigureHeap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaManagerPreferencesPanel.this.actionConfigureHeap();
            }
        });
        this.btnConfigureHeap.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnConfigureHeap = new GridBagConstraints();
        gbc_btnConfigureHeap.insets = new Insets(0, 0, 0, 5);
        gbc_btnConfigureHeap.anchor = 13;
        gbc_btnConfigureHeap.gridx = 1;
        gbc_btnConfigureHeap.gridy = 2;
        panel_1.add((Component)this.btnConfigureHeap, gbc_btnConfigureHeap);
        this.btnResetDefaults = new JButton("Reset Defaults");
        this.btnResetDefaults.setToolTipText("Reset to default settings");
        GridBagConstraints gbc_btnResetDefaults = new GridBagConstraints();
        gbc_btnResetDefaults.anchor = 13;
        gbc_btnResetDefaults.gridx = 2;
        gbc_btnResetDefaults.gridy = 2;
        panel_1.add((Component)this.btnResetDefaults, gbc_btnResetDefaults);
        this.btnResetDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaManagerPreferencesPanel.this.actionResetDefaults();
            }
        });
        this.btnResetDefaults.setMargin(new Insets(2, 4, 2, 4));
        this.initMediaManagerPreferencesPanel();
    }

    protected void initMediaManagerPreferencesPanel() {
        ButtonGroup heapButtonGroup = new ButtonGroup();
        heapButtonGroup.add(this.getRdbtnDefaultHeap());
        heapButtonGroup.add(this.getRdbtnCustomHeap());
        this.getRdbtnDefaultHeap().setSelected(true);
        this.refreshHeapConfig();
    }

    protected void actionCheckLibrary() {
        try {
            String title = "Check Media Library";
            String message = "Check integrity of the media library ?\n";
            message = message + "Note: This operation may take some time...";
            int optionType = 2;
            int messageType = 1;
            int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
            if (rc != 0) {
                return;
            }
            long blockCount = MediaManagerPlugin.getInstance().checkMediaLibrary();
            String title2 = "Check Media Library";
            String message2 = "Successfully checked media library: " + blockCount + " entries.";
            int messageType2 = 1;
            JOptionPane.showMessageDialog(this, message2, title2, messageType2);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionCompactLibrary() {
        try {
            String title = "Compact Media Library";
            String message = "Are you sure to compact the media library ?\n";
            message = message + "Note: This operation may take some time...";
            int optionType = 2;
            int messageType = 1;
            int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
            if (rc != 0) {
                return;
            }
            long deltaFileSize = MediaManagerPlugin.getInstance().compactMediaLibrary();
            String title2 = "Compact Media Library";
            String message2 = deltaFileSize < 0L ? "Successfully compacted media library: " + -deltaFileSize + " bytes" : "Media library is already compacted.\n";
            int messageType2 = 1;
            JOptionPane.showMessageDialog(this, message2, title2, messageType2);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionImportLibrary() {
        try {
            int messageType;
            int optionType;
            MediaLibrary mediaLibrary = MediaManagerPlugin.getInstance().getMediaLibrary();
            MediaContext mediaContext = mediaLibrary.getContext();
            JFileChooser chooser = new JFileChooser();
            String title = "Import Media Library File";
            chooser.setDialogTitle(title);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter((FileFilter)new LibraryFileFilter());
            int rc = chooser.showOpenDialog(this);
            if (rc != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            logger.info("Loading entries from media library file: " + file);
            LinkedList entries = new LinkedList();
            boolean readOnly = true;
            LibraryFile libraryFile = LibraryFileUtil.openLibraryFile((MediaContext)mediaContext, (File)file, (boolean)readOnly);
            try {
                libraryFile.getAllMediaEntries(entries);
            }
            finally {
                libraryFile.close();
            }
            int count = entries.size();
            logger.info("Number of entries to import: " + count);
            if (count < 1) {
                String message = "Invalid or empty media library file:\n" + file;
                int messageType2 = 2;
                JOptionPane.showMessageDialog(this, message, title, messageType2);
                return;
            }
            String message = "Are you sure to import " + count + " media entries ?";
            rc = JOptionPane.showConfirmDialog(this, message, title, optionType = 2, messageType = 3);
            if (rc != 0) {
                return;
            }
            logger.info("Importing " + count + " media entries...");
            int existingCount = 0;
            int importedCount = 0;
            for (MediaEntry newEntry : entries) {
                Resource res;
                if (newEntry == null || (res = newEntry.getResource()) == null) continue;
                MediaEntry old = mediaLibrary.getMediaEntry(res);
                if (old != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Media entry already exists: " + res);
                    }
                    ++existingCount;
                    continue;
                }
                mediaLibrary.putMediaEntry(res, newEntry);
                ++importedCount;
            }
            message = "Number of imported entries: " + importedCount + " of " + count;
            if (existingCount > 0) {
                message = message + "\nIgnored already existing entries: " + existingCount;
            }
            messageType = 1;
            JOptionPane.showMessageDialog(this, message, title, messageType);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionExportLibrary() {
        try {
            int messageType;
            int optionType;
            String overwriteTitle;
            String overwriteMessage;
            String path;
            JFileChooser chooser = new JFileChooser();
            String title = "Export Media Library File";
            chooser.setDialogTitle(title);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter((FileFilter)new LibraryFileFilter());
            int rc = chooser.showSaveDialog(this);
            if (rc != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            boolean autoFileExtension = true;
            if (autoFileExtension && !(path = file.getPath()).endsWith(".mlf")) {
                path = path + ".mlf";
                file = new File(path);
            }
            if (file.exists() && (rc = JOptionPane.showConfirmDialog(this, overwriteMessage = "Are you sure to overwrite the existing file ?", overwriteTitle = "Overwrite Existing File ?", optionType = 2, messageType = 3)) != 0) {
                return;
            }
            long exportedCount = MediaManagerPlugin.getInstance().exportMediaLibrary(file);
            String message = "Number of exported entries: " + exportedCount;
            messageType = 1;
            JOptionPane.showMessageDialog(this, message, title, messageType);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionClearDirectoryCache() {
        try {
            MediaManagerPlugin.getInstance().clearDirectoryCache();
            String title = "Clear Directory Cache";
            String message = "Directory cache has been cleared successfully.";
            int messageType = 1;
            JOptionPane.showMessageDialog(this, message, title, messageType);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected JRadioButton getRdbtnDefaultHeap() {
        return this.rdbtnDefaultHeap;
    }

    protected JRadioButton getRdbtnCustomHeap() {
        return this.rdbtnCustomHeap;
    }

    public HeapConfig getCustomHeapConfig() {
        return this.customHeapConfig;
    }

    public void setCustomHeapConfig(HeapConfig customHeapConfig) {
        this.customHeapConfig = customHeapConfig;
        this.refreshHeapConfig();
    }

    public HeapConfig getDefaultHeapConfig() {
        return this.defaultHeapConfig;
    }

    public void setDefaultHeapConfig(HeapConfig defaultHeapConfig) {
        this.defaultHeapConfig = defaultHeapConfig;
        this.refreshHeapConfig();
    }

    public boolean isUseCustomHeap() {
        return this.useCustomHeap;
    }

    public void setUseCustomHeap(boolean useCustomHeap) {
        this.useCustomHeap = useCustomHeap;
        if (useCustomHeap) {
            this.rdbtnCustomHeap.setSelected(true);
        } else {
            this.rdbtnDefaultHeap.setSelected(true);
        }
    }

    protected void refreshHeapConfig() {
        this.useCustomHeap = this.rdbtnCustomHeap.isSelected();
        if (this.useCustomHeap) {
            this.btnConfigureHeap.setEnabled(true);
            this.btnResetDefaults.setEnabled(true);
        } else {
            this.btnConfigureHeap.setEnabled(false);
            this.btnResetDefaults.setEnabled(false);
        }
    }

    protected JButton getBtnResetDefaults() {
        return this.btnResetDefaults;
    }

    protected void actionResetDefaults() {
        DefaultHeapConfig newDefaultConfig = MediaManagerPlugin.createDefaultHeapConfig();
        this.setCustomHeapConfig((HeapConfig)newDefaultConfig);
    }

    protected JButton getBtnConfigureHeap() {
        return this.btnConfigureHeap;
    }

    protected void actionConfigureHeap() {
        DefaultHeapConfigPanel configPanel = new DefaultHeapConfigPanel();
        configPanel.setHeapConfig(this.customHeapConfig);
        DefaultHeapConfigPanel message = configPanel;
        String title = "Custom Media Heap";
        int messageType = -1;
        JOptionPane.showMessageDialog(this, message, title, messageType);
    }
}

