/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.beans.AbstractBeansToolkit;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.format.FileFormatDetector;
import com.spacekiller.util.format.FileFormatManager;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.manager.MediaCrateEntryLoadFilter;
import com.spacekiller.util.media.manager.MediaManagerPanel;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.media.manager.MediaManagerPluginListener;
import com.spacekiller.util.media.manager.MediaTableEntryPool;
import com.spacekiller.util.media.manager.MediaTableView;
import com.spacekiller.util.media.manager.MediaTreeView;
import com.spacekiller.util.table.DefaultTableExportWizard;
import com.spacekiller.util.table.TableExportWizard;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoManager;

public class MediaManagerView
extends View {
    private static final Logger logger = Logger.getLogger(MediaManagerView.class.getName());
    public static final String KEY_ROOT_CRATE_PATH = "rootCratePath";
    public static final String KEY_VIEW_PROPERTIES = "viewProperties";
    public static final String KEY_MEDIA_PLAYER_NAME = "mediaPlayerName";
    private MediaManagerPanel mediaManagerPanel;
    private MediaTreeView mediaTreeView;
    private MediaTableView mediaTableView;
    private MediaLibrary mediaLibrary;
    private ThreadPool workerThreadPool;
    private ThreadPool loaderThreadPool;
    private ThreadPool pictureThreadPool;
    private MediaTableEntryPool tableEntryPool;
    private PluginHandler pluginHandler;
    private ToolGroup crateToolBarGroup;
    private ToolGroup crateLoadBarGroup;
    private ToolGroup cratePopupMenuGroup;
    private ToolGroup entryToolBarGroup;
    private ToolGroup entryPopupMenuGroup;
    private ToolGroup tableHeaderPopupMenuGroup;
    private ToolGroup tableCornerPopupMenuGroup;
    private ToolGroup showHideColumnMenuGroup;
    private TableExportWizard tableExportWizard;

    public MediaManagerView() {
        this.initMediaManagerView();
    }

    protected void initMediaManagerView() {
        try {
            this.pluginHandler = new PluginHandler();
            MediaManagerPlugin.getInstance().addPluginListener(this.pluginHandler);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected Component createComponent() {
        return this.getMediaManagerPanel();
    }

    protected synchronized void dispose() {
        MediaManagerPanel mmp = this.mediaManagerPanel;
        if (mmp != null) {
            mmp.actionCancelLoader();
        }
        try {
            MediaManagerPlugin.getInstance().removePluginListener(this.pluginHandler);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("MediaTableEntryPool:" + this.tableEntryPool);
        }
        super.dispose();
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    public MediaLibrary getMediaLibrary() {
        return this.mediaLibrary;
    }

    public void setMediaLibrary(MediaLibrary mediaLibrary) {
        this.mediaLibrary = mediaLibrary;
        MediaManagerPanel mmp = this.mediaManagerPanel;
        if (mmp != null) {
            mmp.setMediaLibrary(mediaLibrary);
        }
    }

    public ToolGroup getCrateToolBarGroup() {
        return this.crateToolBarGroup;
    }

    public void setCrateToolBarGroup(ToolGroup crateToolBarGroup) {
        this.crateToolBarGroup = crateToolBarGroup;
    }

    public ToolGroup getCrateLoadBarGroup() {
        return this.crateLoadBarGroup;
    }

    public void setCrateLoadBarGroup(ToolGroup crateLoadBarGroup) {
        this.crateLoadBarGroup = crateLoadBarGroup;
    }

    public ToolGroup getCratePopupMenuGroup() {
        return this.cratePopupMenuGroup;
    }

    public void setCratePopupMenuGroup(ToolGroup cratePopupMenuGroup) {
        this.cratePopupMenuGroup = cratePopupMenuGroup;
    }

    public ToolGroup getEntryToolBarGroup() {
        return this.entryToolBarGroup;
    }

    public void setEntryToolBarGroup(ToolGroup entryToolBarGroup) {
        this.entryToolBarGroup = entryToolBarGroup;
    }

    public ToolGroup getEntryPopupMenuGroup() {
        return this.entryPopupMenuGroup;
    }

    public void setEntryPopupMenuGroup(ToolGroup entryPopupMenuGroup) {
        this.entryPopupMenuGroup = entryPopupMenuGroup;
    }

    public ToolGroup getTableCornerPopupMenuGroup() {
        return this.tableCornerPopupMenuGroup;
    }

    public void setTableCornerPopupMenuGroup(ToolGroup tableCornerPopupMenuGroup) {
        this.tableCornerPopupMenuGroup = tableCornerPopupMenuGroup;
    }

    public TableExportWizard getTableExportWizard() {
        if (this.tableExportWizard == null) {
            this.setTableExportWizard(this.createTableExportWizard());
        }
        return this.tableExportWizard;
    }

    public void setTableExportWizard(TableExportWizard tableExportWizard) {
        this.tableExportWizard = tableExportWizard;
    }

    protected TableExportWizard createTableExportWizard() {
        return new DefaultTableExportWizard();
    }

    public MediaTreeView getMediaTreeView() {
        return this.mediaTreeView;
    }

    public void setMediaTreeView(MediaTreeView mediaTreeView) {
        this.mediaTreeView = mediaTreeView;
    }

    public MediaTableView getMediaTableView() {
        return this.mediaTableView;
    }

    public void setMediaTableView(MediaTableView mediaTableView) {
        this.mediaTableView = mediaTableView;
    }

    public boolean isDirty() throws Exception {
        if (super.isDirty()) {
            return true;
        }
        MediaManagerPanel panel = this.mediaManagerPanel;
        return panel != null && panel.isDirty();
    }

    public void save() throws Exception {
        super.save();
        MediaManagerPanel panel = this.mediaManagerPanel;
        if (panel != null) {
            panel.saveCrates();
        }
    }

    public synchronized void loadMediaManagerView(Preferences prefs) {
        try {
            if (prefs != null) {
                String name;
                Object mediaPlayerName;
                String path;
                Object rootCratePath;
                Properties props = null;
                Object viewProps = prefs.getObject(KEY_VIEW_PROPERTIES);
                if (viewProps != null && viewProps instanceof Properties) {
                    props = (Properties)viewProps;
                }
                if (props == null) {
                    props = new Properties();
                }
                if ((rootCratePath = prefs.getObject(KEY_ROOT_CRATE_PATH)) != null && (path = String.valueOf(rootCratePath)).length() > 0) {
                    props.setProperty(KEY_ROOT_CRATE_PATH, path);
                }
                if ((mediaPlayerName = prefs.getObject(KEY_MEDIA_PLAYER_NAME)) != null && (name = String.valueOf(mediaPlayerName)).length() > 0) {
                    props.setProperty(KEY_MEDIA_PLAYER_NAME, name);
                }
                this.loadMediaManagerView(props);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void loadMediaManagerView(Properties props) throws Exception {
        File baseDirectory = null;
        this.loadMediaManagerView(props, baseDirectory);
    }

    public synchronized void loadMediaManagerView(Properties props, File baseDirectory) throws Exception {
        String rootCratePath;
        MediaManagerPanel mmp = this.getMediaManagerPanel();
        mmp.loadViewPreferences(props);
        String mediaPlayerName = props.getProperty(KEY_MEDIA_PLAYER_NAME);
        if (mediaPlayerName != null && mediaPlayerName.length() > 0) {
            mmp.setMediaPlayerName(mediaPlayerName);
        }
        if ((rootCratePath = props.getProperty(KEY_ROOT_CRATE_PATH)) != null && rootCratePath.length() > 0) {
            File file;
            if (baseDirectory != null && !(file = new File(rootCratePath)).isAbsolute()) {
                file = new File(baseDirectory, rootCratePath);
                rootCratePath = file.getPath();
            }
            final File finalRootCrateFile = new File(rootCratePath);
            final MediaManagerPanel finalPanel = mmp;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        finalPanel.openRootCrateFile(finalRootCrateFile);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            });
        }
    }

    public synchronized void saveMediaManagerView(Preferences prefs) {
        try {
            MediaManagerPanel mmp = this.mediaManagerPanel;
            if (mmp == null) {
                return;
            }
            Properties props = new Properties();
            this.saveMediaManagerView(props);
            prefs.setObject(KEY_VIEW_PROPERTIES, (Object)props);
            String rootCratePath = props.getProperty(KEY_ROOT_CRATE_PATH);
            prefs.setObject(KEY_ROOT_CRATE_PATH, (Object)rootCratePath);
            String mediaPlayerName = props.getProperty(KEY_MEDIA_PLAYER_NAME);
            prefs.setObject(KEY_MEDIA_PLAYER_NAME, (Object)mediaPlayerName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void saveMediaManagerView(Properties props) {
        File baseDirectory = null;
        this.saveMediaManagerView(props, baseDirectory);
    }

    public synchronized void saveMediaManagerView(Properties props, File baseDirectory) {
        String mediaPlayerName;
        String rootCratePath;
        File rootCrateFile;
        MediaManagerPanel mmp = this.getMediaManagerPanel();
        if (mmp != null) {
            mmp.saveViewPreferences(props);
        }
        if ((rootCrateFile = mmp.getRootCrateFile()) != null && (rootCratePath = rootCrateFile.getPath()) != null) {
            String basePath;
            if (baseDirectory != null && rootCratePath.startsWith(basePath = baseDirectory.getPath() + File.separator)) {
                rootCratePath = rootCratePath.substring(basePath.length());
            }
            props.setProperty(KEY_ROOT_CRATE_PATH, rootCratePath);
        }
        if ((mediaPlayerName = mmp.getMediaPlayerName()) != null) {
            props.setProperty(KEY_MEDIA_PLAYER_NAME, mediaPlayerName);
        }
    }

    public MediaManagerPanel getMediaManagerPanel() {
        if (this.mediaManagerPanel == null) {
            this.setMediaManagerPanel(this.createMediaManagerPanel());
        }
        return this.mediaManagerPanel;
    }

    private void setMediaManagerPanel(MediaManagerPanel mediaManagerPanel) {
        this.mediaManagerPanel = mediaManagerPanel;
    }

    protected MediaManagerPanel createMediaManagerPanel() {
        MediaTableView mediaTableView;
        BeansToolkit btk = Platform.getInstance().getBeansToolkit();
        ClipboardManager cm = null;
        BeanDropSupport bds = null;
        UndoManager undoManager = null;
        if (btk != null && btk instanceof AbstractBeansToolkit) {
            AbstractBeansToolkit abt = (AbstractBeansToolkit)btk;
            cm = abt.getClipboardManager();
            bds = abt.getBeanDropSupport();
            undoManager = abt.getUndoManager();
        }
        MediaManagerPanel mmp = new MediaManagerPanel();
        MediaLibrary lib = this.getMediaLibrary();
        mmp.setMediaLibrary(lib);
        mmp.setBeansToolkit(btk);
        mmp.setClipboardManager(cm);
        mmp.setBeanDropSupport(bds);
        mmp.setUndoManager(undoManager);
        FileFormatDetector fileFormatDetector = FileFormatManager.getInstance().createFileFormatDetector();
        MediaCrateEntryLoadFilter loadFilter = new MediaCrateEntryLoadFilter(fileFormatDetector);
        mmp.setLoadFilter(loadFilter);
        mmp.setMediaManagerView(this);
        JToolBar crateToolBar = null;
        if (this.crateToolBarGroup != null) {
            crateToolBar = (JToolBar)this.crateToolBarGroup.createInstance((ToolContext)mmp.getMediaTreeToolContext(), JToolBar.class);
        }
        JToolBar crateLoadBar = null;
        if (this.crateLoadBarGroup != null) {
            crateLoadBar = (JToolBar)this.crateLoadBarGroup.createInstance((ToolContext)mmp.getMediaTreeToolContext(), JToolBar.class);
        }
        JPopupMenu cratePopupMenu = null;
        if (this.cratePopupMenuGroup != null) {
            cratePopupMenu = (JPopupMenu)this.cratePopupMenuGroup.createInstance((ToolContext)mmp.getMediaTreeToolContext(), JPopupMenu.class);
        }
        JToolBar entryToolBar = null;
        if (this.entryToolBarGroup != null) {
            entryToolBar = (JToolBar)this.entryToolBarGroup.createInstance((ToolContext)mmp.getMediaTableToolContext(), JToolBar.class);
        }
        JPopupMenu entryPopupMenu = null;
        if (this.entryPopupMenuGroup != null) {
            entryPopupMenu = (JPopupMenu)this.entryPopupMenuGroup.createInstance((ToolContext)mmp.getMediaTableToolContext(), JPopupMenu.class);
        }
        JPopupMenu tableHeaderPopupMenu = null;
        if (this.tableHeaderPopupMenuGroup != null) {
            tableHeaderPopupMenu = (JPopupMenu)this.tableHeaderPopupMenuGroup.createInstance((ToolContext)mmp.getMediaTableToolContext(), JPopupMenu.class);
        }
        JPopupMenu tableCornerPopupMenu = null;
        if (this.tableCornerPopupMenuGroup != null) {
            tableCornerPopupMenu = (JPopupMenu)this.tableCornerPopupMenuGroup.createInstance((ToolContext)mmp.getMediaTableToolContext(), JPopupMenu.class);
        }
        mmp.setCrateToolBar(crateToolBar);
        mmp.setCrateLoadBar(crateLoadBar);
        mmp.setCratePopupMenu(cratePopupMenu);
        mmp.setEntryToolBar(entryToolBar);
        mmp.setTableExportWizard(this.getTableExportWizard());
        mmp.setEntryPopupMenu(entryPopupMenu);
        mmp.setTableHeaderPopupMenu(tableHeaderPopupMenu);
        mmp.setTableCornerPopupMenu(tableCornerPopupMenu);
        mmp.setShowHideColumnMenuGroup(this.showHideColumnMenuGroup);
        MediaTreeView mediaTreeView = mmp.getMediaTreeView();
        if (mediaTreeView != null) {
            this.addChild(mediaTreeView);
        }
        if ((mediaTableView = mmp.getMediaTableView()) != null) {
            this.addChild(mediaTableView);
        }
        mmp.setCurrentDirectory(Platform.getInstance().getDataDir());
        mmp.setTableEntryPool(this.tableEntryPool);
        mmp.setWorkerThreadPool(this.workerThreadPool);
        mmp.setLoaderThreadPool(this.loaderThreadPool);
        mmp.setPictureThreadPool(this.pictureThreadPool);
        File rootFile = null;
        try {
            mmp.openRootCrateFileImpl(rootFile);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        mmp.refreshMediaPlayersImpl();
        return mmp;
    }

    public MediaTableEntryPool getTableEntryPool() {
        return this.tableEntryPool;
    }

    public void setTableEntryPool(MediaTableEntryPool tableEntryPool) {
        this.tableEntryPool = tableEntryPool;
    }

    public ToolGroup getTableHeaderPopupMenuGroup() {
        return this.tableHeaderPopupMenuGroup;
    }

    public void setTableHeaderPopupMenuGroup(ToolGroup tableHeaderPopupMenuGroup) {
        this.tableHeaderPopupMenuGroup = tableHeaderPopupMenuGroup;
    }

    public ToolGroup getShowHideColumnMenuGroup() {
        return this.showHideColumnMenuGroup;
    }

    public void setShowHideColumnMenuGroup(ToolGroup showHideColumnMenuGroup) {
        this.showHideColumnMenuGroup = showHideColumnMenuGroup;
    }

    protected ThreadPool getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    protected void setWorkerThreadPool(ThreadPool workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    protected ThreadPool getLoaderThreadPool() {
        return this.loaderThreadPool;
    }

    protected void setLoaderThreadPool(ThreadPool loaderThreadPool) {
        this.loaderThreadPool = loaderThreadPool;
    }

    protected ThreadPool getPictureThreadPool() {
        return this.pictureThreadPool;
    }

    protected void setPictureThreadPool(ThreadPool pictureThreadPool) {
        this.pictureThreadPool = pictureThreadPool;
    }

    protected class PluginHandler
    implements MediaManagerPluginListener {
        protected PluginHandler() {
        }

        @Override
        public void mediaPlayerAdded(MediaPlayer player) {
            MediaManagerPanel mmp = MediaManagerView.this.mediaManagerPanel;
            if (mmp != null) {
                mmp.mediaPlayerAdded(player);
            }
        }

        @Override
        public void mediaPlayerRemoved(MediaPlayer player) {
            MediaManagerPanel mmp = MediaManagerView.this.mediaManagerPanel;
            if (mmp != null) {
                mmp.mediaPlayerRemoved(player);
            }
        }
    }
}

