/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.media.manager.MediaManagerView;
import com.spacekiller.util.media.manager.MediaTableEntryPool;
import com.spacekiller.util.thread.DefaultThreadPool;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.DefaultViewProvider;
import com.spacekiller.util.workbench.View;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MediaManagerViewProvider
extends DefaultViewProvider {
    private static final Logger logger = Logger.getLogger(MediaManagerViewProvider.class.getName());
    private MediaLibrary mediaLibrary;
    private ThreadPool workerThreadPool;
    private ThreadPool loaderThreadPool;
    private ThreadPool pictureThreadPool;
    private MediaTableEntryPool tableEntryPool;
    private ToolGroup crateToolBarGroup;
    private ToolGroup crateLoadBarGroup;
    private ToolGroup cratePopupMenuGroup;
    private ToolGroup entryToolBarGroup;
    private ToolGroup entryPopupMenuGroup;
    private ToolGroup tableHeaderPopupMenuGroup;
    private ToolGroup tableCornerPopupMenuGroup;
    private ToolGroup showHideColumnMenuGroup;

    protected void initView(View v) {
        super.initView(v);
        if (v instanceof MediaManagerView) {
            MediaManagerView mmv = (MediaManagerView)v;
            try {
                mmv.setMediaLibrary(this.getMediaLibrary());
                mmv.setCrateToolBarGroup(this.getCrateToolBarGroup());
                mmv.setCrateLoadBarGroup(this.getCrateLoadBarGroup());
                mmv.setCratePopupMenuGroup(this.getCratePopupMenuGroup());
                mmv.setEntryToolBarGroup(this.getEntryToolBarGroup());
                mmv.setEntryPopupMenuGroup(this.getEntryPopupMenuGroup());
                mmv.setTableHeaderPopupMenuGroup(this.getTableHeaderPopupMenuGroup());
                mmv.setTableCornerPopupMenuGroup(this.getTableCornerPopupMenuGroup());
                mmv.setWorkerThreadPool(this.getWorkerThreadPool());
                mmv.setLoaderThreadPool(this.getLoaderThreadPool());
                mmv.setPictureThreadPool(this.getPictureThreadPool());
                mmv.setTableEntryPool(this.getTableEntryPool());
                mmv.setShowHideColumnMenuGroup(this.getShowHideColumnMenuGroup());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public View loadView(Preferences prefs) throws Exception {
        return super.loadView(prefs);
    }

    protected void loadView(View view, Preferences prefs) throws Exception {
        super.loadView(view, prefs);
        if (view != null && view instanceof MediaManagerView) {
            MediaManagerView mmv = (MediaManagerView)view;
            mmv.loadMediaManagerView(prefs);
        }
    }

    public void saveView(View view, Preferences prefs) throws Exception {
        super.saveView(view, prefs);
        if (view != null && view instanceof MediaManagerView) {
            MediaManagerView mmv = (MediaManagerView)view;
            mmv.saveMediaManagerView(prefs);
        }
    }

    public ToolGroup getCrateToolBarGroup() {
        return this.crateToolBarGroup;
    }

    public void setCrateToolBarGroup(ToolGroup crateToolBarGroup) {
        this.crateToolBarGroup = crateToolBarGroup;
    }

    public ToolGroup getCrateLoadBarGroup() {
        return this.crateLoadBarGroup;
    }

    public void setCrateLoadBarGroup(ToolGroup crateLoadBarGroup) {
        this.crateLoadBarGroup = crateLoadBarGroup;
    }

    public ToolGroup getCratePopupMenuGroup() {
        return this.cratePopupMenuGroup;
    }

    public void setCratePopupMenuGroup(ToolGroup cratePopupMenuGroup) {
        this.cratePopupMenuGroup = cratePopupMenuGroup;
    }

    public ToolGroup getEntryToolBarGroup() {
        return this.entryToolBarGroup;
    }

    public void setEntryToolBarGroup(ToolGroup entryToolBarGroup) {
        this.entryToolBarGroup = entryToolBarGroup;
    }

    public ToolGroup getEntryPopupMenuGroup() {
        return this.entryPopupMenuGroup;
    }

    public void setEntryPopupMenuGroup(ToolGroup entryPopupMenuGroup) {
        this.entryPopupMenuGroup = entryPopupMenuGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaLibrary getMediaLibrary() throws Exception {
        if (this.mediaLibrary == null) {
            MediaManagerViewProvider mediaManagerViewProvider = this;
            synchronized (mediaManagerViewProvider) {
                if (this.mediaLibrary == null) {
                    this.setMediaLibrary(this.lookupMediaLibrary());
                }
            }
        }
        return this.mediaLibrary;
    }

    public void setMediaLibrary(MediaLibrary mediaLibrary) {
        this.mediaLibrary = mediaLibrary;
    }

    protected MediaLibrary lookupMediaLibrary() throws Exception {
        MediaManagerPlugin mmp = MediaManagerPlugin.getInstance();
        return mmp.getMediaLibrary();
    }

    public ToolGroup getTableCornerPopupMenuGroup() {
        return this.tableCornerPopupMenuGroup;
    }

    public void setTableCornerPopupMenuGroup(ToolGroup tableCornerPopupMenuGroup) {
        this.tableCornerPopupMenuGroup = tableCornerPopupMenuGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPool getWorkerThreadPool() {
        if (this.workerThreadPool == null) {
            MediaManagerViewProvider mediaManagerViewProvider = this;
            synchronized (mediaManagerViewProvider) {
                if (this.workerThreadPool == null) {
                    try {
                        this.setWorkerThreadPool(this.createWorkerThreadPool());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        return this.workerThreadPool;
    }

    protected void setWorkerThreadPool(ThreadPool workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    protected ThreadPool createWorkerThreadPool() throws InterruptedException {
        ThreadManager manager = Platform.getInstance().getThreadManager();
        ClassLoader contextLoader = ((Object)((Object)this)).getClass().getClassLoader();
        String namePrefix = "MediaWorker-";
        int priority = 4;
        boolean daemon = true;
        int minThreadCount = 2;
        int maxThreadCount = Integer.MAX_VALUE;
        int idleTimeout = 60000;
        DefaultThreadPool pool = new DefaultThreadPool(manager, namePrefix, priority, daemon, contextLoader, minThreadCount, maxThreadCount, (long)idleTimeout);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPool getLoaderThreadPool() {
        if (this.loaderThreadPool == null) {
            MediaManagerViewProvider mediaManagerViewProvider = this;
            synchronized (mediaManagerViewProvider) {
                if (this.loaderThreadPool == null) {
                    try {
                        this.setLoaderThreadPool(this.createLoaderThreadPool());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        return this.loaderThreadPool;
    }

    protected void setLoaderThreadPool(ThreadPool threadPool) {
        this.loaderThreadPool = threadPool;
    }

    protected ThreadPool createLoaderThreadPool() throws InterruptedException {
        ThreadManager manager = Platform.getInstance().getThreadManager();
        ClassLoader contextLoader = ((Object)((Object)this)).getClass().getClassLoader();
        String namePrefix = "MediaLoader-";
        int priority = 4;
        boolean daemon = true;
        int minThreadCount = 4;
        int maxThreadCount = Integer.MAX_VALUE;
        int idleTimeout = 60000;
        DefaultThreadPool pool = new DefaultThreadPool(manager, namePrefix, priority, daemon, contextLoader, minThreadCount, maxThreadCount, (long)idleTimeout);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPool getPictureThreadPool() {
        if (this.pictureThreadPool == null) {
            MediaManagerViewProvider mediaManagerViewProvider = this;
            synchronized (mediaManagerViewProvider) {
                if (this.pictureThreadPool == null) {
                    try {
                        this.setPictureThreadPool(this.createPictureThreadPool());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        return this.pictureThreadPool;
    }

    protected void setPictureThreadPool(ThreadPool pictureThreadPool) {
        this.pictureThreadPool = pictureThreadPool;
    }

    protected ThreadPool createPictureThreadPool() throws InterruptedException {
        ThreadManager manager = Platform.getInstance().getThreadManager();
        ClassLoader contextLoader = ((Object)((Object)this)).getClass().getClassLoader();
        String namePrefix = "PictureLoader-";
        int priority = 3;
        boolean daemon = true;
        int minThreadCount = 2;
        int maxThreadCount = Integer.MAX_VALUE;
        int idleTimeout = 60000;
        DefaultThreadPool pool = new DefaultThreadPool(manager, namePrefix, priority, daemon, contextLoader, minThreadCount, maxThreadCount, (long)idleTimeout);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaTableEntryPool getTableEntryPool() {
        if (this.tableEntryPool == null) {
            MediaManagerViewProvider mediaManagerViewProvider = this;
            synchronized (mediaManagerViewProvider) {
                if (this.tableEntryPool == null) {
                    try {
                        this.setTableEntryPool(MediaManagerPlugin.getInstance().getMediaTableEntryPool());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.tableEntryPool;
    }

    protected void setTableEntryPool(MediaTableEntryPool tableEntryPool) {
        this.tableEntryPool = tableEntryPool;
    }

    public ToolGroup getTableHeaderPopupMenuGroup() {
        return this.tableHeaderPopupMenuGroup;
    }

    public void setTableHeaderPopupMenuGroup(ToolGroup tableHeaderPopupMenuGroup) {
        this.tableHeaderPopupMenuGroup = tableHeaderPopupMenuGroup;
    }

    public ToolGroup getShowHideColumnMenuGroup() {
        return this.showHideColumnMenuGroup;
    }

    public void setShowHideColumnMenuGroup(ToolGroup showHideColumnMenuGroup) {
        this.showHideColumnMenuGroup = showHideColumnMenuGroup;
    }
}

