/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Tools;
import com.spacekiller.util.media.DefaultMediaMarker;
import com.spacekiller.util.media.MediaMarker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MediaMarkerEditorPanel
extends JPanel {
    private static final long serialVersionUID = 3351000427566111783L;
    public static final String NAME_START_POINT = "Start Pos.";
    public static final String NAME_END_POINT = "End Pos.";
    public static final String NAME_CUE_POINT = "Cue Point";
    public static final String NAME_BAR_POINT = "Bar Pos.";
    public static final String NAME_BEAT_POINT = "Beat Pos.";
    public static final String NAME_SERATO_MARKER = "Serato Marker";
    private static final int[] MARKER_TYPES = new int[]{3, 1, 2, 5, 4, 9};
    private static Icon defaultMarkerIcon;
    private static Icon seratoMarkerIcon;
    private MediaMarker mediaMarker;
    private boolean refreshing;
    private JTextField textFieldName;
    private JTextField textFieldIndex;
    private JComboBox comboBoxType;
    private JTextField textFieldPosition;

    public MediaMarkerEditorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblType = new JLabel("Type:");
        GridBagConstraints gbc_lblType = new GridBagConstraints();
        gbc_lblType.anchor = 17;
        gbc_lblType.insets = new Insets(0, 0, 5, 5);
        gbc_lblType.gridx = 0;
        gbc_lblType.gridy = 0;
        this.add((Component)lblType, gbc_lblType);
        this.comboBoxType = new JComboBox();
        this.comboBoxType.setToolTipText("Marker type");
        this.comboBoxType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MediaMarkerEditorPanel.this.refreshing) {
                    MediaMarkerEditorPanel.this.apply();
                }
            }
        });
        this.comboBoxType.setOpaque(false);
        GridBagConstraints gbc_comboBoxType = new GridBagConstraints();
        gbc_comboBoxType.weightx = 1.0;
        gbc_comboBoxType.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxType.fill = 2;
        gbc_comboBoxType.gridx = 1;
        gbc_comboBoxType.gridy = 0;
        this.add((Component)this.comboBoxType, gbc_comboBoxType);
        JLabel lblName = new JLabel("Name:");
        GridBagConstraints gbc_lblName = new GridBagConstraints();
        gbc_lblName.anchor = 17;
        gbc_lblName.insets = new Insets(0, 0, 5, 5);
        gbc_lblName.gridx = 0;
        gbc_lblName.gridy = 1;
        this.add((Component)lblName, gbc_lblName);
        this.textFieldName = new JTextField();
        this.textFieldName.setToolTipText("Marker name (optional)");
        this.textFieldName.setOpaque(false);
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldName.fill = 2;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 1;
        this.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(10);
        JLabel lblIndex = new JLabel("Index:");
        GridBagConstraints gbc_lblIndex = new GridBagConstraints();
        gbc_lblIndex.anchor = 17;
        gbc_lblIndex.insets = new Insets(0, 0, 5, 5);
        gbc_lblIndex.gridx = 0;
        gbc_lblIndex.gridy = 2;
        this.add((Component)lblIndex, gbc_lblIndex);
        this.textFieldIndex = new JTextField();
        GridBagConstraints gbc_textFieldIndex = new GridBagConstraints();
        gbc_textFieldIndex.fill = 2;
        gbc_textFieldIndex.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldIndex.gridx = 1;
        gbc_textFieldIndex.gridy = 2;
        this.add((Component)this.textFieldIndex, gbc_textFieldIndex);
        this.textFieldIndex.setToolTipText("Cue point index (optional)");
        this.textFieldIndex.setOpaque(false);
        this.textFieldIndex.setColumns(5);
        JLabel lblPosition = new JLabel("Position:");
        GridBagConstraints gbc_lblPosition = new GridBagConstraints();
        gbc_lblPosition.insets = new Insets(0, 0, 0, 5);
        gbc_lblPosition.anchor = 17;
        gbc_lblPosition.gridx = 0;
        gbc_lblPosition.gridy = 3;
        this.add((Component)lblPosition, gbc_lblPosition);
        this.textFieldPosition = new JTextField();
        GridBagConstraints gbc_textFieldPosition = new GridBagConstraints();
        gbc_textFieldPosition.fill = 2;
        gbc_textFieldPosition.gridx = 1;
        gbc_textFieldPosition.gridy = 3;
        this.add((Component)this.textFieldPosition, gbc_textFieldPosition);
        this.textFieldPosition.setToolTipText("Position (seconds)");
        this.textFieldPosition.setOpaque(false);
        this.textFieldPosition.setColumns(10);
        this.initMediaMarkerPropertiesPanel();
    }

    protected void initMediaMarkerPropertiesPanel() {
        DocumentListener docHandler = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!MediaMarkerEditorPanel.this.refreshing) {
                    MediaMarkerEditorPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!MediaMarkerEditorPanel.this.refreshing) {
                    MediaMarkerEditorPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!MediaMarkerEditorPanel.this.refreshing) {
                    MediaMarkerEditorPanel.this.apply();
                }
            }
        };
        this.textFieldName.getDocument().addDocumentListener(docHandler);
        this.textFieldIndex.getDocument().addDocumentListener(docHandler);
        this.textFieldPosition.getDocument().addDocumentListener(docHandler);
        this.comboBoxType.removeAllItems();
        for (int i = 0; i < MARKER_TYPES.length; ++i) {
            int type = MARKER_TYPES[i];
            String typeName = MediaMarkerEditorPanel.getMarkerTypeName(type);
            this.comboBoxType.addItem(typeName);
        }
    }

    protected JComboBox getComboBoxType() {
        return this.comboBoxType;
    }

    protected JTextField getTextFieldIndex() {
        return this.textFieldIndex;
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    public MediaMarker getMediaMarker() {
        return this.mediaMarker;
    }

    public void setMediaMarker(MediaMarker mediaMarker) {
        this.mediaMarker = mediaMarker;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            String posText;
            this.refreshing = true;
            int type = -1;
            int index = -1;
            String name = null;
            double pos = Double.NaN;
            MediaMarker mediaMarker = this.getMediaMarker();
            if (mediaMarker != null) {
                type = mediaMarker.getType();
                index = mediaMarker.getIndex();
                name = mediaMarker.getName();
                pos = mediaMarker.getPosition();
            }
            String typeName = MediaMarkerEditorPanel.getMarkerTypeName(type);
            this.comboBoxType.setSelectedItem(typeName);
            this.textFieldIndex.setText(index >= 0 ? Integer.toString(index) : "");
            if (name == null) {
                name = "";
            }
            this.textFieldName.setText(name);
            if (!Double.isNaN(pos)) {
                double secPos = pos / 1000.0;
                posText = String.valueOf(secPos);
            } else {
                posText = "";
            }
            this.textFieldPosition.setText(posText);
            this.textFieldPosition.setCaretPosition(0);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        DefaultMediaMarker marker = null;
        MediaMarker mm = this.getMediaMarker();
        if (mm != null && mm instanceof DefaultMediaMarker) {
            marker = (DefaultMediaMarker)mm;
        }
        if (marker == null) {
            return;
        }
        int typeIndex = this.comboBoxType.getSelectedIndex();
        if (typeIndex >= 0 && typeIndex < MARKER_TYPES.length) {
            marker.setType(MARKER_TYPES[typeIndex]);
        }
        String name = this.textFieldName.getText();
        marker.setName(name);
        String sIndex = this.textFieldIndex.getText().trim();
        if (sIndex.length() > 0) {
            try {
                int index = Integer.parseInt(sIndex);
                marker.setIndex(index);
            }
            catch (NumberFormatException e) {}
        } else {
            marker.setIndex(-1);
        }
        double pos = this.getMarkerPosition();
        if (pos >= 0.0) {
            marker.setPosition(pos);
        } else {
            marker.setPosition(Double.NaN);
        }
    }

    protected JTextField getTextFieldPosition() {
        return this.textFieldPosition;
    }

    public double getMarkerPosition() {
        String sPos = this.textFieldPosition.getText();
        if (sPos.length() < 1) {
            return -1.0;
        }
        try {
            double secPos = Double.parseDouble(sPos);
            double pos = secPos * 1000.0;
            return pos;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public static int getMarkerType(String typeName) {
        if (NAME_START_POINT.equals(typeName)) {
            return 1;
        }
        if (NAME_END_POINT.equals(typeName)) {
            return 2;
        }
        if (NAME_CUE_POINT.equals(typeName)) {
            return 3;
        }
        if (NAME_BAR_POINT.equals(typeName)) {
            return 4;
        }
        if (NAME_BEAT_POINT.equals(typeName)) {
            return 5;
        }
        if (NAME_SERATO_MARKER.equals(typeName)) {
            return 9;
        }
        return 0;
    }

    public static String getMarkerTypeName(int markerType) {
        switch (markerType) {
            case 1: {
                return NAME_START_POINT;
            }
            case 2: {
                return NAME_END_POINT;
            }
            case 3: {
                return NAME_CUE_POINT;
            }
            case 4: {
                return NAME_BAR_POINT;
            }
            case 5: {
                return NAME_BEAT_POINT;
            }
            case 9: {
                return NAME_SERATO_MARKER;
            }
        }
        return null;
    }

    public static Icon getMarkerIcon(int markerType) {
        switch (markerType) {
            case 3: {
                return MediaMarkerEditorPanel.getDefaultMarkerIcon();
            }
            case 9: {
                return MediaMarkerEditorPanel.getSeratoMarkerIcon();
            }
        }
        return MediaMarkerEditorPanel.getDefaultMarkerIcon();
    }

    public static Icon getDefaultMarkerIcon() {
        if (defaultMarkerIcon == null) {
            defaultMarkerIcon = Tools.getIcon(MediaMarkerEditorPanel.class, (String)"/com/spacekiller/util/media/manager/icons/media-marker_icon16.png");
        }
        return defaultMarkerIcon;
    }

    public static Icon getSeratoMarkerIcon() {
        if (seratoMarkerIcon == null) {
            seratoMarkerIcon = Tools.getIcon(MediaMarkerEditorPanel.class, (String)"/com/spacekiller/util/media/manager/icons/serato-crate_icon16.png");
        }
        return seratoMarkerIcon;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBoxType.setEnabled(enabled);
        this.textFieldIndex.setEnabled(enabled);
        this.textFieldName.setEnabled(enabled);
        this.textFieldPosition.setEnabled(enabled);
    }
}

