/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.DefaultMediaMarker;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.Player;
import com.spacekiller.util.media.PlayerItem;
import com.spacekiller.util.media.manager.AbstractEntryPropertiesPanel;
import com.spacekiller.util.media.manager.MediaMarkerEditorPanel;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaMarkerPropertiesPanel
extends AbstractEntryPropertiesPanel {
    private static final long serialVersionUID = -7606981085599715523L;
    private static final Logger logger = Logger.getLogger(MediaMarkerPropertiesPanel.class.getName());
    private Player audioPlayer;
    private DefaultListModel markerListModel;
    private JLabel lblMarkerCount;
    private JList listMarkers;
    private MediaMarkerEditorPanel mediaMarkerEditorPanel;
    private JButton btnAddMarker;
    private JButton btnRemoveMarker;
    private JButton btnUpdateMarker;
    private JButton btnSeek;

    public MediaMarkerPropertiesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelMarkers = new JPanel();
        GridBagConstraints gbc_panelMarkers = new GridBagConstraints();
        gbc_panelMarkers.weighty = 1.0;
        gbc_panelMarkers.weightx = 1.0;
        gbc_panelMarkers.fill = 1;
        gbc_panelMarkers.gridx = 0;
        gbc_panelMarkers.gridy = 0;
        this.add((Component)panelMarkers, gbc_panelMarkers);
        GridBagLayout gbl_panelMarkers = new GridBagLayout();
        gbl_panelMarkers.columnWidths = new int[]{0, 0, 0};
        gbl_panelMarkers.rowHeights = new int[]{0, 0};
        gbl_panelMarkers.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMarkers.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelMarkers.setLayout(gbl_panelMarkers);
        JPanel panelMarkerList = new JPanel();
        GridBagConstraints gbc_panelMarkerList = new GridBagConstraints();
        gbc_panelMarkerList.weightx = 1.0;
        gbc_panelMarkerList.insets = new Insets(4, 4, 4, 4);
        gbc_panelMarkerList.weighty = 1.0;
        gbc_panelMarkerList.fill = 1;
        gbc_panelMarkerList.gridx = 0;
        gbc_panelMarkerList.gridy = 0;
        panelMarkers.add((Component)panelMarkerList, gbc_panelMarkerList);
        GridBagLayout gbl_panelMarkerList = new GridBagLayout();
        gbl_panelMarkerList.columnWidths = new int[]{0, 0};
        gbl_panelMarkerList.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelMarkerList.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMarkerList.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelMarkerList.setLayout(gbl_panelMarkerList);
        JPanel panelMarkerTitle = new JPanel();
        GridBagConstraints gbc_panelMarkerTitle = new GridBagConstraints();
        gbc_panelMarkerTitle.insets = new Insets(0, 0, 5, 0);
        gbc_panelMarkerTitle.fill = 1;
        gbc_panelMarkerTitle.gridx = 0;
        gbc_panelMarkerTitle.gridy = 0;
        panelMarkerList.add((Component)panelMarkerTitle, gbc_panelMarkerTitle);
        GridBagLayout gbl_panelMarkerTitle = new GridBagLayout();
        gbl_panelMarkerTitle.columnWidths = new int[]{0, 0, 0};
        gbl_panelMarkerTitle.rowHeights = new int[]{0, 0};
        gbl_panelMarkerTitle.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMarkerTitle.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelMarkerTitle.setLayout(gbl_panelMarkerTitle);
        JLabel lblPositionMarkers = new JLabel("Position Markers:");
        GridBagConstraints gbc_lblPositionMarkers = new GridBagConstraints();
        gbc_lblPositionMarkers.insets = new Insets(0, 0, 0, 5);
        gbc_lblPositionMarkers.gridx = 0;
        gbc_lblPositionMarkers.gridy = 0;
        panelMarkerTitle.add((Component)lblPositionMarkers, gbc_lblPositionMarkers);
        this.lblMarkerCount = new JLabel("N/A");
        GridBagConstraints gbc_lblMarkerCount = new GridBagConstraints();
        gbc_lblMarkerCount.insets = new Insets(0, 4, 0, 0);
        gbc_lblMarkerCount.gridx = 1;
        gbc_lblMarkerCount.gridy = 0;
        panelMarkerTitle.add((Component)this.lblMarkerCount, gbc_lblMarkerCount);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        panelMarkerList.add((Component)scrollPane, gbc_scrollPane);
        this.listMarkers = new JList();
        this.listMarkers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clicks = e.getClickCount();
                if (clicks > 1) {
                    MediaMarkerPropertiesPanel.this.actionSeekMarker();
                }
            }
        });
        this.listMarkers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MediaMarkerPropertiesPanel.this.handleMarkerSelected();
            }
        });
        scrollPane.setViewportView(this.listMarkers);
        JPanel panelMarkerActions = new JPanel();
        GridBagConstraints gbc_panelMarkerActions = new GridBagConstraints();
        gbc_panelMarkerActions.fill = 1;
        gbc_panelMarkerActions.gridx = 0;
        gbc_panelMarkerActions.gridy = 2;
        panelMarkerList.add((Component)panelMarkerActions, gbc_panelMarkerActions);
        GridBagLayout gbl_panelMarkerActions = new GridBagLayout();
        gbl_panelMarkerActions.columnWidths = new int[]{0, 0, 0};
        gbl_panelMarkerActions.rowHeights = new int[]{0, 0};
        gbl_panelMarkerActions.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelMarkerActions.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelMarkerActions.setLayout(gbl_panelMarkerActions);
        this.btnAddMarker = new JButton("Add");
        this.btnAddMarker.setMargin(new Insets(2, 4, 2, 4));
        this.btnAddMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaMarkerPropertiesPanel.this.actionAddMarker();
            }
        });
        GridBagConstraints gbc_btnAddMarker = new GridBagConstraints();
        gbc_btnAddMarker.anchor = 17;
        gbc_btnAddMarker.weightx = 1.0;
        gbc_btnAddMarker.insets = new Insets(0, 0, 0, 5);
        gbc_btnAddMarker.gridx = 0;
        gbc_btnAddMarker.gridy = 0;
        panelMarkerActions.add((Component)this.btnAddMarker, gbc_btnAddMarker);
        this.btnRemoveMarker = new JButton("Remove");
        this.btnRemoveMarker.setMargin(new Insets(2, 4, 2, 4));
        this.btnRemoveMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaMarkerPropertiesPanel.this.actionRemoveMarker();
            }
        });
        GridBagConstraints gbc_btnRemoveMarker = new GridBagConstraints();
        gbc_btnRemoveMarker.gridx = 1;
        gbc_btnRemoveMarker.gridy = 0;
        panelMarkerActions.add((Component)this.btnRemoveMarker, gbc_btnRemoveMarker);
        JPanel panelMarkerDetails = new JPanel();
        GridBagConstraints gbc_panelMarkerDetails = new GridBagConstraints();
        gbc_panelMarkerDetails.insets = new Insets(4, 4, 4, 4);
        gbc_panelMarkerDetails.weighty = 1.0;
        gbc_panelMarkerDetails.weightx = 1.0;
        gbc_panelMarkerDetails.fill = 1;
        gbc_panelMarkerDetails.gridx = 1;
        gbc_panelMarkerDetails.gridy = 0;
        panelMarkers.add((Component)panelMarkerDetails, gbc_panelMarkerDetails);
        GridBagLayout gbl_panelMarkerDetails = new GridBagLayout();
        gbl_panelMarkerDetails.columnWidths = new int[]{0, 0};
        gbl_panelMarkerDetails.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelMarkerDetails.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMarkerDetails.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelMarkerDetails.setLayout(gbl_panelMarkerDetails);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(0, 0, 5, 0);
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.fill = 2;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        panelMarkerDetails.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblMarkerDetails = new JLabel("Marker Details:");
        GridBagConstraints gbc_lblMarkerDetails = new GridBagConstraints();
        gbc_lblMarkerDetails.gridx = 0;
        gbc_lblMarkerDetails.gridy = 0;
        panel_1.add((Component)lblMarkerDetails, gbc_lblMarkerDetails);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.weighty = 1.0;
        gbc_panel_2.insets = new Insets(0, 0, 5, 0);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 1;
        panelMarkerDetails.add((Component)panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        this.mediaMarkerEditorPanel = new MediaMarkerEditorPanel();
        GridBagConstraints gbc_mediaMarkerPropertiesPanel = new GridBagConstraints();
        gbc_mediaMarkerPropertiesPanel.insets = new Insets(4, 4, 4, 4);
        gbc_mediaMarkerPropertiesPanel.weightx = 1.0;
        gbc_mediaMarkerPropertiesPanel.fill = 1;
        gbc_mediaMarkerPropertiesPanel.gridx = 0;
        gbc_mediaMarkerPropertiesPanel.gridy = 0;
        panel_2.add((Component)this.mediaMarkerEditorPanel, gbc_mediaMarkerPropertiesPanel);
        JPanel panel_3 = new JPanel();
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.anchor = 11;
        gbc_panel_3.insets = new Insets(4, 4, 4, 4);
        gbc_panel_3.weighty = 1.0;
        gbc_panel_3.weightx = 1.0;
        gbc_panel_3.fill = 2;
        gbc_panel_3.gridx = 0;
        gbc_panel_3.gridy = 1;
        panel_2.add((Component)panel_3, gbc_panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{0, 0};
        gbl_panel_3.rowHeights = new int[]{0, 0};
        gbl_panel_3.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_3.setLayout(gbl_panel_3);
        this.btnSeek = new JButton("Seek");
        this.btnSeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaMarkerPropertiesPanel.this.actionSeekMarker();
            }
        });
        this.btnSeek.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnSeek = new GridBagConstraints();
        gbc_btnSeek.weightx = 1.0;
        gbc_btnSeek.anchor = 12;
        gbc_btnSeek.gridx = 0;
        gbc_btnSeek.gridy = 0;
        panel_3.add((Component)this.btnSeek, gbc_btnSeek);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 2;
        panelMarkerDetails.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.btnUpdateMarker = new JButton("Update");
        this.btnUpdateMarker.setMargin(new Insets(2, 4, 2, 4));
        this.btnUpdateMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaMarkerPropertiesPanel.this.actionUpdateMarker();
            }
        });
        GridBagConstraints gbc_btnUpdateMarker = new GridBagConstraints();
        gbc_btnUpdateMarker.weightx = 1.0;
        gbc_btnUpdateMarker.anchor = 13;
        gbc_btnUpdateMarker.gridx = 0;
        gbc_btnUpdateMarker.gridy = 0;
        panel.add((Component)this.btnUpdateMarker, gbc_btnUpdateMarker);
        this.initMediaMarkerPropertiesPanel();
    }

    protected void initMediaMarkerPropertiesPanel() {
        this.setTitle("Markers");
        this.setTooltip("Position Markers");
        this.markerListModel = new DefaultListModel();
        this.listMarkers.setModel(this.markerListModel);
        this.listMarkers.setCellRenderer(new MarkerListCellRenderer());
        this.refresh();
    }

    protected Icon getMarkerIcon(MediaMarker marker) {
        if (marker == null) {
            return null;
        }
        int markerType = marker.getType();
        return MediaMarkerEditorPanel.getMarkerIcon(markerType);
    }

    @Override
    public synchronized void refresh() {
        MediaEntry mediaEntry = this.getMediaEntry();
        MediaMarker[] markers = null;
        if (mediaEntry != null) {
            markers = mediaEntry.getMarkers();
        }
        int markerCount = markers == null ? 0 : markers.length;
        this.lblMarkerCount.setText(Integer.toString(markerCount));
        this.markerListModel.clear();
        if (markerCount > 0) {
            for (int i = 0; i < markerCount; ++i) {
                MediaMarker marker = markers[i];
                if (marker == null) continue;
                this.markerListModel.addElement(marker);
            }
        }
        this.btnAddMarker.setEnabled(mediaEntry != null);
        this.handleMarkerSelected();
    }

    protected void handleMarkerSelected() {
        try {
            MediaMarker selMarker;
            MediaMarker marker = null;
            int[] sel = this.listMarkers.getSelectedIndices();
            if (sel.length == 1 && (selMarker = (MediaMarker)this.markerListModel.getElementAt(sel[0])) != null) {
                marker = selMarker.cloneMarker();
            }
            this.btnRemoveMarker.setEnabled(sel.length > 0);
            this.mediaMarkerEditorPanel.setMediaMarker(marker);
            this.mediaMarkerEditorPanel.setEnabled(marker != null);
            this.btnSeek.setEnabled(marker != null);
            this.btnUpdateMarker.setEnabled(marker != null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionAddMarker() {
        try {
            MediaMarker[] oldMarkers;
            MediaEntry me = this.getMediaEntry();
            MutableMediaEntry mme = null;
            if (me != null && me instanceof MutableMediaEntry) {
                mme = (MutableMediaEntry)me;
            }
            if (mme == null) {
                return;
            }
            MediaMarker marker = null;
            MediaPlayer player = this.getMediaPlayer();
            if (player != null) {
                marker = player.createMediaMarker();
            }
            if (marker == null) {
                int type = 1;
                double position = 0.0;
                int index = -1;
                String name = null;
                marker = new DefaultMediaMarker(type, index, position, name);
            }
            int oldCount = (oldMarkers = mme.getMarkers()) == null ? 0 : oldMarkers.length;
            MediaMarker[] newMarkers = new MediaMarker[oldCount + 1];
            if (oldCount > 0) {
                System.arraycopy(oldMarkers, 0, newMarkers, 0, oldCount);
            }
            newMarkers[oldCount] = marker;
            this.applyMarkers(mme, newMarkers);
            this.refresh();
            if (oldCount < this.markerListModel.size()) {
                this.listMarkers.setSelectedIndex(oldCount);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionRemoveMarker() {
        try {
            int[] sel = this.listMarkers.getSelectedIndices();
            if (sel.length < 1) {
                return;
            }
            MediaEntry me = this.getMediaEntry();
            MutableMediaEntry mme = null;
            if (me != null && me instanceof MutableMediaEntry) {
                mme = (MutableMediaEntry)me;
            }
            if (mme == null) {
                return;
            }
            MediaMarker[] oldMarkers = mme.getMarkers();
            int oldCount = oldMarkers == null ? 0 : oldMarkers.length;
            MediaMarker[] newMarkers = null;
            if (oldCount > 0) {
                int newCount = oldCount;
                for (int i = sel.length - 1; i >= 0; --i) {
                    int index = sel[i];
                    if (index < 0 || index >= newCount) continue;
                    System.arraycopy(oldMarkers, index + 1, oldMarkers, index, newCount - index - 1);
                    --newCount;
                }
                if (newCount > 0) {
                    newMarkers = new MediaMarker[newCount];
                    System.arraycopy(oldMarkers, 0, newMarkers, 0, newCount);
                }
            }
            this.applyMarkers(mme, newMarkers);
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionUpdateMarker() {
        try {
            int count;
            int[] sel = this.listMarkers.getSelectedIndices();
            if (sel.length != 1) {
                return;
            }
            int index = sel[0];
            MediaMarker newMarker = this.mediaMarkerEditorPanel.getMediaMarker();
            if (newMarker == null) {
                return;
            }
            MediaEntry me = this.getMediaEntry();
            MutableMediaEntry mme = null;
            if (me != null && me instanceof MutableMediaEntry) {
                mme = (MutableMediaEntry)me;
            }
            if (mme == null) {
                return;
            }
            MediaMarker[] markers = mme.getMarkers();
            int n = count = markers == null ? 0 : markers.length;
            if (index < 0 || index >= count) {
                return;
            }
            markers[index] = newMarker;
            this.applyMarkers(mme, markers);
            this.refresh();
            if (index < this.markerListModel.size()) {
                this.getListMarkers().setSelectedIndex(index);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void applyMarkers(MutableMediaEntry mme, MediaMarker[] markers) {
        MediaPlayerContext mpc = this.getMediaPlayerContext();
        if (mpc != null && mpc.updateMediaMarkers(mme, markers)) {
            return;
        }
        MediaTableToolContext mttc = this.getMediaTableToolContext();
        if (mttc != null && mttc.setMediaMarkers(mme, markers)) {
            return;
        }
        logger.warning("No context available to apply markers!");
    }

    protected JLabel getLblMarkerCount() {
        return this.lblMarkerCount;
    }

    protected JList getListMarkers() {
        return this.listMarkers;
    }

    protected MediaMarkerEditorPanel getMediaMarkerEditorPanel() {
        return this.mediaMarkerEditorPanel;
    }

    protected JButton getBtnAddMarker() {
        return this.btnAddMarker;
    }

    protected JButton getBtnRemoveMarker() {
        return this.btnRemoveMarker;
    }

    public AbstractButton getAddMarkerButton() {
        return this.getBtnAddMarker();
    }

    protected JButton getBtnUpdateMarker() {
        return this.btnUpdateMarker;
    }

    protected JButton getBtnSeek() {
        return this.btnSeek;
    }

    protected void actionSeekMarker() {
        try {
            double pos = this.mediaMarkerEditorPanel.getMarkerPosition();
            if (pos < 0.0) {
                return;
            }
            this.seek(pos);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Player getAudioPlayer() {
        return this.audioPlayer;
    }

    public void setAudioPlayer(Player audioPlayer) {
        this.audioPlayer = audioPlayer;
    }

    protected boolean seek(double pos) {
        Player player = this.audioPlayer;
        if (player == null) {
            return false;
        }
        PlayerItem item = player.getCurrentItem();
        if (item == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Seek marker position: " + pos + ", player=" + player);
        }
        player.setTimePosition(item, pos);
        return true;
    }

    protected String getPositionString(double markerPos) {
        String s;
        long millis = Math.round(markerPos);
        long secs = millis / 1000L;
        if (secs < 60L) {
            s = "0:";
        } else {
            s = Long.toString(secs / 60L) + ":";
            secs %= 60L;
        }
        s = s + Long.toString(100 + (int)secs).substring(1);
        s = s + "." + Long.toString(1000L + millis % 1000L).substring(1);
        return s;
    }

    protected class MarkerListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -6171905968234893430L;

        protected MarkerListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            Icon icon = null;
            String tip = null;
            if (value != null && value instanceof MediaMarker) {
                double markerPos;
                String markerName;
                MediaMarker marker = (MediaMarker)value;
                text = "";
                int markerIndex = marker.getIndex();
                if (markerIndex >= 0) {
                    text = text + "#" + markerIndex + " ";
                }
                if ((markerName = marker.getName()) != null) {
                    text = text + markerName;
                }
                if ((markerPos = marker.getPosition()) >= 0.0) {
                    text = text + " @ " + MediaMarkerPropertiesPanel.this.getPositionString(markerPos);
                }
                icon = MediaMarkerPropertiesPanel.this.getMarkerIcon(marker);
            }
            if (text == null) {
                text = "";
            }
            this.setText(text);
            this.setIcon(icon);
            this.setToolTipText(tip);
            this.setOpaque(isSelected);
            return comp;
        }
    }
}

