/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.library.remote.MediaClient;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import com.spacekiller.util.media.manager.MediaTableEntry;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class MediaTableEntryAnalyzer
implements Runnable {
    private static final Logger logger = Logger.getLogger(MediaTableEntryAnalyzer.class.getName());
    private static final int ANALYZER_VERSION = 3;
    private static final int ENTRY_REFRESH_DELAY = 1000;
    private final MediaLibrary library;
    private final List entryList;
    private final Component tableComponent;
    private boolean forceRescan;
    protected volatile double currentProgress;
    protected volatile Resource currentMediaResource;
    private boolean active;
    private volatile boolean cancel;
    protected final EntryUpdater entryUpdater = new EntryUpdater();
    protected volatile boolean entryUpdaterPending;

    public MediaTableEntryAnalyzer(MediaLibrary library, List entryList, Component tableComponent, boolean forceRescan) {
        this.library = library;
        this.entryList = entryList;
        this.tableComponent = tableComponent;
        this.forceRescan = forceRescan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MediaTableEntryAnalyzer mediaTableEntryAnalyzer;
        MediaAnalyzerExecution mediaAnalyzerExecution = null;
        ExecutionManager executionManager = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MediaAnalyzer started: " + Thread.currentThread());
            }
            this.currentProgress = 0.0;
            executionManager = Platform.getInstance().getExecutionManager();
            if (executionManager != null) {
                mediaAnalyzerExecution = new MediaAnalyzerExecution();
                executionManager.addExecution((Execution)mediaAnalyzerExecution);
                mediaAnalyzerExecution.mediaAnalyzerStarted();
            }
            mediaTableEntryAnalyzer = this;
            synchronized (mediaTableEntryAnalyzer) {
                this.active = true;
            }
            if (this.cancel) {
                return;
            }
            this.analyzeMediaEntries();
        }
        finally {
            mediaTableEntryAnalyzer = this;
            synchronized (mediaTableEntryAnalyzer) {
                this.active = false;
                this.currentMediaResource = null;
                this.notifyAll();
            }
            this.currentProgress = 1.0;
            if (mediaAnalyzerExecution != null) {
                mediaAnalyzerExecution.mediaAnalyzerStopped();
                if (executionManager != null) {
                    executionManager.removeExecution((Execution)mediaAnalyzerExecution);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                if (this.cancel) {
                    logger.fine("MediaAnalyzer cancelled: " + Thread.currentThread());
                } else {
                    logger.fine("MediaAnalyzer completed: " + Thread.currentThread());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyzeMediaEntries() {
        long lastFireTime = System.currentTimeMillis();
        int index = 0;
        int count = this.entryList.size();
        while (!this.cancel && index < count) {
            this.currentProgress = 1.0 * (double)index / (double)count;
            try {
                MediaTableEntry mmce = (MediaTableEntry)this.entryList.get(index);
                MediaEntry me = mmce.getMediaEntry();
                Resource res = mmce.getResource();
                if (res != null) {
                    this.currentMediaResource = res;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Checking media entry #" + index + " / " + count + ": " + res);
                    }
                    int analyzerChecksum = this.computeAnalyzerChecksum(me, 3);
                    boolean rescan = true;
                    if (!this.forceRescan && me != null && analyzerChecksum == me.getLastAnalyzerChecksum()) {
                        rescan = false;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Skipping non-forced rescan of known media resource: " + res);
                        }
                    }
                    if (rescan) {
                        RemoteMediaLibrary remoteLib;
                        MediaClient client;
                        MediaResource mr;
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("Analyzing media resource: " + res);
                        }
                        MediaEntry mex = null;
                        MediaLibrary lib = null;
                        if (res instanceof MediaResource && (lib = (mr = (MediaResource)res).getLibrary()) != null && lib instanceof RemoteMediaLibrary && (client = (remoteLib = (RemoteMediaLibrary)lib).getClient()) != null) {
                            mex = client.getMediaEntry(mr, 16);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Analyzed remote media resource: " + res + " => " + mex);
                            }
                        }
                        if (mex == null) {
                            lib = this.library;
                            if (lib == null) {
                                return;
                            }
                            mex = lib.getMediaEntry(res, 16);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Analyzed local media resource: " + res + " => " + mex);
                            }
                        }
                        if (mex != null) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Updating media entry: " + res + " => " + mex);
                            }
                            if (mex instanceof MutableMediaEntry) {
                                MutableMediaEntry ame = (MutableMediaEntry)mex;
                                ame.setLastAnalyzed(System.currentTimeMillis());
                                ame.setLastAnalyzerChecksum(analyzerChecksum);
                            }
                            mmce.setMediaEntry(mex);
                            long time = System.currentTimeMillis();
                            if (time - lastFireTime > 1000L) {
                                if (!this.entryUpdaterPending) {
                                    this.entryUpdaterPending = true;
                                    SwingUtilities.invokeLater(this.entryUpdater);
                                }
                                lastFireTime = time;
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                ++index;
            }
            Thread.yield();
        }
        this.currentProgress = 1.0;
        this.currentMediaResource = null;
        SwingUtilities.invokeLater(this.entryUpdater);
    }

    protected int computeAnalyzerChecksum(MediaEntry me, int analyzerVersion) {
        if (me == null) {
            return 0;
        }
        long fileSize = me.getFileSize();
        long lastModified = me.getLastModified();
        long longSum = fileSize + lastModified + (long)analyzerVersion;
        return (int)longSum;
    }

    public void cancel() {
        this.cancel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        MediaTableEntryAnalyzer mediaTableEntryAnalyzer = this;
        synchronized (mediaTableEntryAnalyzer) {
            while (this.active) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    protected class MediaAnalyzerExecution
    extends AbstractExecution {
        public MediaAnalyzerExecution() {
            this.setName("Media Analyzer");
            this.setStopSupported(true);
            this.setPauseSupported(false);
            this.setDaemon(true);
        }

        protected void execute() throws Exception {
        }

        public void stop() {
            super.stop();
            MediaTableEntryAnalyzer.this.cancel();
        }

        public double getProgress() {
            return MediaTableEntryAnalyzer.this.currentProgress;
        }

        public String getDescription() {
            Resource res = MediaTableEntryAnalyzer.this.currentMediaResource;
            if (res != null) {
                return "Analyzing: " + res;
            }
            return null;
        }

        protected void mediaAnalyzerStarted() {
            this.setStartMillis(System.currentTimeMillis());
            this.setRunning(true);
            this.fireExecutionStarted();
        }

        protected void mediaAnalyzerStopped() {
            this.setRunning(false);
            this.fireExecutionStopped();
        }
    }

    protected class EntryUpdater
    implements Runnable {
        protected EntryUpdater() {
        }

        @Override
        public void run() {
            MediaTableEntryAnalyzer.this.entryUpdaterPending = false;
            MediaTableEntryAnalyzer.this.tableComponent.validate();
            MediaTableEntryAnalyzer.this.tableComponent.repaint();
        }
    }
}

