/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.manager.MediaManagerPanel;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class MediaTableEntryLoader
implements Runnable {
    private static final Logger logger = Logger.getLogger(MediaTableEntryLoader.class.getName());
    private final MediaManagerPanel mediaManagerPanel;
    private final MediaCrate[] crates;
    private final int maxEntries;
    protected final EntryInserter entryInserter = new EntryInserter();
    protected volatile boolean entryLoaderPending;
    protected List loaderList1 = new ArrayList();
    protected List loaderList2 = new ArrayList();
    protected volatile double crateLoaderProgress;
    protected volatile MediaCrate currentLoaderCrate;
    private boolean active;
    private volatile boolean cancel;
    private int entryCount;
    private final EntryPublisher publisher;

    public MediaTableEntryLoader(MediaManagerPanel mediaManagerPanel, MediaCrate[] crates, Filter crateEntryFilter, int maxEntries) {
        this.mediaManagerPanel = mediaManagerPanel;
        this.crates = crates;
        this.maxEntries = maxEntries;
        this.publisher = new EntryPublisher(crateEntryFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runnable runnable;
        CrateLoaderExecution crateLoaderExecution = null;
        ExecutionManager executionManager = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CrateLoader started: " + Thread.currentThread());
            }
            this.crateLoaderProgress = 0.0;
            executionManager = Platform.getInstance().getExecutionManager();
            if (executionManager != null) {
                crateLoaderExecution = new CrateLoaderExecution();
                executionManager.addExecution((Execution)crateLoaderExecution);
                crateLoaderExecution.crateLoaderStarted();
            }
            runnable = this;
            synchronized (runnable) {
                this.active = true;
            }
            if (this.cancel) {
                return;
            }
            runnable = this.entryInserter;
            synchronized (runnable) {
                this.loaderList1.clear();
                this.loaderList2.clear();
                this.entryLoaderPending = false;
            }
            try {
                int num = this.crates.length;
                int i = 0;
                while (true) {
                    if (i >= num) break;
                    MediaCrate crate = this.crates[i];
                    if (this.cancel) {
                        return;
                    }
                    crate.loadAll();
                    this.loadCrate(crate);
                    if (this.entryCount >= this.maxEntries) {
                        break;
                    }
                    ++i;
                }
            }
            finally {
                try {
                    SwingUtilities.invokeAndWait(this.entryInserter);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        finally {
            runnable = this;
            synchronized (runnable) {
                this.active = false;
                this.currentLoaderCrate = null;
                this.notifyAll();
            }
            this.crateLoaderProgress = 1.0;
            if (crateLoaderExecution != null) {
                crateLoaderExecution.crateLoaderStopped();
                if (executionManager != null) {
                    executionManager.removeExecution((Execution)crateLoaderExecution);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                if (this.cancel) {
                    logger.fine("CrateLoader cancelled: " + Thread.currentThread());
                } else {
                    logger.fine("CrateLoader completed: " + Thread.currentThread());
                }
            }
        }
    }

    protected void loadCrate(MediaCrate crate) {
        if (this.cancel) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Loading crate: " + crate);
        }
        this.currentLoaderCrate = crate;
        this.publisher.setCurrentCrate(crate);
        crate.getEntries((Collection)this.publisher);
        if (this.entryCount >= this.maxEntries) {
            return;
        }
        int subs = crate.getCrateCount();
        for (int i = 0; i < subs; ++i) {
            MediaCrate sub = crate.getCrateAt(i);
            if (this.cancel) {
                return;
            }
            if (sub == null) continue;
            this.loadCrate(sub);
            if (this.entryCount < this.maxEntries) continue;
            return;
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        MediaTableEntryLoader mediaTableEntryLoader = this;
        synchronized (mediaTableEntryLoader) {
            while (this.active) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    protected class CrateLoaderExecution
    extends AbstractExecution {
        public CrateLoaderExecution() {
            this.setName("Crate Loader");
            this.setStopSupported(true);
            this.setPauseSupported(false);
            this.setDaemon(true);
        }

        protected void execute() throws Exception {
        }

        public void stop() {
            super.stop();
            MediaTableEntryLoader.this.cancel();
        }

        public double getProgress() {
            return MediaTableEntryLoader.this.crateLoaderProgress;
        }

        public String getDescription() {
            MediaCrate crate = MediaTableEntryLoader.this.currentLoaderCrate;
            if (crate != null) {
                return "Loading: " + crate;
            }
            return null;
        }

        protected void crateLoaderStarted() {
            this.setStartMillis(System.currentTimeMillis());
            this.setRunning(true);
            this.fireExecutionStarted();
        }

        protected void crateLoaderStopped() {
            this.setRunning(false);
            this.fireExecutionStopped();
        }
    }

    protected class EntryInserter
    implements Runnable {
        protected EntryInserter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List list;
            EntryInserter entryInserter = MediaTableEntryLoader.this.entryInserter;
            synchronized (entryInserter) {
                list = MediaTableEntryLoader.this.loaderList1;
                if (list.isEmpty()) {
                    return;
                }
                MediaTableEntryLoader.this.loaderList1 = MediaTableEntryLoader.this.loaderList2;
                MediaTableEntryLoader.this.loaderList2 = list;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Loading entries: " + list.size());
            }
            MediaTableEntryLoader.this.mediaManagerPanel.loadEntries(list);
            list.clear();
            MediaTableEntryLoader.this.entryLoaderPending = false;
        }
    }

    protected class EntryPublisher
    extends AbstractCollection {
        private Filter entryFilter;
        private MediaCrate currentCrate;

        public EntryPublisher(Filter crateEntryFilter) {
            this.entryFilter = crateEntryFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Object e) {
            MediaCrateEntry me = (MediaCrateEntry)e;
            if (MediaTableEntryLoader.this.entryCount >= MediaTableEntryLoader.this.maxEntries) {
                return false;
            }
            if (this.entryFilter != null && !this.entryFilter.accept((Object)me)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Ignored Entry: " + e);
                }
                return false;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Loading Entry: " + e);
            }
            EntryInserter entryInserter = MediaTableEntryLoader.this.entryInserter;
            synchronized (entryInserter) {
                MediaTableEntryLoader.this.loaderList1.add(me);
                if (!MediaTableEntryLoader.this.entryLoaderPending) {
                    MediaTableEntryLoader.this.entryLoaderPending = true;
                    SwingUtilities.invokeLater(MediaTableEntryLoader.this.entryInserter);
                }
            }
            MediaTableEntryLoader.this.entryCount++;
            Thread.yield();
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        public MediaCrate getCurrentCrate() {
            return this.currentCrate;
        }

        public void setCurrentCrate(MediaCrate currentCrate) {
            this.currentCrate = currentCrate;
        }
    }
}

